/*
 * Decompiled with CFR 0.152.
 */
package com.morpheusdata.views;

import com.github.jknack.handlebars.io.CompositeTemplateLoader;
import com.github.jknack.handlebars.io.TemplateLoader;
import com.github.jknack.handlebars.io.TemplateSource;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicTemplateLoader
implements TemplateLoader {
    private static final Logger logger = LoggerFactory.getLogger(CompositeTemplateLoader.class);
    private List<TemplateLoader> delegates;

    public DynamicTemplateLoader(TemplateLoader ... loaders) {
        this.delegates = Arrays.asList(loaders);
    }

    public TemplateSource sourceAt(String location) throws IOException {
        for (TemplateLoader delegate : this.delegates) {
            try {
                return delegate.sourceAt(location);
            }
            catch (IOException ex) {
                logger.trace("Unable to resolve: {}, trying next loader in the chain.", (Object)location);
            }
        }
        throw new FileNotFoundException(location);
    }

    public String resolve(String location) {
        for (TemplateLoader delegate : this.delegates) {
            try {
                delegate.sourceAt(location);
                return delegate.resolve(location);
            }
            catch (IOException ex) {
                logger.trace("Unable to resolve: {}, trying next loader in the chain.", (Object)location);
            }
        }
        throw new IllegalStateException("Can't resolve: '" + location + "'");
    }

    public String getPrefix() {
        throw new UnsupportedOperationException();
    }

    public String getSuffix() {
        throw new UnsupportedOperationException();
    }

    public void setPrefix(String prefix) {
        throw new UnsupportedOperationException();
    }

    public void setSuffix(String suffix) {
        throw new UnsupportedOperationException();
    }

    public void setCharset(Charset charset) {
        for (TemplateLoader delegate : this.delegates) {
            delegate.setCharset(charset);
        }
    }

    public Charset getCharset() {
        throw new UnsupportedOperationException();
    }

    public Iterable<TemplateLoader> getTemplateLoaders() {
        return this.delegates;
    }

    public void addTemplateLoader(TemplateLoader loader) {
        this.delegates.add(loader);
    }

    public void removeTemplateLoader(TemplateLoader loader) {
        this.delegates.remove(loader);
    }
}

