/*
 * Decompiled with CFR 0.152.
 */
package com.morpheusdata.views;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.io.TemplateLoader;
import com.morpheusdata.views.DynamicTemplateLoader;
import com.morpheusdata.views.HTMLResponse;
import com.morpheusdata.views.HandlebarsPluginTemplateLoader;
import com.morpheusdata.views.Renderer;
import com.morpheusdata.views.ViewModel;
import java.io.FileNotFoundException;
import java.io.IOException;

public class HandlebarsRenderer
implements Renderer<Handlebars> {
    private final Handlebars engine;
    private DynamicTemplateLoader loader;

    public HandlebarsRenderer() {
        HandlebarsPluginTemplateLoader customLoader = new HandlebarsPluginTemplateLoader(this.getClass().getClassLoader());
        this.loader = new DynamicTemplateLoader(new TemplateLoader[]{customLoader});
        this.engine = new Handlebars((TemplateLoader)this.loader);
    }

    public HandlebarsRenderer(String prefix) {
        HandlebarsPluginTemplateLoader customLoader = new HandlebarsPluginTemplateLoader(prefix, this.getClass().getClassLoader());
        this.loader = new DynamicTemplateLoader(new TemplateLoader[]{customLoader});
        this.engine = new Handlebars((TemplateLoader)this.loader);
    }

    public HandlebarsRenderer(ClassLoader classLoader) {
        HandlebarsPluginTemplateLoader customLoader = new HandlebarsPluginTemplateLoader(classLoader);
        this.loader = new DynamicTemplateLoader(new TemplateLoader[]{customLoader});
        this.engine = new Handlebars((TemplateLoader)this.loader);
    }

    public HandlebarsRenderer(String prefix, ClassLoader classLoader) {
        HandlebarsPluginTemplateLoader customLoader = new HandlebarsPluginTemplateLoader(prefix, classLoader);
        this.loader = new DynamicTemplateLoader(new TemplateLoader[]{customLoader});
        this.engine = new Handlebars((TemplateLoader)this.loader);
    }

    @Override
    public void addTemplateLoader(ClassLoader classLoader) {
        HandlebarsPluginTemplateLoader loader = new HandlebarsPluginTemplateLoader(classLoader);
        this.loader.addTemplateLoader((TemplateLoader)loader);
    }

    @Override
    public void removeTemplateLoader(ClassLoader classLoader) {
        for (TemplateLoader templateLoader : this.loader.getTemplateLoaders()) {
            if (templateLoader.getClass().getClassLoader() != classLoader) continue;
            this.loader.removeTemplateLoader(this.loader);
            break;
        }
    }

    @Override
    public Iterable<TemplateLoader> getTemplateLoaders() {
        return this.loader.getTemplateLoaders();
    }

    public HandlebarsRenderer(Handlebars overrideEngine) {
        this.engine = overrideEngine;
    }

    @Override
    public HTMLResponse render(String templateText, ViewModel<?> model) {
        Template template = null;
        try {
            template = this.engine.compileInline(templateText);
        }
        catch (Exception e) {
            this.handleError(e);
        }
        return this.applyModel(template, model);
    }

    @Override
    public HTMLResponse renderTemplate(String location, ViewModel<?> model) {
        Template template;
        try {
            template = this.engine.compile(location);
        }
        catch (IOException e) {
            return this.handleError(e);
        }
        return this.applyModel(template, model);
    }

    @Override
    public Handlebars getEngine() {
        return this.engine;
    }

    public void registerAssetHelper(String pluginName) {
        this.engine.registerHelper("asset", (context, options) -> "/assets/plugin/" + pluginName.toLowerCase().replace(" ", "-") + context);
    }

    private HTMLResponse handleError(Exception e) {
        e.printStackTrace();
        HTMLResponse response = new HTMLResponse();
        response.html = FileNotFoundException.class.equals(e.getClass()) ? "Template file not found: " + e.getMessage() : e.getMessage();
        response.status = 400;
        return response;
    }

    private HTMLResponse applyModel(Template template, ViewModel<?> model) {
        HTMLResponse response = new HTMLResponse();
        try {
            if (template == null) {
                throw new Exception("No template defined.");
            }
            response.html = model != null && model.object != null ? template.apply(model.object) : template.text();
            response.status = model.status;
            return response;
        }
        catch (Exception e) {
            return this.handleError(e);
        }
    }
}

