/*
 * Decompiled with CFR 0.152.
 */
package com.morpheusdata.web;

import com.morpheusdata.core.Plugin;
import com.morpheusdata.core.PluginManager;
import com.morpheusdata.model.Permission;
import com.morpheusdata.views.ViewModel;
import com.morpheusdata.web.PluginController;
import com.morpheusdata.web.Route;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;

public class Dispatcher {
    private final PluginManager pluginManager;

    public Dispatcher(PluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    public Object handleRoute(String path, List<Map<String, String>> usersPermissions) {
        ViewModel model = new ViewModel();
        return this.handleRoute(path, model, usersPermissions);
    }

    public Object handleRoute(String path, ViewModel<?> model, List<Map<String, String>> usersPermissions) {
        for (Plugin p : this.pluginManager.getPlugins()) {
            for (PluginController controller : p.getControllers()) {
                for (Route route : controller.getRoutes()) {
                    if (!route.url.equals(path) || !this.checkPermissions(usersPermissions, route.permissions)) continue;
                    return this.doDispatch(controller.getClass().getName(), route.method, model);
                }
            }
        }
        return null;
    }

    boolean checkPermissions(List<Map<String, String>> userPermissions, List<Permission> requiredPermissions) {
        for (Permission p : requiredPermissions) {
            if (!userPermissions.contains(p.asMap())) continue;
            return true;
        }
        return false;
    }

    public Object doDispatch(String className, String methodName, ViewModel<?> params) {
        try {
            Class[] argsList = new Class[]{ViewModel.class};
            Class<?> clazz = Class.forName(className);
            Object inst = clazz.newInstance();
            Method m = clazz.getMethod(methodName, argsList);
            return m.invoke(inst, params);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

