/*
 * Decompiled with CFR 0.152.
 */
package com.mparticle.sdk.model.registration.authentication;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mparticle.sdk.model.registration.authentication.AuthenticationConfiguration;
import com.mparticle.sdk.model.registration.authentication.ScopeDetail;

public final class OAuth2Authentication
extends AuthenticationConfiguration {
    @JsonProperty(value="authorization_url", required=true)
    private String authorizationUrl;
    @JsonProperty(value="refresh_url")
    private String refreshUrl;
    @JsonProperty(value="token_url", required=true)
    private String tokenUrl;
    @JsonProperty(value="grant_type")
    private GrantType grantType;
    @JsonProperty(value="default_expires_in")
    private Integer defaultExpiresIn;
    @JsonProperty(value="client_id")
    private String clientId;
    @JsonProperty(value="access_token_type")
    private AccessTokenType accessTokenType;
    @JsonProperty(value="custom_header_name")
    private String customHeaderName;
    @JsonProperty(value="param_client_id_name")
    private String paramClientIdName;
    @JsonProperty(value="param_secret_name")
    private String paramSecretName;
    @JsonProperty(value="scopes")
    private ScopeDetail[] scopes;

    public OAuth2Authentication() {
        super(AuthenticationConfiguration.Type.OAUTH2);
    }

    public String getAuthorizationUrl() {
        return this.authorizationUrl;
    }

    public OAuth2Authentication setAuthorizationUrl(String authorizationUrl) {
        this.authorizationUrl = authorizationUrl;
        return this;
    }

    public String getRefreshUrl() {
        return this.refreshUrl;
    }

    public OAuth2Authentication setRefreshUrl(String refreshUrl) {
        this.refreshUrl = refreshUrl;
        return this;
    }

    public String getTokenUrl() {
        return this.tokenUrl;
    }

    public OAuth2Authentication setTokenUrl(String tokenUrl) {
        this.tokenUrl = tokenUrl;
        return this;
    }

    public GrantType getGrantType() {
        return this.grantType;
    }

    public OAuth2Authentication setGrantType(GrantType grantType) {
        this.grantType = grantType;
        return this;
    }

    public int getDefaultExpiresIn() {
        return this.defaultExpiresIn;
    }

    public OAuth2Authentication setDefaultExpiresIn(int defaultExpiresIn) {
        this.defaultExpiresIn = defaultExpiresIn;
        return this;
    }

    public String getClientId() {
        return this.clientId;
    }

    public OAuth2Authentication setClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public AccessTokenType getAccessTokenType() {
        return this.accessTokenType;
    }

    public OAuth2Authentication setAccessTokenType(AccessTokenType accessTokenType) {
        this.accessTokenType = accessTokenType;
        return this;
    }

    public String getCustomHeaderName() {
        return this.customHeaderName;
    }

    public OAuth2Authentication setCustomHeaderName(String customHeaderName) {
        this.customHeaderName = customHeaderName;
        return this;
    }

    public String getParamClientIdName() {
        return this.paramClientIdName;
    }

    public OAuth2Authentication setParamClientIdName(String paramClientIdName) {
        this.paramClientIdName = paramClientIdName;
        return this;
    }

    public String getParamSecretName() {
        return this.paramSecretName;
    }

    public OAuth2Authentication setParamSecretName(String paramSecretName) {
        this.paramSecretName = paramSecretName;
        return this;
    }

    public ScopeDetail[] getScopes() {
        return this.scopes;
    }

    public OAuth2Authentication setScopes(ScopeDetail[] scopes) {
        this.scopes = scopes;
        return this;
    }

    public static enum GrantType {
        AUTHORIZATION_CODE;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum AccessTokenType {
        BEARER,
        CUSTOM_HEADER;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

