/*
 * Decompiled with CFR 0.152.
 */
package com.mx.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AccountCreateRequest {
    public static final String SERIALIZED_NAME_ACCOUNT_SUBTYPE = "account_subtype";
    @SerializedName(value="account_subtype")
    private String accountSubtype;
    public static final String SERIALIZED_NAME_ACCOUNT_TYPE = "account_type";
    @SerializedName(value="account_type")
    private String accountType;
    public static final String SERIALIZED_NAME_APR = "apr";
    @SerializedName(value="apr")
    private BigDecimal apr;
    public static final String SERIALIZED_NAME_APY = "apy";
    @SerializedName(value="apy")
    private BigDecimal apy;
    public static final String SERIALIZED_NAME_AVAILABLE_BALANCE = "available_balance";
    @SerializedName(value="available_balance")
    private BigDecimal availableBalance;
    public static final String SERIALIZED_NAME_BALANCE = "balance";
    @SerializedName(value="balance")
    private BigDecimal balance;
    public static final String SERIALIZED_NAME_CASH_SURRENDER_VALUE = "cash_surrender_value";
    @SerializedName(value="cash_surrender_value")
    private BigDecimal cashSurrenderValue;
    public static final String SERIALIZED_NAME_CREDIT_LIMIT = "credit_limit";
    @SerializedName(value="credit_limit")
    private BigDecimal creditLimit;
    public static final String SERIALIZED_NAME_CURRENCY_CODE = "currency_code";
    @SerializedName(value="currency_code")
    private String currencyCode;
    public static final String SERIALIZED_NAME_DEATH_BENEFIT = "death_benefit";
    @SerializedName(value="death_benefit")
    private Integer deathBenefit;
    public static final String SERIALIZED_NAME_INTEREST_RATE = "interest_rate";
    @SerializedName(value="interest_rate")
    private BigDecimal interestRate;
    public static final String SERIALIZED_NAME_IS_BUSINESS = "is_business";
    @SerializedName(value="is_business")
    private Boolean isBusiness;
    public static final String SERIALIZED_NAME_IS_CLOSED = "is_closed";
    @SerializedName(value="is_closed")
    private Boolean isClosed;
    public static final String SERIALIZED_NAME_IS_HIDDEN = "is_hidden";
    @SerializedName(value="is_hidden")
    private Boolean isHidden;
    public static final String SERIALIZED_NAME_LOAN_AMOUNT = "loan_amount";
    @SerializedName(value="loan_amount")
    private BigDecimal loanAmount;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private String metadata;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_NICKNAME = "nickname";
    @SerializedName(value="nickname")
    private String nickname;
    public static final String SERIALIZED_NAME_ORIGINAL_BALANCE = "original_balance";
    @SerializedName(value="original_balance")
    private BigDecimal originalBalance;
    public static final String SERIALIZED_NAME_PROPERTY_TYPE = "property_type";
    @SerializedName(value="property_type")
    private String propertyType;
    public static final String SERIALIZED_NAME_SKIP_WEBHOOK = "skip_webhook";
    @SerializedName(value="skip_webhook")
    private Boolean skipWebhook;

    public AccountCreateRequest accountSubtype(String accountSubtype) {
        this.accountSubtype = accountSubtype;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="PERSONAL", value="")
    public String getAccountSubtype() {
        return this.accountSubtype;
    }

    public void setAccountSubtype(String accountSubtype) {
        this.accountSubtype = accountSubtype;
    }

    public AccountCreateRequest accountType(String accountType) {
        this.accountType = accountType;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="SAVINGS", required=true, value="")
    public String getAccountType() {
        return this.accountType;
    }

    public void setAccountType(String accountType) {
        this.accountType = accountType;
    }

    public AccountCreateRequest apr(BigDecimal apr) {
        this.apr = apr;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1.0", value="")
    public BigDecimal getApr() {
        return this.apr;
    }

    public void setApr(BigDecimal apr) {
        this.apr = apr;
    }

    public AccountCreateRequest apy(BigDecimal apy) {
        this.apy = apy;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1.0", value="")
    public BigDecimal getApy() {
        return this.apy;
    }

    public void setApy(BigDecimal apy) {
        this.apy = apy;
    }

    public AccountCreateRequest availableBalance(BigDecimal availableBalance) {
        this.availableBalance = availableBalance;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1000.0", value="")
    public BigDecimal getAvailableBalance() {
        return this.availableBalance;
    }

    public void setAvailableBalance(BigDecimal availableBalance) {
        this.availableBalance = availableBalance;
    }

    public AccountCreateRequest balance(BigDecimal balance) {
        this.balance = balance;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1000.0", value="")
    public BigDecimal getBalance() {
        return this.balance;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }

    public AccountCreateRequest cashSurrenderValue(BigDecimal cashSurrenderValue) {
        this.cashSurrenderValue = cashSurrenderValue;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1000.0", value="")
    public BigDecimal getCashSurrenderValue() {
        return this.cashSurrenderValue;
    }

    public void setCashSurrenderValue(BigDecimal cashSurrenderValue) {
        this.cashSurrenderValue = cashSurrenderValue;
    }

    public AccountCreateRequest creditLimit(BigDecimal creditLimit) {
        this.creditLimit = creditLimit;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="100.0", value="")
    public BigDecimal getCreditLimit() {
        return this.creditLimit;
    }

    public void setCreditLimit(BigDecimal creditLimit) {
        this.creditLimit = creditLimit;
    }

    public AccountCreateRequest currencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="USD", value="")
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public AccountCreateRequest deathBenefit(Integer deathBenefit) {
        this.deathBenefit = deathBenefit;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1000", value="")
    public Integer getDeathBenefit() {
        return this.deathBenefit;
    }

    public void setDeathBenefit(Integer deathBenefit) {
        this.deathBenefit = deathBenefit;
    }

    public AccountCreateRequest interestRate(BigDecimal interestRate) {
        this.interestRate = interestRate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1.0", value="")
    public BigDecimal getInterestRate() {
        return this.interestRate;
    }

    public void setInterestRate(BigDecimal interestRate) {
        this.interestRate = interestRate;
    }

    public AccountCreateRequest isBusiness(Boolean isBusiness) {
        this.isBusiness = isBusiness;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="")
    public Boolean getIsBusiness() {
        return this.isBusiness;
    }

    public void setIsBusiness(Boolean isBusiness) {
        this.isBusiness = isBusiness;
    }

    public AccountCreateRequest isClosed(Boolean isClosed) {
        this.isClosed = isClosed;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="")
    public Boolean getIsClosed() {
        return this.isClosed;
    }

    public void setIsClosed(Boolean isClosed) {
        this.isClosed = isClosed;
    }

    public AccountCreateRequest isHidden(Boolean isHidden) {
        this.isHidden = isHidden;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="")
    public Boolean getIsHidden() {
        return this.isHidden;
    }

    public void setIsHidden(Boolean isHidden) {
        this.isHidden = isHidden;
    }

    public AccountCreateRequest loanAmount(BigDecimal loanAmount) {
        this.loanAmount = loanAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1000.0", value="")
    public BigDecimal getLoanAmount() {
        return this.loanAmount;
    }

    public void setLoanAmount(BigDecimal loanAmount) {
        this.loanAmount = loanAmount;
    }

    public AccountCreateRequest metadata(String metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="some metadata", value="")
    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public AccountCreateRequest name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="Test account 2", required=true, value="")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AccountCreateRequest nickname(String nickname) {
        this.nickname = nickname;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Swiss Account", value="")
    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public AccountCreateRequest originalBalance(BigDecimal originalBalance) {
        this.originalBalance = originalBalance;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="10.0", value="")
    public BigDecimal getOriginalBalance() {
        return this.originalBalance;
    }

    public void setOriginalBalance(BigDecimal originalBalance) {
        this.originalBalance = originalBalance;
    }

    public AccountCreateRequest propertyType(String propertyType) {
        this.propertyType = propertyType;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="VEHICLE", value="")
    public String getPropertyType() {
        return this.propertyType;
    }

    public void setPropertyType(String propertyType) {
        this.propertyType = propertyType;
    }

    public AccountCreateRequest skipWebhook(Boolean skipWebhook) {
        this.skipWebhook = skipWebhook;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="")
    public Boolean getSkipWebhook() {
        return this.skipWebhook;
    }

    public void setSkipWebhook(Boolean skipWebhook) {
        this.skipWebhook = skipWebhook;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountCreateRequest accountCreateRequest = (AccountCreateRequest)o;
        return Objects.equals(this.accountSubtype, accountCreateRequest.accountSubtype) && Objects.equals(this.accountType, accountCreateRequest.accountType) && Objects.equals(this.apr, accountCreateRequest.apr) && Objects.equals(this.apy, accountCreateRequest.apy) && Objects.equals(this.availableBalance, accountCreateRequest.availableBalance) && Objects.equals(this.balance, accountCreateRequest.balance) && Objects.equals(this.cashSurrenderValue, accountCreateRequest.cashSurrenderValue) && Objects.equals(this.creditLimit, accountCreateRequest.creditLimit) && Objects.equals(this.currencyCode, accountCreateRequest.currencyCode) && Objects.equals(this.deathBenefit, accountCreateRequest.deathBenefit) && Objects.equals(this.interestRate, accountCreateRequest.interestRate) && Objects.equals(this.isBusiness, accountCreateRequest.isBusiness) && Objects.equals(this.isClosed, accountCreateRequest.isClosed) && Objects.equals(this.isHidden, accountCreateRequest.isHidden) && Objects.equals(this.loanAmount, accountCreateRequest.loanAmount) && Objects.equals(this.metadata, accountCreateRequest.metadata) && Objects.equals(this.name, accountCreateRequest.name) && Objects.equals(this.nickname, accountCreateRequest.nickname) && Objects.equals(this.originalBalance, accountCreateRequest.originalBalance) && Objects.equals(this.propertyType, accountCreateRequest.propertyType) && Objects.equals(this.skipWebhook, accountCreateRequest.skipWebhook);
    }

    public int hashCode() {
        return Objects.hash(this.accountSubtype, this.accountType, this.apr, this.apy, this.availableBalance, this.balance, this.cashSurrenderValue, this.creditLimit, this.currencyCode, this.deathBenefit, this.interestRate, this.isBusiness, this.isClosed, this.isHidden, this.loanAmount, this.metadata, this.name, this.nickname, this.originalBalance, this.propertyType, this.skipWebhook);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountCreateRequest {\n");
        sb.append("    accountSubtype: ").append(this.toIndentedString(this.accountSubtype)).append("\n");
        sb.append("    accountType: ").append(this.toIndentedString(this.accountType)).append("\n");
        sb.append("    apr: ").append(this.toIndentedString(this.apr)).append("\n");
        sb.append("    apy: ").append(this.toIndentedString(this.apy)).append("\n");
        sb.append("    availableBalance: ").append(this.toIndentedString(this.availableBalance)).append("\n");
        sb.append("    balance: ").append(this.toIndentedString(this.balance)).append("\n");
        sb.append("    cashSurrenderValue: ").append(this.toIndentedString(this.cashSurrenderValue)).append("\n");
        sb.append("    creditLimit: ").append(this.toIndentedString(this.creditLimit)).append("\n");
        sb.append("    currencyCode: ").append(this.toIndentedString(this.currencyCode)).append("\n");
        sb.append("    deathBenefit: ").append(this.toIndentedString(this.deathBenefit)).append("\n");
        sb.append("    interestRate: ").append(this.toIndentedString(this.interestRate)).append("\n");
        sb.append("    isBusiness: ").append(this.toIndentedString(this.isBusiness)).append("\n");
        sb.append("    isClosed: ").append(this.toIndentedString(this.isClosed)).append("\n");
        sb.append("    isHidden: ").append(this.toIndentedString(this.isHidden)).append("\n");
        sb.append("    loanAmount: ").append(this.toIndentedString(this.loanAmount)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    nickname: ").append(this.toIndentedString(this.nickname)).append("\n");
        sb.append("    originalBalance: ").append(this.toIndentedString(this.originalBalance)).append("\n");
        sb.append("    propertyType: ").append(this.toIndentedString(this.propertyType)).append("\n");
        sb.append("    skipWebhook: ").append(this.toIndentedString(this.skipWebhook)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

