/*
 * MX Platform API
 * The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.
 *
 * The version of the OpenAPI document: 0.1.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.mx.client.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Arrays;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.mx.client.JSON;

/**
 * BudgetCreateRequest
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class BudgetCreateRequest {
  public static final String SERIALIZED_NAME_CATEGORY_GUID = "category_guid";
  @SerializedName(SERIALIZED_NAME_CATEGORY_GUID)
  private String categoryGuid;

  public static final String SERIALIZED_NAME_PARENT_GUID = "parent_guid";
  @SerializedName(SERIALIZED_NAME_PARENT_GUID)
  private String parentGuid;

  public static final String SERIALIZED_NAME_AMOUNT = "amount";
  @SerializedName(SERIALIZED_NAME_AMOUNT)
  private Integer amount;

  public static final String SERIALIZED_NAME_METADATA = "metadata";
  @SerializedName(SERIALIZED_NAME_METADATA)
  private String metadata;

  public static final String SERIALIZED_NAME_SKIP_WEBHOOK = "skip_webhook";
  @SerializedName(SERIALIZED_NAME_SKIP_WEBHOOK)
  private Boolean skipWebhook;

  public BudgetCreateRequest() {
  }

  public BudgetCreateRequest categoryGuid(String categoryGuid) {
    
    this.categoryGuid = categoryGuid;
    return this;
  }

   /**
   * Unique identifier of the category.
   * @return categoryGuid
  **/
  @javax.annotation.Nonnull
  public String getCategoryGuid() {
    return categoryGuid;
  }


  public void setCategoryGuid(String categoryGuid) {
    this.categoryGuid = categoryGuid;
  }


  public BudgetCreateRequest parentGuid(String parentGuid) {
    
    this.parentGuid = parentGuid;
    return this;
  }

   /**
   * Unique identifier of the parent budget. This is only required when creating a budget on a sub-category.
   * @return parentGuid
  **/
  @javax.annotation.Nonnull
  public String getParentGuid() {
    return parentGuid;
  }


  public void setParentGuid(String parentGuid) {
    this.parentGuid = parentGuid;
  }


  public BudgetCreateRequest amount(Integer amount) {
    
    this.amount = amount;
    return this;
  }

   /**
   * Amount of the budget.
   * @return amount
  **/
  @javax.annotation.Nullable
  public Integer getAmount() {
    return amount;
  }


  public void setAmount(Integer amount) {
    this.amount = amount;
  }


  public BudgetCreateRequest metadata(String metadata) {
    
    this.metadata = metadata;
    return this;
  }

   /**
   * Additional information a partner can store on the budget.
   * @return metadata
  **/
  @javax.annotation.Nullable
  public String getMetadata() {
    return metadata;
  }


  public void setMetadata(String metadata) {
    this.metadata = metadata;
  }


  public BudgetCreateRequest skipWebhook(Boolean skipWebhook) {
    
    this.skipWebhook = skipWebhook;
    return this;
  }

   /**
   * When set to true, this parameter will prevent a webhook from being triggered by the request.
   * @return skipWebhook
  **/
  @javax.annotation.Nullable
  public Boolean getSkipWebhook() {
    return skipWebhook;
  }


  public void setSkipWebhook(Boolean skipWebhook) {
    this.skipWebhook = skipWebhook;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BudgetCreateRequest budgetCreateRequest = (BudgetCreateRequest) o;
    return Objects.equals(this.categoryGuid, budgetCreateRequest.categoryGuid) &&
        Objects.equals(this.parentGuid, budgetCreateRequest.parentGuid) &&
        Objects.equals(this.amount, budgetCreateRequest.amount) &&
        Objects.equals(this.metadata, budgetCreateRequest.metadata) &&
        Objects.equals(this.skipWebhook, budgetCreateRequest.skipWebhook);
  }

  @Override
  public int hashCode() {
    return Objects.hash(categoryGuid, parentGuid, amount, metadata, skipWebhook);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BudgetCreateRequest {\n");
    sb.append("    categoryGuid: ").append(toIndentedString(categoryGuid)).append("\n");
    sb.append("    parentGuid: ").append(toIndentedString(parentGuid)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    skipWebhook: ").append(toIndentedString(skipWebhook)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("category_guid");
    openapiFields.add("parent_guid");
    openapiFields.add("amount");
    openapiFields.add("metadata");
    openapiFields.add("skip_webhook");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("category_guid");
    openapiRequiredFields.add("parent_guid");
  }

 /**
  * Validates the JSON Element and throws an exception if issues found
  *
  * @param jsonElement JSON Element
  * @throws IOException if the JSON Element is invalid with respect to BudgetCreateRequest
  */
  public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (jsonElement == null) {
        if (!BudgetCreateRequest.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in BudgetCreateRequest is not found in the empty JSON string", BudgetCreateRequest.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!BudgetCreateRequest.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `BudgetCreateRequest` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : BudgetCreateRequest.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if (!jsonObj.get("category_guid").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `category_guid` to be a primitive type in the JSON string but got `%s`", jsonObj.get("category_guid").toString()));
      }
      if (!jsonObj.get("parent_guid").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `parent_guid` to be a primitive type in the JSON string but got `%s`", jsonObj.get("parent_guid").toString()));
      }
      if ((jsonObj.get("metadata") != null && !jsonObj.get("metadata").isJsonNull()) && !jsonObj.get("metadata").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `metadata` to be a primitive type in the JSON string but got `%s`", jsonObj.get("metadata").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!BudgetCreateRequest.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'BudgetCreateRequest' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<BudgetCreateRequest> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(BudgetCreateRequest.class));

       return (TypeAdapter<T>) new TypeAdapter<BudgetCreateRequest>() {
           @Override
           public void write(JsonWriter out, BudgetCreateRequest value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public BudgetCreateRequest read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of BudgetCreateRequest given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of BudgetCreateRequest
  * @throws IOException if the JSON string is invalid with respect to BudgetCreateRequest
  */
  public static BudgetCreateRequest fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, BudgetCreateRequest.class);
  }

 /**
  * Convert an instance of BudgetCreateRequest to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

