/*
 * MX Platform API
 * The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.
 *
 * The version of the OpenAPI document: 0.1.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.mx.client.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.mx.client.JSON;

/**
 * GoalResponse
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class GoalResponse {
  public static final String SERIALIZED_NAME_ACCOUNT_GUID = "account_guid";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_GUID)
  private String accountGuid;

  public static final String SERIALIZED_NAME_AMOUNT = "amount";
  @SerializedName(SERIALIZED_NAME_AMOUNT)
  private BigDecimal amount;

  public static final String SERIALIZED_NAME_COMPLETED_AT = "completed_at";
  @SerializedName(SERIALIZED_NAME_COMPLETED_AT)
  private String completedAt;

  public static final String SERIALIZED_NAME_CURRENT_AMOUNT = "current_amount";
  @SerializedName(SERIALIZED_NAME_CURRENT_AMOUNT)
  private BigDecimal currentAmount;

  public static final String SERIALIZED_NAME_GOAL_TYPE_NAME = "goal_type_name";
  @SerializedName(SERIALIZED_NAME_GOAL_TYPE_NAME)
  private String goalTypeName;

  public static final String SERIALIZED_NAME_GUID = "guid";
  @SerializedName(SERIALIZED_NAME_GUID)
  private String guid;

  public static final String SERIALIZED_NAME_HAS_BEEN_SPENT = "has_been_spent";
  @SerializedName(SERIALIZED_NAME_HAS_BEEN_SPENT)
  private Boolean hasBeenSpent;

  public static final String SERIALIZED_NAME_IS_COMPLETE = "is_complete";
  @SerializedName(SERIALIZED_NAME_IS_COMPLETE)
  private Boolean isComplete;

  public static final String SERIALIZED_NAME_METADATA = "metadata";
  @SerializedName(SERIALIZED_NAME_METADATA)
  private String metadata;

  public static final String SERIALIZED_NAME_META_TYPE_NAME = "meta_type_name";
  @SerializedName(SERIALIZED_NAME_META_TYPE_NAME)
  private String metaTypeName;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_POSITION = "position";
  @SerializedName(SERIALIZED_NAME_POSITION)
  private Integer position;

  public static final String SERIALIZED_NAME_PROJECTED_TO_COMPLETE_AT = "projected_to_complete_at";
  @SerializedName(SERIALIZED_NAME_PROJECTED_TO_COMPLETE_AT)
  private String projectedToCompleteAt;

  public static final String SERIALIZED_NAME_TARGETED_TO_COMPLETE_AT = "targeted_to_complete_at";
  @SerializedName(SERIALIZED_NAME_TARGETED_TO_COMPLETE_AT)
  private String targetedToCompleteAt;

  public static final String SERIALIZED_NAME_TRACK_TYPE_NAME = "track_type_name";
  @SerializedName(SERIALIZED_NAME_TRACK_TYPE_NAME)
  private String trackTypeName;

  public static final String SERIALIZED_NAME_USER_GUID = "user_guid";
  @SerializedName(SERIALIZED_NAME_USER_GUID)
  private String userGuid;

  public GoalResponse() {
  }

  public GoalResponse accountGuid(String accountGuid) {
    
    this.accountGuid = accountGuid;
    return this;
  }

   /**
   * Unique identifier of the account for the goal.
   * @return accountGuid
  **/
  @javax.annotation.Nullable
  public String getAccountGuid() {
    return accountGuid;
  }


  public void setAccountGuid(String accountGuid) {
    this.accountGuid = accountGuid;
  }


  public GoalResponse amount(BigDecimal amount) {
    
    this.amount = amount;
    return this;
  }

   /**
   * Amount of the goal.
   * @return amount
  **/
  @javax.annotation.Nullable
  public BigDecimal getAmount() {
    return amount;
  }


  public void setAmount(BigDecimal amount) {
    this.amount = amount;
  }


  public GoalResponse completedAt(String completedAt) {
    
    this.completedAt = completedAt;
    return this;
  }

   /**
   * Date and time the goal was completed.
   * @return completedAt
  **/
  @javax.annotation.Nullable
  public String getCompletedAt() {
    return completedAt;
  }


  public void setCompletedAt(String completedAt) {
    this.completedAt = completedAt;
  }


  public GoalResponse currentAmount(BigDecimal currentAmount) {
    
    this.currentAmount = currentAmount;
    return this;
  }

   /**
   * The current amount of the goal.
   * @return currentAmount
  **/
  @javax.annotation.Nullable
  public BigDecimal getCurrentAmount() {
    return currentAmount;
  }


  public void setCurrentAmount(BigDecimal currentAmount) {
    this.currentAmount = currentAmount;
  }


  public GoalResponse goalTypeName(String goalTypeName) {
    
    this.goalTypeName = goalTypeName;
    return this;
  }

   /**
   * The goal type.
   * @return goalTypeName
  **/
  @javax.annotation.Nullable
  public String getGoalTypeName() {
    return goalTypeName;
  }


  public void setGoalTypeName(String goalTypeName) {
    this.goalTypeName = goalTypeName;
  }


  public GoalResponse guid(String guid) {
    
    this.guid = guid;
    return this;
  }

   /**
   * Unique identifier for the goal. Defined by MX.
   * @return guid
  **/
  @javax.annotation.Nullable
  public String getGuid() {
    return guid;
  }


  public void setGuid(String guid) {
    this.guid = guid;
  }


  public GoalResponse hasBeenSpent(Boolean hasBeenSpent) {
    
    this.hasBeenSpent = hasBeenSpent;
    return this;
  }

   /**
   * Determines if the goal has been spent.
   * @return hasBeenSpent
  **/
  @javax.annotation.Nullable
  public Boolean getHasBeenSpent() {
    return hasBeenSpent;
  }


  public void setHasBeenSpent(Boolean hasBeenSpent) {
    this.hasBeenSpent = hasBeenSpent;
  }


  public GoalResponse isComplete(Boolean isComplete) {
    
    this.isComplete = isComplete;
    return this;
  }

   /**
   * Determines if the goal is complete.
   * @return isComplete
  **/
  @javax.annotation.Nullable
  public Boolean getIsComplete() {
    return isComplete;
  }


  public void setIsComplete(Boolean isComplete) {
    this.isComplete = isComplete;
  }


  public GoalResponse metadata(String metadata) {
    
    this.metadata = metadata;
    return this;
  }

   /**
   * Additional information a partner can store on the goal.
   * @return metadata
  **/
  @javax.annotation.Nullable
  public String getMetadata() {
    return metadata;
  }


  public void setMetadata(String metadata) {
    this.metadata = metadata;
  }


  public GoalResponse metaTypeName(String metaTypeName) {
    
    this.metaTypeName = metaTypeName;
    return this;
  }

   /**
   * The category of the goal.
   * @return metaTypeName
  **/
  @javax.annotation.Nullable
  public String getMetaTypeName() {
    return metaTypeName;
  }


  public void setMetaTypeName(String metaTypeName) {
    this.metaTypeName = metaTypeName;
  }


  public GoalResponse name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * The name of the goal.
   * @return name
  **/
  @javax.annotation.Nullable
  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }


  public GoalResponse position(Integer position) {
    
    this.position = position;
    return this;
  }

   /**
   * The priority of the goal in relation to multiple goals.
   * @return position
  **/
  @javax.annotation.Nullable
  public Integer getPosition() {
    return position;
  }


  public void setPosition(Integer position) {
    this.position = position;
  }


  public GoalResponse projectedToCompleteAt(String projectedToCompleteAt) {
    
    this.projectedToCompleteAt = projectedToCompleteAt;
    return this;
  }

   /**
   * Date and time the goal is projected to be completed.
   * @return projectedToCompleteAt
  **/
  @javax.annotation.Nullable
  public String getProjectedToCompleteAt() {
    return projectedToCompleteAt;
  }


  public void setProjectedToCompleteAt(String projectedToCompleteAt) {
    this.projectedToCompleteAt = projectedToCompleteAt;
  }


  public GoalResponse targetedToCompleteAt(String targetedToCompleteAt) {
    
    this.targetedToCompleteAt = targetedToCompleteAt;
    return this;
  }

   /**
   * Date and time the goal is to complete. Intended for users to set their own goal completion dates.
   * @return targetedToCompleteAt
  **/
  @javax.annotation.Nullable
  public String getTargetedToCompleteAt() {
    return targetedToCompleteAt;
  }


  public void setTargetedToCompleteAt(String targetedToCompleteAt) {
    this.targetedToCompleteAt = targetedToCompleteAt;
  }


  public GoalResponse trackTypeName(String trackTypeName) {
    
    this.trackTypeName = trackTypeName;
    return this;
  }

   /**
   * Get trackTypeName
   * @return trackTypeName
  **/
  @javax.annotation.Nullable
  public String getTrackTypeName() {
    return trackTypeName;
  }


  public void setTrackTypeName(String trackTypeName) {
    this.trackTypeName = trackTypeName;
  }


  public GoalResponse userGuid(String userGuid) {
    
    this.userGuid = userGuid;
    return this;
  }

   /**
   * The unique identifier for the the user. Defined by MX.
   * @return userGuid
  **/
  @javax.annotation.Nullable
  public String getUserGuid() {
    return userGuid;
  }


  public void setUserGuid(String userGuid) {
    this.userGuid = userGuid;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GoalResponse goalResponse = (GoalResponse) o;
    return Objects.equals(this.accountGuid, goalResponse.accountGuid) &&
        Objects.equals(this.amount, goalResponse.amount) &&
        Objects.equals(this.completedAt, goalResponse.completedAt) &&
        Objects.equals(this.currentAmount, goalResponse.currentAmount) &&
        Objects.equals(this.goalTypeName, goalResponse.goalTypeName) &&
        Objects.equals(this.guid, goalResponse.guid) &&
        Objects.equals(this.hasBeenSpent, goalResponse.hasBeenSpent) &&
        Objects.equals(this.isComplete, goalResponse.isComplete) &&
        Objects.equals(this.metadata, goalResponse.metadata) &&
        Objects.equals(this.metaTypeName, goalResponse.metaTypeName) &&
        Objects.equals(this.name, goalResponse.name) &&
        Objects.equals(this.position, goalResponse.position) &&
        Objects.equals(this.projectedToCompleteAt, goalResponse.projectedToCompleteAt) &&
        Objects.equals(this.targetedToCompleteAt, goalResponse.targetedToCompleteAt) &&
        Objects.equals(this.trackTypeName, goalResponse.trackTypeName) &&
        Objects.equals(this.userGuid, goalResponse.userGuid);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountGuid, amount, completedAt, currentAmount, goalTypeName, guid, hasBeenSpent, isComplete, metadata, metaTypeName, name, position, projectedToCompleteAt, targetedToCompleteAt, trackTypeName, userGuid);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GoalResponse {\n");
    sb.append("    accountGuid: ").append(toIndentedString(accountGuid)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    completedAt: ").append(toIndentedString(completedAt)).append("\n");
    sb.append("    currentAmount: ").append(toIndentedString(currentAmount)).append("\n");
    sb.append("    goalTypeName: ").append(toIndentedString(goalTypeName)).append("\n");
    sb.append("    guid: ").append(toIndentedString(guid)).append("\n");
    sb.append("    hasBeenSpent: ").append(toIndentedString(hasBeenSpent)).append("\n");
    sb.append("    isComplete: ").append(toIndentedString(isComplete)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    metaTypeName: ").append(toIndentedString(metaTypeName)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    position: ").append(toIndentedString(position)).append("\n");
    sb.append("    projectedToCompleteAt: ").append(toIndentedString(projectedToCompleteAt)).append("\n");
    sb.append("    targetedToCompleteAt: ").append(toIndentedString(targetedToCompleteAt)).append("\n");
    sb.append("    trackTypeName: ").append(toIndentedString(trackTypeName)).append("\n");
    sb.append("    userGuid: ").append(toIndentedString(userGuid)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("account_guid");
    openapiFields.add("amount");
    openapiFields.add("completed_at");
    openapiFields.add("current_amount");
    openapiFields.add("goal_type_name");
    openapiFields.add("guid");
    openapiFields.add("has_been_spent");
    openapiFields.add("is_complete");
    openapiFields.add("metadata");
    openapiFields.add("meta_type_name");
    openapiFields.add("name");
    openapiFields.add("position");
    openapiFields.add("projected_to_complete_at");
    openapiFields.add("targeted_to_complete_at");
    openapiFields.add("track_type_name");
    openapiFields.add("user_guid");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Element and throws an exception if issues found
  *
  * @param jsonElement JSON Element
  * @throws IOException if the JSON Element is invalid with respect to GoalResponse
  */
  public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (jsonElement == null) {
        if (!GoalResponse.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in GoalResponse is not found in the empty JSON string", GoalResponse.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!GoalResponse.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `GoalResponse` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if ((jsonObj.get("account_guid") != null && !jsonObj.get("account_guid").isJsonNull()) && !jsonObj.get("account_guid").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `account_guid` to be a primitive type in the JSON string but got `%s`", jsonObj.get("account_guid").toString()));
      }
      if ((jsonObj.get("completed_at") != null && !jsonObj.get("completed_at").isJsonNull()) && !jsonObj.get("completed_at").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `completed_at` to be a primitive type in the JSON string but got `%s`", jsonObj.get("completed_at").toString()));
      }
      if ((jsonObj.get("goal_type_name") != null && !jsonObj.get("goal_type_name").isJsonNull()) && !jsonObj.get("goal_type_name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `goal_type_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("goal_type_name").toString()));
      }
      if ((jsonObj.get("guid") != null && !jsonObj.get("guid").isJsonNull()) && !jsonObj.get("guid").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `guid` to be a primitive type in the JSON string but got `%s`", jsonObj.get("guid").toString()));
      }
      if ((jsonObj.get("metadata") != null && !jsonObj.get("metadata").isJsonNull()) && !jsonObj.get("metadata").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `metadata` to be a primitive type in the JSON string but got `%s`", jsonObj.get("metadata").toString()));
      }
      if ((jsonObj.get("meta_type_name") != null && !jsonObj.get("meta_type_name").isJsonNull()) && !jsonObj.get("meta_type_name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `meta_type_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("meta_type_name").toString()));
      }
      if ((jsonObj.get("name") != null && !jsonObj.get("name").isJsonNull()) && !jsonObj.get("name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("name").toString()));
      }
      if ((jsonObj.get("projected_to_complete_at") != null && !jsonObj.get("projected_to_complete_at").isJsonNull()) && !jsonObj.get("projected_to_complete_at").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `projected_to_complete_at` to be a primitive type in the JSON string but got `%s`", jsonObj.get("projected_to_complete_at").toString()));
      }
      if ((jsonObj.get("targeted_to_complete_at") != null && !jsonObj.get("targeted_to_complete_at").isJsonNull()) && !jsonObj.get("targeted_to_complete_at").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `targeted_to_complete_at` to be a primitive type in the JSON string but got `%s`", jsonObj.get("targeted_to_complete_at").toString()));
      }
      if ((jsonObj.get("track_type_name") != null && !jsonObj.get("track_type_name").isJsonNull()) && !jsonObj.get("track_type_name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `track_type_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("track_type_name").toString()));
      }
      if ((jsonObj.get("user_guid") != null && !jsonObj.get("user_guid").isJsonNull()) && !jsonObj.get("user_guid").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `user_guid` to be a primitive type in the JSON string but got `%s`", jsonObj.get("user_guid").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!GoalResponse.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'GoalResponse' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<GoalResponse> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(GoalResponse.class));

       return (TypeAdapter<T>) new TypeAdapter<GoalResponse>() {
           @Override
           public void write(JsonWriter out, GoalResponse value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public GoalResponse read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of GoalResponse given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of GoalResponse
  * @throws IOException if the JSON string is invalid with respect to GoalResponse
  */
  public static GoalResponse fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, GoalResponse.class);
  }

 /**
  * Convert an instance of GoalResponse to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

