/*
 * MX Platform API
 * The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.
 *
 * The version of the OpenAPI document: 0.1.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.mx.client.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.mx.client.JSON;

/**
 * MonthlyCashFlowResponse
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class MonthlyCashFlowResponse {
  public static final String SERIALIZED_NAME_GUID = "guid";
  @SerializedName(SERIALIZED_NAME_GUID)
  private String guid;

  public static final String SERIALIZED_NAME_USER_GUID = "user_guid";
  @SerializedName(SERIALIZED_NAME_USER_GUID)
  private String userGuid;

  public static final String SERIALIZED_NAME_BUDGETED_INCOME = "budgeted_income";
  @SerializedName(SERIALIZED_NAME_BUDGETED_INCOME)
  private BigDecimal budgetedIncome;

  public static final String SERIALIZED_NAME_BUDGETED_EXPENSES = "budgeted_expenses";
  @SerializedName(SERIALIZED_NAME_BUDGETED_EXPENSES)
  private BigDecimal budgetedExpenses;

  public static final String SERIALIZED_NAME_GOALS_CONTRIBUTION = "goals_contribution";
  @SerializedName(SERIALIZED_NAME_GOALS_CONTRIBUTION)
  private BigDecimal goalsContribution;

  public static final String SERIALIZED_NAME_ESTIMATED_GOALS_CONTRIBUTION = "estimated_goals_contribution";
  @SerializedName(SERIALIZED_NAME_ESTIMATED_GOALS_CONTRIBUTION)
  private Integer estimatedGoalsContribution;

  public static final String SERIALIZED_NAME_USES_ESTIMATED_GOALS_CONTRIBUTION = "uses_estimated_goals_contribution";
  @SerializedName(SERIALIZED_NAME_USES_ESTIMATED_GOALS_CONTRIBUTION)
  private Boolean usesEstimatedGoalsContribution;

  public MonthlyCashFlowResponse() {
  }

  public MonthlyCashFlowResponse guid(String guid) {
    
    this.guid = guid;
    return this;
  }

   /**
   * Unique identifier for the monthly cash flow profile. Defined by MX.
   * @return guid
  **/
  @javax.annotation.Nullable
  public String getGuid() {
    return guid;
  }


  public void setGuid(String guid) {
    this.guid = guid;
  }


  public MonthlyCashFlowResponse userGuid(String userGuid) {
    
    this.userGuid = userGuid;
    return this;
  }

   /**
   * Unique identifier for the user the monthly cash flow profile is attached to. Defined by MX.
   * @return userGuid
  **/
  @javax.annotation.Nullable
  public String getUserGuid() {
    return userGuid;
  }


  public void setUserGuid(String userGuid) {
    this.userGuid = userGuid;
  }


  public MonthlyCashFlowResponse budgetedIncome(BigDecimal budgetedIncome) {
    
    this.budgetedIncome = budgetedIncome;
    return this;
  }

   /**
   * The amount of the budgeted income for the user.
   * @return budgetedIncome
  **/
  @javax.annotation.Nullable
  public BigDecimal getBudgetedIncome() {
    return budgetedIncome;
  }


  public void setBudgetedIncome(BigDecimal budgetedIncome) {
    this.budgetedIncome = budgetedIncome;
  }


  public MonthlyCashFlowResponse budgetedExpenses(BigDecimal budgetedExpenses) {
    
    this.budgetedExpenses = budgetedExpenses;
    return this;
  }

   /**
   * The amount of the budgeted expenses for the user.
   * @return budgetedExpenses
  **/
  @javax.annotation.Nullable
  public BigDecimal getBudgetedExpenses() {
    return budgetedExpenses;
  }


  public void setBudgetedExpenses(BigDecimal budgetedExpenses) {
    this.budgetedExpenses = budgetedExpenses;
  }


  public MonthlyCashFlowResponse goalsContribution(BigDecimal goalsContribution) {
    
    this.goalsContribution = goalsContribution;
    return this;
  }

   /**
   * The monthly dollar amount allocated for goals.
   * @return goalsContribution
  **/
  @javax.annotation.Nullable
  public BigDecimal getGoalsContribution() {
    return goalsContribution;
  }


  public void setGoalsContribution(BigDecimal goalsContribution) {
    this.goalsContribution = goalsContribution;
  }


  public MonthlyCashFlowResponse estimatedGoalsContribution(Integer estimatedGoalsContribution) {
    
    this.estimatedGoalsContribution = estimatedGoalsContribution;
    return this;
  }

   /**
   * The estimated monthly dollar amount allocated for goals calculated from income and budgets.
   * @return estimatedGoalsContribution
  **/
  @javax.annotation.Nullable
  public Integer getEstimatedGoalsContribution() {
    return estimatedGoalsContribution;
  }


  public void setEstimatedGoalsContribution(Integer estimatedGoalsContribution) {
    this.estimatedGoalsContribution = estimatedGoalsContribution;
  }


  public MonthlyCashFlowResponse usesEstimatedGoalsContribution(Boolean usesEstimatedGoalsContribution) {
    
    this.usesEstimatedGoalsContribution = usesEstimatedGoalsContribution;
    return this;
  }

   /**
   * Get usesEstimatedGoalsContribution
   * @return usesEstimatedGoalsContribution
  **/
  @javax.annotation.Nullable
  public Boolean getUsesEstimatedGoalsContribution() {
    return usesEstimatedGoalsContribution;
  }


  public void setUsesEstimatedGoalsContribution(Boolean usesEstimatedGoalsContribution) {
    this.usesEstimatedGoalsContribution = usesEstimatedGoalsContribution;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MonthlyCashFlowResponse monthlyCashFlowResponse = (MonthlyCashFlowResponse) o;
    return Objects.equals(this.guid, monthlyCashFlowResponse.guid) &&
        Objects.equals(this.userGuid, monthlyCashFlowResponse.userGuid) &&
        Objects.equals(this.budgetedIncome, monthlyCashFlowResponse.budgetedIncome) &&
        Objects.equals(this.budgetedExpenses, monthlyCashFlowResponse.budgetedExpenses) &&
        Objects.equals(this.goalsContribution, monthlyCashFlowResponse.goalsContribution) &&
        Objects.equals(this.estimatedGoalsContribution, monthlyCashFlowResponse.estimatedGoalsContribution) &&
        Objects.equals(this.usesEstimatedGoalsContribution, monthlyCashFlowResponse.usesEstimatedGoalsContribution);
  }

  @Override
  public int hashCode() {
    return Objects.hash(guid, userGuid, budgetedIncome, budgetedExpenses, goalsContribution, estimatedGoalsContribution, usesEstimatedGoalsContribution);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MonthlyCashFlowResponse {\n");
    sb.append("    guid: ").append(toIndentedString(guid)).append("\n");
    sb.append("    userGuid: ").append(toIndentedString(userGuid)).append("\n");
    sb.append("    budgetedIncome: ").append(toIndentedString(budgetedIncome)).append("\n");
    sb.append("    budgetedExpenses: ").append(toIndentedString(budgetedExpenses)).append("\n");
    sb.append("    goalsContribution: ").append(toIndentedString(goalsContribution)).append("\n");
    sb.append("    estimatedGoalsContribution: ").append(toIndentedString(estimatedGoalsContribution)).append("\n");
    sb.append("    usesEstimatedGoalsContribution: ").append(toIndentedString(usesEstimatedGoalsContribution)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("guid");
    openapiFields.add("user_guid");
    openapiFields.add("budgeted_income");
    openapiFields.add("budgeted_expenses");
    openapiFields.add("goals_contribution");
    openapiFields.add("estimated_goals_contribution");
    openapiFields.add("uses_estimated_goals_contribution");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Element and throws an exception if issues found
  *
  * @param jsonElement JSON Element
  * @throws IOException if the JSON Element is invalid with respect to MonthlyCashFlowResponse
  */
  public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (jsonElement == null) {
        if (!MonthlyCashFlowResponse.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in MonthlyCashFlowResponse is not found in the empty JSON string", MonthlyCashFlowResponse.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!MonthlyCashFlowResponse.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `MonthlyCashFlowResponse` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if ((jsonObj.get("guid") != null && !jsonObj.get("guid").isJsonNull()) && !jsonObj.get("guid").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `guid` to be a primitive type in the JSON string but got `%s`", jsonObj.get("guid").toString()));
      }
      if ((jsonObj.get("user_guid") != null && !jsonObj.get("user_guid").isJsonNull()) && !jsonObj.get("user_guid").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `user_guid` to be a primitive type in the JSON string but got `%s`", jsonObj.get("user_guid").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!MonthlyCashFlowResponse.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'MonthlyCashFlowResponse' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<MonthlyCashFlowResponse> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(MonthlyCashFlowResponse.class));

       return (TypeAdapter<T>) new TypeAdapter<MonthlyCashFlowResponse>() {
           @Override
           public void write(JsonWriter out, MonthlyCashFlowResponse value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public MonthlyCashFlowResponse read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of MonthlyCashFlowResponse given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of MonthlyCashFlowResponse
  * @throws IOException if the JSON string is invalid with respect to MonthlyCashFlowResponse
  */
  public static MonthlyCashFlowResponse fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, MonthlyCashFlowResponse.class);
  }

 /**
  * Convert an instance of MonthlyCashFlowResponse to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

