/*
 * MX Platform API
 * The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.
 *
 * The version of the OpenAPI document: 0.1.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.mx.client.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.mx.client.model.PaginationResponse;
import com.mx.client.model.ScheduledPaymentResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.mx.client.JSON;

/**
 * ScheduledPaymentsResponseBody
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class ScheduledPaymentsResponseBody {
  public static final String SERIALIZED_NAME_PAGINATION = "pagination";
  @SerializedName(SERIALIZED_NAME_PAGINATION)
  private PaginationResponse pagination;

  public static final String SERIALIZED_NAME_SCHEDULED_PAYMENTS = "scheduled_payments";
  @SerializedName(SERIALIZED_NAME_SCHEDULED_PAYMENTS)
  private List<ScheduledPaymentResponse> scheduledPayments;

  public ScheduledPaymentsResponseBody() {
  }

  public ScheduledPaymentsResponseBody pagination(PaginationResponse pagination) {
    
    this.pagination = pagination;
    return this;
  }

   /**
   * Get pagination
   * @return pagination
  **/
  @javax.annotation.Nullable
  public PaginationResponse getPagination() {
    return pagination;
  }


  public void setPagination(PaginationResponse pagination) {
    this.pagination = pagination;
  }


  public ScheduledPaymentsResponseBody scheduledPayments(List<ScheduledPaymentResponse> scheduledPayments) {
    
    this.scheduledPayments = scheduledPayments;
    return this;
  }

  public ScheduledPaymentsResponseBody addScheduledPaymentsItem(ScheduledPaymentResponse scheduledPaymentsItem) {
    if (this.scheduledPayments == null) {
      this.scheduledPayments = new ArrayList<>();
    }
    this.scheduledPayments.add(scheduledPaymentsItem);
    return this;
  }

   /**
   * Get scheduledPayments
   * @return scheduledPayments
  **/
  @javax.annotation.Nullable
  public List<ScheduledPaymentResponse> getScheduledPayments() {
    return scheduledPayments;
  }


  public void setScheduledPayments(List<ScheduledPaymentResponse> scheduledPayments) {
    this.scheduledPayments = scheduledPayments;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ScheduledPaymentsResponseBody scheduledPaymentsResponseBody = (ScheduledPaymentsResponseBody) o;
    return Objects.equals(this.pagination, scheduledPaymentsResponseBody.pagination) &&
        Objects.equals(this.scheduledPayments, scheduledPaymentsResponseBody.scheduledPayments);
  }

  @Override
  public int hashCode() {
    return Objects.hash(pagination, scheduledPayments);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ScheduledPaymentsResponseBody {\n");
    sb.append("    pagination: ").append(toIndentedString(pagination)).append("\n");
    sb.append("    scheduledPayments: ").append(toIndentedString(scheduledPayments)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("pagination");
    openapiFields.add("scheduled_payments");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Element and throws an exception if issues found
  *
  * @param jsonElement JSON Element
  * @throws IOException if the JSON Element is invalid with respect to ScheduledPaymentsResponseBody
  */
  public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (jsonElement == null) {
        if (!ScheduledPaymentsResponseBody.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in ScheduledPaymentsResponseBody is not found in the empty JSON string", ScheduledPaymentsResponseBody.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!ScheduledPaymentsResponseBody.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `ScheduledPaymentsResponseBody` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      // validate the optional field `pagination`
      if (jsonObj.get("pagination") != null && !jsonObj.get("pagination").isJsonNull()) {
        PaginationResponse.validateJsonElement(jsonObj.get("pagination"));
      }
      if (jsonObj.get("scheduled_payments") != null && !jsonObj.get("scheduled_payments").isJsonNull()) {
        JsonArray jsonArrayscheduledPayments = jsonObj.getAsJsonArray("scheduled_payments");
        if (jsonArrayscheduledPayments != null) {
          // ensure the json data is an array
          if (!jsonObj.get("scheduled_payments").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `scheduled_payments` to be an array in the JSON string but got `%s`", jsonObj.get("scheduled_payments").toString()));
          }

          // validate the optional field `scheduled_payments` (array)
          for (int i = 0; i < jsonArrayscheduledPayments.size(); i++) {
            ScheduledPaymentResponse.validateJsonElement(jsonArrayscheduledPayments.get(i));
          };
        }
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!ScheduledPaymentsResponseBody.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'ScheduledPaymentsResponseBody' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<ScheduledPaymentsResponseBody> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(ScheduledPaymentsResponseBody.class));

       return (TypeAdapter<T>) new TypeAdapter<ScheduledPaymentsResponseBody>() {
           @Override
           public void write(JsonWriter out, ScheduledPaymentsResponseBody value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public ScheduledPaymentsResponseBody read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of ScheduledPaymentsResponseBody given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of ScheduledPaymentsResponseBody
  * @throws IOException if the JSON string is invalid with respect to ScheduledPaymentsResponseBody
  */
  public static ScheduledPaymentsResponseBody fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, ScheduledPaymentsResponseBody.class);
  }

 /**
  * Convert an instance of ScheduledPaymentsResponseBody to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

