/*
 * MX Platform API
 * The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.
 *
 * The version of the OpenAPI document: 0.1.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.mx.client.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.mx.client.JSON;

/**
 * UpdateGoalRequest
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class UpdateGoalRequest {
  public static final String SERIALIZED_NAME_ACCOUNT_GUID = "account_guid";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_GUID)
  private String accountGuid;

  public static final String SERIALIZED_NAME_AMOUNT = "amount";
  @SerializedName(SERIALIZED_NAME_AMOUNT)
  private BigDecimal amount;

  public static final String SERIALIZED_NAME_GOAL_TYPE_NAME = "goal_type_name";
  @SerializedName(SERIALIZED_NAME_GOAL_TYPE_NAME)
  private String goalTypeName;

  public static final String SERIALIZED_NAME_META_TYPE_NAME = "meta_type_name";
  @SerializedName(SERIALIZED_NAME_META_TYPE_NAME)
  private String metaTypeName;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_COMPLETED_AT = "completed_at";
  @SerializedName(SERIALIZED_NAME_COMPLETED_AT)
  private String completedAt;

  public static final String SERIALIZED_NAME_HAS_BEEN_SPENT = "has_been_spent";
  @SerializedName(SERIALIZED_NAME_HAS_BEEN_SPENT)
  private Boolean hasBeenSpent;

  public static final String SERIALIZED_NAME_IS_COMPLETE = "is_complete";
  @SerializedName(SERIALIZED_NAME_IS_COMPLETE)
  private Boolean isComplete;

  public static final String SERIALIZED_NAME_METADATA = "metadata";
  @SerializedName(SERIALIZED_NAME_METADATA)
  private String metadata;

  public static final String SERIALIZED_NAME_POSITION = "position";
  @SerializedName(SERIALIZED_NAME_POSITION)
  private Integer position;

  public static final String SERIALIZED_NAME_TARGETED_TO_COMPLETE_AT = "targeted_to_complete_at";
  @SerializedName(SERIALIZED_NAME_TARGETED_TO_COMPLETE_AT)
  private String targetedToCompleteAt;

  public UpdateGoalRequest() {
  }

  public UpdateGoalRequest accountGuid(String accountGuid) {
    
    this.accountGuid = accountGuid;
    return this;
  }

   /**
   * Unique identifier of the account for the goal.
   * @return accountGuid
  **/
  @javax.annotation.Nullable
  public String getAccountGuid() {
    return accountGuid;
  }


  public void setAccountGuid(String accountGuid) {
    this.accountGuid = accountGuid;
  }


  public UpdateGoalRequest amount(BigDecimal amount) {
    
    this.amount = amount;
    return this;
  }

   /**
   * Amount of the goal.
   * @return amount
  **/
  @javax.annotation.Nullable
  public BigDecimal getAmount() {
    return amount;
  }


  public void setAmount(BigDecimal amount) {
    this.amount = amount;
  }


  public UpdateGoalRequest goalTypeName(String goalTypeName) {
    
    this.goalTypeName = goalTypeName;
    return this;
  }

   /**
   * The goal type.
   * @return goalTypeName
  **/
  @javax.annotation.Nullable
  public String getGoalTypeName() {
    return goalTypeName;
  }


  public void setGoalTypeName(String goalTypeName) {
    this.goalTypeName = goalTypeName;
  }


  public UpdateGoalRequest metaTypeName(String metaTypeName) {
    
    this.metaTypeName = metaTypeName;
    return this;
  }

   /**
   * The category of the goal.
   * @return metaTypeName
  **/
  @javax.annotation.Nullable
  public String getMetaTypeName() {
    return metaTypeName;
  }


  public void setMetaTypeName(String metaTypeName) {
    this.metaTypeName = metaTypeName;
  }


  public UpdateGoalRequest name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * The name of the goal.
   * @return name
  **/
  @javax.annotation.Nullable
  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }


  public UpdateGoalRequest completedAt(String completedAt) {
    
    this.completedAt = completedAt;
    return this;
  }

   /**
   * Date and time the goal was completed.
   * @return completedAt
  **/
  @javax.annotation.Nullable
  public String getCompletedAt() {
    return completedAt;
  }


  public void setCompletedAt(String completedAt) {
    this.completedAt = completedAt;
  }


  public UpdateGoalRequest hasBeenSpent(Boolean hasBeenSpent) {
    
    this.hasBeenSpent = hasBeenSpent;
    return this;
  }

   /**
   * Determines if the goal has been spent.
   * @return hasBeenSpent
  **/
  @javax.annotation.Nullable
  public Boolean getHasBeenSpent() {
    return hasBeenSpent;
  }


  public void setHasBeenSpent(Boolean hasBeenSpent) {
    this.hasBeenSpent = hasBeenSpent;
  }


  public UpdateGoalRequest isComplete(Boolean isComplete) {
    
    this.isComplete = isComplete;
    return this;
  }

   /**
   * Determines if the goal is complete.
   * @return isComplete
  **/
  @javax.annotation.Nullable
  public Boolean getIsComplete() {
    return isComplete;
  }


  public void setIsComplete(Boolean isComplete) {
    this.isComplete = isComplete;
  }


  public UpdateGoalRequest metadata(String metadata) {
    
    this.metadata = metadata;
    return this;
  }

   /**
   * Additional information a partner can store on the goal.
   * @return metadata
  **/
  @javax.annotation.Nullable
  public String getMetadata() {
    return metadata;
  }


  public void setMetadata(String metadata) {
    this.metadata = metadata;
  }


  public UpdateGoalRequest position(Integer position) {
    
    this.position = position;
    return this;
  }

   /**
   * The priority of the goal in relation to multiple goals.
   * @return position
  **/
  @javax.annotation.Nullable
  public Integer getPosition() {
    return position;
  }


  public void setPosition(Integer position) {
    this.position = position;
  }


  public UpdateGoalRequest targetedToCompleteAt(String targetedToCompleteAt) {
    
    this.targetedToCompleteAt = targetedToCompleteAt;
    return this;
  }

   /**
   * Date and time the goal is to complete. Intended for users to set their own goal completion dates.
   * @return targetedToCompleteAt
  **/
  @javax.annotation.Nullable
  public String getTargetedToCompleteAt() {
    return targetedToCompleteAt;
  }


  public void setTargetedToCompleteAt(String targetedToCompleteAt) {
    this.targetedToCompleteAt = targetedToCompleteAt;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpdateGoalRequest updateGoalRequest = (UpdateGoalRequest) o;
    return Objects.equals(this.accountGuid, updateGoalRequest.accountGuid) &&
        Objects.equals(this.amount, updateGoalRequest.amount) &&
        Objects.equals(this.goalTypeName, updateGoalRequest.goalTypeName) &&
        Objects.equals(this.metaTypeName, updateGoalRequest.metaTypeName) &&
        Objects.equals(this.name, updateGoalRequest.name) &&
        Objects.equals(this.completedAt, updateGoalRequest.completedAt) &&
        Objects.equals(this.hasBeenSpent, updateGoalRequest.hasBeenSpent) &&
        Objects.equals(this.isComplete, updateGoalRequest.isComplete) &&
        Objects.equals(this.metadata, updateGoalRequest.metadata) &&
        Objects.equals(this.position, updateGoalRequest.position) &&
        Objects.equals(this.targetedToCompleteAt, updateGoalRequest.targetedToCompleteAt);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountGuid, amount, goalTypeName, metaTypeName, name, completedAt, hasBeenSpent, isComplete, metadata, position, targetedToCompleteAt);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpdateGoalRequest {\n");
    sb.append("    accountGuid: ").append(toIndentedString(accountGuid)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    goalTypeName: ").append(toIndentedString(goalTypeName)).append("\n");
    sb.append("    metaTypeName: ").append(toIndentedString(metaTypeName)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    completedAt: ").append(toIndentedString(completedAt)).append("\n");
    sb.append("    hasBeenSpent: ").append(toIndentedString(hasBeenSpent)).append("\n");
    sb.append("    isComplete: ").append(toIndentedString(isComplete)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    position: ").append(toIndentedString(position)).append("\n");
    sb.append("    targetedToCompleteAt: ").append(toIndentedString(targetedToCompleteAt)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("account_guid");
    openapiFields.add("amount");
    openapiFields.add("goal_type_name");
    openapiFields.add("meta_type_name");
    openapiFields.add("name");
    openapiFields.add("completed_at");
    openapiFields.add("has_been_spent");
    openapiFields.add("is_complete");
    openapiFields.add("metadata");
    openapiFields.add("position");
    openapiFields.add("targeted_to_complete_at");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Element and throws an exception if issues found
  *
  * @param jsonElement JSON Element
  * @throws IOException if the JSON Element is invalid with respect to UpdateGoalRequest
  */
  public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (jsonElement == null) {
        if (!UpdateGoalRequest.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in UpdateGoalRequest is not found in the empty JSON string", UpdateGoalRequest.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!UpdateGoalRequest.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `UpdateGoalRequest` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if ((jsonObj.get("account_guid") != null && !jsonObj.get("account_guid").isJsonNull()) && !jsonObj.get("account_guid").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `account_guid` to be a primitive type in the JSON string but got `%s`", jsonObj.get("account_guid").toString()));
      }
      if ((jsonObj.get("goal_type_name") != null && !jsonObj.get("goal_type_name").isJsonNull()) && !jsonObj.get("goal_type_name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `goal_type_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("goal_type_name").toString()));
      }
      if ((jsonObj.get("meta_type_name") != null && !jsonObj.get("meta_type_name").isJsonNull()) && !jsonObj.get("meta_type_name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `meta_type_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("meta_type_name").toString()));
      }
      if ((jsonObj.get("name") != null && !jsonObj.get("name").isJsonNull()) && !jsonObj.get("name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("name").toString()));
      }
      if ((jsonObj.get("completed_at") != null && !jsonObj.get("completed_at").isJsonNull()) && !jsonObj.get("completed_at").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `completed_at` to be a primitive type in the JSON string but got `%s`", jsonObj.get("completed_at").toString()));
      }
      if ((jsonObj.get("metadata") != null && !jsonObj.get("metadata").isJsonNull()) && !jsonObj.get("metadata").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `metadata` to be a primitive type in the JSON string but got `%s`", jsonObj.get("metadata").toString()));
      }
      if ((jsonObj.get("targeted_to_complete_at") != null && !jsonObj.get("targeted_to_complete_at").isJsonNull()) && !jsonObj.get("targeted_to_complete_at").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `targeted_to_complete_at` to be a primitive type in the JSON string but got `%s`", jsonObj.get("targeted_to_complete_at").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!UpdateGoalRequest.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'UpdateGoalRequest' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<UpdateGoalRequest> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(UpdateGoalRequest.class));

       return (TypeAdapter<T>) new TypeAdapter<UpdateGoalRequest>() {
           @Override
           public void write(JsonWriter out, UpdateGoalRequest value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public UpdateGoalRequest read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of UpdateGoalRequest given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of UpdateGoalRequest
  * @throws IOException if the JSON string is invalid with respect to UpdateGoalRequest
  */
  public static UpdateGoalRequest fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, UpdateGoalRequest.class);
  }

 /**
  * Convert an instance of UpdateGoalRequest to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

