/*
 * MX Platform API
 * The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.
 *
 * The version of the OpenAPI document: 0.1.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.mx.client.mx_platform_api;

import com.mx.client.ApiCallback;
import com.mx.client.ApiClient;
import com.mx.client.ApiException;
import com.mx.client.ApiResponse;
import com.mx.client.Configuration;
import com.mx.client.Pair;
import com.mx.client.ProgressRequestBody;
import com.mx.client.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import com.mx.client.model.GoalRequestBody;
import com.mx.client.model.GoalResponseBody;
import com.mx.client.model.GoalsResponseBody;
import com.mx.client.model.RepositionRequestBody;
import com.mx.client.model.RepositionResponseBody;
import com.mx.client.model.UpdateGoalRequestBody;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GoalsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public GoalsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public GoalsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    /**
     * Build call for usersUserGuidGoalsGet
     * @param userGuid The unique identifier for the user. (required)
     * @param page Results are returned in paginated sets, this is the page of the results you would like to view. Defaults to page 1 if no page is specified. (optional)
     * @param recordsPerAge The supported range is from 10 to 1000. If the records_per_page parameter is not specified or is outside this range, a default of 25 records per page will be used. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersUserGuidGoalsGetCall(String userGuid, String page, String recordsPerAge, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/goals"
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerAge != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_age", recordsPerAge));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call usersUserGuidGoalsGetValidateBeforeCall(String userGuid, String page, String recordsPerAge, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling usersUserGuidGoalsGet(Async)");
        }

        return usersUserGuidGoalsGetCall(userGuid, page, recordsPerAge, _callback);

    }

    /**
     * List goals
     * List all goals a user can set.
     * @param userGuid The unique identifier for the user. (required)
     * @param page Results are returned in paginated sets, this is the page of the results you would like to view. Defaults to page 1 if no page is specified. (optional)
     * @param recordsPerAge The supported range is from 10 to 1000. If the records_per_page parameter is not specified or is outside this range, a default of 25 records per page will be used. (optional)
     * @return GoalsResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public GoalsResponseBody usersUserGuidGoalsGet(String userGuid, String page, String recordsPerAge) throws ApiException {
        ApiResponse<GoalsResponseBody> localVarResp = usersUserGuidGoalsGetWithHttpInfo(userGuid, page, recordsPerAge);
        return localVarResp.getData();
    }

    /**
     * List goals
     * List all goals a user can set.
     * @param userGuid The unique identifier for the user. (required)
     * @param page Results are returned in paginated sets, this is the page of the results you would like to view. Defaults to page 1 if no page is specified. (optional)
     * @param recordsPerAge The supported range is from 10 to 1000. If the records_per_page parameter is not specified or is outside this range, a default of 25 records per page will be used. (optional)
     * @return ApiResponse&lt;GoalsResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<GoalsResponseBody> usersUserGuidGoalsGetWithHttpInfo(String userGuid, String page, String recordsPerAge) throws ApiException {
        okhttp3.Call localVarCall = usersUserGuidGoalsGetValidateBeforeCall(userGuid, page, recordsPerAge, null);
        Type localVarReturnType = new TypeToken<GoalsResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List goals (asynchronously)
     * List all goals a user can set.
     * @param userGuid The unique identifier for the user. (required)
     * @param page Results are returned in paginated sets, this is the page of the results you would like to view. Defaults to page 1 if no page is specified. (optional)
     * @param recordsPerAge The supported range is from 10 to 1000. If the records_per_page parameter is not specified or is outside this range, a default of 25 records per page will be used. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersUserGuidGoalsGetAsync(String userGuid, String page, String recordsPerAge, final ApiCallback<GoalsResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = usersUserGuidGoalsGetValidateBeforeCall(userGuid, page, recordsPerAge, _callback);
        Type localVarReturnType = new TypeToken<GoalsResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for usersUserGuidGoalsGoalGuidDelete
     * @param goalGuid The unique identifier for a goal. Defined by MX. (required)
     * @param userGuid The unique identifier for a user. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersUserGuidGoalsGoalGuidDeleteCall(String goalGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/goals/{goal_guid}"
            .replace("{" + "goal_guid" + "}", localVarApiClient.escapeString(goalGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call usersUserGuidGoalsGoalGuidDeleteValidateBeforeCall(String goalGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'goalGuid' is set
        if (goalGuid == null) {
            throw new ApiException("Missing the required parameter 'goalGuid' when calling usersUserGuidGoalsGoalGuidDelete(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling usersUserGuidGoalsGoalGuidDelete(Async)");
        }

        return usersUserGuidGoalsGoalGuidDeleteCall(goalGuid, userGuid, _callback);

    }

    /**
     * Delete a goal
     * Delete a goal.
     * @param goalGuid The unique identifier for a goal. Defined by MX. (required)
     * @param userGuid The unique identifier for a user. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No content </td><td>  -  </td></tr>
     </table>
     */
    public void usersUserGuidGoalsGoalGuidDelete(String goalGuid, String userGuid) throws ApiException {
        usersUserGuidGoalsGoalGuidDeleteWithHttpInfo(goalGuid, userGuid);
    }

    /**
     * Delete a goal
     * Delete a goal.
     * @param goalGuid The unique identifier for a goal. Defined by MX. (required)
     * @param userGuid The unique identifier for a user. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No content </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> usersUserGuidGoalsGoalGuidDeleteWithHttpInfo(String goalGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = usersUserGuidGoalsGoalGuidDeleteValidateBeforeCall(goalGuid, userGuid, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete a goal (asynchronously)
     * Delete a goal.
     * @param goalGuid The unique identifier for a goal. Defined by MX. (required)
     * @param userGuid The unique identifier for a user. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersUserGuidGoalsGoalGuidDeleteAsync(String goalGuid, String userGuid, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = usersUserGuidGoalsGoalGuidDeleteValidateBeforeCall(goalGuid, userGuid, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for usersUserGuidGoalsGoalGuidGet
     * @param goalGuid The unique identifier for a goal. Defined by MX. (required)
     * @param userGuid The unique identifier for a user. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersUserGuidGoalsGoalGuidGetCall(String goalGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/goals/{goal_guid}"
            .replace("{" + "goal_guid" + "}", localVarApiClient.escapeString(goalGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call usersUserGuidGoalsGoalGuidGetValidateBeforeCall(String goalGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'goalGuid' is set
        if (goalGuid == null) {
            throw new ApiException("Missing the required parameter 'goalGuid' when calling usersUserGuidGoalsGoalGuidGet(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling usersUserGuidGoalsGoalGuidGet(Async)");
        }

        return usersUserGuidGoalsGoalGuidGetCall(goalGuid, userGuid, _callback);

    }

    /**
     * Read a goal
     * Read a specific goal.
     * @param goalGuid The unique identifier for a goal. Defined by MX. (required)
     * @param userGuid The unique identifier for a user. (required)
     * @return GoalResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public GoalResponseBody usersUserGuidGoalsGoalGuidGet(String goalGuid, String userGuid) throws ApiException {
        ApiResponse<GoalResponseBody> localVarResp = usersUserGuidGoalsGoalGuidGetWithHttpInfo(goalGuid, userGuid);
        return localVarResp.getData();
    }

    /**
     * Read a goal
     * Read a specific goal.
     * @param goalGuid The unique identifier for a goal. Defined by MX. (required)
     * @param userGuid The unique identifier for a user. (required)
     * @return ApiResponse&lt;GoalResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<GoalResponseBody> usersUserGuidGoalsGoalGuidGetWithHttpInfo(String goalGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = usersUserGuidGoalsGoalGuidGetValidateBeforeCall(goalGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<GoalResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Read a goal (asynchronously)
     * Read a specific goal.
     * @param goalGuid The unique identifier for a goal. Defined by MX. (required)
     * @param userGuid The unique identifier for a user. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersUserGuidGoalsGoalGuidGetAsync(String goalGuid, String userGuid, final ApiCallback<GoalResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = usersUserGuidGoalsGoalGuidGetValidateBeforeCall(goalGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<GoalResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for usersUserGuidGoalsGoalGuidPut
     * @param goalGuid The unique identifier for a goal. Defined by MX. (required)
     * @param userGuid The unique identifier for a user. (required)
     * @param updateGoalRequestBody  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersUserGuidGoalsGoalGuidPutCall(String goalGuid, String userGuid, UpdateGoalRequestBody updateGoalRequestBody, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = updateGoalRequestBody;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/goals/{goal_guid}"
            .replace("{" + "goal_guid" + "}", localVarApiClient.escapeString(goalGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call usersUserGuidGoalsGoalGuidPutValidateBeforeCall(String goalGuid, String userGuid, UpdateGoalRequestBody updateGoalRequestBody, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'goalGuid' is set
        if (goalGuid == null) {
            throw new ApiException("Missing the required parameter 'goalGuid' when calling usersUserGuidGoalsGoalGuidPut(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling usersUserGuidGoalsGoalGuidPut(Async)");
        }

        // verify the required parameter 'updateGoalRequestBody' is set
        if (updateGoalRequestBody == null) {
            throw new ApiException("Missing the required parameter 'updateGoalRequestBody' when calling usersUserGuidGoalsGoalGuidPut(Async)");
        }

        return usersUserGuidGoalsGoalGuidPutCall(goalGuid, userGuid, updateGoalRequestBody, _callback);

    }

    /**
     * Update a goal
     * This endpoint updates a specific goal.
     * @param goalGuid The unique identifier for a goal. Defined by MX. (required)
     * @param userGuid The unique identifier for a user. (required)
     * @param updateGoalRequestBody  (required)
     * @return GoalResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public GoalResponseBody usersUserGuidGoalsGoalGuidPut(String goalGuid, String userGuid, UpdateGoalRequestBody updateGoalRequestBody) throws ApiException {
        ApiResponse<GoalResponseBody> localVarResp = usersUserGuidGoalsGoalGuidPutWithHttpInfo(goalGuid, userGuid, updateGoalRequestBody);
        return localVarResp.getData();
    }

    /**
     * Update a goal
     * This endpoint updates a specific goal.
     * @param goalGuid The unique identifier for a goal. Defined by MX. (required)
     * @param userGuid The unique identifier for a user. (required)
     * @param updateGoalRequestBody  (required)
     * @return ApiResponse&lt;GoalResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<GoalResponseBody> usersUserGuidGoalsGoalGuidPutWithHttpInfo(String goalGuid, String userGuid, UpdateGoalRequestBody updateGoalRequestBody) throws ApiException {
        okhttp3.Call localVarCall = usersUserGuidGoalsGoalGuidPutValidateBeforeCall(goalGuid, userGuid, updateGoalRequestBody, null);
        Type localVarReturnType = new TypeToken<GoalResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update a goal (asynchronously)
     * This endpoint updates a specific goal.
     * @param goalGuid The unique identifier for a goal. Defined by MX. (required)
     * @param userGuid The unique identifier for a user. (required)
     * @param updateGoalRequestBody  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersUserGuidGoalsGoalGuidPutAsync(String goalGuid, String userGuid, UpdateGoalRequestBody updateGoalRequestBody, final ApiCallback<GoalResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = usersUserGuidGoalsGoalGuidPutValidateBeforeCall(goalGuid, userGuid, updateGoalRequestBody, _callback);
        Type localVarReturnType = new TypeToken<GoalResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for usersUserGuidGoalsPost
     * @param userGuid The unique identifier for the user. (required)
     * @param goalRequestBody  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersUserGuidGoalsPostCall(String userGuid, GoalRequestBody goalRequestBody, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = goalRequestBody;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/goals"
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call usersUserGuidGoalsPostValidateBeforeCall(String userGuid, GoalRequestBody goalRequestBody, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling usersUserGuidGoalsPost(Async)");
        }

        // verify the required parameter 'goalRequestBody' is set
        if (goalRequestBody == null) {
            throw new ApiException("Missing the required parameter 'goalRequestBody' when calling usersUserGuidGoalsPost(Async)");
        }

        return usersUserGuidGoalsPostCall(userGuid, goalRequestBody, _callback);

    }

    /**
     * Create a goal
     * Create a goal. This endpoint accepts the optional &#x60;MX-Skip-Webhook&#x60; header and &#x60;skip_webhook&#x60; parameter.
     * @param userGuid The unique identifier for the user. (required)
     * @param goalRequestBody  (required)
     * @return GoalResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public GoalResponseBody usersUserGuidGoalsPost(String userGuid, GoalRequestBody goalRequestBody) throws ApiException {
        ApiResponse<GoalResponseBody> localVarResp = usersUserGuidGoalsPostWithHttpInfo(userGuid, goalRequestBody);
        return localVarResp.getData();
    }

    /**
     * Create a goal
     * Create a goal. This endpoint accepts the optional &#x60;MX-Skip-Webhook&#x60; header and &#x60;skip_webhook&#x60; parameter.
     * @param userGuid The unique identifier for the user. (required)
     * @param goalRequestBody  (required)
     * @return ApiResponse&lt;GoalResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<GoalResponseBody> usersUserGuidGoalsPostWithHttpInfo(String userGuid, GoalRequestBody goalRequestBody) throws ApiException {
        okhttp3.Call localVarCall = usersUserGuidGoalsPostValidateBeforeCall(userGuid, goalRequestBody, null);
        Type localVarReturnType = new TypeToken<GoalResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create a goal (asynchronously)
     * Create a goal. This endpoint accepts the optional &#x60;MX-Skip-Webhook&#x60; header and &#x60;skip_webhook&#x60; parameter.
     * @param userGuid The unique identifier for the user. (required)
     * @param goalRequestBody  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersUserGuidGoalsPostAsync(String userGuid, GoalRequestBody goalRequestBody, final ApiCallback<GoalResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = usersUserGuidGoalsPostValidateBeforeCall(userGuid, goalRequestBody, _callback);
        Type localVarReturnType = new TypeToken<GoalResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for usersUserGuidGoalsRepositionPut
     * @param userGuid The unique identifier for the user. (required)
     * @param repositionRequestBody  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersUserGuidGoalsRepositionPutCall(String userGuid, RepositionRequestBody repositionRequestBody, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = repositionRequestBody;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/goals/reposition"
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call usersUserGuidGoalsRepositionPutValidateBeforeCall(String userGuid, RepositionRequestBody repositionRequestBody, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling usersUserGuidGoalsRepositionPut(Async)");
        }

        // verify the required parameter 'repositionRequestBody' is set
        if (repositionRequestBody == null) {
            throw new ApiException("Missing the required parameter 'repositionRequestBody' when calling usersUserGuidGoalsRepositionPut(Async)");
        }

        return usersUserGuidGoalsRepositionPutCall(userGuid, repositionRequestBody, _callback);

    }

    /**
     * Reposition goals
     * This endpoint repositions goal priority levels. If one goal is set to a lower priority, then any other goals need to be adjusted accordingly.
     * @param userGuid The unique identifier for the user. (required)
     * @param repositionRequestBody  (required)
     * @return RepositionResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public RepositionResponseBody usersUserGuidGoalsRepositionPut(String userGuid, RepositionRequestBody repositionRequestBody) throws ApiException {
        ApiResponse<RepositionResponseBody> localVarResp = usersUserGuidGoalsRepositionPutWithHttpInfo(userGuid, repositionRequestBody);
        return localVarResp.getData();
    }

    /**
     * Reposition goals
     * This endpoint repositions goal priority levels. If one goal is set to a lower priority, then any other goals need to be adjusted accordingly.
     * @param userGuid The unique identifier for the user. (required)
     * @param repositionRequestBody  (required)
     * @return ApiResponse&lt;RepositionResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<RepositionResponseBody> usersUserGuidGoalsRepositionPutWithHttpInfo(String userGuid, RepositionRequestBody repositionRequestBody) throws ApiException {
        okhttp3.Call localVarCall = usersUserGuidGoalsRepositionPutValidateBeforeCall(userGuid, repositionRequestBody, null);
        Type localVarReturnType = new TypeToken<RepositionResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Reposition goals (asynchronously)
     * This endpoint repositions goal priority levels. If one goal is set to a lower priority, then any other goals need to be adjusted accordingly.
     * @param userGuid The unique identifier for the user. (required)
     * @param repositionRequestBody  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersUserGuidGoalsRepositionPutAsync(String userGuid, RepositionRequestBody repositionRequestBody, final ApiCallback<RepositionResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = usersUserGuidGoalsRepositionPutValidateBeforeCall(userGuid, repositionRequestBody, _callback);
        Type localVarReturnType = new TypeToken<RepositionResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
