/*
 * MX Platform API
 * The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.
 *
 * The version of the OpenAPI document: 0.1.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.mx.client.mx_platform_api;

import com.mx.client.ApiCallback;
import com.mx.client.ApiClient;
import com.mx.client.ApiException;
import com.mx.client.ApiResponse;
import com.mx.client.Configuration;
import com.mx.client.Pair;
import com.mx.client.ProgressRequestBody;
import com.mx.client.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import com.mx.client.model.AccountsResponseBody;
import com.mx.client.model.CategoriesResponseBody;
import com.mx.client.model.InsightResponse;
import com.mx.client.model.InsightResponseBody;
import com.mx.client.model.InsightUpdateRequest;
import com.mx.client.model.InsightsResponseBody;
import com.mx.client.model.MerchantsResponseBody;
import com.mx.client.model.ScheduledPaymentsResponseBody;
import com.mx.client.model.TransactionsResponseBody;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InsightsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public InsightsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public InsightsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    /**
     * Build call for listAccountsInsight
     * @param userGuid The unique identifier for the user. Defined by MX. (required)
     * @param insightGuid The unique identifier for the insight. Defined by MX. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listAccountsInsightCall(String userGuid, String insightGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/insights/{insight_guid}/accounts"
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()))
            .replace("{" + "insight_guid" + "}", localVarApiClient.escapeString(insightGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listAccountsInsightValidateBeforeCall(String userGuid, String insightGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listAccountsInsight(Async)");
        }

        // verify the required parameter 'insightGuid' is set
        if (insightGuid == null) {
            throw new ApiException("Missing the required parameter 'insightGuid' when calling listAccountsInsight(Async)");
        }

        return listAccountsInsightCall(userGuid, insightGuid, page, recordsPerPage, _callback);

    }

    /**
     * List all accounts associated with an insight.
     * Use this endpoint to list all the accounts associated with the insight.
     * @param userGuid The unique identifier for the user. Defined by MX. (required)
     * @param insightGuid The unique identifier for the insight. Defined by MX. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return AccountsResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public AccountsResponseBody listAccountsInsight(String userGuid, String insightGuid, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<AccountsResponseBody> localVarResp = listAccountsInsightWithHttpInfo(userGuid, insightGuid, page, recordsPerPage);
        return localVarResp.getData();
    }

    /**
     * List all accounts associated with an insight.
     * Use this endpoint to list all the accounts associated with the insight.
     * @param userGuid The unique identifier for the user. Defined by MX. (required)
     * @param insightGuid The unique identifier for the insight. Defined by MX. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return ApiResponse&lt;AccountsResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AccountsResponseBody> listAccountsInsightWithHttpInfo(String userGuid, String insightGuid, Integer page, Integer recordsPerPage) throws ApiException {
        okhttp3.Call localVarCall = listAccountsInsightValidateBeforeCall(userGuid, insightGuid, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<AccountsResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List all accounts associated with an insight. (asynchronously)
     * Use this endpoint to list all the accounts associated with the insight.
     * @param userGuid The unique identifier for the user. Defined by MX. (required)
     * @param insightGuid The unique identifier for the insight. Defined by MX. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listAccountsInsightAsync(String userGuid, String insightGuid, Integer page, Integer recordsPerPage, final ApiCallback<AccountsResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listAccountsInsightValidateBeforeCall(userGuid, insightGuid, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<AccountsResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listCategoriesInsight
     * @param userGuid The unique identifier for the user. Defined by MX. (required)
     * @param insightGuid The unique identifier for the insight. Defined by MX. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listCategoriesInsightCall(String userGuid, String insightGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/insights/{insight_guid}/categories"
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()))
            .replace("{" + "insight_guid" + "}", localVarApiClient.escapeString(insightGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listCategoriesInsightValidateBeforeCall(String userGuid, String insightGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listCategoriesInsight(Async)");
        }

        // verify the required parameter 'insightGuid' is set
        if (insightGuid == null) {
            throw new ApiException("Missing the required parameter 'insightGuid' when calling listCategoriesInsight(Async)");
        }

        return listCategoriesInsightCall(userGuid, insightGuid, page, recordsPerPage, _callback);

    }

    /**
     * List all categories associated with an insight.
     * Use this endpoint to list all the categories associated with the insight.
     * @param userGuid The unique identifier for the user. Defined by MX. (required)
     * @param insightGuid The unique identifier for the insight. Defined by MX. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return CategoriesResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public CategoriesResponseBody listCategoriesInsight(String userGuid, String insightGuid, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<CategoriesResponseBody> localVarResp = listCategoriesInsightWithHttpInfo(userGuid, insightGuid, page, recordsPerPage);
        return localVarResp.getData();
    }

    /**
     * List all categories associated with an insight.
     * Use this endpoint to list all the categories associated with the insight.
     * @param userGuid The unique identifier for the user. Defined by MX. (required)
     * @param insightGuid The unique identifier for the insight. Defined by MX. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return ApiResponse&lt;CategoriesResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CategoriesResponseBody> listCategoriesInsightWithHttpInfo(String userGuid, String insightGuid, Integer page, Integer recordsPerPage) throws ApiException {
        okhttp3.Call localVarCall = listCategoriesInsightValidateBeforeCall(userGuid, insightGuid, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<CategoriesResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List all categories associated with an insight. (asynchronously)
     * Use this endpoint to list all the categories associated with the insight.
     * @param userGuid The unique identifier for the user. Defined by MX. (required)
     * @param insightGuid The unique identifier for the insight. Defined by MX. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listCategoriesInsightAsync(String userGuid, String insightGuid, Integer page, Integer recordsPerPage, final ApiCallback<CategoriesResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listCategoriesInsightValidateBeforeCall(userGuid, insightGuid, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<CategoriesResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listInsightsByAccount
     * @param accountGuid The unique id for the &#x60;account&#x60;. (required)
     * @param userGuid The unique id for the &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listInsightsByAccountCall(String accountGuid, String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/accounts/{account_guid}/insights"
            .replace("{" + "account_guid" + "}", localVarApiClient.escapeString(accountGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listInsightsByAccountValidateBeforeCall(String accountGuid, String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountGuid' is set
        if (accountGuid == null) {
            throw new ApiException("Missing the required parameter 'accountGuid' when calling listInsightsByAccount(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listInsightsByAccount(Async)");
        }

        return listInsightsByAccountCall(accountGuid, userGuid, page, recordsPerPage, _callback);

    }

    /**
     * List insights by account
     * Use this endpoint to list all insights associated with a specified account GUID.
     * @param accountGuid The unique id for the &#x60;account&#x60;. (required)
     * @param userGuid The unique id for the &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return InsightsResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public InsightsResponseBody listInsightsByAccount(String accountGuid, String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<InsightsResponseBody> localVarResp = listInsightsByAccountWithHttpInfo(accountGuid, userGuid, page, recordsPerPage);
        return localVarResp.getData();
    }

    /**
     * List insights by account
     * Use this endpoint to list all insights associated with a specified account GUID.
     * @param accountGuid The unique id for the &#x60;account&#x60;. (required)
     * @param userGuid The unique id for the &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return ApiResponse&lt;InsightsResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<InsightsResponseBody> listInsightsByAccountWithHttpInfo(String accountGuid, String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        okhttp3.Call localVarCall = listInsightsByAccountValidateBeforeCall(accountGuid, userGuid, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<InsightsResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List insights by account (asynchronously)
     * Use this endpoint to list all insights associated with a specified account GUID.
     * @param accountGuid The unique id for the &#x60;account&#x60;. (required)
     * @param userGuid The unique id for the &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listInsightsByAccountAsync(String accountGuid, String userGuid, Integer page, Integer recordsPerPage, final ApiCallback<InsightsResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listInsightsByAccountValidateBeforeCall(accountGuid, userGuid, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<InsightsResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listInsightsUser
     * @param userGuid The unique identifier for the user. Defined by MX. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listInsightsUserCall(String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/insights"
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listInsightsUserValidateBeforeCall(String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listInsightsUser(Async)");
        }

        return listInsightsUserCall(userGuid, page, recordsPerPage, _callback);

    }

    /**
     * List all insights for a user.
     * Use this endpoint to list all the insights associated with the user.
     * @param userGuid The unique identifier for the user. Defined by MX. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return InsightsResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public InsightsResponseBody listInsightsUser(String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<InsightsResponseBody> localVarResp = listInsightsUserWithHttpInfo(userGuid, page, recordsPerPage);
        return localVarResp.getData();
    }

    /**
     * List all insights for a user.
     * Use this endpoint to list all the insights associated with the user.
     * @param userGuid The unique identifier for the user. Defined by MX. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return ApiResponse&lt;InsightsResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<InsightsResponseBody> listInsightsUserWithHttpInfo(String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        okhttp3.Call localVarCall = listInsightsUserValidateBeforeCall(userGuid, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<InsightsResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List all insights for a user. (asynchronously)
     * Use this endpoint to list all the insights associated with the user.
     * @param userGuid The unique identifier for the user. Defined by MX. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listInsightsUserAsync(String userGuid, Integer page, Integer recordsPerPage, final ApiCallback<InsightsResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listInsightsUserValidateBeforeCall(userGuid, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<InsightsResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listMerchantsInsight
     * @param userGuid The unique identifier for the user. Defined by MX. (required)
     * @param insightGuid The unique identifier for the insight. Defined by MX. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listMerchantsInsightCall(String userGuid, String insightGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/insights/{insight_guid}/merchants"
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()))
            .replace("{" + "insight_guid" + "}", localVarApiClient.escapeString(insightGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listMerchantsInsightValidateBeforeCall(String userGuid, String insightGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listMerchantsInsight(Async)");
        }

        // verify the required parameter 'insightGuid' is set
        if (insightGuid == null) {
            throw new ApiException("Missing the required parameter 'insightGuid' when calling listMerchantsInsight(Async)");
        }

        return listMerchantsInsightCall(userGuid, insightGuid, page, recordsPerPage, _callback);

    }

    /**
     * List all merchants associated with an insight.
     * Use this endpoint to list all the merchants associated with the insight.
     * @param userGuid The unique identifier for the user. Defined by MX. (required)
     * @param insightGuid The unique identifier for the insight. Defined by MX. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return MerchantsResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public MerchantsResponseBody listMerchantsInsight(String userGuid, String insightGuid, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<MerchantsResponseBody> localVarResp = listMerchantsInsightWithHttpInfo(userGuid, insightGuid, page, recordsPerPage);
        return localVarResp.getData();
    }

    /**
     * List all merchants associated with an insight.
     * Use this endpoint to list all the merchants associated with the insight.
     * @param userGuid The unique identifier for the user. Defined by MX. (required)
     * @param insightGuid The unique identifier for the insight. Defined by MX. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return ApiResponse&lt;MerchantsResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MerchantsResponseBody> listMerchantsInsightWithHttpInfo(String userGuid, String insightGuid, Integer page, Integer recordsPerPage) throws ApiException {
        okhttp3.Call localVarCall = listMerchantsInsightValidateBeforeCall(userGuid, insightGuid, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<MerchantsResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List all merchants associated with an insight. (asynchronously)
     * Use this endpoint to list all the merchants associated with the insight.
     * @param userGuid The unique identifier for the user. Defined by MX. (required)
     * @param insightGuid The unique identifier for the insight. Defined by MX. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listMerchantsInsightAsync(String userGuid, String insightGuid, Integer page, Integer recordsPerPage, final ApiCallback<MerchantsResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listMerchantsInsightValidateBeforeCall(userGuid, insightGuid, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<MerchantsResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listScheduledPaymentsInsight
     * @param userGuid The unique identifier for the user. Defined by MX. (required)
     * @param insightGuid The unique identifier for the insight. Defined by MX. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listScheduledPaymentsInsightCall(String userGuid, String insightGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/insights/{insight_guid}/scheduled_payments"
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()))
            .replace("{" + "insight_guid" + "}", localVarApiClient.escapeString(insightGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listScheduledPaymentsInsightValidateBeforeCall(String userGuid, String insightGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listScheduledPaymentsInsight(Async)");
        }

        // verify the required parameter 'insightGuid' is set
        if (insightGuid == null) {
            throw new ApiException("Missing the required parameter 'insightGuid' when calling listScheduledPaymentsInsight(Async)");
        }

        return listScheduledPaymentsInsightCall(userGuid, insightGuid, page, recordsPerPage, _callback);

    }

    /**
     * List all scheduled payments associated with an insight
     * Use this endpoint to list all the scheduled payments associated with the insight.
     * @param userGuid The unique identifier for the user. Defined by MX. (required)
     * @param insightGuid The unique identifier for the insight. Defined by MX. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return ScheduledPaymentsResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ScheduledPaymentsResponseBody listScheduledPaymentsInsight(String userGuid, String insightGuid, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<ScheduledPaymentsResponseBody> localVarResp = listScheduledPaymentsInsightWithHttpInfo(userGuid, insightGuid, page, recordsPerPage);
        return localVarResp.getData();
    }

    /**
     * List all scheduled payments associated with an insight
     * Use this endpoint to list all the scheduled payments associated with the insight.
     * @param userGuid The unique identifier for the user. Defined by MX. (required)
     * @param insightGuid The unique identifier for the insight. Defined by MX. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return ApiResponse&lt;ScheduledPaymentsResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ScheduledPaymentsResponseBody> listScheduledPaymentsInsightWithHttpInfo(String userGuid, String insightGuid, Integer page, Integer recordsPerPage) throws ApiException {
        okhttp3.Call localVarCall = listScheduledPaymentsInsightValidateBeforeCall(userGuid, insightGuid, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<ScheduledPaymentsResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List all scheduled payments associated with an insight (asynchronously)
     * Use this endpoint to list all the scheduled payments associated with the insight.
     * @param userGuid The unique identifier for the user. Defined by MX. (required)
     * @param insightGuid The unique identifier for the insight. Defined by MX. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listScheduledPaymentsInsightAsync(String userGuid, String insightGuid, Integer page, Integer recordsPerPage, final ApiCallback<ScheduledPaymentsResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listScheduledPaymentsInsightValidateBeforeCall(userGuid, insightGuid, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<ScheduledPaymentsResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listTransactionsInsight
     * @param userGuid The unique identifier for the user. Defined by MX. (required)
     * @param insightGuid The unique identifier for the insight. Defined by MX. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listTransactionsInsightCall(String userGuid, String insightGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/insights/{insight_guid}/transactions"
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()))
            .replace("{" + "insight_guid" + "}", localVarApiClient.escapeString(insightGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listTransactionsInsightValidateBeforeCall(String userGuid, String insightGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listTransactionsInsight(Async)");
        }

        // verify the required parameter 'insightGuid' is set
        if (insightGuid == null) {
            throw new ApiException("Missing the required parameter 'insightGuid' when calling listTransactionsInsight(Async)");
        }

        return listTransactionsInsightCall(userGuid, insightGuid, page, recordsPerPage, _callback);

    }

    /**
     * List all transactions associated with an insight.
     * Use this endpoint to list all the transactions associated with the insight.
     * @param userGuid The unique identifier for the user. Defined by MX. (required)
     * @param insightGuid The unique identifier for the insight. Defined by MX. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return TransactionsResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public TransactionsResponseBody listTransactionsInsight(String userGuid, String insightGuid, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<TransactionsResponseBody> localVarResp = listTransactionsInsightWithHttpInfo(userGuid, insightGuid, page, recordsPerPage);
        return localVarResp.getData();
    }

    /**
     * List all transactions associated with an insight.
     * Use this endpoint to list all the transactions associated with the insight.
     * @param userGuid The unique identifier for the user. Defined by MX. (required)
     * @param insightGuid The unique identifier for the insight. Defined by MX. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return ApiResponse&lt;TransactionsResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TransactionsResponseBody> listTransactionsInsightWithHttpInfo(String userGuid, String insightGuid, Integer page, Integer recordsPerPage) throws ApiException {
        okhttp3.Call localVarCall = listTransactionsInsightValidateBeforeCall(userGuid, insightGuid, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<TransactionsResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List all transactions associated with an insight. (asynchronously)
     * Use this endpoint to list all the transactions associated with the insight.
     * @param userGuid The unique identifier for the user. Defined by MX. (required)
     * @param insightGuid The unique identifier for the insight. Defined by MX. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listTransactionsInsightAsync(String userGuid, String insightGuid, Integer page, Integer recordsPerPage, final ApiCallback<TransactionsResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listTransactionsInsightValidateBeforeCall(userGuid, insightGuid, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<TransactionsResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for readInsightsUser
     * @param userGuid The unique identifier for the user. Defined by MX. (required)
     * @param insightGuid The unique identifier for the insight. Defined by MX. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readInsightsUserCall(String userGuid, String insightGuid, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/insights{insight_guid}"
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()))
            .replace("{" + "insight_guid" + "}", localVarApiClient.escapeString(insightGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call readInsightsUserValidateBeforeCall(String userGuid, String insightGuid, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling readInsightsUser(Async)");
        }

        // verify the required parameter 'insightGuid' is set
        if (insightGuid == null) {
            throw new ApiException("Missing the required parameter 'insightGuid' when calling readInsightsUser(Async)");
        }

        return readInsightsUserCall(userGuid, insightGuid, _callback);

    }

    /**
     * Read a specific insight.
     * Use this endpoint to read the attributes of a specific insight according to its unique GUID.
     * @param userGuid The unique identifier for the user. Defined by MX. (required)
     * @param insightGuid The unique identifier for the insight. Defined by MX. (required)
     * @return InsightResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public InsightResponseBody readInsightsUser(String userGuid, String insightGuid) throws ApiException {
        ApiResponse<InsightResponseBody> localVarResp = readInsightsUserWithHttpInfo(userGuid, insightGuid);
        return localVarResp.getData();
    }

    /**
     * Read a specific insight.
     * Use this endpoint to read the attributes of a specific insight according to its unique GUID.
     * @param userGuid The unique identifier for the user. Defined by MX. (required)
     * @param insightGuid The unique identifier for the insight. Defined by MX. (required)
     * @return ApiResponse&lt;InsightResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<InsightResponseBody> readInsightsUserWithHttpInfo(String userGuid, String insightGuid) throws ApiException {
        okhttp3.Call localVarCall = readInsightsUserValidateBeforeCall(userGuid, insightGuid, null);
        Type localVarReturnType = new TypeToken<InsightResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Read a specific insight. (asynchronously)
     * Use this endpoint to read the attributes of a specific insight according to its unique GUID.
     * @param userGuid The unique identifier for the user. Defined by MX. (required)
     * @param insightGuid The unique identifier for the insight. Defined by MX. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readInsightsUserAsync(String userGuid, String insightGuid, final ApiCallback<InsightResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = readInsightsUserValidateBeforeCall(userGuid, insightGuid, _callback);
        Type localVarReturnType = new TypeToken<InsightResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateInsight
     * @param userGuid The unique identifier for the user. Defined by MX. (required)
     * @param insightGuid The unique identifier for the insight. Defined by MX. (required)
     * @param insightUpdateRequest The insight to be updated (None of these parameters are required, but the user object cannot be empty.) (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateInsightCall(String userGuid, String insightGuid, InsightUpdateRequest insightUpdateRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = insightUpdateRequest;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/insights{insight_guid}"
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()))
            .replace("{" + "insight_guid" + "}", localVarApiClient.escapeString(insightGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateInsightValidateBeforeCall(String userGuid, String insightGuid, InsightUpdateRequest insightUpdateRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling updateInsight(Async)");
        }

        // verify the required parameter 'insightGuid' is set
        if (insightGuid == null) {
            throw new ApiException("Missing the required parameter 'insightGuid' when calling updateInsight(Async)");
        }

        // verify the required parameter 'insightUpdateRequest' is set
        if (insightUpdateRequest == null) {
            throw new ApiException("Missing the required parameter 'insightUpdateRequest' when calling updateInsight(Async)");
        }

        return updateInsightCall(userGuid, insightGuid, insightUpdateRequest, _callback);

    }

    /**
     * Update insight
     * Use this endpoint to update the attributes of a particular insight according to its unique GUID.
     * @param userGuid The unique identifier for the user. Defined by MX. (required)
     * @param insightGuid The unique identifier for the insight. Defined by MX. (required)
     * @param insightUpdateRequest The insight to be updated (None of these parameters are required, but the user object cannot be empty.) (required)
     * @return InsightResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public InsightResponse updateInsight(String userGuid, String insightGuid, InsightUpdateRequest insightUpdateRequest) throws ApiException {
        ApiResponse<InsightResponse> localVarResp = updateInsightWithHttpInfo(userGuid, insightGuid, insightUpdateRequest);
        return localVarResp.getData();
    }

    /**
     * Update insight
     * Use this endpoint to update the attributes of a particular insight according to its unique GUID.
     * @param userGuid The unique identifier for the user. Defined by MX. (required)
     * @param insightGuid The unique identifier for the insight. Defined by MX. (required)
     * @param insightUpdateRequest The insight to be updated (None of these parameters are required, but the user object cannot be empty.) (required)
     * @return ApiResponse&lt;InsightResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<InsightResponse> updateInsightWithHttpInfo(String userGuid, String insightGuid, InsightUpdateRequest insightUpdateRequest) throws ApiException {
        okhttp3.Call localVarCall = updateInsightValidateBeforeCall(userGuid, insightGuid, insightUpdateRequest, null);
        Type localVarReturnType = new TypeToken<InsightResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update insight (asynchronously)
     * Use this endpoint to update the attributes of a particular insight according to its unique GUID.
     * @param userGuid The unique identifier for the user. Defined by MX. (required)
     * @param insightGuid The unique identifier for the insight. Defined by MX. (required)
     * @param insightUpdateRequest The insight to be updated (None of these parameters are required, but the user object cannot be empty.) (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateInsightAsync(String userGuid, String insightGuid, InsightUpdateRequest insightUpdateRequest, final ApiCallback<InsightResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateInsightValidateBeforeCall(userGuid, insightGuid, insightUpdateRequest, _callback);
        Type localVarReturnType = new TypeToken<InsightResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
