/*
 * MX Platform API
 * The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.
 *
 * The version of the OpenAPI document: 0.1.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.mx.client.mx_platform_api;

import com.mx.client.ApiCallback;
import com.mx.client.ApiClient;
import com.mx.client.ApiException;
import com.mx.client.ApiResponse;
import com.mx.client.Configuration;
import com.mx.client.Pair;
import com.mx.client.ProgressRequestBody;
import com.mx.client.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import com.mx.client.model.AccountCreateRequestBody;
import com.mx.client.model.AccountNumbersResponseBody;
import com.mx.client.model.AccountOwnersResponseBody;
import com.mx.client.model.AccountResponseBody;
import com.mx.client.model.AccountUpdateRequestBody;
import com.mx.client.model.AccountsResponseBody;
import com.mx.client.model.AuthorizationCodeRequestBody;
import com.mx.client.model.AuthorizationCodeResponseBody;
import com.mx.client.model.CategoriesResponseBody;
import com.mx.client.model.CategoryCreateRequestBody;
import com.mx.client.model.CategoryResponseBody;
import com.mx.client.model.CategoryUpdateRequestBody;
import com.mx.client.model.ChallengesResponseBody;
import com.mx.client.model.ConnectWidgetRequestBody;
import com.mx.client.model.ConnectWidgetResponseBody;
import com.mx.client.model.CredentialsResponseBody;
import com.mx.client.model.CreditCardProductResponse;
import com.mx.client.model.EnhanceTransactionsRequestBody;
import com.mx.client.model.EnhanceTransactionsResponseBody;
import java.io.File;
import com.mx.client.model.HoldingResponseBody;
import com.mx.client.model.HoldingsResponseBody;
import com.mx.client.model.InstitutionResponseBody;
import com.mx.client.model.InstitutionsResponseBody;
import com.mx.client.model.ManagedAccountCreateRequestBody;
import com.mx.client.model.ManagedAccountUpdateRequestBody;
import com.mx.client.model.ManagedMemberCreateRequestBody;
import com.mx.client.model.ManagedMemberUpdateRequestBody;
import com.mx.client.model.ManagedTransactionCreateRequestBody;
import com.mx.client.model.ManagedTransactionUpdateRequestBody;
import com.mx.client.model.MemberCreateRequestBody;
import com.mx.client.model.MemberResponseBody;
import com.mx.client.model.MemberResumeRequestBody;
import com.mx.client.model.MemberStatusResponseBody;
import com.mx.client.model.MemberUpdateRequestBody;
import com.mx.client.model.MembersResponseBody;
import com.mx.client.model.MerchantLocationResponseBody;
import com.mx.client.model.MerchantResponseBody;
import com.mx.client.model.MerchantsResponseBody;
import com.mx.client.model.MonthlyCashFlowProfileRequestBody;
import com.mx.client.model.MonthlyCashFlowResponseBody;
import com.mx.client.model.OAuthWindowResponseBody;
import com.mx.client.model.PaymentProcessorAuthorizationCodeRequestBody;
import com.mx.client.model.PaymentProcessorAuthorizationCodeResponseBody;
import com.mx.client.model.RewardResponseBody;
import com.mx.client.model.RewardsResponseBody;
import com.mx.client.model.SplitTransactionRequestBody;
import com.mx.client.model.SplitTransactionsResponseBody;
import com.mx.client.model.StatementResponseBody;
import com.mx.client.model.StatementsResponseBody;
import com.mx.client.model.TagCreateRequestBody;
import com.mx.client.model.TagResponseBody;
import com.mx.client.model.TagUpdateRequestBody;
import com.mx.client.model.TaggingCreateRequestBody;
import com.mx.client.model.TaggingResponseBody;
import com.mx.client.model.TaggingUpdateRequestBody;
import com.mx.client.model.TaggingsResponseBody;
import com.mx.client.model.TagsResponseBody;
import com.mx.client.model.TaxDocumentResponseBody;
import com.mx.client.model.TaxDocumentsResponseBody;
import com.mx.client.model.TransactionResponseBody;
import com.mx.client.model.TransactionRuleCreateRequestBody;
import com.mx.client.model.TransactionRuleResponseBody;
import com.mx.client.model.TransactionRuleUpdateRequestBody;
import com.mx.client.model.TransactionRulesResponseBody;
import com.mx.client.model.TransactionUpdateRequestBody;
import com.mx.client.model.TransactionsResponseBody;
import com.mx.client.model.UserCreateRequestBody;
import com.mx.client.model.UserResponseBody;
import com.mx.client.model.UserUpdateRequestBody;
import com.mx.client.model.UsersResponseBody;
import com.mx.client.model.WidgetRequestBody;
import com.mx.client.model.WidgetResponseBody;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MxPlatformApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public MxPlatformApi() {
        this(Configuration.getDefaultApiClient());
    }

    public MxPlatformApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    /**
     * Build call for aggregateMember
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call aggregateMemberCall(String memberGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/members/{member_guid}/aggregate"
            .replace("{" + "member_guid" + "}", localVarApiClient.escapeString(memberGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call aggregateMemberValidateBeforeCall(String memberGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling aggregateMember(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling aggregateMember(Async)");
        }

        return aggregateMemberCall(memberGuid, userGuid, _callback);

    }

    /**
     * Aggregate member
     * Calling this endpoint initiates an aggregation event for the member. This brings in the latest account and transaction data from the connected institution. If this data has recently been updated, MX may not initiate an aggregation event.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return MemberResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public MemberResponseBody aggregateMember(String memberGuid, String userGuid) throws ApiException {
        ApiResponse<MemberResponseBody> localVarResp = aggregateMemberWithHttpInfo(memberGuid, userGuid);
        return localVarResp.getData();
    }

    /**
     * Aggregate member
     * Calling this endpoint initiates an aggregation event for the member. This brings in the latest account and transaction data from the connected institution. If this data has recently been updated, MX may not initiate an aggregation event.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;MemberResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MemberResponseBody> aggregateMemberWithHttpInfo(String memberGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = aggregateMemberValidateBeforeCall(memberGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Aggregate member (asynchronously)
     * Calling this endpoint initiates an aggregation event for the member. This brings in the latest account and transaction data from the connected institution. If this data has recently been updated, MX may not initiate an aggregation event.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call aggregateMemberAsync(String memberGuid, String userGuid, final ApiCallback<MemberResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = aggregateMemberValidateBeforeCall(memberGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for checkBalances
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call checkBalancesCall(String memberGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/members/{member_guid}/check_balance"
            .replace("{" + "member_guid" + "}", localVarApiClient.escapeString(memberGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call checkBalancesValidateBeforeCall(String memberGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling checkBalances(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling checkBalances(Async)");
        }

        return checkBalancesCall(memberGuid, userGuid, _callback);

    }

    /**
     * Check balances
     * This endpoint operates much like the aggregate member endpoint except that it gathers only account balance information; it does not gather any transaction data.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return MemberResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public MemberResponseBody checkBalances(String memberGuid, String userGuid) throws ApiException {
        ApiResponse<MemberResponseBody> localVarResp = checkBalancesWithHttpInfo(memberGuid, userGuid);
        return localVarResp.getData();
    }

    /**
     * Check balances
     * This endpoint operates much like the aggregate member endpoint except that it gathers only account balance information; it does not gather any transaction data.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;MemberResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MemberResponseBody> checkBalancesWithHttpInfo(String memberGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = checkBalancesValidateBeforeCall(memberGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Check balances (asynchronously)
     * This endpoint operates much like the aggregate member endpoint except that it gathers only account balance information; it does not gather any transaction data.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call checkBalancesAsync(String memberGuid, String userGuid, final ApiCallback<MemberResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = checkBalancesValidateBeforeCall(memberGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for createCategory
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param categoryCreateRequestBody Custom category object to be created (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createCategoryCall(String userGuid, CategoryCreateRequestBody categoryCreateRequestBody, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = categoryCreateRequestBody;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/categories"
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createCategoryValidateBeforeCall(String userGuid, CategoryCreateRequestBody categoryCreateRequestBody, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling createCategory(Async)");
        }

        // verify the required parameter 'categoryCreateRequestBody' is set
        if (categoryCreateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'categoryCreateRequestBody' when calling createCategory(Async)");
        }

        return createCategoryCall(userGuid, categoryCreateRequestBody, _callback);

    }

    /**
     * Create category
     * Use this endpoint to create a new custom category for a specific &#x60;user&#x60;.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param categoryCreateRequestBody Custom category object to be created (required)
     * @return CategoryResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public CategoryResponseBody createCategory(String userGuid, CategoryCreateRequestBody categoryCreateRequestBody) throws ApiException {
        ApiResponse<CategoryResponseBody> localVarResp = createCategoryWithHttpInfo(userGuid, categoryCreateRequestBody);
        return localVarResp.getData();
    }

    /**
     * Create category
     * Use this endpoint to create a new custom category for a specific &#x60;user&#x60;.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param categoryCreateRequestBody Custom category object to be created (required)
     * @return ApiResponse&lt;CategoryResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CategoryResponseBody> createCategoryWithHttpInfo(String userGuid, CategoryCreateRequestBody categoryCreateRequestBody) throws ApiException {
        okhttp3.Call localVarCall = createCategoryValidateBeforeCall(userGuid, categoryCreateRequestBody, null);
        Type localVarReturnType = new TypeToken<CategoryResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create category (asynchronously)
     * Use this endpoint to create a new custom category for a specific &#x60;user&#x60;.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param categoryCreateRequestBody Custom category object to be created (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createCategoryAsync(String userGuid, CategoryCreateRequestBody categoryCreateRequestBody, final ApiCallback<CategoryResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = createCategoryValidateBeforeCall(userGuid, categoryCreateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<CategoryResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for createManagedAccount
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param managedAccountCreateRequestBody Managed account to be created. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createManagedAccountCall(String memberGuid, String userGuid, ManagedAccountCreateRequestBody managedAccountCreateRequestBody, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = managedAccountCreateRequestBody;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/managed_members/{member_guid}/accounts"
            .replace("{" + "member_guid" + "}", localVarApiClient.escapeString(memberGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createManagedAccountValidateBeforeCall(String memberGuid, String userGuid, ManagedAccountCreateRequestBody managedAccountCreateRequestBody, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling createManagedAccount(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling createManagedAccount(Async)");
        }

        // verify the required parameter 'managedAccountCreateRequestBody' is set
        if (managedAccountCreateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'managedAccountCreateRequestBody' when calling createManagedAccount(Async)");
        }

        return createManagedAccountCall(memberGuid, userGuid, managedAccountCreateRequestBody, _callback);

    }

    /**
     * Create managed account
     * Use this endpoint to create a partner-managed account.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param managedAccountCreateRequestBody Managed account to be created. (required)
     * @return AccountResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public AccountResponseBody createManagedAccount(String memberGuid, String userGuid, ManagedAccountCreateRequestBody managedAccountCreateRequestBody) throws ApiException {
        ApiResponse<AccountResponseBody> localVarResp = createManagedAccountWithHttpInfo(memberGuid, userGuid, managedAccountCreateRequestBody);
        return localVarResp.getData();
    }

    /**
     * Create managed account
     * Use this endpoint to create a partner-managed account.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param managedAccountCreateRequestBody Managed account to be created. (required)
     * @return ApiResponse&lt;AccountResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AccountResponseBody> createManagedAccountWithHttpInfo(String memberGuid, String userGuid, ManagedAccountCreateRequestBody managedAccountCreateRequestBody) throws ApiException {
        okhttp3.Call localVarCall = createManagedAccountValidateBeforeCall(memberGuid, userGuid, managedAccountCreateRequestBody, null);
        Type localVarReturnType = new TypeToken<AccountResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create managed account (asynchronously)
     * Use this endpoint to create a partner-managed account.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param managedAccountCreateRequestBody Managed account to be created. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createManagedAccountAsync(String memberGuid, String userGuid, ManagedAccountCreateRequestBody managedAccountCreateRequestBody, final ApiCallback<AccountResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = createManagedAccountValidateBeforeCall(memberGuid, userGuid, managedAccountCreateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<AccountResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for createManagedMember
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param managedMemberCreateRequestBody Managed member to be created. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createManagedMemberCall(String userGuid, ManagedMemberCreateRequestBody managedMemberCreateRequestBody, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = managedMemberCreateRequestBody;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/managed_members"
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createManagedMemberValidateBeforeCall(String userGuid, ManagedMemberCreateRequestBody managedMemberCreateRequestBody, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling createManagedMember(Async)");
        }

        // verify the required parameter 'managedMemberCreateRequestBody' is set
        if (managedMemberCreateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'managedMemberCreateRequestBody' when calling createManagedMember(Async)");
        }

        return createManagedMemberCall(userGuid, managedMemberCreateRequestBody, _callback);

    }

    /**
     * Create managed member
     * Use this endpoint to create a new partner-managed &#x60;member&#x60;.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param managedMemberCreateRequestBody Managed member to be created. (required)
     * @return MemberResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public MemberResponseBody createManagedMember(String userGuid, ManagedMemberCreateRequestBody managedMemberCreateRequestBody) throws ApiException {
        ApiResponse<MemberResponseBody> localVarResp = createManagedMemberWithHttpInfo(userGuid, managedMemberCreateRequestBody);
        return localVarResp.getData();
    }

    /**
     * Create managed member
     * Use this endpoint to create a new partner-managed &#x60;member&#x60;.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param managedMemberCreateRequestBody Managed member to be created. (required)
     * @return ApiResponse&lt;MemberResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MemberResponseBody> createManagedMemberWithHttpInfo(String userGuid, ManagedMemberCreateRequestBody managedMemberCreateRequestBody) throws ApiException {
        okhttp3.Call localVarCall = createManagedMemberValidateBeforeCall(userGuid, managedMemberCreateRequestBody, null);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create managed member (asynchronously)
     * Use this endpoint to create a new partner-managed &#x60;member&#x60;.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param managedMemberCreateRequestBody Managed member to be created. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createManagedMemberAsync(String userGuid, ManagedMemberCreateRequestBody managedMemberCreateRequestBody, final ApiCallback<MemberResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = createManagedMemberValidateBeforeCall(userGuid, managedMemberCreateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for createManagedTransaction
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param managedTransactionCreateRequestBody Managed transaction to be created. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createManagedTransactionCall(String accountGuid, String memberGuid, String userGuid, ManagedTransactionCreateRequestBody managedTransactionCreateRequestBody, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = managedTransactionCreateRequestBody;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/managed_members/{member_guid}/accounts/{account_guid}/transactions"
            .replace("{" + "account_guid" + "}", localVarApiClient.escapeString(accountGuid.toString()))
            .replace("{" + "member_guid" + "}", localVarApiClient.escapeString(memberGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createManagedTransactionValidateBeforeCall(String accountGuid, String memberGuid, String userGuid, ManagedTransactionCreateRequestBody managedTransactionCreateRequestBody, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountGuid' is set
        if (accountGuid == null) {
            throw new ApiException("Missing the required parameter 'accountGuid' when calling createManagedTransaction(Async)");
        }

        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling createManagedTransaction(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling createManagedTransaction(Async)");
        }

        // verify the required parameter 'managedTransactionCreateRequestBody' is set
        if (managedTransactionCreateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'managedTransactionCreateRequestBody' when calling createManagedTransaction(Async)");
        }

        return createManagedTransactionCall(accountGuid, memberGuid, userGuid, managedTransactionCreateRequestBody, _callback);

    }

    /**
     * Create managed transaction
     * Use this endpoint to create a new partner-managed &#x60;transaction&#x60;.
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param managedTransactionCreateRequestBody Managed transaction to be created. (required)
     * @return TransactionResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public TransactionResponseBody createManagedTransaction(String accountGuid, String memberGuid, String userGuid, ManagedTransactionCreateRequestBody managedTransactionCreateRequestBody) throws ApiException {
        ApiResponse<TransactionResponseBody> localVarResp = createManagedTransactionWithHttpInfo(accountGuid, memberGuid, userGuid, managedTransactionCreateRequestBody);
        return localVarResp.getData();
    }

    /**
     * Create managed transaction
     * Use this endpoint to create a new partner-managed &#x60;transaction&#x60;.
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param managedTransactionCreateRequestBody Managed transaction to be created. (required)
     * @return ApiResponse&lt;TransactionResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TransactionResponseBody> createManagedTransactionWithHttpInfo(String accountGuid, String memberGuid, String userGuid, ManagedTransactionCreateRequestBody managedTransactionCreateRequestBody) throws ApiException {
        okhttp3.Call localVarCall = createManagedTransactionValidateBeforeCall(accountGuid, memberGuid, userGuid, managedTransactionCreateRequestBody, null);
        Type localVarReturnType = new TypeToken<TransactionResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create managed transaction (asynchronously)
     * Use this endpoint to create a new partner-managed &#x60;transaction&#x60;.
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param managedTransactionCreateRequestBody Managed transaction to be created. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createManagedTransactionAsync(String accountGuid, String memberGuid, String userGuid, ManagedTransactionCreateRequestBody managedTransactionCreateRequestBody, final ApiCallback<TransactionResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = createManagedTransactionValidateBeforeCall(accountGuid, memberGuid, userGuid, managedTransactionCreateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<TransactionResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for createManualAccount
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param accountCreateRequestBody Manual account object to be created. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createManualAccountCall(String userGuid, AccountCreateRequestBody accountCreateRequestBody, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = accountCreateRequestBody;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/accounts"
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createManualAccountValidateBeforeCall(String userGuid, AccountCreateRequestBody accountCreateRequestBody, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling createManualAccount(Async)");
        }

        // verify the required parameter 'accountCreateRequestBody' is set
        if (accountCreateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'accountCreateRequestBody' when calling createManualAccount(Async)");
        }

        return createManualAccountCall(userGuid, accountCreateRequestBody, _callback);

    }

    /**
     * Create manual account
     * This endpoint can only be used to create manual accounts. Creating a manual account will automatically create it under the Manual Institution member. Since a manual account has no credentials tied to the member, the account will never aggregate or include data from a data feed.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param accountCreateRequestBody Manual account object to be created. (required)
     * @return AccountResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public AccountResponseBody createManualAccount(String userGuid, AccountCreateRequestBody accountCreateRequestBody) throws ApiException {
        ApiResponse<AccountResponseBody> localVarResp = createManualAccountWithHttpInfo(userGuid, accountCreateRequestBody);
        return localVarResp.getData();
    }

    /**
     * Create manual account
     * This endpoint can only be used to create manual accounts. Creating a manual account will automatically create it under the Manual Institution member. Since a manual account has no credentials tied to the member, the account will never aggregate or include data from a data feed.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param accountCreateRequestBody Manual account object to be created. (required)
     * @return ApiResponse&lt;AccountResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AccountResponseBody> createManualAccountWithHttpInfo(String userGuid, AccountCreateRequestBody accountCreateRequestBody) throws ApiException {
        okhttp3.Call localVarCall = createManualAccountValidateBeforeCall(userGuid, accountCreateRequestBody, null);
        Type localVarReturnType = new TypeToken<AccountResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create manual account (asynchronously)
     * This endpoint can only be used to create manual accounts. Creating a manual account will automatically create it under the Manual Institution member. Since a manual account has no credentials tied to the member, the account will never aggregate or include data from a data feed.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param accountCreateRequestBody Manual account object to be created. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createManualAccountAsync(String userGuid, AccountCreateRequestBody accountCreateRequestBody, final ApiCallback<AccountResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = createManualAccountValidateBeforeCall(userGuid, accountCreateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<AccountResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for createMember
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberCreateRequestBody Member object to be created with optional parameters (id and metadata) and required parameters (credentials and institution_code) (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createMemberCall(String userGuid, MemberCreateRequestBody memberCreateRequestBody, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = memberCreateRequestBody;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/members"
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createMemberValidateBeforeCall(String userGuid, MemberCreateRequestBody memberCreateRequestBody, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling createMember(Async)");
        }

        // verify the required parameter 'memberCreateRequestBody' is set
        if (memberCreateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'memberCreateRequestBody' when calling createMember(Async)");
        }

        return createMemberCall(userGuid, memberCreateRequestBody, _callback);

    }

    /**
     * Create member
     * This endpoint allows you to create a new member. Members are created with the required parameters credentials and institution_code, and the optional parameters id and metadata. When creating a member, youll need to include the correct type of credential required by the financial institution and provided by the user. You can find out which credential type is required with the &#x60;/institutions/{institution_code}/credentials&#x60; endpoint. If successful, the MX Platform API will respond with the newly-created member object. Once you successfully create a member, MX will immediately validate the provided credentials and attempt to aggregate data for accounts and transactions.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberCreateRequestBody Member object to be created with optional parameters (id and metadata) and required parameters (credentials and institution_code) (required)
     * @return MemberResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public MemberResponseBody createMember(String userGuid, MemberCreateRequestBody memberCreateRequestBody) throws ApiException {
        ApiResponse<MemberResponseBody> localVarResp = createMemberWithHttpInfo(userGuid, memberCreateRequestBody);
        return localVarResp.getData();
    }

    /**
     * Create member
     * This endpoint allows you to create a new member. Members are created with the required parameters credentials and institution_code, and the optional parameters id and metadata. When creating a member, youll need to include the correct type of credential required by the financial institution and provided by the user. You can find out which credential type is required with the &#x60;/institutions/{institution_code}/credentials&#x60; endpoint. If successful, the MX Platform API will respond with the newly-created member object. Once you successfully create a member, MX will immediately validate the provided credentials and attempt to aggregate data for accounts and transactions.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberCreateRequestBody Member object to be created with optional parameters (id and metadata) and required parameters (credentials and institution_code) (required)
     * @return ApiResponse&lt;MemberResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MemberResponseBody> createMemberWithHttpInfo(String userGuid, MemberCreateRequestBody memberCreateRequestBody) throws ApiException {
        okhttp3.Call localVarCall = createMemberValidateBeforeCall(userGuid, memberCreateRequestBody, null);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create member (asynchronously)
     * This endpoint allows you to create a new member. Members are created with the required parameters credentials and institution_code, and the optional parameters id and metadata. When creating a member, youll need to include the correct type of credential required by the financial institution and provided by the user. You can find out which credential type is required with the &#x60;/institutions/{institution_code}/credentials&#x60; endpoint. If successful, the MX Platform API will respond with the newly-created member object. Once you successfully create a member, MX will immediately validate the provided credentials and attempt to aggregate data for accounts and transactions.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberCreateRequestBody Member object to be created with optional parameters (id and metadata) and required parameters (credentials and institution_code) (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createMemberAsync(String userGuid, MemberCreateRequestBody memberCreateRequestBody, final ApiCallback<MemberResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = createMemberValidateBeforeCall(userGuid, memberCreateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for createTag
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param tagCreateRequestBody Tag object to be created with required parameters (tag_guid) (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createTagCall(String userGuid, TagCreateRequestBody tagCreateRequestBody, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = tagCreateRequestBody;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/tags"
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createTagValidateBeforeCall(String userGuid, TagCreateRequestBody tagCreateRequestBody, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling createTag(Async)");
        }

        // verify the required parameter 'tagCreateRequestBody' is set
        if (tagCreateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'tagCreateRequestBody' when calling createTag(Async)");
        }

        return createTagCall(userGuid, tagCreateRequestBody, _callback);

    }

    /**
     * Create tag
     * Use this endpoint to create a new custom tag.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param tagCreateRequestBody Tag object to be created with required parameters (tag_guid) (required)
     * @return TagResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public TagResponseBody createTag(String userGuid, TagCreateRequestBody tagCreateRequestBody) throws ApiException {
        ApiResponse<TagResponseBody> localVarResp = createTagWithHttpInfo(userGuid, tagCreateRequestBody);
        return localVarResp.getData();
    }

    /**
     * Create tag
     * Use this endpoint to create a new custom tag.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param tagCreateRequestBody Tag object to be created with required parameters (tag_guid) (required)
     * @return ApiResponse&lt;TagResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TagResponseBody> createTagWithHttpInfo(String userGuid, TagCreateRequestBody tagCreateRequestBody) throws ApiException {
        okhttp3.Call localVarCall = createTagValidateBeforeCall(userGuid, tagCreateRequestBody, null);
        Type localVarReturnType = new TypeToken<TagResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create tag (asynchronously)
     * Use this endpoint to create a new custom tag.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param tagCreateRequestBody Tag object to be created with required parameters (tag_guid) (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createTagAsync(String userGuid, TagCreateRequestBody tagCreateRequestBody, final ApiCallback<TagResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = createTagValidateBeforeCall(userGuid, tagCreateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<TagResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for createTagging
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param taggingCreateRequestBody Tagging object to be created with required parameters (tag_guid and transaction_guid) (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createTaggingCall(String userGuid, TaggingCreateRequestBody taggingCreateRequestBody, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = taggingCreateRequestBody;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/taggings"
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createTaggingValidateBeforeCall(String userGuid, TaggingCreateRequestBody taggingCreateRequestBody, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling createTagging(Async)");
        }

        // verify the required parameter 'taggingCreateRequestBody' is set
        if (taggingCreateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'taggingCreateRequestBody' when calling createTagging(Async)");
        }

        return createTaggingCall(userGuid, taggingCreateRequestBody, _callback);

    }

    /**
     * Create tagging
     * Use this endpoint to create a new association between a tag and a particular transaction, according to their unique GUIDs.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param taggingCreateRequestBody Tagging object to be created with required parameters (tag_guid and transaction_guid) (required)
     * @return TaggingResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public TaggingResponseBody createTagging(String userGuid, TaggingCreateRequestBody taggingCreateRequestBody) throws ApiException {
        ApiResponse<TaggingResponseBody> localVarResp = createTaggingWithHttpInfo(userGuid, taggingCreateRequestBody);
        return localVarResp.getData();
    }

    /**
     * Create tagging
     * Use this endpoint to create a new association between a tag and a particular transaction, according to their unique GUIDs.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param taggingCreateRequestBody Tagging object to be created with required parameters (tag_guid and transaction_guid) (required)
     * @return ApiResponse&lt;TaggingResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TaggingResponseBody> createTaggingWithHttpInfo(String userGuid, TaggingCreateRequestBody taggingCreateRequestBody) throws ApiException {
        okhttp3.Call localVarCall = createTaggingValidateBeforeCall(userGuid, taggingCreateRequestBody, null);
        Type localVarReturnType = new TypeToken<TaggingResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create tagging (asynchronously)
     * Use this endpoint to create a new association between a tag and a particular transaction, according to their unique GUIDs.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param taggingCreateRequestBody Tagging object to be created with required parameters (tag_guid and transaction_guid) (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createTaggingAsync(String userGuid, TaggingCreateRequestBody taggingCreateRequestBody, final ApiCallback<TaggingResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = createTaggingValidateBeforeCall(userGuid, taggingCreateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<TaggingResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for createTransactionRule
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param transactionRuleCreateRequestBody TransactionRule object to be created with optional parameters (description) and required parameters (category_guid and match_description) (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createTransactionRuleCall(String userGuid, TransactionRuleCreateRequestBody transactionRuleCreateRequestBody, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = transactionRuleCreateRequestBody;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/transaction_rules"
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createTransactionRuleValidateBeforeCall(String userGuid, TransactionRuleCreateRequestBody transactionRuleCreateRequestBody, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling createTransactionRule(Async)");
        }

        // verify the required parameter 'transactionRuleCreateRequestBody' is set
        if (transactionRuleCreateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'transactionRuleCreateRequestBody' when calling createTransactionRule(Async)");
        }

        return createTransactionRuleCall(userGuid, transactionRuleCreateRequestBody, _callback);

    }

    /**
     * Create transaction rule
     * Use this endpoint to create a new transaction rule. The newly-created &#x60;transaction_rule&#x60; object will be returned if successful.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param transactionRuleCreateRequestBody TransactionRule object to be created with optional parameters (description) and required parameters (category_guid and match_description) (required)
     * @return TransactionRuleResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public TransactionRuleResponseBody createTransactionRule(String userGuid, TransactionRuleCreateRequestBody transactionRuleCreateRequestBody) throws ApiException {
        ApiResponse<TransactionRuleResponseBody> localVarResp = createTransactionRuleWithHttpInfo(userGuid, transactionRuleCreateRequestBody);
        return localVarResp.getData();
    }

    /**
     * Create transaction rule
     * Use this endpoint to create a new transaction rule. The newly-created &#x60;transaction_rule&#x60; object will be returned if successful.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param transactionRuleCreateRequestBody TransactionRule object to be created with optional parameters (description) and required parameters (category_guid and match_description) (required)
     * @return ApiResponse&lt;TransactionRuleResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TransactionRuleResponseBody> createTransactionRuleWithHttpInfo(String userGuid, TransactionRuleCreateRequestBody transactionRuleCreateRequestBody) throws ApiException {
        okhttp3.Call localVarCall = createTransactionRuleValidateBeforeCall(userGuid, transactionRuleCreateRequestBody, null);
        Type localVarReturnType = new TypeToken<TransactionRuleResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create transaction rule (asynchronously)
     * Use this endpoint to create a new transaction rule. The newly-created &#x60;transaction_rule&#x60; object will be returned if successful.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param transactionRuleCreateRequestBody TransactionRule object to be created with optional parameters (description) and required parameters (category_guid and match_description) (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createTransactionRuleAsync(String userGuid, TransactionRuleCreateRequestBody transactionRuleCreateRequestBody, final ApiCallback<TransactionRuleResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = createTransactionRuleValidateBeforeCall(userGuid, transactionRuleCreateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<TransactionRuleResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for createUser
     * @param userCreateRequestBody User object to be created. (None of these parameters are required, but the user object cannot be empty) (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createUserCall(UserCreateRequestBody userCreateRequestBody, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = userCreateRequestBody;

        // create path and map variables
        String localVarPath = "/users";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createUserValidateBeforeCall(UserCreateRequestBody userCreateRequestBody, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userCreateRequestBody' is set
        if (userCreateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'userCreateRequestBody' when calling createUser(Async)");
        }

        return createUserCall(userCreateRequestBody, _callback);

    }

    /**
     * Create user
     * Use this endpoint to create a new user. The API will respond with the newly-created user object if successful. Disabling a user means that accounts and transactions associated with it will not be updated in the background by MX. It will also restrict access to that user’s data until they are no longer disabled.
     * @param userCreateRequestBody User object to be created. (None of these parameters are required, but the user object cannot be empty) (required)
     * @return UserResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public UserResponseBody createUser(UserCreateRequestBody userCreateRequestBody) throws ApiException {
        ApiResponse<UserResponseBody> localVarResp = createUserWithHttpInfo(userCreateRequestBody);
        return localVarResp.getData();
    }

    /**
     * Create user
     * Use this endpoint to create a new user. The API will respond with the newly-created user object if successful. Disabling a user means that accounts and transactions associated with it will not be updated in the background by MX. It will also restrict access to that user’s data until they are no longer disabled.
     * @param userCreateRequestBody User object to be created. (None of these parameters are required, but the user object cannot be empty) (required)
     * @return ApiResponse&lt;UserResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<UserResponseBody> createUserWithHttpInfo(UserCreateRequestBody userCreateRequestBody) throws ApiException {
        okhttp3.Call localVarCall = createUserValidateBeforeCall(userCreateRequestBody, null);
        Type localVarReturnType = new TypeToken<UserResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create user (asynchronously)
     * Use this endpoint to create a new user. The API will respond with the newly-created user object if successful. Disabling a user means that accounts and transactions associated with it will not be updated in the background by MX. It will also restrict access to that user’s data until they are no longer disabled.
     * @param userCreateRequestBody User object to be created. (None of these parameters are required, but the user object cannot be empty) (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createUserAsync(UserCreateRequestBody userCreateRequestBody, final ApiCallback<UserResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = createUserValidateBeforeCall(userCreateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<UserResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for creditCard
     * @param creditCardProductGuid The required &#x60;credit_card_product_guid&#x60; can be found on the &#x60;account&#x60; object. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call creditCardCall(String creditCardProductGuid, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/credit_card_products/{credit_card_product_guid}"
            .replace("{" + "credit_card_product_guid" + "}", localVarApiClient.escapeString(creditCardProductGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call creditCardValidateBeforeCall(String creditCardProductGuid, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'creditCardProductGuid' is set
        if (creditCardProductGuid == null) {
            throw new ApiException("Missing the required parameter 'creditCardProductGuid' when calling creditCard(Async)");
        }

        return creditCardCall(creditCardProductGuid, _callback);

    }

    /**
     * Read a Credit Card Product
     * This endpoint returns the specified &#x60;credit_card_product&#x60; according to the unique GUID.
     * @param creditCardProductGuid The required &#x60;credit_card_product_guid&#x60; can be found on the &#x60;account&#x60; object. (required)
     * @return CreditCardProductResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public CreditCardProductResponse creditCard(String creditCardProductGuid) throws ApiException {
        ApiResponse<CreditCardProductResponse> localVarResp = creditCardWithHttpInfo(creditCardProductGuid);
        return localVarResp.getData();
    }

    /**
     * Read a Credit Card Product
     * This endpoint returns the specified &#x60;credit_card_product&#x60; according to the unique GUID.
     * @param creditCardProductGuid The required &#x60;credit_card_product_guid&#x60; can be found on the &#x60;account&#x60; object. (required)
     * @return ApiResponse&lt;CreditCardProductResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CreditCardProductResponse> creditCardWithHttpInfo(String creditCardProductGuid) throws ApiException {
        okhttp3.Call localVarCall = creditCardValidateBeforeCall(creditCardProductGuid, null);
        Type localVarReturnType = new TypeToken<CreditCardProductResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Read a Credit Card Product (asynchronously)
     * This endpoint returns the specified &#x60;credit_card_product&#x60; according to the unique GUID.
     * @param creditCardProductGuid The required &#x60;credit_card_product_guid&#x60; can be found on the &#x60;account&#x60; object. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call creditCardAsync(String creditCardProductGuid, final ApiCallback<CreditCardProductResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = creditCardValidateBeforeCall(creditCardProductGuid, _callback);
        Type localVarReturnType = new TypeToken<CreditCardProductResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteCategory
     * @param categoryGuid The unique id for a &#x60;category&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteCategoryCall(String categoryGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/categories/{category_guid}"
            .replace("{" + "category_guid" + "}", localVarApiClient.escapeString(categoryGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteCategoryValidateBeforeCall(String categoryGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'categoryGuid' is set
        if (categoryGuid == null) {
            throw new ApiException("Missing the required parameter 'categoryGuid' when calling deleteCategory(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling deleteCategory(Async)");
        }

        return deleteCategoryCall(categoryGuid, userGuid, _callback);

    }

    /**
     * Delete category
     * Use this endpoint to delete a specific custom category according to its unique GUID. The API will respond with an empty object and a status of &#x60;204 No Content&#x60;.
     * @param categoryGuid The unique id for a &#x60;category&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public void deleteCategory(String categoryGuid, String userGuid) throws ApiException {
        deleteCategoryWithHttpInfo(categoryGuid, userGuid);
    }

    /**
     * Delete category
     * Use this endpoint to delete a specific custom category according to its unique GUID. The API will respond with an empty object and a status of &#x60;204 No Content&#x60;.
     * @param categoryGuid The unique id for a &#x60;category&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteCategoryWithHttpInfo(String categoryGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = deleteCategoryValidateBeforeCall(categoryGuid, userGuid, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete category (asynchronously)
     * Use this endpoint to delete a specific custom category according to its unique GUID. The API will respond with an empty object and a status of &#x60;204 No Content&#x60;.
     * @param categoryGuid The unique id for a &#x60;category&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteCategoryAsync(String categoryGuid, String userGuid, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteCategoryValidateBeforeCall(categoryGuid, userGuid, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteManagedAccount
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteManagedAccountCall(String accountGuid, String memberGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/managed_members/{member_guid}/accounts/{account_guid}"
            .replace("{" + "account_guid" + "}", localVarApiClient.escapeString(accountGuid.toString()))
            .replace("{" + "member_guid" + "}", localVarApiClient.escapeString(memberGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteManagedAccountValidateBeforeCall(String accountGuid, String memberGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountGuid' is set
        if (accountGuid == null) {
            throw new ApiException("Missing the required parameter 'accountGuid' when calling deleteManagedAccount(Async)");
        }

        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling deleteManagedAccount(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling deleteManagedAccount(Async)");
        }

        return deleteManagedAccountCall(accountGuid, memberGuid, userGuid, _callback);

    }

    /**
     * Delete managed account
     * Use this endpoint to delete a partner-managed account according to its unique GUID. If successful, the API will respond with a status of &#x60;204 No Content&#x60;.
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public void deleteManagedAccount(String accountGuid, String memberGuid, String userGuid) throws ApiException {
        deleteManagedAccountWithHttpInfo(accountGuid, memberGuid, userGuid);
    }

    /**
     * Delete managed account
     * Use this endpoint to delete a partner-managed account according to its unique GUID. If successful, the API will respond with a status of &#x60;204 No Content&#x60;.
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteManagedAccountWithHttpInfo(String accountGuid, String memberGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = deleteManagedAccountValidateBeforeCall(accountGuid, memberGuid, userGuid, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete managed account (asynchronously)
     * Use this endpoint to delete a partner-managed account according to its unique GUID. If successful, the API will respond with a status of &#x60;204 No Content&#x60;.
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteManagedAccountAsync(String accountGuid, String memberGuid, String userGuid, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteManagedAccountValidateBeforeCall(accountGuid, memberGuid, userGuid, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteManagedMember
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteManagedMemberCall(String memberGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/managed_members/{member_guid}"
            .replace("{" + "member_guid" + "}", localVarApiClient.escapeString(memberGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteManagedMemberValidateBeforeCall(String memberGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling deleteManagedMember(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling deleteManagedMember(Async)");
        }

        return deleteManagedMemberCall(memberGuid, userGuid, _callback);

    }

    /**
     * Delete managed member
     * Use this endpoint to delete the specified partner-managed &#x60;member&#x60;. The endpoint will respond with a status of &#x60;204 No Content&#x60; without a resource.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public void deleteManagedMember(String memberGuid, String userGuid) throws ApiException {
        deleteManagedMemberWithHttpInfo(memberGuid, userGuid);
    }

    /**
     * Delete managed member
     * Use this endpoint to delete the specified partner-managed &#x60;member&#x60;. The endpoint will respond with a status of &#x60;204 No Content&#x60; without a resource.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteManagedMemberWithHttpInfo(String memberGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = deleteManagedMemberValidateBeforeCall(memberGuid, userGuid, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete managed member (asynchronously)
     * Use this endpoint to delete the specified partner-managed &#x60;member&#x60;. The endpoint will respond with a status of &#x60;204 No Content&#x60; without a resource.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteManagedMemberAsync(String memberGuid, String userGuid, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteManagedMemberValidateBeforeCall(memberGuid, userGuid, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteManagedTransaction
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param transactionGuid The unique id for a &#x60;transaction&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteManagedTransactionCall(String accountGuid, String memberGuid, String transactionGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/managed_members/{member_guid}/accounts/{account_guid}/transactions/{transaction_guid}"
            .replace("{" + "account_guid" + "}", localVarApiClient.escapeString(accountGuid.toString()))
            .replace("{" + "member_guid" + "}", localVarApiClient.escapeString(memberGuid.toString()))
            .replace("{" + "transaction_guid" + "}", localVarApiClient.escapeString(transactionGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteManagedTransactionValidateBeforeCall(String accountGuid, String memberGuid, String transactionGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountGuid' is set
        if (accountGuid == null) {
            throw new ApiException("Missing the required parameter 'accountGuid' when calling deleteManagedTransaction(Async)");
        }

        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling deleteManagedTransaction(Async)");
        }

        // verify the required parameter 'transactionGuid' is set
        if (transactionGuid == null) {
            throw new ApiException("Missing the required parameter 'transactionGuid' when calling deleteManagedTransaction(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling deleteManagedTransaction(Async)");
        }

        return deleteManagedTransactionCall(accountGuid, memberGuid, transactionGuid, userGuid, _callback);

    }

    /**
     * Delete managed transaction
     * Use this endpoint to delete the specified partner-managed &#x60;transaction&#x60;. The endpoint will respond with a status of &#x60;204 No Content&#x60; without a resource.
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param transactionGuid The unique id for a &#x60;transaction&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public void deleteManagedTransaction(String accountGuid, String memberGuid, String transactionGuid, String userGuid) throws ApiException {
        deleteManagedTransactionWithHttpInfo(accountGuid, memberGuid, transactionGuid, userGuid);
    }

    /**
     * Delete managed transaction
     * Use this endpoint to delete the specified partner-managed &#x60;transaction&#x60;. The endpoint will respond with a status of &#x60;204 No Content&#x60; without a resource.
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param transactionGuid The unique id for a &#x60;transaction&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteManagedTransactionWithHttpInfo(String accountGuid, String memberGuid, String transactionGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = deleteManagedTransactionValidateBeforeCall(accountGuid, memberGuid, transactionGuid, userGuid, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete managed transaction (asynchronously)
     * Use this endpoint to delete the specified partner-managed &#x60;transaction&#x60;. The endpoint will respond with a status of &#x60;204 No Content&#x60; without a resource.
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param transactionGuid The unique id for a &#x60;transaction&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteManagedTransactionAsync(String accountGuid, String memberGuid, String transactionGuid, String userGuid, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteManagedTransactionValidateBeforeCall(accountGuid, memberGuid, transactionGuid, userGuid, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteManualAccount
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No content. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteManualAccountCall(String accountGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/accounts/{account_guid}"
            .replace("{" + "account_guid" + "}", localVarApiClient.escapeString(accountGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteManualAccountValidateBeforeCall(String accountGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountGuid' is set
        if (accountGuid == null) {
            throw new ApiException("Missing the required parameter 'accountGuid' when calling deleteManualAccount(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling deleteManualAccount(Async)");
        }

        return deleteManualAccountCall(accountGuid, userGuid, _callback);

    }

    /**
     * Delete manual account
     * This endpoint deletes accounts that were manually created. The API will respond with an empty object and a status of &#x60;204 No Content&#x60;.
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No content. </td><td>  -  </td></tr>
     </table>
     */
    public void deleteManualAccount(String accountGuid, String userGuid) throws ApiException {
        deleteManualAccountWithHttpInfo(accountGuid, userGuid);
    }

    /**
     * Delete manual account
     * This endpoint deletes accounts that were manually created. The API will respond with an empty object and a status of &#x60;204 No Content&#x60;.
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No content. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteManualAccountWithHttpInfo(String accountGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = deleteManualAccountValidateBeforeCall(accountGuid, userGuid, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete manual account (asynchronously)
     * This endpoint deletes accounts that were manually created. The API will respond with an empty object and a status of &#x60;204 No Content&#x60;.
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No content. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteManualAccountAsync(String accountGuid, String userGuid, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteManualAccountValidateBeforeCall(accountGuid, userGuid, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteMember
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteMemberCall(String memberGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/members/{member_guid}"
            .replace("{" + "member_guid" + "}", localVarApiClient.escapeString(memberGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteMemberValidateBeforeCall(String memberGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling deleteMember(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling deleteMember(Async)");
        }

        return deleteMemberCall(memberGuid, userGuid, _callback);

    }

    /**
     * Delete member
     * Accessing this endpoint will permanently delete a member.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public void deleteMember(String memberGuid, String userGuid) throws ApiException {
        deleteMemberWithHttpInfo(memberGuid, userGuid);
    }

    /**
     * Delete member
     * Accessing this endpoint will permanently delete a member.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteMemberWithHttpInfo(String memberGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = deleteMemberValidateBeforeCall(memberGuid, userGuid, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete member (asynchronously)
     * Accessing this endpoint will permanently delete a member.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteMemberAsync(String memberGuid, String userGuid, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteMemberValidateBeforeCall(memberGuid, userGuid, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteTag
     * @param tagGuid The unique id for a &#x60;tag&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteTagCall(String tagGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/tags/{tag_guid}"
            .replace("{" + "tag_guid" + "}", localVarApiClient.escapeString(tagGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteTagValidateBeforeCall(String tagGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'tagGuid' is set
        if (tagGuid == null) {
            throw new ApiException("Missing the required parameter 'tagGuid' when calling deleteTag(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling deleteTag(Async)");
        }

        return deleteTagCall(tagGuid, userGuid, _callback);

    }

    /**
     * Delete tag
     * Use this endpoint to permanently delete a specific tag based on its unique GUID. If successful, the API will respond with status of &#x60;204 No Content&#x60;.
     * @param tagGuid The unique id for a &#x60;tag&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public void deleteTag(String tagGuid, String userGuid) throws ApiException {
        deleteTagWithHttpInfo(tagGuid, userGuid);
    }

    /**
     * Delete tag
     * Use this endpoint to permanently delete a specific tag based on its unique GUID. If successful, the API will respond with status of &#x60;204 No Content&#x60;.
     * @param tagGuid The unique id for a &#x60;tag&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteTagWithHttpInfo(String tagGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = deleteTagValidateBeforeCall(tagGuid, userGuid, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete tag (asynchronously)
     * Use this endpoint to permanently delete a specific tag based on its unique GUID. If successful, the API will respond with status of &#x60;204 No Content&#x60;.
     * @param tagGuid The unique id for a &#x60;tag&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteTagAsync(String tagGuid, String userGuid, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteTagValidateBeforeCall(tagGuid, userGuid, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteTagging
     * @param taggingGuid The unique id for a &#x60;tagging&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteTaggingCall(String taggingGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/taggings/{tagging_guid}"
            .replace("{" + "tagging_guid" + "}", localVarApiClient.escapeString(taggingGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteTaggingValidateBeforeCall(String taggingGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'taggingGuid' is set
        if (taggingGuid == null) {
            throw new ApiException("Missing the required parameter 'taggingGuid' when calling deleteTagging(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling deleteTagging(Async)");
        }

        return deleteTaggingCall(taggingGuid, userGuid, _callback);

    }

    /**
     * Delete tagging
     * Use this endpoint to delete a tagging according to its unique GUID. If successful, the API will respond with an empty body and a status of 204 NO Content.
     * @param taggingGuid The unique id for a &#x60;tagging&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public void deleteTagging(String taggingGuid, String userGuid) throws ApiException {
        deleteTaggingWithHttpInfo(taggingGuid, userGuid);
    }

    /**
     * Delete tagging
     * Use this endpoint to delete a tagging according to its unique GUID. If successful, the API will respond with an empty body and a status of 204 NO Content.
     * @param taggingGuid The unique id for a &#x60;tagging&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteTaggingWithHttpInfo(String taggingGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = deleteTaggingValidateBeforeCall(taggingGuid, userGuid, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete tagging (asynchronously)
     * Use this endpoint to delete a tagging according to its unique GUID. If successful, the API will respond with an empty body and a status of 204 NO Content.
     * @param taggingGuid The unique id for a &#x60;tagging&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteTaggingAsync(String taggingGuid, String userGuid, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteTaggingValidateBeforeCall(taggingGuid, userGuid, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteTransactionRule
     * @param transactionRuleGuid The unique id for a &#x60;transaction_rule&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteTransactionRuleCall(String transactionRuleGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/transaction_rules/{transaction_rule_guid}"
            .replace("{" + "transaction_rule_guid" + "}", localVarApiClient.escapeString(transactionRuleGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteTransactionRuleValidateBeforeCall(String transactionRuleGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'transactionRuleGuid' is set
        if (transactionRuleGuid == null) {
            throw new ApiException("Missing the required parameter 'transactionRuleGuid' when calling deleteTransactionRule(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling deleteTransactionRule(Async)");
        }

        return deleteTransactionRuleCall(transactionRuleGuid, userGuid, _callback);

    }

    /**
     * Delete transaction rule
     * Use this endpoint to permanently delete a transaction rule based on its unique GUID.
     * @param transactionRuleGuid The unique id for a &#x60;transaction_rule&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public void deleteTransactionRule(String transactionRuleGuid, String userGuid) throws ApiException {
        deleteTransactionRuleWithHttpInfo(transactionRuleGuid, userGuid);
    }

    /**
     * Delete transaction rule
     * Use this endpoint to permanently delete a transaction rule based on its unique GUID.
     * @param transactionRuleGuid The unique id for a &#x60;transaction_rule&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteTransactionRuleWithHttpInfo(String transactionRuleGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = deleteTransactionRuleValidateBeforeCall(transactionRuleGuid, userGuid, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete transaction rule (asynchronously)
     * Use this endpoint to permanently delete a transaction rule based on its unique GUID.
     * @param transactionRuleGuid The unique id for a &#x60;transaction_rule&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteTransactionRuleAsync(String transactionRuleGuid, String userGuid, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteTransactionRuleValidateBeforeCall(transactionRuleGuid, userGuid, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteUser
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteUserCall(String userGuid, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}"
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteUserValidateBeforeCall(String userGuid, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling deleteUser(Async)");
        }

        return deleteUserCall(userGuid, _callback);

    }

    /**
     * Delete user
     * Use this endpoint to delete the specified &#x60;user&#x60;. The response will have a status of &#x60;204 No Content&#x60; without an object.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public void deleteUser(String userGuid) throws ApiException {
        deleteUserWithHttpInfo(userGuid);
    }

    /**
     * Delete user
     * Use this endpoint to delete the specified &#x60;user&#x60;. The response will have a status of &#x60;204 No Content&#x60; without an object.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteUserWithHttpInfo(String userGuid) throws ApiException {
        okhttp3.Call localVarCall = deleteUserValidateBeforeCall(userGuid, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete user (asynchronously)
     * Use this endpoint to delete the specified &#x60;user&#x60;. The response will have a status of &#x60;204 No Content&#x60; without an object.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteUserAsync(String userGuid, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteUserValidateBeforeCall(userGuid, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for deprecatedRequestPaymentProcessorAuthorizationCode
     * @param paymentProcessorAuthorizationCodeRequestBody The scope for the authorization code. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deprecatedRequestPaymentProcessorAuthorizationCodeCall(PaymentProcessorAuthorizationCodeRequestBody paymentProcessorAuthorizationCodeRequestBody, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = paymentProcessorAuthorizationCodeRequestBody;

        // create path and map variables
        String localVarPath = "/payment_processor_authorization_code";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deprecatedRequestPaymentProcessorAuthorizationCodeValidateBeforeCall(PaymentProcessorAuthorizationCodeRequestBody paymentProcessorAuthorizationCodeRequestBody, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'paymentProcessorAuthorizationCodeRequestBody' is set
        if (paymentProcessorAuthorizationCodeRequestBody == null) {
            throw new ApiException("Missing the required parameter 'paymentProcessorAuthorizationCodeRequestBody' when calling deprecatedRequestPaymentProcessorAuthorizationCode(Async)");
        }

        return deprecatedRequestPaymentProcessorAuthorizationCodeCall(paymentProcessorAuthorizationCodeRequestBody, _callback);

    }

    /**
     * (Deprecated) Request an authorization code.
     * (This endpoint is deprecated. Clients should use &#x60;/authorization_code&#x60;.) Clients use this endpoint to request an authorization_code according to a user, member, and account specified in the request body. Clients then pass this code to processors. Processor access is scoped only to the user/member/account specified in this request. Before requesting an authorization_code, clients must have verified the specified member.
     * @param paymentProcessorAuthorizationCodeRequestBody The scope for the authorization code. (required)
     * @return PaymentProcessorAuthorizationCodeResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public PaymentProcessorAuthorizationCodeResponseBody deprecatedRequestPaymentProcessorAuthorizationCode(PaymentProcessorAuthorizationCodeRequestBody paymentProcessorAuthorizationCodeRequestBody) throws ApiException {
        ApiResponse<PaymentProcessorAuthorizationCodeResponseBody> localVarResp = deprecatedRequestPaymentProcessorAuthorizationCodeWithHttpInfo(paymentProcessorAuthorizationCodeRequestBody);
        return localVarResp.getData();
    }

    /**
     * (Deprecated) Request an authorization code.
     * (This endpoint is deprecated. Clients should use &#x60;/authorization_code&#x60;.) Clients use this endpoint to request an authorization_code according to a user, member, and account specified in the request body. Clients then pass this code to processors. Processor access is scoped only to the user/member/account specified in this request. Before requesting an authorization_code, clients must have verified the specified member.
     * @param paymentProcessorAuthorizationCodeRequestBody The scope for the authorization code. (required)
     * @return ApiResponse&lt;PaymentProcessorAuthorizationCodeResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<PaymentProcessorAuthorizationCodeResponseBody> deprecatedRequestPaymentProcessorAuthorizationCodeWithHttpInfo(PaymentProcessorAuthorizationCodeRequestBody paymentProcessorAuthorizationCodeRequestBody) throws ApiException {
        okhttp3.Call localVarCall = deprecatedRequestPaymentProcessorAuthorizationCodeValidateBeforeCall(paymentProcessorAuthorizationCodeRequestBody, null);
        Type localVarReturnType = new TypeToken<PaymentProcessorAuthorizationCodeResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * (Deprecated) Request an authorization code. (asynchronously)
     * (This endpoint is deprecated. Clients should use &#x60;/authorization_code&#x60;.) Clients use this endpoint to request an authorization_code according to a user, member, and account specified in the request body. Clients then pass this code to processors. Processor access is scoped only to the user/member/account specified in this request. Before requesting an authorization_code, clients must have verified the specified member.
     * @param paymentProcessorAuthorizationCodeRequestBody The scope for the authorization code. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deprecatedRequestPaymentProcessorAuthorizationCodeAsync(PaymentProcessorAuthorizationCodeRequestBody paymentProcessorAuthorizationCodeRequestBody, final ApiCallback<PaymentProcessorAuthorizationCodeResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = deprecatedRequestPaymentProcessorAuthorizationCodeValidateBeforeCall(paymentProcessorAuthorizationCodeRequestBody, _callback);
        Type localVarReturnType = new TypeToken<PaymentProcessorAuthorizationCodeResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for downloadStatementPDF
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param statementGuid The unique id for a &#x60;statement&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call downloadStatementPDFCall(String memberGuid, String statementGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/members/{member_guid}/statements/{statement_guid}.pdf"
            .replace("{" + "member_guid" + "}", localVarApiClient.escapeString(memberGuid.toString()))
            .replace("{" + "statement_guid" + "}", localVarApiClient.escapeString(statementGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+pdf"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call downloadStatementPDFValidateBeforeCall(String memberGuid, String statementGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling downloadStatementPDF(Async)");
        }

        // verify the required parameter 'statementGuid' is set
        if (statementGuid == null) {
            throw new ApiException("Missing the required parameter 'statementGuid' when calling downloadStatementPDF(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling downloadStatementPDF(Async)");
        }

        return downloadStatementPDFCall(memberGuid, statementGuid, userGuid, _callback);

    }

    /**
     * Download statement pdf
     * Use this endpoint to download a specified statement PDF.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param statementGuid The unique id for a &#x60;statement&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public File downloadStatementPDF(String memberGuid, String statementGuid, String userGuid) throws ApiException {
        ApiResponse<File> localVarResp = downloadStatementPDFWithHttpInfo(memberGuid, statementGuid, userGuid);
        return localVarResp.getData();
    }

    /**
     * Download statement pdf
     * Use this endpoint to download a specified statement PDF.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param statementGuid The unique id for a &#x60;statement&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<File> downloadStatementPDFWithHttpInfo(String memberGuid, String statementGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = downloadStatementPDFValidateBeforeCall(memberGuid, statementGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Download statement pdf (asynchronously)
     * Use this endpoint to download a specified statement PDF.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param statementGuid The unique id for a &#x60;statement&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call downloadStatementPDFAsync(String memberGuid, String statementGuid, String userGuid, final ApiCallback<File> _callback) throws ApiException {

        okhttp3.Call localVarCall = downloadStatementPDFValidateBeforeCall(memberGuid, statementGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for downloadTaxDocument
     * @param taxDocumentGuid The unique id for a &#x60;tax_document&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call downloadTaxDocumentCall(String taxDocumentGuid, String memberGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/members/{member_guid}/tax_documents/{tax_document_guid}.pdf"
            .replace("{" + "tax_document_guid" + "}", localVarApiClient.escapeString(taxDocumentGuid.toString()))
            .replace("{" + "member_guid" + "}", localVarApiClient.escapeString(memberGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+pdf"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call downloadTaxDocumentValidateBeforeCall(String taxDocumentGuid, String memberGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'taxDocumentGuid' is set
        if (taxDocumentGuid == null) {
            throw new ApiException("Missing the required parameter 'taxDocumentGuid' when calling downloadTaxDocument(Async)");
        }

        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling downloadTaxDocument(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling downloadTaxDocument(Async)");
        }

        return downloadTaxDocumentCall(taxDocumentGuid, memberGuid, userGuid, _callback);

    }

    /**
     * Download a Tax Document PDF
     * Use this endpoint to download a PDF version of the specified tax document. The endpoint URL is the base URL appended with the uri of the tax_document.
     * @param taxDocumentGuid The unique id for a &#x60;tax_document&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public File downloadTaxDocument(String taxDocumentGuid, String memberGuid, String userGuid) throws ApiException {
        ApiResponse<File> localVarResp = downloadTaxDocumentWithHttpInfo(taxDocumentGuid, memberGuid, userGuid);
        return localVarResp.getData();
    }

    /**
     * Download a Tax Document PDF
     * Use this endpoint to download a PDF version of the specified tax document. The endpoint URL is the base URL appended with the uri of the tax_document.
     * @param taxDocumentGuid The unique id for a &#x60;tax_document&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<File> downloadTaxDocumentWithHttpInfo(String taxDocumentGuid, String memberGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = downloadTaxDocumentValidateBeforeCall(taxDocumentGuid, memberGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Download a Tax Document PDF (asynchronously)
     * Use this endpoint to download a PDF version of the specified tax document. The endpoint URL is the base URL appended with the uri of the tax_document.
     * @param taxDocumentGuid The unique id for a &#x60;tax_document&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call downloadTaxDocumentAsync(String taxDocumentGuid, String memberGuid, String userGuid, final ApiCallback<File> _callback) throws ApiException {

        okhttp3.Call localVarCall = downloadTaxDocumentValidateBeforeCall(taxDocumentGuid, memberGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for enhanceTransactions
     * @param enhanceTransactionsRequestBody Transaction object to be enhanced (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call enhanceTransactionsCall(EnhanceTransactionsRequestBody enhanceTransactionsRequestBody, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = enhanceTransactionsRequestBody;

        // create path and map variables
        String localVarPath = "/transactions/enhance";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call enhanceTransactionsValidateBeforeCall(EnhanceTransactionsRequestBody enhanceTransactionsRequestBody, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'enhanceTransactionsRequestBody' is set
        if (enhanceTransactionsRequestBody == null) {
            throw new ApiException("Missing the required parameter 'enhanceTransactionsRequestBody' when calling enhanceTransactions(Async)");
        }

        return enhanceTransactionsCall(enhanceTransactionsRequestBody, _callback);

    }

    /**
     * Enhance transactions
     * Use this endpoint to categorize, cleanse, and classify transactions. These transactions are not persisted or stored on the MX platform.
     * @param enhanceTransactionsRequestBody Transaction object to be enhanced (required)
     * @return EnhanceTransactionsResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public EnhanceTransactionsResponseBody enhanceTransactions(EnhanceTransactionsRequestBody enhanceTransactionsRequestBody) throws ApiException {
        ApiResponse<EnhanceTransactionsResponseBody> localVarResp = enhanceTransactionsWithHttpInfo(enhanceTransactionsRequestBody);
        return localVarResp.getData();
    }

    /**
     * Enhance transactions
     * Use this endpoint to categorize, cleanse, and classify transactions. These transactions are not persisted or stored on the MX platform.
     * @param enhanceTransactionsRequestBody Transaction object to be enhanced (required)
     * @return ApiResponse&lt;EnhanceTransactionsResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<EnhanceTransactionsResponseBody> enhanceTransactionsWithHttpInfo(EnhanceTransactionsRequestBody enhanceTransactionsRequestBody) throws ApiException {
        okhttp3.Call localVarCall = enhanceTransactionsValidateBeforeCall(enhanceTransactionsRequestBody, null);
        Type localVarReturnType = new TypeToken<EnhanceTransactionsResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Enhance transactions (asynchronously)
     * Use this endpoint to categorize, cleanse, and classify transactions. These transactions are not persisted or stored on the MX platform.
     * @param enhanceTransactionsRequestBody Transaction object to be enhanced (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call enhanceTransactionsAsync(EnhanceTransactionsRequestBody enhanceTransactionsRequestBody, final ApiCallback<EnhanceTransactionsResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = enhanceTransactionsValidateBeforeCall(enhanceTransactionsRequestBody, _callback);
        Type localVarReturnType = new TypeToken<EnhanceTransactionsResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for extendHistory
     * @param memberGuid The unique identifier for a &#x60;member&#x60;. (required)
     * @param userGuid The unique identifier for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call extendHistoryCall(String memberGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/members/{member_guid}/extend_history"
            .replace("{" + "member_guid" + "}", localVarApiClient.escapeString(memberGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call extendHistoryValidateBeforeCall(String memberGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling extendHistory(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling extendHistory(Async)");
        }

        return extendHistoryCall(memberGuid, userGuid, _callback);

    }

    /**
     * Extend history
     * Some institutions allow developers to access an extended transaction history with up to 24 months of data associated with a particular member. The process for fetching and then reading this extended transaction history is much like standard aggregation, and it may trigger multi-factor authentication.
     * @param memberGuid The unique identifier for a &#x60;member&#x60;. (required)
     * @param userGuid The unique identifier for a &#x60;user&#x60;. (required)
     * @return MemberResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public MemberResponseBody extendHistory(String memberGuid, String userGuid) throws ApiException {
        ApiResponse<MemberResponseBody> localVarResp = extendHistoryWithHttpInfo(memberGuid, userGuid);
        return localVarResp.getData();
    }

    /**
     * Extend history
     * Some institutions allow developers to access an extended transaction history with up to 24 months of data associated with a particular member. The process for fetching and then reading this extended transaction history is much like standard aggregation, and it may trigger multi-factor authentication.
     * @param memberGuid The unique identifier for a &#x60;member&#x60;. (required)
     * @param userGuid The unique identifier for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;MemberResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MemberResponseBody> extendHistoryWithHttpInfo(String memberGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = extendHistoryValidateBeforeCall(memberGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Extend history (asynchronously)
     * Some institutions allow developers to access an extended transaction history with up to 24 months of data associated with a particular member. The process for fetching and then reading this extended transaction history is much like standard aggregation, and it may trigger multi-factor authentication.
     * @param memberGuid The unique identifier for a &#x60;member&#x60;. (required)
     * @param userGuid The unique identifier for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call extendHistoryAsync(String memberGuid, String userGuid, final ApiCallback<MemberResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = extendHistoryValidateBeforeCall(memberGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for fetchRewards
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberGuid The unique identifier for the member. Defined by MX. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call fetchRewardsCall(String userGuid, String memberGuid, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/members/{member_guid}/fetch_rewards"
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()))
            .replace("{" + "member_guid" + "}", localVarApiClient.escapeString(memberGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call fetchRewardsValidateBeforeCall(String userGuid, String memberGuid, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling fetchRewards(Async)");
        }

        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling fetchRewards(Async)");
        }

        return fetchRewardsCall(userGuid, memberGuid, _callback);

    }

    /**
     * Fetch Rewards
     * Calling this endpoint initiates an aggregation-type event which will gather the member&#39;s rewards information, as well as account and transaction information. Rewards data is also gathered with daily background aggregations.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberGuid The unique identifier for the member. Defined by MX. (required)
     * @return MemberResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public MemberResponseBody fetchRewards(String userGuid, String memberGuid) throws ApiException {
        ApiResponse<MemberResponseBody> localVarResp = fetchRewardsWithHttpInfo(userGuid, memberGuid);
        return localVarResp.getData();
    }

    /**
     * Fetch Rewards
     * Calling this endpoint initiates an aggregation-type event which will gather the member&#39;s rewards information, as well as account and transaction information. Rewards data is also gathered with daily background aggregations.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberGuid The unique identifier for the member. Defined by MX. (required)
     * @return ApiResponse&lt;MemberResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MemberResponseBody> fetchRewardsWithHttpInfo(String userGuid, String memberGuid) throws ApiException {
        okhttp3.Call localVarCall = fetchRewardsValidateBeforeCall(userGuid, memberGuid, null);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Fetch Rewards (asynchronously)
     * Calling this endpoint initiates an aggregation-type event which will gather the member&#39;s rewards information, as well as account and transaction information. Rewards data is also gathered with daily background aggregations.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberGuid The unique identifier for the member. Defined by MX. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call fetchRewardsAsync(String userGuid, String memberGuid, final ApiCallback<MemberResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = fetchRewardsValidateBeforeCall(userGuid, memberGuid, _callback);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for fetchStatements
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call fetchStatementsCall(String memberGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/members/{member_guid}/fetch_statements"
            .replace("{" + "member_guid" + "}", localVarApiClient.escapeString(memberGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call fetchStatementsValidateBeforeCall(String memberGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling fetchStatements(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling fetchStatements(Async)");
        }

        return fetchStatementsCall(memberGuid, userGuid, _callback);

    }

    /**
     * Fetch statements
     * Use this endpoint to fetch the statements associated with a particular member.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return MemberResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public MemberResponseBody fetchStatements(String memberGuid, String userGuid) throws ApiException {
        ApiResponse<MemberResponseBody> localVarResp = fetchStatementsWithHttpInfo(memberGuid, userGuid);
        return localVarResp.getData();
    }

    /**
     * Fetch statements
     * Use this endpoint to fetch the statements associated with a particular member.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;MemberResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MemberResponseBody> fetchStatementsWithHttpInfo(String memberGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = fetchStatementsValidateBeforeCall(memberGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Fetch statements (asynchronously)
     * Use this endpoint to fetch the statements associated with a particular member.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call fetchStatementsAsync(String memberGuid, String userGuid, final ApiCallback<MemberResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = fetchStatementsValidateBeforeCall(memberGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for fetchTaxDocuments
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call fetchTaxDocumentsCall(String memberGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/members/{member_guid}/fetch_tax_documents"
            .replace("{" + "member_guid" + "}", localVarApiClient.escapeString(memberGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call fetchTaxDocumentsValidateBeforeCall(String memberGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling fetchTaxDocuments(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling fetchTaxDocuments(Async)");
        }

        return fetchTaxDocumentsCall(memberGuid, userGuid, _callback);

    }

    /**
     * Fetch Tax Documents
     * Use this endpoint to fetch (aggregate) the tax documents associated with the specified member. This request **does not** return the latest tax documents. It just starts the document aggregation process and returns the initial state of the process. You must interact with the newly aggregated data using the other document endpoints in this reference. This request may also trigger multi-factor authentication which requires end-user input and a specific process for answering authentication challenges.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return MemberResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public MemberResponseBody fetchTaxDocuments(String memberGuid, String userGuid) throws ApiException {
        ApiResponse<MemberResponseBody> localVarResp = fetchTaxDocumentsWithHttpInfo(memberGuid, userGuid);
        return localVarResp.getData();
    }

    /**
     * Fetch Tax Documents
     * Use this endpoint to fetch (aggregate) the tax documents associated with the specified member. This request **does not** return the latest tax documents. It just starts the document aggregation process and returns the initial state of the process. You must interact with the newly aggregated data using the other document endpoints in this reference. This request may also trigger multi-factor authentication which requires end-user input and a specific process for answering authentication challenges.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;MemberResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MemberResponseBody> fetchTaxDocumentsWithHttpInfo(String memberGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = fetchTaxDocumentsValidateBeforeCall(memberGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Fetch Tax Documents (asynchronously)
     * Use this endpoint to fetch (aggregate) the tax documents associated with the specified member. This request **does not** return the latest tax documents. It just starts the document aggregation process and returns the initial state of the process. You must interact with the newly aggregated data using the other document endpoints in this reference. This request may also trigger multi-factor authentication which requires end-user input and a specific process for answering authentication challenges.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call fetchTaxDocumentsAsync(String memberGuid, String userGuid, final ApiCallback<MemberResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = fetchTaxDocumentsValidateBeforeCall(memberGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for identifyMember
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call identifyMemberCall(String memberGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/members/{member_guid}/identify"
            .replace("{" + "member_guid" + "}", localVarApiClient.escapeString(memberGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call identifyMemberValidateBeforeCall(String memberGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling identifyMember(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling identifyMember(Async)");
        }

        return identifyMemberCall(memberGuid, userGuid, _callback);

    }

    /**
     * Identify member
     * The identify endpoint begins an identification process for an already-existing member.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return MemberResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public MemberResponseBody identifyMember(String memberGuid, String userGuid) throws ApiException {
        ApiResponse<MemberResponseBody> localVarResp = identifyMemberWithHttpInfo(memberGuid, userGuid);
        return localVarResp.getData();
    }

    /**
     * Identify member
     * The identify endpoint begins an identification process for an already-existing member.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;MemberResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MemberResponseBody> identifyMemberWithHttpInfo(String memberGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = identifyMemberValidateBeforeCall(memberGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Identify member (asynchronously)
     * The identify endpoint begins an identification process for an already-existing member.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call identifyMemberAsync(String memberGuid, String userGuid, final ApiCallback<MemberResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = identifyMemberValidateBeforeCall(memberGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listAccountNumbersByAccount
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listAccountNumbersByAccountCall(String accountGuid, String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/accounts/{account_guid}/account_numbers"
            .replace("{" + "account_guid" + "}", localVarApiClient.escapeString(accountGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listAccountNumbersByAccountValidateBeforeCall(String accountGuid, String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountGuid' is set
        if (accountGuid == null) {
            throw new ApiException("Missing the required parameter 'accountGuid' when calling listAccountNumbersByAccount(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listAccountNumbersByAccount(Async)");
        }

        return listAccountNumbersByAccountCall(accountGuid, userGuid, page, recordsPerPage, _callback);

    }

    /**
     * List account numbers by account
     * This endpoint returns a list of account numbers associated with the specified &#x60;account&#x60;.
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return AccountNumbersResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public AccountNumbersResponseBody listAccountNumbersByAccount(String accountGuid, String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<AccountNumbersResponseBody> localVarResp = listAccountNumbersByAccountWithHttpInfo(accountGuid, userGuid, page, recordsPerPage);
        return localVarResp.getData();
    }

    /**
     * List account numbers by account
     * This endpoint returns a list of account numbers associated with the specified &#x60;account&#x60;.
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return ApiResponse&lt;AccountNumbersResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AccountNumbersResponseBody> listAccountNumbersByAccountWithHttpInfo(String accountGuid, String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        okhttp3.Call localVarCall = listAccountNumbersByAccountValidateBeforeCall(accountGuid, userGuid, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<AccountNumbersResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List account numbers by account (asynchronously)
     * This endpoint returns a list of account numbers associated with the specified &#x60;account&#x60;.
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listAccountNumbersByAccountAsync(String accountGuid, String userGuid, Integer page, Integer recordsPerPage, final ApiCallback<AccountNumbersResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listAccountNumbersByAccountValidateBeforeCall(accountGuid, userGuid, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<AccountNumbersResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listAccountNumbersByMember
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listAccountNumbersByMemberCall(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/members/{member_guid}/account_numbers"
            .replace("{" + "member_guid" + "}", localVarApiClient.escapeString(memberGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listAccountNumbersByMemberValidateBeforeCall(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling listAccountNumbersByMember(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listAccountNumbersByMember(Async)");
        }

        return listAccountNumbersByMemberCall(memberGuid, userGuid, page, recordsPerPage, _callback);

    }

    /**
     * List account numbers by member
     * This endpoint returns a list of account numbers associated with the specified &#x60;member&#x60;.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return AccountNumbersResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public AccountNumbersResponseBody listAccountNumbersByMember(String memberGuid, String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<AccountNumbersResponseBody> localVarResp = listAccountNumbersByMemberWithHttpInfo(memberGuid, userGuid, page, recordsPerPage);
        return localVarResp.getData();
    }

    /**
     * List account numbers by member
     * This endpoint returns a list of account numbers associated with the specified &#x60;member&#x60;.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return ApiResponse&lt;AccountNumbersResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AccountNumbersResponseBody> listAccountNumbersByMemberWithHttpInfo(String memberGuid, String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        okhttp3.Call localVarCall = listAccountNumbersByMemberValidateBeforeCall(memberGuid, userGuid, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<AccountNumbersResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List account numbers by member (asynchronously)
     * This endpoint returns a list of account numbers associated with the specified &#x60;member&#x60;.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listAccountNumbersByMemberAsync(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, final ApiCallback<AccountNumbersResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listAccountNumbersByMemberValidateBeforeCall(memberGuid, userGuid, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<AccountNumbersResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listAccountOwnersByMember
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listAccountOwnersByMemberCall(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/members/{member_guid}/account_owners"
            .replace("{" + "member_guid" + "}", localVarApiClient.escapeString(memberGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listAccountOwnersByMemberValidateBeforeCall(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling listAccountOwnersByMember(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listAccountOwnersByMember(Async)");
        }

        return listAccountOwnersByMemberCall(memberGuid, userGuid, page, recordsPerPage, _callback);

    }

    /**
     * List account owners by member
     * This endpoint returns an array with information about every account associated with a particular member.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return AccountOwnersResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public AccountOwnersResponseBody listAccountOwnersByMember(String memberGuid, String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<AccountOwnersResponseBody> localVarResp = listAccountOwnersByMemberWithHttpInfo(memberGuid, userGuid, page, recordsPerPage);
        return localVarResp.getData();
    }

    /**
     * List account owners by member
     * This endpoint returns an array with information about every account associated with a particular member.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return ApiResponse&lt;AccountOwnersResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AccountOwnersResponseBody> listAccountOwnersByMemberWithHttpInfo(String memberGuid, String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        okhttp3.Call localVarCall = listAccountOwnersByMemberValidateBeforeCall(memberGuid, userGuid, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<AccountOwnersResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List account owners by member (asynchronously)
     * This endpoint returns an array with information about every account associated with a particular member.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listAccountOwnersByMemberAsync(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, final ApiCallback<AccountOwnersResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listAccountOwnersByMemberValidateBeforeCall(memberGuid, userGuid, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<AccountOwnersResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listCategories
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listCategoriesCall(String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/categories"
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listCategoriesValidateBeforeCall(String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listCategories(Async)");
        }

        return listCategoriesCall(userGuid, page, recordsPerPage, _callback);

    }

    /**
     * List categories
     * Use this endpoint to list all categories associated with a &#x60;user&#x60;, including both default and custom categories.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return CategoriesResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public CategoriesResponseBody listCategories(String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<CategoriesResponseBody> localVarResp = listCategoriesWithHttpInfo(userGuid, page, recordsPerPage);
        return localVarResp.getData();
    }

    /**
     * List categories
     * Use this endpoint to list all categories associated with a &#x60;user&#x60;, including both default and custom categories.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return ApiResponse&lt;CategoriesResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CategoriesResponseBody> listCategoriesWithHttpInfo(String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        okhttp3.Call localVarCall = listCategoriesValidateBeforeCall(userGuid, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<CategoriesResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List categories (asynchronously)
     * Use this endpoint to list all categories associated with a &#x60;user&#x60;, including both default and custom categories.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listCategoriesAsync(String userGuid, Integer page, Integer recordsPerPage, final ApiCallback<CategoriesResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listCategoriesValidateBeforeCall(userGuid, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<CategoriesResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listDefaultCategories
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listDefaultCategoriesCall(Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/categories/default";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listDefaultCategoriesValidateBeforeCall(Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        return listDefaultCategoriesCall(page, recordsPerPage, _callback);

    }

    /**
     * List default categories
     * Use this endpoint to retrieve a list of all the default categories and subcategories offered within the MX Platform API. In other words, each item in the returned list will have its &#x60;is_default&#x60; field set to &#x60;true&#x60;. There are currently 119 default categories and subcategories. Both the _list default categories_ and _list default categories by user_ endpoints return the same results. The different routes are provided for convenience.
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return CategoriesResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public CategoriesResponseBody listDefaultCategories(Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<CategoriesResponseBody> localVarResp = listDefaultCategoriesWithHttpInfo(page, recordsPerPage);
        return localVarResp.getData();
    }

    /**
     * List default categories
     * Use this endpoint to retrieve a list of all the default categories and subcategories offered within the MX Platform API. In other words, each item in the returned list will have its &#x60;is_default&#x60; field set to &#x60;true&#x60;. There are currently 119 default categories and subcategories. Both the _list default categories_ and _list default categories by user_ endpoints return the same results. The different routes are provided for convenience.
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return ApiResponse&lt;CategoriesResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CategoriesResponseBody> listDefaultCategoriesWithHttpInfo(Integer page, Integer recordsPerPage) throws ApiException {
        okhttp3.Call localVarCall = listDefaultCategoriesValidateBeforeCall(page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<CategoriesResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List default categories (asynchronously)
     * Use this endpoint to retrieve a list of all the default categories and subcategories offered within the MX Platform API. In other words, each item in the returned list will have its &#x60;is_default&#x60; field set to &#x60;true&#x60;. There are currently 119 default categories and subcategories. Both the _list default categories_ and _list default categories by user_ endpoints return the same results. The different routes are provided for convenience.
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listDefaultCategoriesAsync(Integer page, Integer recordsPerPage, final ApiCallback<CategoriesResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listDefaultCategoriesValidateBeforeCall(page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<CategoriesResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listDefaultCategoriesByUser
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listDefaultCategoriesByUserCall(String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/categories/default"
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listDefaultCategoriesByUserValidateBeforeCall(String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listDefaultCategoriesByUser(Async)");
        }

        return listDefaultCategoriesByUserCall(userGuid, page, recordsPerPage, _callback);

    }

    /**
     * List default categories by user
     * Use this endpoint to retrieve a list of all the default categories and subcategories, scoped by user, offered within the MX Platform API. In other words, each item in the returned list will have its &#x60;is_default&#x60; field set to &#x60;true&#x60;. There are currently 119 default categories and subcategories. Both the _list default categories_ and _list default categories by user_ endpoints return the same results. The different routes are provided for convenience.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return CategoriesResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public CategoriesResponseBody listDefaultCategoriesByUser(String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<CategoriesResponseBody> localVarResp = listDefaultCategoriesByUserWithHttpInfo(userGuid, page, recordsPerPage);
        return localVarResp.getData();
    }

    /**
     * List default categories by user
     * Use this endpoint to retrieve a list of all the default categories and subcategories, scoped by user, offered within the MX Platform API. In other words, each item in the returned list will have its &#x60;is_default&#x60; field set to &#x60;true&#x60;. There are currently 119 default categories and subcategories. Both the _list default categories_ and _list default categories by user_ endpoints return the same results. The different routes are provided for convenience.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return ApiResponse&lt;CategoriesResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CategoriesResponseBody> listDefaultCategoriesByUserWithHttpInfo(String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        okhttp3.Call localVarCall = listDefaultCategoriesByUserValidateBeforeCall(userGuid, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<CategoriesResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List default categories by user (asynchronously)
     * Use this endpoint to retrieve a list of all the default categories and subcategories, scoped by user, offered within the MX Platform API. In other words, each item in the returned list will have its &#x60;is_default&#x60; field set to &#x60;true&#x60;. There are currently 119 default categories and subcategories. Both the _list default categories_ and _list default categories by user_ endpoints return the same results. The different routes are provided for convenience.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listDefaultCategoriesByUserAsync(String userGuid, Integer page, Integer recordsPerPage, final ApiCallback<CategoriesResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listDefaultCategoriesByUserValidateBeforeCall(userGuid, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<CategoriesResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listFavoriteInstitutions
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listFavoriteInstitutionsCall(Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/institutions/favorites";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listFavoriteInstitutionsValidateBeforeCall(Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        return listFavoriteInstitutionsCall(page, recordsPerPage, _callback);

    }

    /**
     * List favorite institutions
     * This endpoint returns a paginated list containing institutions that have been set as the partner’s favorites, sorted by popularity. Please contact MX to set a list of favorites.
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return InstitutionsResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public InstitutionsResponseBody listFavoriteInstitutions(Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<InstitutionsResponseBody> localVarResp = listFavoriteInstitutionsWithHttpInfo(page, recordsPerPage);
        return localVarResp.getData();
    }

    /**
     * List favorite institutions
     * This endpoint returns a paginated list containing institutions that have been set as the partner’s favorites, sorted by popularity. Please contact MX to set a list of favorites.
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return ApiResponse&lt;InstitutionsResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<InstitutionsResponseBody> listFavoriteInstitutionsWithHttpInfo(Integer page, Integer recordsPerPage) throws ApiException {
        okhttp3.Call localVarCall = listFavoriteInstitutionsValidateBeforeCall(page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<InstitutionsResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List favorite institutions (asynchronously)
     * This endpoint returns a paginated list containing institutions that have been set as the partner’s favorites, sorted by popularity. Please contact MX to set a list of favorites.
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listFavoriteInstitutionsAsync(Integer page, Integer recordsPerPage, final ApiCallback<InstitutionsResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listFavoriteInstitutionsValidateBeforeCall(page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<InstitutionsResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listHoldings
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param fromDate Filter holdings from this date. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param toDate Filter holdings to this date. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listHoldingsCall(String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/holdings"
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (fromDate != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("from_date", fromDate));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        if (toDate != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("to_date", toDate));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listHoldingsValidateBeforeCall(String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listHoldings(Async)");
        }

        return listHoldingsCall(userGuid, fromDate, page, recordsPerPage, toDate, _callback);

    }

    /**
     * List holdings
     * This endpoint returns all holdings associated with the specified &#x60;user&#x60; across all accounts and members.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param fromDate Filter holdings from this date. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param toDate Filter holdings to this date. (optional)
     * @return HoldingsResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public HoldingsResponseBody listHoldings(String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate) throws ApiException {
        ApiResponse<HoldingsResponseBody> localVarResp = listHoldingsWithHttpInfo(userGuid, fromDate, page, recordsPerPage, toDate);
        return localVarResp.getData();
    }

    /**
     * List holdings
     * This endpoint returns all holdings associated with the specified &#x60;user&#x60; across all accounts and members.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param fromDate Filter holdings from this date. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param toDate Filter holdings to this date. (optional)
     * @return ApiResponse&lt;HoldingsResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<HoldingsResponseBody> listHoldingsWithHttpInfo(String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate) throws ApiException {
        okhttp3.Call localVarCall = listHoldingsValidateBeforeCall(userGuid, fromDate, page, recordsPerPage, toDate, null);
        Type localVarReturnType = new TypeToken<HoldingsResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List holdings (asynchronously)
     * This endpoint returns all holdings associated with the specified &#x60;user&#x60; across all accounts and members.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param fromDate Filter holdings from this date. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param toDate Filter holdings to this date. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listHoldingsAsync(String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate, final ApiCallback<HoldingsResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listHoldingsValidateBeforeCall(userGuid, fromDate, page, recordsPerPage, toDate, _callback);
        Type localVarReturnType = new TypeToken<HoldingsResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listHoldingsByAccount
     * @param accountGuid The unique id for the &#x60;account&#x60;. (required)
     * @param userGuid The unique id for the &#x60;user&#x60;. (required)
     * @param fromDate Filter holdings from this date. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param toDate Filter holdings to this date. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listHoldingsByAccountCall(String accountGuid, String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/accounts/{account_guid}/holdings"
            .replace("{" + "account_guid" + "}", localVarApiClient.escapeString(accountGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (fromDate != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("from_date", fromDate));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        if (toDate != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("to_date", toDate));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listHoldingsByAccountValidateBeforeCall(String accountGuid, String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountGuid' is set
        if (accountGuid == null) {
            throw new ApiException("Missing the required parameter 'accountGuid' when calling listHoldingsByAccount(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listHoldingsByAccount(Async)");
        }

        return listHoldingsByAccountCall(accountGuid, userGuid, fromDate, page, recordsPerPage, toDate, _callback);

    }

    /**
     * List holdings by account
     * This endpoint returns all holdings associated with the specified &#x60;account&#x60;.
     * @param accountGuid The unique id for the &#x60;account&#x60;. (required)
     * @param userGuid The unique id for the &#x60;user&#x60;. (required)
     * @param fromDate Filter holdings from this date. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param toDate Filter holdings to this date. (optional)
     * @return HoldingsResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public HoldingsResponseBody listHoldingsByAccount(String accountGuid, String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate) throws ApiException {
        ApiResponse<HoldingsResponseBody> localVarResp = listHoldingsByAccountWithHttpInfo(accountGuid, userGuid, fromDate, page, recordsPerPage, toDate);
        return localVarResp.getData();
    }

    /**
     * List holdings by account
     * This endpoint returns all holdings associated with the specified &#x60;account&#x60;.
     * @param accountGuid The unique id for the &#x60;account&#x60;. (required)
     * @param userGuid The unique id for the &#x60;user&#x60;. (required)
     * @param fromDate Filter holdings from this date. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param toDate Filter holdings to this date. (optional)
     * @return ApiResponse&lt;HoldingsResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<HoldingsResponseBody> listHoldingsByAccountWithHttpInfo(String accountGuid, String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate) throws ApiException {
        okhttp3.Call localVarCall = listHoldingsByAccountValidateBeforeCall(accountGuid, userGuid, fromDate, page, recordsPerPage, toDate, null);
        Type localVarReturnType = new TypeToken<HoldingsResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List holdings by account (asynchronously)
     * This endpoint returns all holdings associated with the specified &#x60;account&#x60;.
     * @param accountGuid The unique id for the &#x60;account&#x60;. (required)
     * @param userGuid The unique id for the &#x60;user&#x60;. (required)
     * @param fromDate Filter holdings from this date. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param toDate Filter holdings to this date. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listHoldingsByAccountAsync(String accountGuid, String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate, final ApiCallback<HoldingsResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listHoldingsByAccountValidateBeforeCall(accountGuid, userGuid, fromDate, page, recordsPerPage, toDate, _callback);
        Type localVarReturnType = new TypeToken<HoldingsResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listHoldingsByMember
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param fromDate Filter holdings from this date. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param toDate Filter holdings to this date. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listHoldingsByMemberCall(String memberGuid, String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/members/{member_guid}/holdings"
            .replace("{" + "member_guid" + "}", localVarApiClient.escapeString(memberGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (fromDate != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("from_date", fromDate));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        if (toDate != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("to_date", toDate));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listHoldingsByMemberValidateBeforeCall(String memberGuid, String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling listHoldingsByMember(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listHoldingsByMember(Async)");
        }

        return listHoldingsByMemberCall(memberGuid, userGuid, fromDate, page, recordsPerPage, toDate, _callback);

    }

    /**
     * List holdings by member
     * This endpoint returns all holdings associated with the specified &#x60;member&#x60; across all accounts.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param fromDate Filter holdings from this date. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param toDate Filter holdings to this date. (optional)
     * @return HoldingsResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public HoldingsResponseBody listHoldingsByMember(String memberGuid, String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate) throws ApiException {
        ApiResponse<HoldingsResponseBody> localVarResp = listHoldingsByMemberWithHttpInfo(memberGuid, userGuid, fromDate, page, recordsPerPage, toDate);
        return localVarResp.getData();
    }

    /**
     * List holdings by member
     * This endpoint returns all holdings associated with the specified &#x60;member&#x60; across all accounts.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param fromDate Filter holdings from this date. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param toDate Filter holdings to this date. (optional)
     * @return ApiResponse&lt;HoldingsResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<HoldingsResponseBody> listHoldingsByMemberWithHttpInfo(String memberGuid, String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate) throws ApiException {
        okhttp3.Call localVarCall = listHoldingsByMemberValidateBeforeCall(memberGuid, userGuid, fromDate, page, recordsPerPage, toDate, null);
        Type localVarReturnType = new TypeToken<HoldingsResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List holdings by member (asynchronously)
     * This endpoint returns all holdings associated with the specified &#x60;member&#x60; across all accounts.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param fromDate Filter holdings from this date. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param toDate Filter holdings to this date. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listHoldingsByMemberAsync(String memberGuid, String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate, final ApiCallback<HoldingsResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listHoldingsByMemberValidateBeforeCall(memberGuid, userGuid, fromDate, page, recordsPerPage, toDate, _callback);
        Type localVarReturnType = new TypeToken<HoldingsResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listInstitutionCredentials
     * @param institutionCode The institution_code of the institution. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listInstitutionCredentialsCall(String institutionCode, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/institutions/{institution_code}/credentials"
            .replace("{" + "institution_code" + "}", localVarApiClient.escapeString(institutionCode.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listInstitutionCredentialsValidateBeforeCall(String institutionCode, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'institutionCode' is set
        if (institutionCode == null) {
            throw new ApiException("Missing the required parameter 'institutionCode' when calling listInstitutionCredentials(Async)");
        }

        return listInstitutionCredentialsCall(institutionCode, page, recordsPerPage, _callback);

    }

    /**
     * List institution credentials
     * Use this endpoint to see which credentials will be needed to create a member for a specific institution.
     * @param institutionCode The institution_code of the institution. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return CredentialsResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public CredentialsResponseBody listInstitutionCredentials(String institutionCode, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<CredentialsResponseBody> localVarResp = listInstitutionCredentialsWithHttpInfo(institutionCode, page, recordsPerPage);
        return localVarResp.getData();
    }

    /**
     * List institution credentials
     * Use this endpoint to see which credentials will be needed to create a member for a specific institution.
     * @param institutionCode The institution_code of the institution. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return ApiResponse&lt;CredentialsResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CredentialsResponseBody> listInstitutionCredentialsWithHttpInfo(String institutionCode, Integer page, Integer recordsPerPage) throws ApiException {
        okhttp3.Call localVarCall = listInstitutionCredentialsValidateBeforeCall(institutionCode, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<CredentialsResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List institution credentials (asynchronously)
     * Use this endpoint to see which credentials will be needed to create a member for a specific institution.
     * @param institutionCode The institution_code of the institution. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listInstitutionCredentialsAsync(String institutionCode, Integer page, Integer recordsPerPage, final ApiCallback<CredentialsResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listInstitutionCredentialsValidateBeforeCall(institutionCode, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<CredentialsResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listInstitutions
     * @param name This will list only institutions in which the appended string appears. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param supportsAccountIdentification Filter only institutions which support account identification. (optional)
     * @param supportsAccountStatement Filter only institutions which support account statements. (optional)
     * @param supportsAccountVerification Filter only institutions which support account verification. (optional)
     * @param supportsTransactionHistory Filter only institutions which support extended transaction history. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listInstitutionsCall(String name, Integer page, Integer recordsPerPage, Boolean supportsAccountIdentification, Boolean supportsAccountStatement, Boolean supportsAccountVerification, Boolean supportsTransactionHistory, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/institutions";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (name != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("name", name));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        if (supportsAccountIdentification != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("supports_account_identification", supportsAccountIdentification));
        }

        if (supportsAccountStatement != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("supports_account_statement", supportsAccountStatement));
        }

        if (supportsAccountVerification != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("supports_account_verification", supportsAccountVerification));
        }

        if (supportsTransactionHistory != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("supports_transaction_history", supportsTransactionHistory));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listInstitutionsValidateBeforeCall(String name, Integer page, Integer recordsPerPage, Boolean supportsAccountIdentification, Boolean supportsAccountStatement, Boolean supportsAccountVerification, Boolean supportsTransactionHistory, final ApiCallback _callback) throws ApiException {
        return listInstitutionsCall(name, page, recordsPerPage, supportsAccountIdentification, supportsAccountStatement, supportsAccountVerification, supportsTransactionHistory, _callback);

    }

    /**
     * List institutions
     * This endpoint returns a list of institutions based on the specified search term or parameter.
     * @param name This will list only institutions in which the appended string appears. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param supportsAccountIdentification Filter only institutions which support account identification. (optional)
     * @param supportsAccountStatement Filter only institutions which support account statements. (optional)
     * @param supportsAccountVerification Filter only institutions which support account verification. (optional)
     * @param supportsTransactionHistory Filter only institutions which support extended transaction history. (optional)
     * @return InstitutionsResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public InstitutionsResponseBody listInstitutions(String name, Integer page, Integer recordsPerPage, Boolean supportsAccountIdentification, Boolean supportsAccountStatement, Boolean supportsAccountVerification, Boolean supportsTransactionHistory) throws ApiException {
        ApiResponse<InstitutionsResponseBody> localVarResp = listInstitutionsWithHttpInfo(name, page, recordsPerPage, supportsAccountIdentification, supportsAccountStatement, supportsAccountVerification, supportsTransactionHistory);
        return localVarResp.getData();
    }

    /**
     * List institutions
     * This endpoint returns a list of institutions based on the specified search term or parameter.
     * @param name This will list only institutions in which the appended string appears. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param supportsAccountIdentification Filter only institutions which support account identification. (optional)
     * @param supportsAccountStatement Filter only institutions which support account statements. (optional)
     * @param supportsAccountVerification Filter only institutions which support account verification. (optional)
     * @param supportsTransactionHistory Filter only institutions which support extended transaction history. (optional)
     * @return ApiResponse&lt;InstitutionsResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<InstitutionsResponseBody> listInstitutionsWithHttpInfo(String name, Integer page, Integer recordsPerPage, Boolean supportsAccountIdentification, Boolean supportsAccountStatement, Boolean supportsAccountVerification, Boolean supportsTransactionHistory) throws ApiException {
        okhttp3.Call localVarCall = listInstitutionsValidateBeforeCall(name, page, recordsPerPage, supportsAccountIdentification, supportsAccountStatement, supportsAccountVerification, supportsTransactionHistory, null);
        Type localVarReturnType = new TypeToken<InstitutionsResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List institutions (asynchronously)
     * This endpoint returns a list of institutions based on the specified search term or parameter.
     * @param name This will list only institutions in which the appended string appears. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param supportsAccountIdentification Filter only institutions which support account identification. (optional)
     * @param supportsAccountStatement Filter only institutions which support account statements. (optional)
     * @param supportsAccountVerification Filter only institutions which support account verification. (optional)
     * @param supportsTransactionHistory Filter only institutions which support extended transaction history. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listInstitutionsAsync(String name, Integer page, Integer recordsPerPage, Boolean supportsAccountIdentification, Boolean supportsAccountStatement, Boolean supportsAccountVerification, Boolean supportsTransactionHistory, final ApiCallback<InstitutionsResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listInstitutionsValidateBeforeCall(name, page, recordsPerPage, supportsAccountIdentification, supportsAccountStatement, supportsAccountVerification, supportsTransactionHistory, _callback);
        Type localVarReturnType = new TypeToken<InstitutionsResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listManagedAccounts
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listManagedAccountsCall(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/managed_members/{member_guid}/accounts"
            .replace("{" + "member_guid" + "}", localVarApiClient.escapeString(memberGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listManagedAccountsValidateBeforeCall(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling listManagedAccounts(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listManagedAccounts(Async)");
        }

        return listManagedAccountsCall(memberGuid, userGuid, page, recordsPerPage, _callback);

    }

    /**
     * List managed accounts
     * Use this endpoint to retrieve a list of all the partner-managed accounts associated with the given partner-manage member.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return AccountsResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public AccountsResponseBody listManagedAccounts(String memberGuid, String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<AccountsResponseBody> localVarResp = listManagedAccountsWithHttpInfo(memberGuid, userGuid, page, recordsPerPage);
        return localVarResp.getData();
    }

    /**
     * List managed accounts
     * Use this endpoint to retrieve a list of all the partner-managed accounts associated with the given partner-manage member.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return ApiResponse&lt;AccountsResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AccountsResponseBody> listManagedAccountsWithHttpInfo(String memberGuid, String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        okhttp3.Call localVarCall = listManagedAccountsValidateBeforeCall(memberGuid, userGuid, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<AccountsResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List managed accounts (asynchronously)
     * Use this endpoint to retrieve a list of all the partner-managed accounts associated with the given partner-manage member.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listManagedAccountsAsync(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, final ApiCallback<AccountsResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listManagedAccountsValidateBeforeCall(memberGuid, userGuid, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<AccountsResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listManagedInstitutions
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listManagedInstitutionsCall(Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/managed_institutions";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listManagedInstitutionsValidateBeforeCall(Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        return listManagedInstitutionsCall(page, recordsPerPage, _callback);

    }

    /**
     * List managed institutions
     * This endpoint returns a list of institutions which can be used to create partner-managed members.
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return InstitutionsResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public InstitutionsResponseBody listManagedInstitutions(Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<InstitutionsResponseBody> localVarResp = listManagedInstitutionsWithHttpInfo(page, recordsPerPage);
        return localVarResp.getData();
    }

    /**
     * List managed institutions
     * This endpoint returns a list of institutions which can be used to create partner-managed members.
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return ApiResponse&lt;InstitutionsResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<InstitutionsResponseBody> listManagedInstitutionsWithHttpInfo(Integer page, Integer recordsPerPage) throws ApiException {
        okhttp3.Call localVarCall = listManagedInstitutionsValidateBeforeCall(page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<InstitutionsResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List managed institutions (asynchronously)
     * This endpoint returns a list of institutions which can be used to create partner-managed members.
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listManagedInstitutionsAsync(Integer page, Integer recordsPerPage, final ApiCallback<InstitutionsResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listManagedInstitutionsValidateBeforeCall(page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<InstitutionsResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listManagedMembers
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listManagedMembersCall(String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/managed_members"
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listManagedMembersValidateBeforeCall(String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listManagedMembers(Async)");
        }

        return listManagedMembersCall(userGuid, page, recordsPerPage, _callback);

    }

    /**
     * List managed members
     * This endpoint returns a list of all the partner-managed members associated with the specified &#x60;user&#x60;.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return MembersResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public MembersResponseBody listManagedMembers(String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<MembersResponseBody> localVarResp = listManagedMembersWithHttpInfo(userGuid, page, recordsPerPage);
        return localVarResp.getData();
    }

    /**
     * List managed members
     * This endpoint returns a list of all the partner-managed members associated with the specified &#x60;user&#x60;.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return ApiResponse&lt;MembersResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MembersResponseBody> listManagedMembersWithHttpInfo(String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        okhttp3.Call localVarCall = listManagedMembersValidateBeforeCall(userGuid, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<MembersResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List managed members (asynchronously)
     * This endpoint returns a list of all the partner-managed members associated with the specified &#x60;user&#x60;.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listManagedMembersAsync(String userGuid, Integer page, Integer recordsPerPage, final ApiCallback<MembersResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listManagedMembersValidateBeforeCall(userGuid, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<MembersResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listManagedTransactions
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listManagedTransactionsCall(String accountGuid, String memberGuid, String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/managed_members/{member_guid}/accounts/{account_guid}/transactions"
            .replace("{" + "account_guid" + "}", localVarApiClient.escapeString(accountGuid.toString()))
            .replace("{" + "member_guid" + "}", localVarApiClient.escapeString(memberGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listManagedTransactionsValidateBeforeCall(String accountGuid, String memberGuid, String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountGuid' is set
        if (accountGuid == null) {
            throw new ApiException("Missing the required parameter 'accountGuid' when calling listManagedTransactions(Async)");
        }

        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling listManagedTransactions(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listManagedTransactions(Async)");
        }

        return listManagedTransactionsCall(accountGuid, memberGuid, userGuid, page, recordsPerPage, _callback);

    }

    /**
     * List managed transactions
     * This endpoint returns a list of all the partner-managed transactions associated with the specified &#x60;account&#x60;, scoped through a &#x60;user&#x60; and a &#x60;member&#x60;.
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return TransactionsResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public TransactionsResponseBody listManagedTransactions(String accountGuid, String memberGuid, String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<TransactionsResponseBody> localVarResp = listManagedTransactionsWithHttpInfo(accountGuid, memberGuid, userGuid, page, recordsPerPage);
        return localVarResp.getData();
    }

    /**
     * List managed transactions
     * This endpoint returns a list of all the partner-managed transactions associated with the specified &#x60;account&#x60;, scoped through a &#x60;user&#x60; and a &#x60;member&#x60;.
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return ApiResponse&lt;TransactionsResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TransactionsResponseBody> listManagedTransactionsWithHttpInfo(String accountGuid, String memberGuid, String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        okhttp3.Call localVarCall = listManagedTransactionsValidateBeforeCall(accountGuid, memberGuid, userGuid, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<TransactionsResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List managed transactions (asynchronously)
     * This endpoint returns a list of all the partner-managed transactions associated with the specified &#x60;account&#x60;, scoped through a &#x60;user&#x60; and a &#x60;member&#x60;.
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listManagedTransactionsAsync(String accountGuid, String memberGuid, String userGuid, Integer page, Integer recordsPerPage, final ApiCallback<TransactionsResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listManagedTransactionsValidateBeforeCall(accountGuid, memberGuid, userGuid, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<TransactionsResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listMemberAccounts
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param memberIsManagedByUser List only accounts whose member is managed by the user. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listMemberAccountsCall(String userGuid, String memberGuid, Boolean memberIsManagedByUser, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/members/{member_guid}/accounts"
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()))
            .replace("{" + "member_guid" + "}", localVarApiClient.escapeString(memberGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (memberIsManagedByUser != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("member_is_managed_by_user", memberIsManagedByUser));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listMemberAccountsValidateBeforeCall(String userGuid, String memberGuid, Boolean memberIsManagedByUser, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listMemberAccounts(Async)");
        }

        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling listMemberAccounts(Async)");
        }

        return listMemberAccountsCall(userGuid, memberGuid, memberIsManagedByUser, page, recordsPerPage, _callback);

    }

    /**
     * List accounts by member
     * This endpoint returns a list of all the accounts associated with the specified &#x60;member&#x60;.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param memberIsManagedByUser List only accounts whose member is managed by the user. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return AccountsResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public AccountsResponseBody listMemberAccounts(String userGuid, String memberGuid, Boolean memberIsManagedByUser, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<AccountsResponseBody> localVarResp = listMemberAccountsWithHttpInfo(userGuid, memberGuid, memberIsManagedByUser, page, recordsPerPage);
        return localVarResp.getData();
    }

    /**
     * List accounts by member
     * This endpoint returns a list of all the accounts associated with the specified &#x60;member&#x60;.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param memberIsManagedByUser List only accounts whose member is managed by the user. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return ApiResponse&lt;AccountsResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AccountsResponseBody> listMemberAccountsWithHttpInfo(String userGuid, String memberGuid, Boolean memberIsManagedByUser, Integer page, Integer recordsPerPage) throws ApiException {
        okhttp3.Call localVarCall = listMemberAccountsValidateBeforeCall(userGuid, memberGuid, memberIsManagedByUser, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<AccountsResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List accounts by member (asynchronously)
     * This endpoint returns a list of all the accounts associated with the specified &#x60;member&#x60;.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param memberIsManagedByUser List only accounts whose member is managed by the user. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listMemberAccountsAsync(String userGuid, String memberGuid, Boolean memberIsManagedByUser, Integer page, Integer recordsPerPage, final ApiCallback<AccountsResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listMemberAccountsValidateBeforeCall(userGuid, memberGuid, memberIsManagedByUser, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<AccountsResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listMemberChallenges
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listMemberChallengesCall(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/members/{member_guid}/challenges"
            .replace("{" + "member_guid" + "}", localVarApiClient.escapeString(memberGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listMemberChallengesValidateBeforeCall(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling listMemberChallenges(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listMemberChallenges(Async)");
        }

        return listMemberChallengesCall(memberGuid, userGuid, page, recordsPerPage, _callback);

    }

    /**
     * List member challenges
     * Use this endpoint for information on what multi-factor authentication challenges need to be answered in order to aggregate a member. If the aggregation is not challenged, i.e., the member does not have a connection status of &#x60;CHALLENGED&#x60;, then code &#x60;204 No Content&#x60; will be returned. If the aggregation has been challenged, i.e., the member does have a connection status of &#x60;CHALLENGED&#x60;, then code &#x60;200 OK&#x60; will be returned - along with the corresponding credentials.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return ChallengesResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ChallengesResponseBody listMemberChallenges(String memberGuid, String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<ChallengesResponseBody> localVarResp = listMemberChallengesWithHttpInfo(memberGuid, userGuid, page, recordsPerPage);
        return localVarResp.getData();
    }

    /**
     * List member challenges
     * Use this endpoint for information on what multi-factor authentication challenges need to be answered in order to aggregate a member. If the aggregation is not challenged, i.e., the member does not have a connection status of &#x60;CHALLENGED&#x60;, then code &#x60;204 No Content&#x60; will be returned. If the aggregation has been challenged, i.e., the member does have a connection status of &#x60;CHALLENGED&#x60;, then code &#x60;200 OK&#x60; will be returned - along with the corresponding credentials.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return ApiResponse&lt;ChallengesResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ChallengesResponseBody> listMemberChallengesWithHttpInfo(String memberGuid, String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        okhttp3.Call localVarCall = listMemberChallengesValidateBeforeCall(memberGuid, userGuid, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<ChallengesResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List member challenges (asynchronously)
     * Use this endpoint for information on what multi-factor authentication challenges need to be answered in order to aggregate a member. If the aggregation is not challenged, i.e., the member does not have a connection status of &#x60;CHALLENGED&#x60;, then code &#x60;204 No Content&#x60; will be returned. If the aggregation has been challenged, i.e., the member does have a connection status of &#x60;CHALLENGED&#x60;, then code &#x60;200 OK&#x60; will be returned - along with the corresponding credentials.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listMemberChallengesAsync(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, final ApiCallback<ChallengesResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listMemberChallengesValidateBeforeCall(memberGuid, userGuid, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<ChallengesResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listMemberCredentials
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listMemberCredentialsCall(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/members/{member_guid}/credentials"
            .replace("{" + "member_guid" + "}", localVarApiClient.escapeString(memberGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listMemberCredentialsValidateBeforeCall(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling listMemberCredentials(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listMemberCredentials(Async)");
        }

        return listMemberCredentialsCall(memberGuid, userGuid, page, recordsPerPage, _callback);

    }

    /**
     * List member credentials
     * This endpoint returns an array which contains information on every non-MFA credential associated with a specific member.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return CredentialsResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public CredentialsResponseBody listMemberCredentials(String memberGuid, String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<CredentialsResponseBody> localVarResp = listMemberCredentialsWithHttpInfo(memberGuid, userGuid, page, recordsPerPage);
        return localVarResp.getData();
    }

    /**
     * List member credentials
     * This endpoint returns an array which contains information on every non-MFA credential associated with a specific member.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return ApiResponse&lt;CredentialsResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CredentialsResponseBody> listMemberCredentialsWithHttpInfo(String memberGuid, String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        okhttp3.Call localVarCall = listMemberCredentialsValidateBeforeCall(memberGuid, userGuid, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<CredentialsResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List member credentials (asynchronously)
     * This endpoint returns an array which contains information on every non-MFA credential associated with a specific member.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listMemberCredentialsAsync(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, final ApiCallback<CredentialsResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listMemberCredentialsValidateBeforeCall(memberGuid, userGuid, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<CredentialsResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listMembers
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listMembersCall(String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/members"
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listMembersValidateBeforeCall(String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listMembers(Async)");
        }

        return listMembersCall(userGuid, page, recordsPerPage, _callback);

    }

    /**
     * List members
     * This endpoint returns an array which contains information on every member associated with a specific user.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return MembersResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public MembersResponseBody listMembers(String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<MembersResponseBody> localVarResp = listMembersWithHttpInfo(userGuid, page, recordsPerPage);
        return localVarResp.getData();
    }

    /**
     * List members
     * This endpoint returns an array which contains information on every member associated with a specific user.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return ApiResponse&lt;MembersResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MembersResponseBody> listMembersWithHttpInfo(String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        okhttp3.Call localVarCall = listMembersValidateBeforeCall(userGuid, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<MembersResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List members (asynchronously)
     * This endpoint returns an array which contains information on every member associated with a specific user.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listMembersAsync(String userGuid, Integer page, Integer recordsPerPage, final ApiCallback<MembersResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listMembersValidateBeforeCall(userGuid, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<MembersResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listMerchants
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listMerchantsCall(Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/merchants";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listMerchantsValidateBeforeCall(Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        return listMerchantsCall(page, recordsPerPage, _callback);

    }

    /**
     * List merchants
     * This endpoint returns a paginated list of all the merchants in the MX system.
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return MerchantsResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public MerchantsResponseBody listMerchants(Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<MerchantsResponseBody> localVarResp = listMerchantsWithHttpInfo(page, recordsPerPage);
        return localVarResp.getData();
    }

    /**
     * List merchants
     * This endpoint returns a paginated list of all the merchants in the MX system.
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return ApiResponse&lt;MerchantsResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MerchantsResponseBody> listMerchantsWithHttpInfo(Integer page, Integer recordsPerPage) throws ApiException {
        okhttp3.Call localVarCall = listMerchantsValidateBeforeCall(page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<MerchantsResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List merchants (asynchronously)
     * This endpoint returns a paginated list of all the merchants in the MX system.
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listMerchantsAsync(Integer page, Integer recordsPerPage, final ApiCallback<MerchantsResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listMerchantsValidateBeforeCall(page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<MerchantsResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listRewards
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberGuid The unique identifier for the member. Defined by MX. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listRewardsCall(String userGuid, String memberGuid, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/members/{member_guid}/rewards"
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()))
            .replace("{" + "member_guid" + "}", localVarApiClient.escapeString(memberGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listRewardsValidateBeforeCall(String userGuid, String memberGuid, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listRewards(Async)");
        }

        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling listRewards(Async)");
        }

        return listRewardsCall(userGuid, memberGuid, _callback);

    }

    /**
     * List Rewards
     * Use this endpoint to list all the &#x60;rewards&#x60; associated with a specified &#x60;member&#x60;.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberGuid The unique identifier for the member. Defined by MX. (required)
     * @return RewardsResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public RewardsResponseBody listRewards(String userGuid, String memberGuid) throws ApiException {
        ApiResponse<RewardsResponseBody> localVarResp = listRewardsWithHttpInfo(userGuid, memberGuid);
        return localVarResp.getData();
    }

    /**
     * List Rewards
     * Use this endpoint to list all the &#x60;rewards&#x60; associated with a specified &#x60;member&#x60;.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberGuid The unique identifier for the member. Defined by MX. (required)
     * @return ApiResponse&lt;RewardsResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<RewardsResponseBody> listRewardsWithHttpInfo(String userGuid, String memberGuid) throws ApiException {
        okhttp3.Call localVarCall = listRewardsValidateBeforeCall(userGuid, memberGuid, null);
        Type localVarReturnType = new TypeToken<RewardsResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List Rewards (asynchronously)
     * Use this endpoint to list all the &#x60;rewards&#x60; associated with a specified &#x60;member&#x60;.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberGuid The unique identifier for the member. Defined by MX. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listRewardsAsync(String userGuid, String memberGuid, final ApiCallback<RewardsResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listRewardsValidateBeforeCall(userGuid, memberGuid, _callback);
        Type localVarReturnType = new TypeToken<RewardsResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listStatementsByMember
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listStatementsByMemberCall(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/members/{member_guid}/statements"
            .replace("{" + "member_guid" + "}", localVarApiClient.escapeString(memberGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listStatementsByMemberValidateBeforeCall(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling listStatementsByMember(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listStatementsByMember(Async)");
        }

        return listStatementsByMemberCall(memberGuid, userGuid, page, recordsPerPage, _callback);

    }

    /**
     * List statements by member
     * Use this endpoint to get an array of available statements.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return StatementsResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public StatementsResponseBody listStatementsByMember(String memberGuid, String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<StatementsResponseBody> localVarResp = listStatementsByMemberWithHttpInfo(memberGuid, userGuid, page, recordsPerPage);
        return localVarResp.getData();
    }

    /**
     * List statements by member
     * Use this endpoint to get an array of available statements.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return ApiResponse&lt;StatementsResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<StatementsResponseBody> listStatementsByMemberWithHttpInfo(String memberGuid, String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        okhttp3.Call localVarCall = listStatementsByMemberValidateBeforeCall(memberGuid, userGuid, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<StatementsResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List statements by member (asynchronously)
     * Use this endpoint to get an array of available statements.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listStatementsByMemberAsync(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, final ApiCallback<StatementsResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listStatementsByMemberValidateBeforeCall(memberGuid, userGuid, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<StatementsResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listTaggings
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listTaggingsCall(String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/taggings"
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listTaggingsValidateBeforeCall(String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listTaggings(Async)");
        }

        return listTaggingsCall(userGuid, page, recordsPerPage, _callback);

    }

    /**
     * List taggings
     * Use this endpoint to retrieve a list of all the taggings associated with a specific user.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return TaggingsResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public TaggingsResponseBody listTaggings(String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<TaggingsResponseBody> localVarResp = listTaggingsWithHttpInfo(userGuid, page, recordsPerPage);
        return localVarResp.getData();
    }

    /**
     * List taggings
     * Use this endpoint to retrieve a list of all the taggings associated with a specific user.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return ApiResponse&lt;TaggingsResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TaggingsResponseBody> listTaggingsWithHttpInfo(String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        okhttp3.Call localVarCall = listTaggingsValidateBeforeCall(userGuid, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<TaggingsResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List taggings (asynchronously)
     * Use this endpoint to retrieve a list of all the taggings associated with a specific user.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listTaggingsAsync(String userGuid, Integer page, Integer recordsPerPage, final ApiCallback<TaggingsResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listTaggingsValidateBeforeCall(userGuid, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<TaggingsResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listTags
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listTagsCall(String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/tags"
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listTagsValidateBeforeCall(String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listTags(Async)");
        }

        return listTagsCall(userGuid, page, recordsPerPage, _callback);

    }

    /**
     * List tags
     * Use this endpoint to list all tags associated with the specified &#x60;user&#x60;. Each user includes the &#x60;Business&#x60; tag by default.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return TagsResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public TagsResponseBody listTags(String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<TagsResponseBody> localVarResp = listTagsWithHttpInfo(userGuid, page, recordsPerPage);
        return localVarResp.getData();
    }

    /**
     * List tags
     * Use this endpoint to list all tags associated with the specified &#x60;user&#x60;. Each user includes the &#x60;Business&#x60; tag by default.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return ApiResponse&lt;TagsResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TagsResponseBody> listTagsWithHttpInfo(String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        okhttp3.Call localVarCall = listTagsValidateBeforeCall(userGuid, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<TagsResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List tags (asynchronously)
     * Use this endpoint to list all tags associated with the specified &#x60;user&#x60;. Each user includes the &#x60;Business&#x60; tag by default.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listTagsAsync(String userGuid, Integer page, Integer recordsPerPage, final ApiCallback<TagsResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listTagsValidateBeforeCall(userGuid, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<TagsResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listTaxDocuments
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listTaxDocumentsCall(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/members/{member_guid}/tax_documents"
            .replace("{" + "member_guid" + "}", localVarApiClient.escapeString(memberGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listTaxDocumentsValidateBeforeCall(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling listTaxDocuments(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listTaxDocuments(Async)");
        }

        return listTaxDocumentsCall(memberGuid, userGuid, page, recordsPerPage, _callback);

    }

    /**
     * List Tax Documents
     * Use this endpoint to get a paginated list of tax documents.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return TaxDocumentsResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public TaxDocumentsResponseBody listTaxDocuments(String memberGuid, String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<TaxDocumentsResponseBody> localVarResp = listTaxDocumentsWithHttpInfo(memberGuid, userGuid, page, recordsPerPage);
        return localVarResp.getData();
    }

    /**
     * List Tax Documents
     * Use this endpoint to get a paginated list of tax documents.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return ApiResponse&lt;TaxDocumentsResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TaxDocumentsResponseBody> listTaxDocumentsWithHttpInfo(String memberGuid, String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        okhttp3.Call localVarCall = listTaxDocumentsValidateBeforeCall(memberGuid, userGuid, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<TaxDocumentsResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List Tax Documents (asynchronously)
     * Use this endpoint to get a paginated list of tax documents.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listTaxDocumentsAsync(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, final ApiCallback<TaxDocumentsResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listTaxDocumentsValidateBeforeCall(memberGuid, userGuid, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<TaxDocumentsResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listTransactionRules
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listTransactionRulesCall(String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/transaction_rules"
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listTransactionRulesValidateBeforeCall(String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listTransactionRules(Async)");
        }

        return listTransactionRulesCall(userGuid, page, recordsPerPage, _callback);

    }

    /**
     * List transaction rules
     * Use this endpoint to read the attributes of all existing transaction rules belonging to the user.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return TransactionRulesResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public TransactionRulesResponseBody listTransactionRules(String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<TransactionRulesResponseBody> localVarResp = listTransactionRulesWithHttpInfo(userGuid, page, recordsPerPage);
        return localVarResp.getData();
    }

    /**
     * List transaction rules
     * Use this endpoint to read the attributes of all existing transaction rules belonging to the user.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return ApiResponse&lt;TransactionRulesResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TransactionRulesResponseBody> listTransactionRulesWithHttpInfo(String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        okhttp3.Call localVarCall = listTransactionRulesValidateBeforeCall(userGuid, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<TransactionRulesResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List transaction rules (asynchronously)
     * Use this endpoint to read the attributes of all existing transaction rules belonging to the user.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listTransactionRulesAsync(String userGuid, Integer page, Integer recordsPerPage, final ApiCallback<TransactionRulesResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listTransactionRulesValidateBeforeCall(userGuid, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<TransactionRulesResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listTransactions
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param fromDate Filter transactions from this date. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param toDate Filter transactions to this date. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listTransactionsCall(String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/transactions"
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (fromDate != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("from_date", fromDate));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        if (toDate != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("to_date", toDate));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listTransactionsValidateBeforeCall(String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listTransactions(Async)");
        }

        return listTransactionsCall(userGuid, fromDate, page, recordsPerPage, toDate, _callback);

    }

    /**
     * List transactions
     * Requests to this endpoint return a list of transactions associated with the specified &#x60;user&#x60;, accross all members and accounts associated with that &#x60;user&#x60;.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param fromDate Filter transactions from this date. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param toDate Filter transactions to this date. (optional)
     * @return TransactionsResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public TransactionsResponseBody listTransactions(String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate) throws ApiException {
        ApiResponse<TransactionsResponseBody> localVarResp = listTransactionsWithHttpInfo(userGuid, fromDate, page, recordsPerPage, toDate);
        return localVarResp.getData();
    }

    /**
     * List transactions
     * Requests to this endpoint return a list of transactions associated with the specified &#x60;user&#x60;, accross all members and accounts associated with that &#x60;user&#x60;.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param fromDate Filter transactions from this date. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param toDate Filter transactions to this date. (optional)
     * @return ApiResponse&lt;TransactionsResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TransactionsResponseBody> listTransactionsWithHttpInfo(String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate) throws ApiException {
        okhttp3.Call localVarCall = listTransactionsValidateBeforeCall(userGuid, fromDate, page, recordsPerPage, toDate, null);
        Type localVarReturnType = new TypeToken<TransactionsResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List transactions (asynchronously)
     * Requests to this endpoint return a list of transactions associated with the specified &#x60;user&#x60;, accross all members and accounts associated with that &#x60;user&#x60;.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param fromDate Filter transactions from this date. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param toDate Filter transactions to this date. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listTransactionsAsync(String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate, final ApiCallback<TransactionsResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listTransactionsValidateBeforeCall(userGuid, fromDate, page, recordsPerPage, toDate, _callback);
        Type localVarReturnType = new TypeToken<TransactionsResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listTransactionsByAccount
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param fromDate Filter transactions from this date. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param toDate Filter transactions to this date. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listTransactionsByAccountCall(String accountGuid, String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/accounts/{account_guid}/transactions"
            .replace("{" + "account_guid" + "}", localVarApiClient.escapeString(accountGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (fromDate != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("from_date", fromDate));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        if (toDate != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("to_date", toDate));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listTransactionsByAccountValidateBeforeCall(String accountGuid, String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountGuid' is set
        if (accountGuid == null) {
            throw new ApiException("Missing the required parameter 'accountGuid' when calling listTransactionsByAccount(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listTransactionsByAccount(Async)");
        }

        return listTransactionsByAccountCall(accountGuid, userGuid, fromDate, page, recordsPerPage, toDate, _callback);

    }

    /**
     * List transactions by account
     * This endpoint returns a list of the last 90 days of transactions associated with the specified account.
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param fromDate Filter transactions from this date. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param toDate Filter transactions to this date. (optional)
     * @return TransactionsResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public TransactionsResponseBody listTransactionsByAccount(String accountGuid, String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate) throws ApiException {
        ApiResponse<TransactionsResponseBody> localVarResp = listTransactionsByAccountWithHttpInfo(accountGuid, userGuid, fromDate, page, recordsPerPage, toDate);
        return localVarResp.getData();
    }

    /**
     * List transactions by account
     * This endpoint returns a list of the last 90 days of transactions associated with the specified account.
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param fromDate Filter transactions from this date. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param toDate Filter transactions to this date. (optional)
     * @return ApiResponse&lt;TransactionsResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TransactionsResponseBody> listTransactionsByAccountWithHttpInfo(String accountGuid, String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate) throws ApiException {
        okhttp3.Call localVarCall = listTransactionsByAccountValidateBeforeCall(accountGuid, userGuid, fromDate, page, recordsPerPage, toDate, null);
        Type localVarReturnType = new TypeToken<TransactionsResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List transactions by account (asynchronously)
     * This endpoint returns a list of the last 90 days of transactions associated with the specified account.
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param fromDate Filter transactions from this date. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param toDate Filter transactions to this date. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listTransactionsByAccountAsync(String accountGuid, String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate, final ApiCallback<TransactionsResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listTransactionsByAccountValidateBeforeCall(accountGuid, userGuid, fromDate, page, recordsPerPage, toDate, _callback);
        Type localVarReturnType = new TypeToken<TransactionsResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listTransactionsByMember
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param fromDate Filter transactions from this date. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param toDate Filter transactions to this date. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listTransactionsByMemberCall(String memberGuid, String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/members/{member_guid}/transactions"
            .replace("{" + "member_guid" + "}", localVarApiClient.escapeString(memberGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (fromDate != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("from_date", fromDate));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        if (toDate != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("to_date", toDate));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listTransactionsByMemberValidateBeforeCall(String memberGuid, String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling listTransactionsByMember(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listTransactionsByMember(Async)");
        }

        return listTransactionsByMemberCall(memberGuid, userGuid, fromDate, page, recordsPerPage, toDate, _callback);

    }

    /**
     * List transactions by member
     * Requests to this endpoint return a list of transactions associated with the specified &#x60;member&#x60;, accross all accounts associated with that &#x60;member&#x60;.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param fromDate Filter transactions from this date. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param toDate Filter transactions to this date. (optional)
     * @return TransactionsResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public TransactionsResponseBody listTransactionsByMember(String memberGuid, String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate) throws ApiException {
        ApiResponse<TransactionsResponseBody> localVarResp = listTransactionsByMemberWithHttpInfo(memberGuid, userGuid, fromDate, page, recordsPerPage, toDate);
        return localVarResp.getData();
    }

    /**
     * List transactions by member
     * Requests to this endpoint return a list of transactions associated with the specified &#x60;member&#x60;, accross all accounts associated with that &#x60;member&#x60;.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param fromDate Filter transactions from this date. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param toDate Filter transactions to this date. (optional)
     * @return ApiResponse&lt;TransactionsResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TransactionsResponseBody> listTransactionsByMemberWithHttpInfo(String memberGuid, String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate) throws ApiException {
        okhttp3.Call localVarCall = listTransactionsByMemberValidateBeforeCall(memberGuid, userGuid, fromDate, page, recordsPerPage, toDate, null);
        Type localVarReturnType = new TypeToken<TransactionsResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List transactions by member (asynchronously)
     * Requests to this endpoint return a list of transactions associated with the specified &#x60;member&#x60;, accross all accounts associated with that &#x60;member&#x60;.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param fromDate Filter transactions from this date. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param toDate Filter transactions to this date. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listTransactionsByMemberAsync(String memberGuid, String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate, final ApiCallback<TransactionsResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listTransactionsByMemberValidateBeforeCall(memberGuid, userGuid, fromDate, page, recordsPerPage, toDate, _callback);
        Type localVarReturnType = new TypeToken<TransactionsResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listTransactionsByTag
     * @param tagGuid The unique id for a &#x60;tag&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param fromDate Filter transactions from this date. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param toDate Filter transactions to this date. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listTransactionsByTagCall(String tagGuid, String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/tags/{tag_guid}/transactions"
            .replace("{" + "tag_guid" + "}", localVarApiClient.escapeString(tagGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (fromDate != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("from_date", fromDate));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        if (toDate != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("to_date", toDate));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listTransactionsByTagValidateBeforeCall(String tagGuid, String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'tagGuid' is set
        if (tagGuid == null) {
            throw new ApiException("Missing the required parameter 'tagGuid' when calling listTransactionsByTag(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listTransactionsByTag(Async)");
        }

        return listTransactionsByTagCall(tagGuid, userGuid, fromDate, page, recordsPerPage, toDate, _callback);

    }

    /**
     * List transactions by tag
     * Use this endpoint to get a list of all transactions associated with a particular tag according to the tag’s unique GUID. In other words, a list of all transactions that have been assigned to a particular tag using the create a tagging endpoint.
     * @param tagGuid The unique id for a &#x60;tag&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param fromDate Filter transactions from this date. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param toDate Filter transactions to this date. (optional)
     * @return TransactionsResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public TransactionsResponseBody listTransactionsByTag(String tagGuid, String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate) throws ApiException {
        ApiResponse<TransactionsResponseBody> localVarResp = listTransactionsByTagWithHttpInfo(tagGuid, userGuid, fromDate, page, recordsPerPage, toDate);
        return localVarResp.getData();
    }

    /**
     * List transactions by tag
     * Use this endpoint to get a list of all transactions associated with a particular tag according to the tag’s unique GUID. In other words, a list of all transactions that have been assigned to a particular tag using the create a tagging endpoint.
     * @param tagGuid The unique id for a &#x60;tag&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param fromDate Filter transactions from this date. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param toDate Filter transactions to this date. (optional)
     * @return ApiResponse&lt;TransactionsResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TransactionsResponseBody> listTransactionsByTagWithHttpInfo(String tagGuid, String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate) throws ApiException {
        okhttp3.Call localVarCall = listTransactionsByTagValidateBeforeCall(tagGuid, userGuid, fromDate, page, recordsPerPage, toDate, null);
        Type localVarReturnType = new TypeToken<TransactionsResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List transactions by tag (asynchronously)
     * Use this endpoint to get a list of all transactions associated with a particular tag according to the tag’s unique GUID. In other words, a list of all transactions that have been assigned to a particular tag using the create a tagging endpoint.
     * @param tagGuid The unique id for a &#x60;tag&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param fromDate Filter transactions from this date. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param toDate Filter transactions to this date. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listTransactionsByTagAsync(String tagGuid, String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate, final ApiCallback<TransactionsResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listTransactionsByTagValidateBeforeCall(tagGuid, userGuid, fromDate, page, recordsPerPage, toDate, _callback);
        Type localVarReturnType = new TypeToken<TransactionsResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listUserAccounts
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberIsManagedByUser List only accounts whose member is managed by the user. (optional)
     * @param page Specify current page. (optional)
     * @param isManual List only accounts that were manually created. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listUserAccountsCall(String userGuid, Boolean memberIsManagedByUser, Integer page, Boolean isManual, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/accounts"
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (memberIsManagedByUser != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("member_is_managed_by_user", memberIsManagedByUser));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (isManual != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("is_manual", isManual));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listUserAccountsValidateBeforeCall(String userGuid, Boolean memberIsManagedByUser, Integer page, Boolean isManual, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listUserAccounts(Async)");
        }

        return listUserAccountsCall(userGuid, memberIsManagedByUser, page, isManual, recordsPerPage, _callback);

    }

    /**
     * List accounts
     * This endpoint returns a list of all the accounts associated with the specified &#x60;user&#x60;.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberIsManagedByUser List only accounts whose member is managed by the user. (optional)
     * @param page Specify current page. (optional)
     * @param isManual List only accounts that were manually created. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return AccountsResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public AccountsResponseBody listUserAccounts(String userGuid, Boolean memberIsManagedByUser, Integer page, Boolean isManual, Integer recordsPerPage) throws ApiException {
        ApiResponse<AccountsResponseBody> localVarResp = listUserAccountsWithHttpInfo(userGuid, memberIsManagedByUser, page, isManual, recordsPerPage);
        return localVarResp.getData();
    }

    /**
     * List accounts
     * This endpoint returns a list of all the accounts associated with the specified &#x60;user&#x60;.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberIsManagedByUser List only accounts whose member is managed by the user. (optional)
     * @param page Specify current page. (optional)
     * @param isManual List only accounts that were manually created. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return ApiResponse&lt;AccountsResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AccountsResponseBody> listUserAccountsWithHttpInfo(String userGuid, Boolean memberIsManagedByUser, Integer page, Boolean isManual, Integer recordsPerPage) throws ApiException {
        okhttp3.Call localVarCall = listUserAccountsValidateBeforeCall(userGuid, memberIsManagedByUser, page, isManual, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<AccountsResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List accounts (asynchronously)
     * This endpoint returns a list of all the accounts associated with the specified &#x60;user&#x60;.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberIsManagedByUser List only accounts whose member is managed by the user. (optional)
     * @param page Specify current page. (optional)
     * @param isManual List only accounts that were manually created. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listUserAccountsAsync(String userGuid, Boolean memberIsManagedByUser, Integer page, Boolean isManual, Integer recordsPerPage, final ApiCallback<AccountsResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listUserAccountsValidateBeforeCall(userGuid, memberIsManagedByUser, page, isManual, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<AccountsResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listUsers
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param id The user &#x60;id&#x60; to search for. (optional)
     * @param email The user &#x60;email&#x60; to search for. (optional)
     * @param isDisabled Search for users that are diabled. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listUsersCall(Integer page, Integer recordsPerPage, String id, String email, Boolean isDisabled, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        if (id != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("id", id));
        }

        if (email != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("email", email));
        }

        if (isDisabled != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("is_disabled", isDisabled));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listUsersValidateBeforeCall(Integer page, Integer recordsPerPage, String id, String email, Boolean isDisabled, final ApiCallback _callback) throws ApiException {
        return listUsersCall(page, recordsPerPage, id, email, isDisabled, _callback);

    }

    /**
     * List users
     * Use this endpoint to list every user you&#39;ve created in the MX Platform API.
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param id The user &#x60;id&#x60; to search for. (optional)
     * @param email The user &#x60;email&#x60; to search for. (optional)
     * @param isDisabled Search for users that are diabled. (optional)
     * @return UsersResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public UsersResponseBody listUsers(Integer page, Integer recordsPerPage, String id, String email, Boolean isDisabled) throws ApiException {
        ApiResponse<UsersResponseBody> localVarResp = listUsersWithHttpInfo(page, recordsPerPage, id, email, isDisabled);
        return localVarResp.getData();
    }

    /**
     * List users
     * Use this endpoint to list every user you&#39;ve created in the MX Platform API.
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param id The user &#x60;id&#x60; to search for. (optional)
     * @param email The user &#x60;email&#x60; to search for. (optional)
     * @param isDisabled Search for users that are diabled. (optional)
     * @return ApiResponse&lt;UsersResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<UsersResponseBody> listUsersWithHttpInfo(Integer page, Integer recordsPerPage, String id, String email, Boolean isDisabled) throws ApiException {
        okhttp3.Call localVarCall = listUsersValidateBeforeCall(page, recordsPerPage, id, email, isDisabled, null);
        Type localVarReturnType = new TypeToken<UsersResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List users (asynchronously)
     * Use this endpoint to list every user you&#39;ve created in the MX Platform API.
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param id The user &#x60;id&#x60; to search for. (optional)
     * @param email The user &#x60;email&#x60; to search for. (optional)
     * @param isDisabled Search for users that are diabled. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listUsersAsync(Integer page, Integer recordsPerPage, String id, String email, Boolean isDisabled, final ApiCallback<UsersResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listUsersValidateBeforeCall(page, recordsPerPage, id, email, isDisabled, _callback);
        Type localVarReturnType = new TypeToken<UsersResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for readAccount
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readAccountCall(String accountGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/accounts/{account_guid}"
            .replace("{" + "account_guid" + "}", localVarApiClient.escapeString(accountGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call readAccountValidateBeforeCall(String accountGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountGuid' is set
        if (accountGuid == null) {
            throw new ApiException("Missing the required parameter 'accountGuid' when calling readAccount(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling readAccount(Async)");
        }

        return readAccountCall(accountGuid, userGuid, _callback);

    }

    /**
     * Read account
     * This endpoint returns the specified &#x60;account&#x60; resource.
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return AccountResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public AccountResponseBody readAccount(String accountGuid, String userGuid) throws ApiException {
        ApiResponse<AccountResponseBody> localVarResp = readAccountWithHttpInfo(accountGuid, userGuid);
        return localVarResp.getData();
    }

    /**
     * Read account
     * This endpoint returns the specified &#x60;account&#x60; resource.
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;AccountResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AccountResponseBody> readAccountWithHttpInfo(String accountGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = readAccountValidateBeforeCall(accountGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<AccountResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Read account (asynchronously)
     * This endpoint returns the specified &#x60;account&#x60; resource.
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readAccountAsync(String accountGuid, String userGuid, final ApiCallback<AccountResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = readAccountValidateBeforeCall(accountGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<AccountResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for readAccountByMember
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readAccountByMemberCall(String accountGuid, String memberGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/members/{member_guid}/accounts/{account_guid}"
            .replace("{" + "account_guid" + "}", localVarApiClient.escapeString(accountGuid.toString()))
            .replace("{" + "member_guid" + "}", localVarApiClient.escapeString(memberGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call readAccountByMemberValidateBeforeCall(String accountGuid, String memberGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountGuid' is set
        if (accountGuid == null) {
            throw new ApiException("Missing the required parameter 'accountGuid' when calling readAccountByMember(Async)");
        }

        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling readAccountByMember(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling readAccountByMember(Async)");
        }

        return readAccountByMemberCall(accountGuid, memberGuid, userGuid, _callback);

    }

    /**
     * Read account by member
     * This endpoint allows you to read the attributes of an &#x60;account&#x60; resource.
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return AccountResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public AccountResponseBody readAccountByMember(String accountGuid, String memberGuid, String userGuid) throws ApiException {
        ApiResponse<AccountResponseBody> localVarResp = readAccountByMemberWithHttpInfo(accountGuid, memberGuid, userGuid);
        return localVarResp.getData();
    }

    /**
     * Read account by member
     * This endpoint allows you to read the attributes of an &#x60;account&#x60; resource.
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;AccountResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AccountResponseBody> readAccountByMemberWithHttpInfo(String accountGuid, String memberGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = readAccountByMemberValidateBeforeCall(accountGuid, memberGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<AccountResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Read account by member (asynchronously)
     * This endpoint allows you to read the attributes of an &#x60;account&#x60; resource.
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readAccountByMemberAsync(String accountGuid, String memberGuid, String userGuid, final ApiCallback<AccountResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = readAccountByMemberValidateBeforeCall(accountGuid, memberGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<AccountResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for readCategory
     * @param categoryGuid The unique id for a &#x60;category&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readCategoryCall(String categoryGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/categories/{category_guid}"
            .replace("{" + "category_guid" + "}", localVarApiClient.escapeString(categoryGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call readCategoryValidateBeforeCall(String categoryGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'categoryGuid' is set
        if (categoryGuid == null) {
            throw new ApiException("Missing the required parameter 'categoryGuid' when calling readCategory(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling readCategory(Async)");
        }

        return readCategoryCall(categoryGuid, userGuid, _callback);

    }

    /**
     * Read a custom category
     * Use this endpoint to read the attributes of either a default category or a custom category.
     * @param categoryGuid The unique id for a &#x60;category&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return CategoryResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public CategoryResponseBody readCategory(String categoryGuid, String userGuid) throws ApiException {
        ApiResponse<CategoryResponseBody> localVarResp = readCategoryWithHttpInfo(categoryGuid, userGuid);
        return localVarResp.getData();
    }

    /**
     * Read a custom category
     * Use this endpoint to read the attributes of either a default category or a custom category.
     * @param categoryGuid The unique id for a &#x60;category&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;CategoryResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CategoryResponseBody> readCategoryWithHttpInfo(String categoryGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = readCategoryValidateBeforeCall(categoryGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<CategoryResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Read a custom category (asynchronously)
     * Use this endpoint to read the attributes of either a default category or a custom category.
     * @param categoryGuid The unique id for a &#x60;category&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readCategoryAsync(String categoryGuid, String userGuid, final ApiCallback<CategoryResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = readCategoryValidateBeforeCall(categoryGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<CategoryResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for readDefaultCategory
     * @param categoryGuid The unique id for a &#x60;category&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readDefaultCategoryCall(String categoryGuid, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/categories/{category_guid}"
            .replace("{" + "category_guid" + "}", localVarApiClient.escapeString(categoryGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call readDefaultCategoryValidateBeforeCall(String categoryGuid, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'categoryGuid' is set
        if (categoryGuid == null) {
            throw new ApiException("Missing the required parameter 'categoryGuid' when calling readDefaultCategory(Async)");
        }

        return readDefaultCategoryCall(categoryGuid, _callback);

    }

    /**
     * Read a default category
     * Use this endpoint to read the attributes of a default category.
     * @param categoryGuid The unique id for a &#x60;category&#x60;. (required)
     * @return CategoryResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public CategoryResponseBody readDefaultCategory(String categoryGuid) throws ApiException {
        ApiResponse<CategoryResponseBody> localVarResp = readDefaultCategoryWithHttpInfo(categoryGuid);
        return localVarResp.getData();
    }

    /**
     * Read a default category
     * Use this endpoint to read the attributes of a default category.
     * @param categoryGuid The unique id for a &#x60;category&#x60;. (required)
     * @return ApiResponse&lt;CategoryResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CategoryResponseBody> readDefaultCategoryWithHttpInfo(String categoryGuid) throws ApiException {
        okhttp3.Call localVarCall = readDefaultCategoryValidateBeforeCall(categoryGuid, null);
        Type localVarReturnType = new TypeToken<CategoryResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Read a default category (asynchronously)
     * Use this endpoint to read the attributes of a default category.
     * @param categoryGuid The unique id for a &#x60;category&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readDefaultCategoryAsync(String categoryGuid, final ApiCallback<CategoryResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = readDefaultCategoryValidateBeforeCall(categoryGuid, _callback);
        Type localVarReturnType = new TypeToken<CategoryResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for readHolding
     * @param holdingGuid The unique id for a &#x60;holding&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readHoldingCall(String holdingGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/holdings/{holding_guid}"
            .replace("{" + "holding_guid" + "}", localVarApiClient.escapeString(holdingGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call readHoldingValidateBeforeCall(String holdingGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'holdingGuid' is set
        if (holdingGuid == null) {
            throw new ApiException("Missing the required parameter 'holdingGuid' when calling readHolding(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling readHolding(Async)");
        }

        return readHoldingCall(holdingGuid, userGuid, _callback);

    }

    /**
     * Read holding
     * Use this endpoint to read the attributes of a specific &#x60;holding&#x60;.
     * @param holdingGuid The unique id for a &#x60;holding&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return HoldingResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public HoldingResponseBody readHolding(String holdingGuid, String userGuid) throws ApiException {
        ApiResponse<HoldingResponseBody> localVarResp = readHoldingWithHttpInfo(holdingGuid, userGuid);
        return localVarResp.getData();
    }

    /**
     * Read holding
     * Use this endpoint to read the attributes of a specific &#x60;holding&#x60;.
     * @param holdingGuid The unique id for a &#x60;holding&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;HoldingResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<HoldingResponseBody> readHoldingWithHttpInfo(String holdingGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = readHoldingValidateBeforeCall(holdingGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<HoldingResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Read holding (asynchronously)
     * Use this endpoint to read the attributes of a specific &#x60;holding&#x60;.
     * @param holdingGuid The unique id for a &#x60;holding&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readHoldingAsync(String holdingGuid, String userGuid, final ApiCallback<HoldingResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = readHoldingValidateBeforeCall(holdingGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<HoldingResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for readInstitution
     * @param institutionCode The institution_code of the institution. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readInstitutionCall(String institutionCode, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/institutions/{institution_code}"
            .replace("{" + "institution_code" + "}", localVarApiClient.escapeString(institutionCode.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call readInstitutionValidateBeforeCall(String institutionCode, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'institutionCode' is set
        if (institutionCode == null) {
            throw new ApiException("Missing the required parameter 'institutionCode' when calling readInstitution(Async)");
        }

        return readInstitutionCall(institutionCode, _callback);

    }

    /**
     * Read institution
     * This endpoint returns information about the institution specified by &#x60;institution_code&#x60;.
     * @param institutionCode The institution_code of the institution. (required)
     * @return InstitutionResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public InstitutionResponseBody readInstitution(String institutionCode) throws ApiException {
        ApiResponse<InstitutionResponseBody> localVarResp = readInstitutionWithHttpInfo(institutionCode);
        return localVarResp.getData();
    }

    /**
     * Read institution
     * This endpoint returns information about the institution specified by &#x60;institution_code&#x60;.
     * @param institutionCode The institution_code of the institution. (required)
     * @return ApiResponse&lt;InstitutionResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<InstitutionResponseBody> readInstitutionWithHttpInfo(String institutionCode) throws ApiException {
        okhttp3.Call localVarCall = readInstitutionValidateBeforeCall(institutionCode, null);
        Type localVarReturnType = new TypeToken<InstitutionResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Read institution (asynchronously)
     * This endpoint returns information about the institution specified by &#x60;institution_code&#x60;.
     * @param institutionCode The institution_code of the institution. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readInstitutionAsync(String institutionCode, final ApiCallback<InstitutionResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = readInstitutionValidateBeforeCall(institutionCode, _callback);
        Type localVarReturnType = new TypeToken<InstitutionResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for readManagedAccount
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readManagedAccountCall(String accountGuid, String memberGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/managed_members/{member_guid}/accounts/{account_guid}"
            .replace("{" + "account_guid" + "}", localVarApiClient.escapeString(accountGuid.toString()))
            .replace("{" + "member_guid" + "}", localVarApiClient.escapeString(memberGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call readManagedAccountValidateBeforeCall(String accountGuid, String memberGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountGuid' is set
        if (accountGuid == null) {
            throw new ApiException("Missing the required parameter 'accountGuid' when calling readManagedAccount(Async)");
        }

        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling readManagedAccount(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling readManagedAccount(Async)");
        }

        return readManagedAccountCall(accountGuid, memberGuid, userGuid, _callback);

    }

    /**
     * Read managed account
     * Use this endpoint to read the attributes of a partner-managed account according to its unique guid.
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return AccountResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public AccountResponseBody readManagedAccount(String accountGuid, String memberGuid, String userGuid) throws ApiException {
        ApiResponse<AccountResponseBody> localVarResp = readManagedAccountWithHttpInfo(accountGuid, memberGuid, userGuid);
        return localVarResp.getData();
    }

    /**
     * Read managed account
     * Use this endpoint to read the attributes of a partner-managed account according to its unique guid.
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;AccountResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AccountResponseBody> readManagedAccountWithHttpInfo(String accountGuid, String memberGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = readManagedAccountValidateBeforeCall(accountGuid, memberGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<AccountResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Read managed account (asynchronously)
     * Use this endpoint to read the attributes of a partner-managed account according to its unique guid.
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readManagedAccountAsync(String accountGuid, String memberGuid, String userGuid, final ApiCallback<AccountResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = readManagedAccountValidateBeforeCall(accountGuid, memberGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<AccountResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for readManagedMember
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readManagedMemberCall(String memberGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/managed_members/{member_guid}"
            .replace("{" + "member_guid" + "}", localVarApiClient.escapeString(memberGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call readManagedMemberValidateBeforeCall(String memberGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling readManagedMember(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling readManagedMember(Async)");
        }

        return readManagedMemberCall(memberGuid, userGuid, _callback);

    }

    /**
     * Read managed member
     * This endpoint returns the attributes of the specified partner-managed &#x60;member&#x60;.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return MemberResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public MemberResponseBody readManagedMember(String memberGuid, String userGuid) throws ApiException {
        ApiResponse<MemberResponseBody> localVarResp = readManagedMemberWithHttpInfo(memberGuid, userGuid);
        return localVarResp.getData();
    }

    /**
     * Read managed member
     * This endpoint returns the attributes of the specified partner-managed &#x60;member&#x60;.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;MemberResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MemberResponseBody> readManagedMemberWithHttpInfo(String memberGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = readManagedMemberValidateBeforeCall(memberGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Read managed member (asynchronously)
     * This endpoint returns the attributes of the specified partner-managed &#x60;member&#x60;.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readManagedMemberAsync(String memberGuid, String userGuid, final ApiCallback<MemberResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = readManagedMemberValidateBeforeCall(memberGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for readManagedTransaction
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param transactionGuid The unique id for a &#x60;transaction&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readManagedTransactionCall(String accountGuid, String memberGuid, String transactionGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/managed_members/{member_guid}/accounts/{account_guid}/transactions/{transaction_guid}"
            .replace("{" + "account_guid" + "}", localVarApiClient.escapeString(accountGuid.toString()))
            .replace("{" + "member_guid" + "}", localVarApiClient.escapeString(memberGuid.toString()))
            .replace("{" + "transaction_guid" + "}", localVarApiClient.escapeString(transactionGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call readManagedTransactionValidateBeforeCall(String accountGuid, String memberGuid, String transactionGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountGuid' is set
        if (accountGuid == null) {
            throw new ApiException("Missing the required parameter 'accountGuid' when calling readManagedTransaction(Async)");
        }

        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling readManagedTransaction(Async)");
        }

        // verify the required parameter 'transactionGuid' is set
        if (transactionGuid == null) {
            throw new ApiException("Missing the required parameter 'transactionGuid' when calling readManagedTransaction(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling readManagedTransaction(Async)");
        }

        return readManagedTransactionCall(accountGuid, memberGuid, transactionGuid, userGuid, _callback);

    }

    /**
     * Read managed transaction
     * Requests to this endpoint will return the attributes of the specified partner-managed &#x60;transaction&#x60;.
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param transactionGuid The unique id for a &#x60;transaction&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return TransactionResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public TransactionResponseBody readManagedTransaction(String accountGuid, String memberGuid, String transactionGuid, String userGuid) throws ApiException {
        ApiResponse<TransactionResponseBody> localVarResp = readManagedTransactionWithHttpInfo(accountGuid, memberGuid, transactionGuid, userGuid);
        return localVarResp.getData();
    }

    /**
     * Read managed transaction
     * Requests to this endpoint will return the attributes of the specified partner-managed &#x60;transaction&#x60;.
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param transactionGuid The unique id for a &#x60;transaction&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;TransactionResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TransactionResponseBody> readManagedTransactionWithHttpInfo(String accountGuid, String memberGuid, String transactionGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = readManagedTransactionValidateBeforeCall(accountGuid, memberGuid, transactionGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<TransactionResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Read managed transaction (asynchronously)
     * Requests to this endpoint will return the attributes of the specified partner-managed &#x60;transaction&#x60;.
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param transactionGuid The unique id for a &#x60;transaction&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readManagedTransactionAsync(String accountGuid, String memberGuid, String transactionGuid, String userGuid, final ApiCallback<TransactionResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = readManagedTransactionValidateBeforeCall(accountGuid, memberGuid, transactionGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<TransactionResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for readMember
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readMemberCall(String memberGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/members/{member_guid}"
            .replace("{" + "member_guid" + "}", localVarApiClient.escapeString(memberGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call readMemberValidateBeforeCall(String memberGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling readMember(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling readMember(Async)");
        }

        return readMemberCall(memberGuid, userGuid, _callback);

    }

    /**
     * Read member
     * Use this endpoint to read the attributes of a specific member.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return MemberResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public MemberResponseBody readMember(String memberGuid, String userGuid) throws ApiException {
        ApiResponse<MemberResponseBody> localVarResp = readMemberWithHttpInfo(memberGuid, userGuid);
        return localVarResp.getData();
    }

    /**
     * Read member
     * Use this endpoint to read the attributes of a specific member.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;MemberResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MemberResponseBody> readMemberWithHttpInfo(String memberGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = readMemberValidateBeforeCall(memberGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Read member (asynchronously)
     * Use this endpoint to read the attributes of a specific member.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readMemberAsync(String memberGuid, String userGuid, final ApiCallback<MemberResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = readMemberValidateBeforeCall(memberGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for readMemberStatus
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readMemberStatusCall(String memberGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/members/{member_guid}/status"
            .replace("{" + "member_guid" + "}", localVarApiClient.escapeString(memberGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call readMemberStatusValidateBeforeCall(String memberGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling readMemberStatus(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling readMemberStatus(Async)");
        }

        return readMemberStatusCall(memberGuid, userGuid, _callback);

    }

    /**
     * Read member status
     * This endpoint provides the status of the members most recent aggregation event. This is an important step in the aggregation process, and the results returned by this endpoint should determine what you do next in order to successfully aggregate a member. MX has introduced new, more detailed information on the current status of a members connection to a financial institution and the state of its aggregation - the connection_status field. These are intended to replace and expand upon the information provided in the status field, which will soon be deprecated; support for the status field remains for the time being.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return MemberStatusResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public MemberStatusResponseBody readMemberStatus(String memberGuid, String userGuid) throws ApiException {
        ApiResponse<MemberStatusResponseBody> localVarResp = readMemberStatusWithHttpInfo(memberGuid, userGuid);
        return localVarResp.getData();
    }

    /**
     * Read member status
     * This endpoint provides the status of the members most recent aggregation event. This is an important step in the aggregation process, and the results returned by this endpoint should determine what you do next in order to successfully aggregate a member. MX has introduced new, more detailed information on the current status of a members connection to a financial institution and the state of its aggregation - the connection_status field. These are intended to replace and expand upon the information provided in the status field, which will soon be deprecated; support for the status field remains for the time being.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;MemberStatusResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MemberStatusResponseBody> readMemberStatusWithHttpInfo(String memberGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = readMemberStatusValidateBeforeCall(memberGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<MemberStatusResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Read member status (asynchronously)
     * This endpoint provides the status of the members most recent aggregation event. This is an important step in the aggregation process, and the results returned by this endpoint should determine what you do next in order to successfully aggregate a member. MX has introduced new, more detailed information on the current status of a members connection to a financial institution and the state of its aggregation - the connection_status field. These are intended to replace and expand upon the information provided in the status field, which will soon be deprecated; support for the status field remains for the time being.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readMemberStatusAsync(String memberGuid, String userGuid, final ApiCallback<MemberStatusResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = readMemberStatusValidateBeforeCall(memberGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<MemberStatusResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for readMerchant
     * @param merchantGuid The unique id for a &#x60;merchant&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readMerchantCall(String merchantGuid, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/merchants/{merchant_guid}"
            .replace("{" + "merchant_guid" + "}", localVarApiClient.escapeString(merchantGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call readMerchantValidateBeforeCall(String merchantGuid, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'merchantGuid' is set
        if (merchantGuid == null) {
            throw new ApiException("Missing the required parameter 'merchantGuid' when calling readMerchant(Async)");
        }

        return readMerchantCall(merchantGuid, _callback);

    }

    /**
     * Read merchant
     * Returns information about a particular merchant, such as a logo, name, and website.
     * @param merchantGuid The unique id for a &#x60;merchant&#x60;. (required)
     * @return MerchantResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public MerchantResponseBody readMerchant(String merchantGuid) throws ApiException {
        ApiResponse<MerchantResponseBody> localVarResp = readMerchantWithHttpInfo(merchantGuid);
        return localVarResp.getData();
    }

    /**
     * Read merchant
     * Returns information about a particular merchant, such as a logo, name, and website.
     * @param merchantGuid The unique id for a &#x60;merchant&#x60;. (required)
     * @return ApiResponse&lt;MerchantResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MerchantResponseBody> readMerchantWithHttpInfo(String merchantGuid) throws ApiException {
        okhttp3.Call localVarCall = readMerchantValidateBeforeCall(merchantGuid, null);
        Type localVarReturnType = new TypeToken<MerchantResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Read merchant (asynchronously)
     * Returns information about a particular merchant, such as a logo, name, and website.
     * @param merchantGuid The unique id for a &#x60;merchant&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readMerchantAsync(String merchantGuid, final ApiCallback<MerchantResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = readMerchantValidateBeforeCall(merchantGuid, _callback);
        Type localVarReturnType = new TypeToken<MerchantResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for readMerchantLocation
     * @param merchantLocationGuid The unique id for a &#x60;merchant_location&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readMerchantLocationCall(String merchantLocationGuid, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/merchant_locations/{merchant_location_guid}"
            .replace("{" + "merchant_location_guid" + "}", localVarApiClient.escapeString(merchantLocationGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call readMerchantLocationValidateBeforeCall(String merchantLocationGuid, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'merchantLocationGuid' is set
        if (merchantLocationGuid == null) {
            throw new ApiException("Missing the required parameter 'merchantLocationGuid' when calling readMerchantLocation(Async)");
        }

        return readMerchantLocationCall(merchantLocationGuid, _callback);

    }

    /**
     * Read merchant location
     * This endpoint returns the specified merchant_location resource.
     * @param merchantLocationGuid The unique id for a &#x60;merchant_location&#x60;. (required)
     * @return MerchantLocationResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public MerchantLocationResponseBody readMerchantLocation(String merchantLocationGuid) throws ApiException {
        ApiResponse<MerchantLocationResponseBody> localVarResp = readMerchantLocationWithHttpInfo(merchantLocationGuid);
        return localVarResp.getData();
    }

    /**
     * Read merchant location
     * This endpoint returns the specified merchant_location resource.
     * @param merchantLocationGuid The unique id for a &#x60;merchant_location&#x60;. (required)
     * @return ApiResponse&lt;MerchantLocationResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MerchantLocationResponseBody> readMerchantLocationWithHttpInfo(String merchantLocationGuid) throws ApiException {
        okhttp3.Call localVarCall = readMerchantLocationValidateBeforeCall(merchantLocationGuid, null);
        Type localVarReturnType = new TypeToken<MerchantLocationResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Read merchant location (asynchronously)
     * This endpoint returns the specified merchant_location resource.
     * @param merchantLocationGuid The unique id for a &#x60;merchant_location&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readMerchantLocationAsync(String merchantLocationGuid, final ApiCallback<MerchantLocationResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = readMerchantLocationValidateBeforeCall(merchantLocationGuid, _callback);
        Type localVarReturnType = new TypeToken<MerchantLocationResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for readRewards
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberGuid The unique identifier for the member. Defined by MX. (required)
     * @param rewardGuid The unique identifier for the rewards. Defined by MX. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readRewardsCall(String userGuid, String memberGuid, String rewardGuid, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/members/{member_guid}/rewards/{reward_guid}"
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()))
            .replace("{" + "member_guid" + "}", localVarApiClient.escapeString(memberGuid.toString()))
            .replace("{" + "reward_guid" + "}", localVarApiClient.escapeString(rewardGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call readRewardsValidateBeforeCall(String userGuid, String memberGuid, String rewardGuid, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling readRewards(Async)");
        }

        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling readRewards(Async)");
        }

        // verify the required parameter 'rewardGuid' is set
        if (rewardGuid == null) {
            throw new ApiException("Missing the required parameter 'rewardGuid' when calling readRewards(Async)");
        }

        return readRewardsCall(userGuid, memberGuid, rewardGuid, _callback);

    }

    /**
     * Read Reward
     * Use this endpoint to read a specific &#x60;reward&#x60; based on its unique GUID..
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberGuid The unique identifier for the member. Defined by MX. (required)
     * @param rewardGuid The unique identifier for the rewards. Defined by MX. (required)
     * @return RewardResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public RewardResponseBody readRewards(String userGuid, String memberGuid, String rewardGuid) throws ApiException {
        ApiResponse<RewardResponseBody> localVarResp = readRewardsWithHttpInfo(userGuid, memberGuid, rewardGuid);
        return localVarResp.getData();
    }

    /**
     * Read Reward
     * Use this endpoint to read a specific &#x60;reward&#x60; based on its unique GUID..
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberGuid The unique identifier for the member. Defined by MX. (required)
     * @param rewardGuid The unique identifier for the rewards. Defined by MX. (required)
     * @return ApiResponse&lt;RewardResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<RewardResponseBody> readRewardsWithHttpInfo(String userGuid, String memberGuid, String rewardGuid) throws ApiException {
        okhttp3.Call localVarCall = readRewardsValidateBeforeCall(userGuid, memberGuid, rewardGuid, null);
        Type localVarReturnType = new TypeToken<RewardResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Read Reward (asynchronously)
     * Use this endpoint to read a specific &#x60;reward&#x60; based on its unique GUID..
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberGuid The unique identifier for the member. Defined by MX. (required)
     * @param rewardGuid The unique identifier for the rewards. Defined by MX. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readRewardsAsync(String userGuid, String memberGuid, String rewardGuid, final ApiCallback<RewardResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = readRewardsValidateBeforeCall(userGuid, memberGuid, rewardGuid, _callback);
        Type localVarReturnType = new TypeToken<RewardResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for readStatementByMember
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param statementGuid The unique id for a &#x60;statement&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readStatementByMemberCall(String memberGuid, String statementGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/members/{member_guid}/statements/{statement_guid}"
            .replace("{" + "member_guid" + "}", localVarApiClient.escapeString(memberGuid.toString()))
            .replace("{" + "statement_guid" + "}", localVarApiClient.escapeString(statementGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call readStatementByMemberValidateBeforeCall(String memberGuid, String statementGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling readStatementByMember(Async)");
        }

        // verify the required parameter 'statementGuid' is set
        if (statementGuid == null) {
            throw new ApiException("Missing the required parameter 'statementGuid' when calling readStatementByMember(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling readStatementByMember(Async)");
        }

        return readStatementByMemberCall(memberGuid, statementGuid, userGuid, _callback);

    }

    /**
     * Read statement by member
     * Use this endpoint to read a JSON representation of the statement.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param statementGuid The unique id for a &#x60;statement&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return StatementResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public StatementResponseBody readStatementByMember(String memberGuid, String statementGuid, String userGuid) throws ApiException {
        ApiResponse<StatementResponseBody> localVarResp = readStatementByMemberWithHttpInfo(memberGuid, statementGuid, userGuid);
        return localVarResp.getData();
    }

    /**
     * Read statement by member
     * Use this endpoint to read a JSON representation of the statement.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param statementGuid The unique id for a &#x60;statement&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;StatementResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<StatementResponseBody> readStatementByMemberWithHttpInfo(String memberGuid, String statementGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = readStatementByMemberValidateBeforeCall(memberGuid, statementGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<StatementResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Read statement by member (asynchronously)
     * Use this endpoint to read a JSON representation of the statement.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param statementGuid The unique id for a &#x60;statement&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readStatementByMemberAsync(String memberGuid, String statementGuid, String userGuid, final ApiCallback<StatementResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = readStatementByMemberValidateBeforeCall(memberGuid, statementGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<StatementResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for readTag
     * @param tagGuid The unique id for a &#x60;tag&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readTagCall(String tagGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/tags/{tag_guid}"
            .replace("{" + "tag_guid" + "}", localVarApiClient.escapeString(tagGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call readTagValidateBeforeCall(String tagGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'tagGuid' is set
        if (tagGuid == null) {
            throw new ApiException("Missing the required parameter 'tagGuid' when calling readTag(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling readTag(Async)");
        }

        return readTagCall(tagGuid, userGuid, _callback);

    }

    /**
     * Read tag
     * Use this endpoint to read the attributes of a particular tag according to its unique GUID.
     * @param tagGuid The unique id for a &#x60;tag&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return TagResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public TagResponseBody readTag(String tagGuid, String userGuid) throws ApiException {
        ApiResponse<TagResponseBody> localVarResp = readTagWithHttpInfo(tagGuid, userGuid);
        return localVarResp.getData();
    }

    /**
     * Read tag
     * Use this endpoint to read the attributes of a particular tag according to its unique GUID.
     * @param tagGuid The unique id for a &#x60;tag&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;TagResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TagResponseBody> readTagWithHttpInfo(String tagGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = readTagValidateBeforeCall(tagGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<TagResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Read tag (asynchronously)
     * Use this endpoint to read the attributes of a particular tag according to its unique GUID.
     * @param tagGuid The unique id for a &#x60;tag&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readTagAsync(String tagGuid, String userGuid, final ApiCallback<TagResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = readTagValidateBeforeCall(tagGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<TagResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for readTagging
     * @param taggingGuid The unique id for a &#x60;tagging&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readTaggingCall(String taggingGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/taggings/{tagging_guid}"
            .replace("{" + "tagging_guid" + "}", localVarApiClient.escapeString(taggingGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call readTaggingValidateBeforeCall(String taggingGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'taggingGuid' is set
        if (taggingGuid == null) {
            throw new ApiException("Missing the required parameter 'taggingGuid' when calling readTagging(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling readTagging(Async)");
        }

        return readTaggingCall(taggingGuid, userGuid, _callback);

    }

    /**
     * Read tagging
     * Use this endpoint to read the attributes of a &#x60;tagging&#x60; according to its unique GUID.
     * @param taggingGuid The unique id for a &#x60;tagging&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return TaggingResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public TaggingResponseBody readTagging(String taggingGuid, String userGuid) throws ApiException {
        ApiResponse<TaggingResponseBody> localVarResp = readTaggingWithHttpInfo(taggingGuid, userGuid);
        return localVarResp.getData();
    }

    /**
     * Read tagging
     * Use this endpoint to read the attributes of a &#x60;tagging&#x60; according to its unique GUID.
     * @param taggingGuid The unique id for a &#x60;tagging&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;TaggingResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TaggingResponseBody> readTaggingWithHttpInfo(String taggingGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = readTaggingValidateBeforeCall(taggingGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<TaggingResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Read tagging (asynchronously)
     * Use this endpoint to read the attributes of a &#x60;tagging&#x60; according to its unique GUID.
     * @param taggingGuid The unique id for a &#x60;tagging&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readTaggingAsync(String taggingGuid, String userGuid, final ApiCallback<TaggingResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = readTaggingValidateBeforeCall(taggingGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<TaggingResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for readTaxDocument
     * @param taxDocumentGuid The unique id for a &#x60;tax_document&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readTaxDocumentCall(String taxDocumentGuid, String memberGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/members/{member_guid}/tax_documents/{tax_document_guid}"
            .replace("{" + "tax_document_guid" + "}", localVarApiClient.escapeString(taxDocumentGuid.toString()))
            .replace("{" + "member_guid" + "}", localVarApiClient.escapeString(memberGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call readTaxDocumentValidateBeforeCall(String taxDocumentGuid, String memberGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'taxDocumentGuid' is set
        if (taxDocumentGuid == null) {
            throw new ApiException("Missing the required parameter 'taxDocumentGuid' when calling readTaxDocument(Async)");
        }

        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling readTaxDocument(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling readTaxDocument(Async)");
        }

        return readTaxDocumentCall(taxDocumentGuid, memberGuid, userGuid, _callback);

    }

    /**
     * Read a Tax Document
     * Use this endpoint to read the attributes of the specified tax document.
     * @param taxDocumentGuid The unique id for a &#x60;tax_document&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return TaxDocumentResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public TaxDocumentResponseBody readTaxDocument(String taxDocumentGuid, String memberGuid, String userGuid) throws ApiException {
        ApiResponse<TaxDocumentResponseBody> localVarResp = readTaxDocumentWithHttpInfo(taxDocumentGuid, memberGuid, userGuid);
        return localVarResp.getData();
    }

    /**
     * Read a Tax Document
     * Use this endpoint to read the attributes of the specified tax document.
     * @param taxDocumentGuid The unique id for a &#x60;tax_document&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;TaxDocumentResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TaxDocumentResponseBody> readTaxDocumentWithHttpInfo(String taxDocumentGuid, String memberGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = readTaxDocumentValidateBeforeCall(taxDocumentGuid, memberGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<TaxDocumentResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Read a Tax Document (asynchronously)
     * Use this endpoint to read the attributes of the specified tax document.
     * @param taxDocumentGuid The unique id for a &#x60;tax_document&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readTaxDocumentAsync(String taxDocumentGuid, String memberGuid, String userGuid, final ApiCallback<TaxDocumentResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = readTaxDocumentValidateBeforeCall(taxDocumentGuid, memberGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<TaxDocumentResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for readTransaction
     * @param transactionGuid The unique id for a &#x60;transaction&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readTransactionCall(String transactionGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/transactions/{transaction_guid}"
            .replace("{" + "transaction_guid" + "}", localVarApiClient.escapeString(transactionGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call readTransactionValidateBeforeCall(String transactionGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'transactionGuid' is set
        if (transactionGuid == null) {
            throw new ApiException("Missing the required parameter 'transactionGuid' when calling readTransaction(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling readTransaction(Async)");
        }

        return readTransactionCall(transactionGuid, userGuid, _callback);

    }

    /**
     * Read transaction
     * Requests to this endpoint will return the attributes of the specified &#x60;transaction&#x60;.
     * @param transactionGuid The unique id for a &#x60;transaction&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return TransactionResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public TransactionResponseBody readTransaction(String transactionGuid, String userGuid) throws ApiException {
        ApiResponse<TransactionResponseBody> localVarResp = readTransactionWithHttpInfo(transactionGuid, userGuid);
        return localVarResp.getData();
    }

    /**
     * Read transaction
     * Requests to this endpoint will return the attributes of the specified &#x60;transaction&#x60;.
     * @param transactionGuid The unique id for a &#x60;transaction&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;TransactionResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TransactionResponseBody> readTransactionWithHttpInfo(String transactionGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = readTransactionValidateBeforeCall(transactionGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<TransactionResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Read transaction (asynchronously)
     * Requests to this endpoint will return the attributes of the specified &#x60;transaction&#x60;.
     * @param transactionGuid The unique id for a &#x60;transaction&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readTransactionAsync(String transactionGuid, String userGuid, final ApiCallback<TransactionResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = readTransactionValidateBeforeCall(transactionGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<TransactionResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for readTransactionRule
     * @param transactionRuleGuid The unique id for a &#x60;transaction_rule&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readTransactionRuleCall(String transactionRuleGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/transaction_rules/{transaction_rule_guid}"
            .replace("{" + "transaction_rule_guid" + "}", localVarApiClient.escapeString(transactionRuleGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call readTransactionRuleValidateBeforeCall(String transactionRuleGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'transactionRuleGuid' is set
        if (transactionRuleGuid == null) {
            throw new ApiException("Missing the required parameter 'transactionRuleGuid' when calling readTransactionRule(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling readTransactionRule(Async)");
        }

        return readTransactionRuleCall(transactionRuleGuid, userGuid, _callback);

    }

    /**
     * Read transaction rule
     * Use this endpoint to read the attributes of an existing transaction rule based on the rule’s unique GUID.
     * @param transactionRuleGuid The unique id for a &#x60;transaction_rule&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return TransactionRuleResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public TransactionRuleResponseBody readTransactionRule(String transactionRuleGuid, String userGuid) throws ApiException {
        ApiResponse<TransactionRuleResponseBody> localVarResp = readTransactionRuleWithHttpInfo(transactionRuleGuid, userGuid);
        return localVarResp.getData();
    }

    /**
     * Read transaction rule
     * Use this endpoint to read the attributes of an existing transaction rule based on the rule’s unique GUID.
     * @param transactionRuleGuid The unique id for a &#x60;transaction_rule&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;TransactionRuleResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TransactionRuleResponseBody> readTransactionRuleWithHttpInfo(String transactionRuleGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = readTransactionRuleValidateBeforeCall(transactionRuleGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<TransactionRuleResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Read transaction rule (asynchronously)
     * Use this endpoint to read the attributes of an existing transaction rule based on the rule’s unique GUID.
     * @param transactionRuleGuid The unique id for a &#x60;transaction_rule&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readTransactionRuleAsync(String transactionRuleGuid, String userGuid, final ApiCallback<TransactionRuleResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = readTransactionRuleValidateBeforeCall(transactionRuleGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<TransactionRuleResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for readUser
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readUserCall(String userGuid, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}"
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call readUserValidateBeforeCall(String userGuid, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling readUser(Async)");
        }

        return readUserCall(userGuid, _callback);

    }

    /**
     * Read user
     * Use this endpoint to read the attributes of a specific user.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return UserResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public UserResponseBody readUser(String userGuid) throws ApiException {
        ApiResponse<UserResponseBody> localVarResp = readUserWithHttpInfo(userGuid);
        return localVarResp.getData();
    }

    /**
     * Read user
     * Use this endpoint to read the attributes of a specific user.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;UserResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<UserResponseBody> readUserWithHttpInfo(String userGuid) throws ApiException {
        okhttp3.Call localVarCall = readUserValidateBeforeCall(userGuid, null);
        Type localVarReturnType = new TypeToken<UserResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Read user (asynchronously)
     * Use this endpoint to read the attributes of a specific user.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readUserAsync(String userGuid, final ApiCallback<UserResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = readUserValidateBeforeCall(userGuid, _callback);
        Type localVarReturnType = new TypeToken<UserResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for requestAuthorizationCode
     * @param authorizationCodeRequestBody The scope for the authorization code. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call requestAuthorizationCodeCall(AuthorizationCodeRequestBody authorizationCodeRequestBody, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = authorizationCodeRequestBody;

        // create path and map variables
        String localVarPath = "/authorization_code";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call requestAuthorizationCodeValidateBeforeCall(AuthorizationCodeRequestBody authorizationCodeRequestBody, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'authorizationCodeRequestBody' is set
        if (authorizationCodeRequestBody == null) {
            throw new ApiException("Missing the required parameter 'authorizationCodeRequestBody' when calling requestAuthorizationCode(Async)");
        }

        return requestAuthorizationCodeCall(authorizationCodeRequestBody, _callback);

    }

    /**
     * Request an authorization code.
     * Clients use this endpoint to request an authorization code according to the parameters specified in the scope. Clients then pass this code to processors. Processor access is scoped only to the GUIDs and features specified in this request. Before requesting an authorization code which includes a member in the scope, clients must have verified that member.
     * @param authorizationCodeRequestBody The scope for the authorization code. (required)
     * @return AuthorizationCodeResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public AuthorizationCodeResponseBody requestAuthorizationCode(AuthorizationCodeRequestBody authorizationCodeRequestBody) throws ApiException {
        ApiResponse<AuthorizationCodeResponseBody> localVarResp = requestAuthorizationCodeWithHttpInfo(authorizationCodeRequestBody);
        return localVarResp.getData();
    }

    /**
     * Request an authorization code.
     * Clients use this endpoint to request an authorization code according to the parameters specified in the scope. Clients then pass this code to processors. Processor access is scoped only to the GUIDs and features specified in this request. Before requesting an authorization code which includes a member in the scope, clients must have verified that member.
     * @param authorizationCodeRequestBody The scope for the authorization code. (required)
     * @return ApiResponse&lt;AuthorizationCodeResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AuthorizationCodeResponseBody> requestAuthorizationCodeWithHttpInfo(AuthorizationCodeRequestBody authorizationCodeRequestBody) throws ApiException {
        okhttp3.Call localVarCall = requestAuthorizationCodeValidateBeforeCall(authorizationCodeRequestBody, null);
        Type localVarReturnType = new TypeToken<AuthorizationCodeResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Request an authorization code. (asynchronously)
     * Clients use this endpoint to request an authorization code according to the parameters specified in the scope. Clients then pass this code to processors. Processor access is scoped only to the GUIDs and features specified in this request. Before requesting an authorization code which includes a member in the scope, clients must have verified that member.
     * @param authorizationCodeRequestBody The scope for the authorization code. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call requestAuthorizationCodeAsync(AuthorizationCodeRequestBody authorizationCodeRequestBody, final ApiCallback<AuthorizationCodeResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = requestAuthorizationCodeValidateBeforeCall(authorizationCodeRequestBody, _callback);
        Type localVarReturnType = new TypeToken<AuthorizationCodeResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for requestConnectWidgetURL
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param connectWidgetRequestBody Optional config options for WebView (is_mobile_webview, current_institution_code, current_member_guid, update_credentials) (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call requestConnectWidgetURLCall(String userGuid, ConnectWidgetRequestBody connectWidgetRequestBody, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = connectWidgetRequestBody;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/connect_widget_url"
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call requestConnectWidgetURLValidateBeforeCall(String userGuid, ConnectWidgetRequestBody connectWidgetRequestBody, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling requestConnectWidgetURL(Async)");
        }

        // verify the required parameter 'connectWidgetRequestBody' is set
        if (connectWidgetRequestBody == null) {
            throw new ApiException("Missing the required parameter 'connectWidgetRequestBody' when calling requestConnectWidgetURL(Async)");
        }

        return requestConnectWidgetURLCall(userGuid, connectWidgetRequestBody, _callback);

    }

    /**
     * Request connect widget url
     * This endpoint will return a URL for an embeddable version of MX Connect.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param connectWidgetRequestBody Optional config options for WebView (is_mobile_webview, current_institution_code, current_member_guid, update_credentials) (required)
     * @return ConnectWidgetResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ConnectWidgetResponseBody requestConnectWidgetURL(String userGuid, ConnectWidgetRequestBody connectWidgetRequestBody) throws ApiException {
        ApiResponse<ConnectWidgetResponseBody> localVarResp = requestConnectWidgetURLWithHttpInfo(userGuid, connectWidgetRequestBody);
        return localVarResp.getData();
    }

    /**
     * Request connect widget url
     * This endpoint will return a URL for an embeddable version of MX Connect.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param connectWidgetRequestBody Optional config options for WebView (is_mobile_webview, current_institution_code, current_member_guid, update_credentials) (required)
     * @return ApiResponse&lt;ConnectWidgetResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ConnectWidgetResponseBody> requestConnectWidgetURLWithHttpInfo(String userGuid, ConnectWidgetRequestBody connectWidgetRequestBody) throws ApiException {
        okhttp3.Call localVarCall = requestConnectWidgetURLValidateBeforeCall(userGuid, connectWidgetRequestBody, null);
        Type localVarReturnType = new TypeToken<ConnectWidgetResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Request connect widget url (asynchronously)
     * This endpoint will return a URL for an embeddable version of MX Connect.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param connectWidgetRequestBody Optional config options for WebView (is_mobile_webview, current_institution_code, current_member_guid, update_credentials) (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call requestConnectWidgetURLAsync(String userGuid, ConnectWidgetRequestBody connectWidgetRequestBody, final ApiCallback<ConnectWidgetResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = requestConnectWidgetURLValidateBeforeCall(userGuid, connectWidgetRequestBody, _callback);
        Type localVarReturnType = new TypeToken<ConnectWidgetResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for requestOAuthWindowURI
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param clientRedirectUrl A URL that MX will redirect to at the end of OAuth with additional query parameters. Only available with &#x60;referral_source&#x3D;APP&#x60;. (optional)
     * @param enableApp2app This indicates whether OAuth app2app behavior is enabled for institutions that support it. Defaults to &#x60;true&#x60;. This setting is not persistent. (optional)
     * @param referralSource Must be either &#x60;BROWSER&#x60; or &#x60;APP&#x60; depending on the implementation. Defaults to &#x60;BROWSER&#x60;. (optional)
     * @param skipAggregation Setting this parameter to &#x60;true&#x60; will prevent the member from automatically aggregating after being redirected from the authorization page. (optional)
     * @param uiMessageWebviewUrlScheme A scheme for routing the user back to the application state they were previously in. Only available with &#x60;referral_source&#x3D;APP&#x60;. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call requestOAuthWindowURICall(String memberGuid, String userGuid, String clientRedirectUrl, String enableApp2app, String referralSource, Boolean skipAggregation, String uiMessageWebviewUrlScheme, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/members/{member_guid}/oauth_window_uri"
            .replace("{" + "member_guid" + "}", localVarApiClient.escapeString(memberGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (clientRedirectUrl != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("client_redirect_url", clientRedirectUrl));
        }

        if (enableApp2app != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("enable_app2app", enableApp2app));
        }

        if (referralSource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("referral_source", referralSource));
        }

        if (skipAggregation != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("skip_aggregation", skipAggregation));
        }

        if (uiMessageWebviewUrlScheme != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("ui_message_webview_url_scheme", uiMessageWebviewUrlScheme));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call requestOAuthWindowURIValidateBeforeCall(String memberGuid, String userGuid, String clientRedirectUrl, String enableApp2app, String referralSource, Boolean skipAggregation, String uiMessageWebviewUrlScheme, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling requestOAuthWindowURI(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling requestOAuthWindowURI(Async)");
        }

        return requestOAuthWindowURICall(memberGuid, userGuid, clientRedirectUrl, enableApp2app, referralSource, skipAggregation, uiMessageWebviewUrlScheme, _callback);

    }

    /**
     * Request oauth window uri
     * This endpoint will generate an &#x60;oauth_window_uri&#x60; for the specified &#x60;member&#x60;.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param clientRedirectUrl A URL that MX will redirect to at the end of OAuth with additional query parameters. Only available with &#x60;referral_source&#x3D;APP&#x60;. (optional)
     * @param enableApp2app This indicates whether OAuth app2app behavior is enabled for institutions that support it. Defaults to &#x60;true&#x60;. This setting is not persistent. (optional)
     * @param referralSource Must be either &#x60;BROWSER&#x60; or &#x60;APP&#x60; depending on the implementation. Defaults to &#x60;BROWSER&#x60;. (optional)
     * @param skipAggregation Setting this parameter to &#x60;true&#x60; will prevent the member from automatically aggregating after being redirected from the authorization page. (optional)
     * @param uiMessageWebviewUrlScheme A scheme for routing the user back to the application state they were previously in. Only available with &#x60;referral_source&#x3D;APP&#x60;. (optional)
     * @return OAuthWindowResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public OAuthWindowResponseBody requestOAuthWindowURI(String memberGuid, String userGuid, String clientRedirectUrl, String enableApp2app, String referralSource, Boolean skipAggregation, String uiMessageWebviewUrlScheme) throws ApiException {
        ApiResponse<OAuthWindowResponseBody> localVarResp = requestOAuthWindowURIWithHttpInfo(memberGuid, userGuid, clientRedirectUrl, enableApp2app, referralSource, skipAggregation, uiMessageWebviewUrlScheme);
        return localVarResp.getData();
    }

    /**
     * Request oauth window uri
     * This endpoint will generate an &#x60;oauth_window_uri&#x60; for the specified &#x60;member&#x60;.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param clientRedirectUrl A URL that MX will redirect to at the end of OAuth with additional query parameters. Only available with &#x60;referral_source&#x3D;APP&#x60;. (optional)
     * @param enableApp2app This indicates whether OAuth app2app behavior is enabled for institutions that support it. Defaults to &#x60;true&#x60;. This setting is not persistent. (optional)
     * @param referralSource Must be either &#x60;BROWSER&#x60; or &#x60;APP&#x60; depending on the implementation. Defaults to &#x60;BROWSER&#x60;. (optional)
     * @param skipAggregation Setting this parameter to &#x60;true&#x60; will prevent the member from automatically aggregating after being redirected from the authorization page. (optional)
     * @param uiMessageWebviewUrlScheme A scheme for routing the user back to the application state they were previously in. Only available with &#x60;referral_source&#x3D;APP&#x60;. (optional)
     * @return ApiResponse&lt;OAuthWindowResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<OAuthWindowResponseBody> requestOAuthWindowURIWithHttpInfo(String memberGuid, String userGuid, String clientRedirectUrl, String enableApp2app, String referralSource, Boolean skipAggregation, String uiMessageWebviewUrlScheme) throws ApiException {
        okhttp3.Call localVarCall = requestOAuthWindowURIValidateBeforeCall(memberGuid, userGuid, clientRedirectUrl, enableApp2app, referralSource, skipAggregation, uiMessageWebviewUrlScheme, null);
        Type localVarReturnType = new TypeToken<OAuthWindowResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Request oauth window uri (asynchronously)
     * This endpoint will generate an &#x60;oauth_window_uri&#x60; for the specified &#x60;member&#x60;.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param clientRedirectUrl A URL that MX will redirect to at the end of OAuth with additional query parameters. Only available with &#x60;referral_source&#x3D;APP&#x60;. (optional)
     * @param enableApp2app This indicates whether OAuth app2app behavior is enabled for institutions that support it. Defaults to &#x60;true&#x60;. This setting is not persistent. (optional)
     * @param referralSource Must be either &#x60;BROWSER&#x60; or &#x60;APP&#x60; depending on the implementation. Defaults to &#x60;BROWSER&#x60;. (optional)
     * @param skipAggregation Setting this parameter to &#x60;true&#x60; will prevent the member from automatically aggregating after being redirected from the authorization page. (optional)
     * @param uiMessageWebviewUrlScheme A scheme for routing the user back to the application state they were previously in. Only available with &#x60;referral_source&#x3D;APP&#x60;. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call requestOAuthWindowURIAsync(String memberGuid, String userGuid, String clientRedirectUrl, String enableApp2app, String referralSource, Boolean skipAggregation, String uiMessageWebviewUrlScheme, final ApiCallback<OAuthWindowResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = requestOAuthWindowURIValidateBeforeCall(memberGuid, userGuid, clientRedirectUrl, enableApp2app, referralSource, skipAggregation, uiMessageWebviewUrlScheme, _callback);
        Type localVarReturnType = new TypeToken<OAuthWindowResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for requestWidgetURL
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param widgetRequestBody The widget url configuration options. (required)
     * @param acceptLanguage The desired language of the widget. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call requestWidgetURLCall(String userGuid, WidgetRequestBody widgetRequestBody, String acceptLanguage, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = widgetRequestBody;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/widget_urls"
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (acceptLanguage != null) {
            localVarHeaderParams.put("Accept-Language", localVarApiClient.parameterToString(acceptLanguage));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call requestWidgetURLValidateBeforeCall(String userGuid, WidgetRequestBody widgetRequestBody, String acceptLanguage, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling requestWidgetURL(Async)");
        }

        // verify the required parameter 'widgetRequestBody' is set
        if (widgetRequestBody == null) {
            throw new ApiException("Missing the required parameter 'widgetRequestBody' when calling requestWidgetURL(Async)");
        }

        return requestWidgetURLCall(userGuid, widgetRequestBody, acceptLanguage, _callback);

    }

    /**
     * Request widget url
     * This endpoint allows partners to get a URL by passing the &#x60;widget_type&#x60; in the request body, as well as configuring it in several different ways. In the case of Connect, that means setting the &#x60;widget_type&#x60; to &#x60;connect_widget&#x60;. Partners may also pass an optional &#x60;Accept-Language&#x60; header as well as a number of configuration options. Note that this is a &#x60;POST&#x60; request.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param widgetRequestBody The widget url configuration options. (required)
     * @param acceptLanguage The desired language of the widget. (optional)
     * @return WidgetResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public WidgetResponseBody requestWidgetURL(String userGuid, WidgetRequestBody widgetRequestBody, String acceptLanguage) throws ApiException {
        ApiResponse<WidgetResponseBody> localVarResp = requestWidgetURLWithHttpInfo(userGuid, widgetRequestBody, acceptLanguage);
        return localVarResp.getData();
    }

    /**
     * Request widget url
     * This endpoint allows partners to get a URL by passing the &#x60;widget_type&#x60; in the request body, as well as configuring it in several different ways. In the case of Connect, that means setting the &#x60;widget_type&#x60; to &#x60;connect_widget&#x60;. Partners may also pass an optional &#x60;Accept-Language&#x60; header as well as a number of configuration options. Note that this is a &#x60;POST&#x60; request.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param widgetRequestBody The widget url configuration options. (required)
     * @param acceptLanguage The desired language of the widget. (optional)
     * @return ApiResponse&lt;WidgetResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<WidgetResponseBody> requestWidgetURLWithHttpInfo(String userGuid, WidgetRequestBody widgetRequestBody, String acceptLanguage) throws ApiException {
        okhttp3.Call localVarCall = requestWidgetURLValidateBeforeCall(userGuid, widgetRequestBody, acceptLanguage, null);
        Type localVarReturnType = new TypeToken<WidgetResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Request widget url (asynchronously)
     * This endpoint allows partners to get a URL by passing the &#x60;widget_type&#x60; in the request body, as well as configuring it in several different ways. In the case of Connect, that means setting the &#x60;widget_type&#x60; to &#x60;connect_widget&#x60;. Partners may also pass an optional &#x60;Accept-Language&#x60; header as well as a number of configuration options. Note that this is a &#x60;POST&#x60; request.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param widgetRequestBody The widget url configuration options. (required)
     * @param acceptLanguage The desired language of the widget. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call requestWidgetURLAsync(String userGuid, WidgetRequestBody widgetRequestBody, String acceptLanguage, final ApiCallback<WidgetResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = requestWidgetURLValidateBeforeCall(userGuid, widgetRequestBody, acceptLanguage, _callback);
        Type localVarReturnType = new TypeToken<WidgetResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for resumeAggregation
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberResumeRequestBody Member object with MFA challenge answers (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call resumeAggregationCall(String memberGuid, String userGuid, MemberResumeRequestBody memberResumeRequestBody, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = memberResumeRequestBody;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/members/{member_guid}/resume"
            .replace("{" + "member_guid" + "}", localVarApiClient.escapeString(memberGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call resumeAggregationValidateBeforeCall(String memberGuid, String userGuid, MemberResumeRequestBody memberResumeRequestBody, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling resumeAggregation(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling resumeAggregation(Async)");
        }

        // verify the required parameter 'memberResumeRequestBody' is set
        if (memberResumeRequestBody == null) {
            throw new ApiException("Missing the required parameter 'memberResumeRequestBody' when calling resumeAggregation(Async)");
        }

        return resumeAggregationCall(memberGuid, userGuid, memberResumeRequestBody, _callback);

    }

    /**
     * Resume aggregation
     * This endpoint answers the challenges needed when a member has been challenged by multi-factor authentication.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberResumeRequestBody Member object with MFA challenge answers (required)
     * @return MemberResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public MemberResponseBody resumeAggregation(String memberGuid, String userGuid, MemberResumeRequestBody memberResumeRequestBody) throws ApiException {
        ApiResponse<MemberResponseBody> localVarResp = resumeAggregationWithHttpInfo(memberGuid, userGuid, memberResumeRequestBody);
        return localVarResp.getData();
    }

    /**
     * Resume aggregation
     * This endpoint answers the challenges needed when a member has been challenged by multi-factor authentication.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberResumeRequestBody Member object with MFA challenge answers (required)
     * @return ApiResponse&lt;MemberResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MemberResponseBody> resumeAggregationWithHttpInfo(String memberGuid, String userGuid, MemberResumeRequestBody memberResumeRequestBody) throws ApiException {
        okhttp3.Call localVarCall = resumeAggregationValidateBeforeCall(memberGuid, userGuid, memberResumeRequestBody, null);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Resume aggregation (asynchronously)
     * This endpoint answers the challenges needed when a member has been challenged by multi-factor authentication.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberResumeRequestBody Member object with MFA challenge answers (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call resumeAggregationAsync(String memberGuid, String userGuid, MemberResumeRequestBody memberResumeRequestBody, final ApiCallback<MemberResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = resumeAggregationValidateBeforeCall(memberGuid, userGuid, memberResumeRequestBody, _callback);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateAccountByMember
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param accountUpdateRequestBody  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateAccountByMemberCall(String accountGuid, String memberGuid, String userGuid, AccountUpdateRequestBody accountUpdateRequestBody, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = accountUpdateRequestBody;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/members/{member_guid}/accounts/{account_guid}"
            .replace("{" + "account_guid" + "}", localVarApiClient.escapeString(accountGuid.toString()))
            .replace("{" + "member_guid" + "}", localVarApiClient.escapeString(memberGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateAccountByMemberValidateBeforeCall(String accountGuid, String memberGuid, String userGuid, AccountUpdateRequestBody accountUpdateRequestBody, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountGuid' is set
        if (accountGuid == null) {
            throw new ApiException("Missing the required parameter 'accountGuid' when calling updateAccountByMember(Async)");
        }

        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling updateAccountByMember(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling updateAccountByMember(Async)");
        }

        // verify the required parameter 'accountUpdateRequestBody' is set
        if (accountUpdateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'accountUpdateRequestBody' when calling updateAccountByMember(Async)");
        }

        return updateAccountByMemberCall(accountGuid, memberGuid, userGuid, accountUpdateRequestBody, _callback);

    }

    /**
     * Update account by member
     * This endpoint allows you to update certain attributes of an &#x60;account&#x60; resource, including manual accounts. For manual accounts, you can update every field listed. For aggregated accounts, you can only update &#x60;is_business&#x60;, &#x60;is_hidden&#x60; and &#x60;metadata&#x60;.
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param accountUpdateRequestBody  (required)
     * @return AccountResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public AccountResponseBody updateAccountByMember(String accountGuid, String memberGuid, String userGuid, AccountUpdateRequestBody accountUpdateRequestBody) throws ApiException {
        ApiResponse<AccountResponseBody> localVarResp = updateAccountByMemberWithHttpInfo(accountGuid, memberGuid, userGuid, accountUpdateRequestBody);
        return localVarResp.getData();
    }

    /**
     * Update account by member
     * This endpoint allows you to update certain attributes of an &#x60;account&#x60; resource, including manual accounts. For manual accounts, you can update every field listed. For aggregated accounts, you can only update &#x60;is_business&#x60;, &#x60;is_hidden&#x60; and &#x60;metadata&#x60;.
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param accountUpdateRequestBody  (required)
     * @return ApiResponse&lt;AccountResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AccountResponseBody> updateAccountByMemberWithHttpInfo(String accountGuid, String memberGuid, String userGuid, AccountUpdateRequestBody accountUpdateRequestBody) throws ApiException {
        okhttp3.Call localVarCall = updateAccountByMemberValidateBeforeCall(accountGuid, memberGuid, userGuid, accountUpdateRequestBody, null);
        Type localVarReturnType = new TypeToken<AccountResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update account by member (asynchronously)
     * This endpoint allows you to update certain attributes of an &#x60;account&#x60; resource, including manual accounts. For manual accounts, you can update every field listed. For aggregated accounts, you can only update &#x60;is_business&#x60;, &#x60;is_hidden&#x60; and &#x60;metadata&#x60;.
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param accountUpdateRequestBody  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateAccountByMemberAsync(String accountGuid, String memberGuid, String userGuid, AccountUpdateRequestBody accountUpdateRequestBody, final ApiCallback<AccountResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateAccountByMemberValidateBeforeCall(accountGuid, memberGuid, userGuid, accountUpdateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<AccountResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateCategory
     * @param categoryGuid The unique id for a &#x60;category&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param categoryUpdateRequestBody Category object to be updated (While no single parameter is required, the &#x60;category&#x60; object cannot be empty) (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateCategoryCall(String categoryGuid, String userGuid, CategoryUpdateRequestBody categoryUpdateRequestBody, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = categoryUpdateRequestBody;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/categories/{category_guid}"
            .replace("{" + "category_guid" + "}", localVarApiClient.escapeString(categoryGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateCategoryValidateBeforeCall(String categoryGuid, String userGuid, CategoryUpdateRequestBody categoryUpdateRequestBody, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'categoryGuid' is set
        if (categoryGuid == null) {
            throw new ApiException("Missing the required parameter 'categoryGuid' when calling updateCategory(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling updateCategory(Async)");
        }

        // verify the required parameter 'categoryUpdateRequestBody' is set
        if (categoryUpdateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'categoryUpdateRequestBody' when calling updateCategory(Async)");
        }

        return updateCategoryCall(categoryGuid, userGuid, categoryUpdateRequestBody, _callback);

    }

    /**
     * Update category
     * Use this endpoint to update the attributes of a custom category according to its unique GUID.
     * @param categoryGuid The unique id for a &#x60;category&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param categoryUpdateRequestBody Category object to be updated (While no single parameter is required, the &#x60;category&#x60; object cannot be empty) (required)
     * @return CategoryResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public CategoryResponseBody updateCategory(String categoryGuid, String userGuid, CategoryUpdateRequestBody categoryUpdateRequestBody) throws ApiException {
        ApiResponse<CategoryResponseBody> localVarResp = updateCategoryWithHttpInfo(categoryGuid, userGuid, categoryUpdateRequestBody);
        return localVarResp.getData();
    }

    /**
     * Update category
     * Use this endpoint to update the attributes of a custom category according to its unique GUID.
     * @param categoryGuid The unique id for a &#x60;category&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param categoryUpdateRequestBody Category object to be updated (While no single parameter is required, the &#x60;category&#x60; object cannot be empty) (required)
     * @return ApiResponse&lt;CategoryResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CategoryResponseBody> updateCategoryWithHttpInfo(String categoryGuid, String userGuid, CategoryUpdateRequestBody categoryUpdateRequestBody) throws ApiException {
        okhttp3.Call localVarCall = updateCategoryValidateBeforeCall(categoryGuid, userGuid, categoryUpdateRequestBody, null);
        Type localVarReturnType = new TypeToken<CategoryResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update category (asynchronously)
     * Use this endpoint to update the attributes of a custom category according to its unique GUID.
     * @param categoryGuid The unique id for a &#x60;category&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param categoryUpdateRequestBody Category object to be updated (While no single parameter is required, the &#x60;category&#x60; object cannot be empty) (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateCategoryAsync(String categoryGuid, String userGuid, CategoryUpdateRequestBody categoryUpdateRequestBody, final ApiCallback<CategoryResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateCategoryValidateBeforeCall(categoryGuid, userGuid, categoryUpdateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<CategoryResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateManagedAccount
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param managedAccountUpdateRequestBody Managed account object to be updated (While no single parameter is required, the request body can&#39;t be empty) (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateManagedAccountCall(String accountGuid, String memberGuid, String userGuid, ManagedAccountUpdateRequestBody managedAccountUpdateRequestBody, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = managedAccountUpdateRequestBody;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/managed_members/{member_guid}/accounts/{account_guid}"
            .replace("{" + "account_guid" + "}", localVarApiClient.escapeString(accountGuid.toString()))
            .replace("{" + "member_guid" + "}", localVarApiClient.escapeString(memberGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateManagedAccountValidateBeforeCall(String accountGuid, String memberGuid, String userGuid, ManagedAccountUpdateRequestBody managedAccountUpdateRequestBody, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountGuid' is set
        if (accountGuid == null) {
            throw new ApiException("Missing the required parameter 'accountGuid' when calling updateManagedAccount(Async)");
        }

        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling updateManagedAccount(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling updateManagedAccount(Async)");
        }

        // verify the required parameter 'managedAccountUpdateRequestBody' is set
        if (managedAccountUpdateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'managedAccountUpdateRequestBody' when calling updateManagedAccount(Async)");
        }

        return updateManagedAccountCall(accountGuid, memberGuid, userGuid, managedAccountUpdateRequestBody, _callback);

    }

    /**
     * Update managed account
     * Use this endpoint to update the attributes of a partner-managed account according to its unique GUID.
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param managedAccountUpdateRequestBody Managed account object to be updated (While no single parameter is required, the request body can&#39;t be empty) (required)
     * @return AccountResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public AccountResponseBody updateManagedAccount(String accountGuid, String memberGuid, String userGuid, ManagedAccountUpdateRequestBody managedAccountUpdateRequestBody) throws ApiException {
        ApiResponse<AccountResponseBody> localVarResp = updateManagedAccountWithHttpInfo(accountGuid, memberGuid, userGuid, managedAccountUpdateRequestBody);
        return localVarResp.getData();
    }

    /**
     * Update managed account
     * Use this endpoint to update the attributes of a partner-managed account according to its unique GUID.
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param managedAccountUpdateRequestBody Managed account object to be updated (While no single parameter is required, the request body can&#39;t be empty) (required)
     * @return ApiResponse&lt;AccountResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AccountResponseBody> updateManagedAccountWithHttpInfo(String accountGuid, String memberGuid, String userGuid, ManagedAccountUpdateRequestBody managedAccountUpdateRequestBody) throws ApiException {
        okhttp3.Call localVarCall = updateManagedAccountValidateBeforeCall(accountGuid, memberGuid, userGuid, managedAccountUpdateRequestBody, null);
        Type localVarReturnType = new TypeToken<AccountResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update managed account (asynchronously)
     * Use this endpoint to update the attributes of a partner-managed account according to its unique GUID.
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param managedAccountUpdateRequestBody Managed account object to be updated (While no single parameter is required, the request body can&#39;t be empty) (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateManagedAccountAsync(String accountGuid, String memberGuid, String userGuid, ManagedAccountUpdateRequestBody managedAccountUpdateRequestBody, final ApiCallback<AccountResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateManagedAccountValidateBeforeCall(accountGuid, memberGuid, userGuid, managedAccountUpdateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<AccountResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateManagedMember
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param managedMemberUpdateRequestBody Managed member object to be updated (While no single parameter is required, the request body can&#39;t be empty) (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateManagedMemberCall(String memberGuid, String userGuid, ManagedMemberUpdateRequestBody managedMemberUpdateRequestBody, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = managedMemberUpdateRequestBody;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/managed_members/{member_guid}"
            .replace("{" + "member_guid" + "}", localVarApiClient.escapeString(memberGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateManagedMemberValidateBeforeCall(String memberGuid, String userGuid, ManagedMemberUpdateRequestBody managedMemberUpdateRequestBody, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling updateManagedMember(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling updateManagedMember(Async)");
        }

        // verify the required parameter 'managedMemberUpdateRequestBody' is set
        if (managedMemberUpdateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'managedMemberUpdateRequestBody' when calling updateManagedMember(Async)");
        }

        return updateManagedMemberCall(memberGuid, userGuid, managedMemberUpdateRequestBody, _callback);

    }

    /**
     * Update managed member
     * Use this endpoint to update the attributes of the specified partner_managed &#x60;member&#x60;.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param managedMemberUpdateRequestBody Managed member object to be updated (While no single parameter is required, the request body can&#39;t be empty) (required)
     * @return MemberResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public MemberResponseBody updateManagedMember(String memberGuid, String userGuid, ManagedMemberUpdateRequestBody managedMemberUpdateRequestBody) throws ApiException {
        ApiResponse<MemberResponseBody> localVarResp = updateManagedMemberWithHttpInfo(memberGuid, userGuid, managedMemberUpdateRequestBody);
        return localVarResp.getData();
    }

    /**
     * Update managed member
     * Use this endpoint to update the attributes of the specified partner_managed &#x60;member&#x60;.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param managedMemberUpdateRequestBody Managed member object to be updated (While no single parameter is required, the request body can&#39;t be empty) (required)
     * @return ApiResponse&lt;MemberResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MemberResponseBody> updateManagedMemberWithHttpInfo(String memberGuid, String userGuid, ManagedMemberUpdateRequestBody managedMemberUpdateRequestBody) throws ApiException {
        okhttp3.Call localVarCall = updateManagedMemberValidateBeforeCall(memberGuid, userGuid, managedMemberUpdateRequestBody, null);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update managed member (asynchronously)
     * Use this endpoint to update the attributes of the specified partner_managed &#x60;member&#x60;.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param managedMemberUpdateRequestBody Managed member object to be updated (While no single parameter is required, the request body can&#39;t be empty) (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateManagedMemberAsync(String memberGuid, String userGuid, ManagedMemberUpdateRequestBody managedMemberUpdateRequestBody, final ApiCallback<MemberResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateManagedMemberValidateBeforeCall(memberGuid, userGuid, managedMemberUpdateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateManagedTransaction
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param transactionGuid The unique id for a &#x60;transaction&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param managedTransactionUpdateRequestBody Managed transaction object to be updated (While no single parameter is required, the request body can&#39;t be empty) (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateManagedTransactionCall(String accountGuid, String memberGuid, String transactionGuid, String userGuid, ManagedTransactionUpdateRequestBody managedTransactionUpdateRequestBody, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = managedTransactionUpdateRequestBody;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/managed_members/{member_guid}/accounts/{account_guid}/transactions/{transaction_guid}"
            .replace("{" + "account_guid" + "}", localVarApiClient.escapeString(accountGuid.toString()))
            .replace("{" + "member_guid" + "}", localVarApiClient.escapeString(memberGuid.toString()))
            .replace("{" + "transaction_guid" + "}", localVarApiClient.escapeString(transactionGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateManagedTransactionValidateBeforeCall(String accountGuid, String memberGuid, String transactionGuid, String userGuid, ManagedTransactionUpdateRequestBody managedTransactionUpdateRequestBody, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountGuid' is set
        if (accountGuid == null) {
            throw new ApiException("Missing the required parameter 'accountGuid' when calling updateManagedTransaction(Async)");
        }

        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling updateManagedTransaction(Async)");
        }

        // verify the required parameter 'transactionGuid' is set
        if (transactionGuid == null) {
            throw new ApiException("Missing the required parameter 'transactionGuid' when calling updateManagedTransaction(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling updateManagedTransaction(Async)");
        }

        // verify the required parameter 'managedTransactionUpdateRequestBody' is set
        if (managedTransactionUpdateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'managedTransactionUpdateRequestBody' when calling updateManagedTransaction(Async)");
        }

        return updateManagedTransactionCall(accountGuid, memberGuid, transactionGuid, userGuid, managedTransactionUpdateRequestBody, _callback);

    }

    /**
     * Update managed transaction
     * Use this endpoint to update the attributes of the specified partner_managed &#x60;transaction&#x60;.
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param transactionGuid The unique id for a &#x60;transaction&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param managedTransactionUpdateRequestBody Managed transaction object to be updated (While no single parameter is required, the request body can&#39;t be empty) (required)
     * @return TransactionResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public TransactionResponseBody updateManagedTransaction(String accountGuid, String memberGuid, String transactionGuid, String userGuid, ManagedTransactionUpdateRequestBody managedTransactionUpdateRequestBody) throws ApiException {
        ApiResponse<TransactionResponseBody> localVarResp = updateManagedTransactionWithHttpInfo(accountGuid, memberGuid, transactionGuid, userGuid, managedTransactionUpdateRequestBody);
        return localVarResp.getData();
    }

    /**
     * Update managed transaction
     * Use this endpoint to update the attributes of the specified partner_managed &#x60;transaction&#x60;.
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param transactionGuid The unique id for a &#x60;transaction&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param managedTransactionUpdateRequestBody Managed transaction object to be updated (While no single parameter is required, the request body can&#39;t be empty) (required)
     * @return ApiResponse&lt;TransactionResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TransactionResponseBody> updateManagedTransactionWithHttpInfo(String accountGuid, String memberGuid, String transactionGuid, String userGuid, ManagedTransactionUpdateRequestBody managedTransactionUpdateRequestBody) throws ApiException {
        okhttp3.Call localVarCall = updateManagedTransactionValidateBeforeCall(accountGuid, memberGuid, transactionGuid, userGuid, managedTransactionUpdateRequestBody, null);
        Type localVarReturnType = new TypeToken<TransactionResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update managed transaction (asynchronously)
     * Use this endpoint to update the attributes of the specified partner_managed &#x60;transaction&#x60;.
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param transactionGuid The unique id for a &#x60;transaction&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param managedTransactionUpdateRequestBody Managed transaction object to be updated (While no single parameter is required, the request body can&#39;t be empty) (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateManagedTransactionAsync(String accountGuid, String memberGuid, String transactionGuid, String userGuid, ManagedTransactionUpdateRequestBody managedTransactionUpdateRequestBody, final ApiCallback<TransactionResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateManagedTransactionValidateBeforeCall(accountGuid, memberGuid, transactionGuid, userGuid, managedTransactionUpdateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<TransactionResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateMember
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberUpdateRequestBody Member object to be updated (While no single parameter is required, the request body can&#39;t be empty) (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateMemberCall(String memberGuid, String userGuid, MemberUpdateRequestBody memberUpdateRequestBody, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = memberUpdateRequestBody;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/members/{member_guid}"
            .replace("{" + "member_guid" + "}", localVarApiClient.escapeString(memberGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateMemberValidateBeforeCall(String memberGuid, String userGuid, MemberUpdateRequestBody memberUpdateRequestBody, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling updateMember(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling updateMember(Async)");
        }

        // verify the required parameter 'memberUpdateRequestBody' is set
        if (memberUpdateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'memberUpdateRequestBody' when calling updateMember(Async)");
        }

        return updateMemberCall(memberGuid, userGuid, memberUpdateRequestBody, _callback);

    }

    /**
     * Update member
     * Use this endpoint to update a members attributes. Only the credentials, id, and metadata parameters can be updated. To get a list of the required credentials for the member, use the list member credentials endpoint.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberUpdateRequestBody Member object to be updated (While no single parameter is required, the request body can&#39;t be empty) (required)
     * @return MemberResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public MemberResponseBody updateMember(String memberGuid, String userGuid, MemberUpdateRequestBody memberUpdateRequestBody) throws ApiException {
        ApiResponse<MemberResponseBody> localVarResp = updateMemberWithHttpInfo(memberGuid, userGuid, memberUpdateRequestBody);
        return localVarResp.getData();
    }

    /**
     * Update member
     * Use this endpoint to update a members attributes. Only the credentials, id, and metadata parameters can be updated. To get a list of the required credentials for the member, use the list member credentials endpoint.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberUpdateRequestBody Member object to be updated (While no single parameter is required, the request body can&#39;t be empty) (required)
     * @return ApiResponse&lt;MemberResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MemberResponseBody> updateMemberWithHttpInfo(String memberGuid, String userGuid, MemberUpdateRequestBody memberUpdateRequestBody) throws ApiException {
        okhttp3.Call localVarCall = updateMemberValidateBeforeCall(memberGuid, userGuid, memberUpdateRequestBody, null);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update member (asynchronously)
     * Use this endpoint to update a members attributes. Only the credentials, id, and metadata parameters can be updated. To get a list of the required credentials for the member, use the list member credentials endpoint.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberUpdateRequestBody Member object to be updated (While no single parameter is required, the request body can&#39;t be empty) (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateMemberAsync(String memberGuid, String userGuid, MemberUpdateRequestBody memberUpdateRequestBody, final ApiCallback<MemberResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateMemberValidateBeforeCall(memberGuid, userGuid, memberUpdateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateTag
     * @param tagGuid The unique id for a &#x60;tag&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param tagUpdateRequestBody Tag object to be updated with required parameter (tag_guid) (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateTagCall(String tagGuid, String userGuid, TagUpdateRequestBody tagUpdateRequestBody, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = tagUpdateRequestBody;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/tags/{tag_guid}"
            .replace("{" + "tag_guid" + "}", localVarApiClient.escapeString(tagGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateTagValidateBeforeCall(String tagGuid, String userGuid, TagUpdateRequestBody tagUpdateRequestBody, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'tagGuid' is set
        if (tagGuid == null) {
            throw new ApiException("Missing the required parameter 'tagGuid' when calling updateTag(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling updateTag(Async)");
        }

        // verify the required parameter 'tagUpdateRequestBody' is set
        if (tagUpdateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'tagUpdateRequestBody' when calling updateTag(Async)");
        }

        return updateTagCall(tagGuid, userGuid, tagUpdateRequestBody, _callback);

    }

    /**
     * Update tag
     * Use this endpoint to update the name of a specific tag according to its unique GUID.
     * @param tagGuid The unique id for a &#x60;tag&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param tagUpdateRequestBody Tag object to be updated with required parameter (tag_guid) (required)
     * @return TagResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public TagResponseBody updateTag(String tagGuid, String userGuid, TagUpdateRequestBody tagUpdateRequestBody) throws ApiException {
        ApiResponse<TagResponseBody> localVarResp = updateTagWithHttpInfo(tagGuid, userGuid, tagUpdateRequestBody);
        return localVarResp.getData();
    }

    /**
     * Update tag
     * Use this endpoint to update the name of a specific tag according to its unique GUID.
     * @param tagGuid The unique id for a &#x60;tag&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param tagUpdateRequestBody Tag object to be updated with required parameter (tag_guid) (required)
     * @return ApiResponse&lt;TagResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TagResponseBody> updateTagWithHttpInfo(String tagGuid, String userGuid, TagUpdateRequestBody tagUpdateRequestBody) throws ApiException {
        okhttp3.Call localVarCall = updateTagValidateBeforeCall(tagGuid, userGuid, tagUpdateRequestBody, null);
        Type localVarReturnType = new TypeToken<TagResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update tag (asynchronously)
     * Use this endpoint to update the name of a specific tag according to its unique GUID.
     * @param tagGuid The unique id for a &#x60;tag&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param tagUpdateRequestBody Tag object to be updated with required parameter (tag_guid) (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateTagAsync(String tagGuid, String userGuid, TagUpdateRequestBody tagUpdateRequestBody, final ApiCallback<TagResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateTagValidateBeforeCall(tagGuid, userGuid, tagUpdateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<TagResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateTagging
     * @param taggingGuid The unique id for a &#x60;tagging&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param taggingUpdateRequestBody Tagging object to be updated with required parameter (tag_guid) (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateTaggingCall(String taggingGuid, String userGuid, TaggingUpdateRequestBody taggingUpdateRequestBody, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = taggingUpdateRequestBody;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/taggings/{tagging_guid}"
            .replace("{" + "tagging_guid" + "}", localVarApiClient.escapeString(taggingGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateTaggingValidateBeforeCall(String taggingGuid, String userGuid, TaggingUpdateRequestBody taggingUpdateRequestBody, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'taggingGuid' is set
        if (taggingGuid == null) {
            throw new ApiException("Missing the required parameter 'taggingGuid' when calling updateTagging(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling updateTagging(Async)");
        }

        // verify the required parameter 'taggingUpdateRequestBody' is set
        if (taggingUpdateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'taggingUpdateRequestBody' when calling updateTagging(Async)");
        }

        return updateTaggingCall(taggingGuid, userGuid, taggingUpdateRequestBody, _callback);

    }

    /**
     * Update tagging
     * Use this endpoint to update a tagging.
     * @param taggingGuid The unique id for a &#x60;tagging&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param taggingUpdateRequestBody Tagging object to be updated with required parameter (tag_guid) (required)
     * @return TaggingResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public TaggingResponseBody updateTagging(String taggingGuid, String userGuid, TaggingUpdateRequestBody taggingUpdateRequestBody) throws ApiException {
        ApiResponse<TaggingResponseBody> localVarResp = updateTaggingWithHttpInfo(taggingGuid, userGuid, taggingUpdateRequestBody);
        return localVarResp.getData();
    }

    /**
     * Update tagging
     * Use this endpoint to update a tagging.
     * @param taggingGuid The unique id for a &#x60;tagging&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param taggingUpdateRequestBody Tagging object to be updated with required parameter (tag_guid) (required)
     * @return ApiResponse&lt;TaggingResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TaggingResponseBody> updateTaggingWithHttpInfo(String taggingGuid, String userGuid, TaggingUpdateRequestBody taggingUpdateRequestBody) throws ApiException {
        okhttp3.Call localVarCall = updateTaggingValidateBeforeCall(taggingGuid, userGuid, taggingUpdateRequestBody, null);
        Type localVarReturnType = new TypeToken<TaggingResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update tagging (asynchronously)
     * Use this endpoint to update a tagging.
     * @param taggingGuid The unique id for a &#x60;tagging&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param taggingUpdateRequestBody Tagging object to be updated with required parameter (tag_guid) (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateTaggingAsync(String taggingGuid, String userGuid, TaggingUpdateRequestBody taggingUpdateRequestBody, final ApiCallback<TaggingResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateTaggingValidateBeforeCall(taggingGuid, userGuid, taggingUpdateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<TaggingResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateTransaction
     * @param transactionGuid The unique id for a &#x60;transaction&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param transactionUpdateRequestBody Transaction object to be updated with a new description (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateTransactionCall(String transactionGuid, String userGuid, TransactionUpdateRequestBody transactionUpdateRequestBody, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = transactionUpdateRequestBody;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/transactions/{transaction_guid}"
            .replace("{" + "transaction_guid" + "}", localVarApiClient.escapeString(transactionGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateTransactionValidateBeforeCall(String transactionGuid, String userGuid, TransactionUpdateRequestBody transactionUpdateRequestBody, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'transactionGuid' is set
        if (transactionGuid == null) {
            throw new ApiException("Missing the required parameter 'transactionGuid' when calling updateTransaction(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling updateTransaction(Async)");
        }

        // verify the required parameter 'transactionUpdateRequestBody' is set
        if (transactionUpdateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'transactionUpdateRequestBody' when calling updateTransaction(Async)");
        }

        return updateTransactionCall(transactionGuid, userGuid, transactionUpdateRequestBody, _callback);

    }

    /**
     * Update transaction
     * Use this endpoint to update the &#x60;description&#x60; of a specific transaction according to its unique GUID.
     * @param transactionGuid The unique id for a &#x60;transaction&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param transactionUpdateRequestBody Transaction object to be updated with a new description (required)
     * @return TransactionResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public TransactionResponseBody updateTransaction(String transactionGuid, String userGuid, TransactionUpdateRequestBody transactionUpdateRequestBody) throws ApiException {
        ApiResponse<TransactionResponseBody> localVarResp = updateTransactionWithHttpInfo(transactionGuid, userGuid, transactionUpdateRequestBody);
        return localVarResp.getData();
    }

    /**
     * Update transaction
     * Use this endpoint to update the &#x60;description&#x60; of a specific transaction according to its unique GUID.
     * @param transactionGuid The unique id for a &#x60;transaction&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param transactionUpdateRequestBody Transaction object to be updated with a new description (required)
     * @return ApiResponse&lt;TransactionResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TransactionResponseBody> updateTransactionWithHttpInfo(String transactionGuid, String userGuid, TransactionUpdateRequestBody transactionUpdateRequestBody) throws ApiException {
        okhttp3.Call localVarCall = updateTransactionValidateBeforeCall(transactionGuid, userGuid, transactionUpdateRequestBody, null);
        Type localVarReturnType = new TypeToken<TransactionResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update transaction (asynchronously)
     * Use this endpoint to update the &#x60;description&#x60; of a specific transaction according to its unique GUID.
     * @param transactionGuid The unique id for a &#x60;transaction&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param transactionUpdateRequestBody Transaction object to be updated with a new description (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateTransactionAsync(String transactionGuid, String userGuid, TransactionUpdateRequestBody transactionUpdateRequestBody, final ApiCallback<TransactionResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateTransactionValidateBeforeCall(transactionGuid, userGuid, transactionUpdateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<TransactionResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateTransactionRule
     * @param transactionRuleGuid The unique id for a &#x60;transaction_rule&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param transactionRuleUpdateRequestBody TransactionRule object to be updated (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateTransactionRuleCall(String transactionRuleGuid, String userGuid, TransactionRuleUpdateRequestBody transactionRuleUpdateRequestBody, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = transactionRuleUpdateRequestBody;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/transaction_rules/{transaction_rule_guid}"
            .replace("{" + "transaction_rule_guid" + "}", localVarApiClient.escapeString(transactionRuleGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateTransactionRuleValidateBeforeCall(String transactionRuleGuid, String userGuid, TransactionRuleUpdateRequestBody transactionRuleUpdateRequestBody, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'transactionRuleGuid' is set
        if (transactionRuleGuid == null) {
            throw new ApiException("Missing the required parameter 'transactionRuleGuid' when calling updateTransactionRule(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling updateTransactionRule(Async)");
        }

        // verify the required parameter 'transactionRuleUpdateRequestBody' is set
        if (transactionRuleUpdateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'transactionRuleUpdateRequestBody' when calling updateTransactionRule(Async)");
        }

        return updateTransactionRuleCall(transactionRuleGuid, userGuid, transactionRuleUpdateRequestBody, _callback);

    }

    /**
     * Update transaction_rule
     * Use this endpoint to update the attributes of a specific transaction rule based on its unique GUID. The API will respond with the updated transaction_rule object. Any attributes not provided will be left unchanged.
     * @param transactionRuleGuid The unique id for a &#x60;transaction_rule&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param transactionRuleUpdateRequestBody TransactionRule object to be updated (required)
     * @return TransactionRuleResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public TransactionRuleResponseBody updateTransactionRule(String transactionRuleGuid, String userGuid, TransactionRuleUpdateRequestBody transactionRuleUpdateRequestBody) throws ApiException {
        ApiResponse<TransactionRuleResponseBody> localVarResp = updateTransactionRuleWithHttpInfo(transactionRuleGuid, userGuid, transactionRuleUpdateRequestBody);
        return localVarResp.getData();
    }

    /**
     * Update transaction_rule
     * Use this endpoint to update the attributes of a specific transaction rule based on its unique GUID. The API will respond with the updated transaction_rule object. Any attributes not provided will be left unchanged.
     * @param transactionRuleGuid The unique id for a &#x60;transaction_rule&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param transactionRuleUpdateRequestBody TransactionRule object to be updated (required)
     * @return ApiResponse&lt;TransactionRuleResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TransactionRuleResponseBody> updateTransactionRuleWithHttpInfo(String transactionRuleGuid, String userGuid, TransactionRuleUpdateRequestBody transactionRuleUpdateRequestBody) throws ApiException {
        okhttp3.Call localVarCall = updateTransactionRuleValidateBeforeCall(transactionRuleGuid, userGuid, transactionRuleUpdateRequestBody, null);
        Type localVarReturnType = new TypeToken<TransactionRuleResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update transaction_rule (asynchronously)
     * Use this endpoint to update the attributes of a specific transaction rule based on its unique GUID. The API will respond with the updated transaction_rule object. Any attributes not provided will be left unchanged.
     * @param transactionRuleGuid The unique id for a &#x60;transaction_rule&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param transactionRuleUpdateRequestBody TransactionRule object to be updated (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateTransactionRuleAsync(String transactionRuleGuid, String userGuid, TransactionRuleUpdateRequestBody transactionRuleUpdateRequestBody, final ApiCallback<TransactionRuleResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateTransactionRuleValidateBeforeCall(transactionRuleGuid, userGuid, transactionRuleUpdateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<TransactionRuleResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateUser
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param userUpdateRequestBody User object to be updated (None of these parameters are required, but the user object cannot be empty.) (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateUserCall(String userGuid, UserUpdateRequestBody userUpdateRequestBody, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = userUpdateRequestBody;

        // create path and map variables
        String localVarPath = "/users/{user_guid}"
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateUserValidateBeforeCall(String userGuid, UserUpdateRequestBody userUpdateRequestBody, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling updateUser(Async)");
        }

        // verify the required parameter 'userUpdateRequestBody' is set
        if (userUpdateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'userUpdateRequestBody' when calling updateUser(Async)");
        }

        return updateUserCall(userGuid, userUpdateRequestBody, _callback);

    }

    /**
     * Update user
     * Use this endpoint to update the attributes of the specified user.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param userUpdateRequestBody User object to be updated (None of these parameters are required, but the user object cannot be empty.) (required)
     * @return UserResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public UserResponseBody updateUser(String userGuid, UserUpdateRequestBody userUpdateRequestBody) throws ApiException {
        ApiResponse<UserResponseBody> localVarResp = updateUserWithHttpInfo(userGuid, userUpdateRequestBody);
        return localVarResp.getData();
    }

    /**
     * Update user
     * Use this endpoint to update the attributes of the specified user.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param userUpdateRequestBody User object to be updated (None of these parameters are required, but the user object cannot be empty.) (required)
     * @return ApiResponse&lt;UserResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<UserResponseBody> updateUserWithHttpInfo(String userGuid, UserUpdateRequestBody userUpdateRequestBody) throws ApiException {
        okhttp3.Call localVarCall = updateUserValidateBeforeCall(userGuid, userUpdateRequestBody, null);
        Type localVarReturnType = new TypeToken<UserResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update user (asynchronously)
     * Use this endpoint to update the attributes of the specified user.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param userUpdateRequestBody User object to be updated (None of these parameters are required, but the user object cannot be empty.) (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateUserAsync(String userGuid, UserUpdateRequestBody userUpdateRequestBody, final ApiCallback<UserResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateUserValidateBeforeCall(userGuid, userUpdateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<UserResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for usersUserGuidMonthlyCashFlowProfileGet
     * @param userGuid The unique identifier for the user. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersUserGuidMonthlyCashFlowProfileGetCall(String userGuid, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/monthly_cash_flow_profile"
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call usersUserGuidMonthlyCashFlowProfileGetValidateBeforeCall(String userGuid, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling usersUserGuidMonthlyCashFlowProfileGet(Async)");
        }

        return usersUserGuidMonthlyCashFlowProfileGetCall(userGuid, _callback);

    }

    /**
     * Read monthly cash flow profile
     * 
     * @param userGuid The unique identifier for the user. (required)
     * @return MonthlyCashFlowResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public MonthlyCashFlowResponseBody usersUserGuidMonthlyCashFlowProfileGet(String userGuid) throws ApiException {
        ApiResponse<MonthlyCashFlowResponseBody> localVarResp = usersUserGuidMonthlyCashFlowProfileGetWithHttpInfo(userGuid);
        return localVarResp.getData();
    }

    /**
     * Read monthly cash flow profile
     * 
     * @param userGuid The unique identifier for the user. (required)
     * @return ApiResponse&lt;MonthlyCashFlowResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MonthlyCashFlowResponseBody> usersUserGuidMonthlyCashFlowProfileGetWithHttpInfo(String userGuid) throws ApiException {
        okhttp3.Call localVarCall = usersUserGuidMonthlyCashFlowProfileGetValidateBeforeCall(userGuid, null);
        Type localVarReturnType = new TypeToken<MonthlyCashFlowResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Read monthly cash flow profile (asynchronously)
     * 
     * @param userGuid The unique identifier for the user. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersUserGuidMonthlyCashFlowProfileGetAsync(String userGuid, final ApiCallback<MonthlyCashFlowResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = usersUserGuidMonthlyCashFlowProfileGetValidateBeforeCall(userGuid, _callback);
        Type localVarReturnType = new TypeToken<MonthlyCashFlowResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for usersUserGuidMonthlyCashFlowProfilePut
     * @param userGuid The unique identifier for the user. (required)
     * @param monthlyCashFlowProfileRequestBody  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersUserGuidMonthlyCashFlowProfilePutCall(String userGuid, MonthlyCashFlowProfileRequestBody monthlyCashFlowProfileRequestBody, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = monthlyCashFlowProfileRequestBody;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/monthly_cash_flow_profile"
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call usersUserGuidMonthlyCashFlowProfilePutValidateBeforeCall(String userGuid, MonthlyCashFlowProfileRequestBody monthlyCashFlowProfileRequestBody, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling usersUserGuidMonthlyCashFlowProfilePut(Async)");
        }

        // verify the required parameter 'monthlyCashFlowProfileRequestBody' is set
        if (monthlyCashFlowProfileRequestBody == null) {
            throw new ApiException("Missing the required parameter 'monthlyCashFlowProfileRequestBody' when calling usersUserGuidMonthlyCashFlowProfilePut(Async)");
        }

        return usersUserGuidMonthlyCashFlowProfilePutCall(userGuid, monthlyCashFlowProfileRequestBody, _callback);

    }

    /**
     * Update monthly cash flow profile
     * Use this endpoint to update the attributes of a &#x60;monthly_cash_flow_profile&#x60;.
     * @param userGuid The unique identifier for the user. (required)
     * @param monthlyCashFlowProfileRequestBody  (required)
     * @return MonthlyCashFlowResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public MonthlyCashFlowResponseBody usersUserGuidMonthlyCashFlowProfilePut(String userGuid, MonthlyCashFlowProfileRequestBody monthlyCashFlowProfileRequestBody) throws ApiException {
        ApiResponse<MonthlyCashFlowResponseBody> localVarResp = usersUserGuidMonthlyCashFlowProfilePutWithHttpInfo(userGuid, monthlyCashFlowProfileRequestBody);
        return localVarResp.getData();
    }

    /**
     * Update monthly cash flow profile
     * Use this endpoint to update the attributes of a &#x60;monthly_cash_flow_profile&#x60;.
     * @param userGuid The unique identifier for the user. (required)
     * @param monthlyCashFlowProfileRequestBody  (required)
     * @return ApiResponse&lt;MonthlyCashFlowResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MonthlyCashFlowResponseBody> usersUserGuidMonthlyCashFlowProfilePutWithHttpInfo(String userGuid, MonthlyCashFlowProfileRequestBody monthlyCashFlowProfileRequestBody) throws ApiException {
        okhttp3.Call localVarCall = usersUserGuidMonthlyCashFlowProfilePutValidateBeforeCall(userGuid, monthlyCashFlowProfileRequestBody, null);
        Type localVarReturnType = new TypeToken<MonthlyCashFlowResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update monthly cash flow profile (asynchronously)
     * Use this endpoint to update the attributes of a &#x60;monthly_cash_flow_profile&#x60;.
     * @param userGuid The unique identifier for the user. (required)
     * @param monthlyCashFlowProfileRequestBody  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersUserGuidMonthlyCashFlowProfilePutAsync(String userGuid, MonthlyCashFlowProfileRequestBody monthlyCashFlowProfileRequestBody, final ApiCallback<MonthlyCashFlowResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = usersUserGuidMonthlyCashFlowProfilePutValidateBeforeCall(userGuid, monthlyCashFlowProfileRequestBody, _callback);
        Type localVarReturnType = new TypeToken<MonthlyCashFlowResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for usersUserGuidTransactionsTransactionGuidSplitDelete
     * @param transactionGuid The unique id for a &#x60;transaction&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersUserGuidTransactionsTransactionGuidSplitDeleteCall(String transactionGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/transactions/{transaction_guid}/split"
            .replace("{" + "transaction_guid" + "}", localVarApiClient.escapeString(transactionGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call usersUserGuidTransactionsTransactionGuidSplitDeleteValidateBeforeCall(String transactionGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'transactionGuid' is set
        if (transactionGuid == null) {
            throw new ApiException("Missing the required parameter 'transactionGuid' when calling usersUserGuidTransactionsTransactionGuidSplitDelete(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling usersUserGuidTransactionsTransactionGuidSplitDelete(Async)");
        }

        return usersUserGuidTransactionsTransactionGuidSplitDeleteCall(transactionGuid, userGuid, _callback);

    }

    /**
     * Delete split transactions
     * This endpoint deletes all split transactions linked to a parent transaction, but it leaves the parent transaction active. This request will also update the parent transaction&#39;s has_been_split field to false. This endpoint accepts the optional MX-Skip-Webhook header.
     * @param transactionGuid The unique id for a &#x60;transaction&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No content </td><td>  -  </td></tr>
     </table>
     */
    public void usersUserGuidTransactionsTransactionGuidSplitDelete(String transactionGuid, String userGuid) throws ApiException {
        usersUserGuidTransactionsTransactionGuidSplitDeleteWithHttpInfo(transactionGuid, userGuid);
    }

    /**
     * Delete split transactions
     * This endpoint deletes all split transactions linked to a parent transaction, but it leaves the parent transaction active. This request will also update the parent transaction&#39;s has_been_split field to false. This endpoint accepts the optional MX-Skip-Webhook header.
     * @param transactionGuid The unique id for a &#x60;transaction&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No content </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> usersUserGuidTransactionsTransactionGuidSplitDeleteWithHttpInfo(String transactionGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = usersUserGuidTransactionsTransactionGuidSplitDeleteValidateBeforeCall(transactionGuid, userGuid, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete split transactions (asynchronously)
     * This endpoint deletes all split transactions linked to a parent transaction, but it leaves the parent transaction active. This request will also update the parent transaction&#39;s has_been_split field to false. This endpoint accepts the optional MX-Skip-Webhook header.
     * @param transactionGuid The unique id for a &#x60;transaction&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersUserGuidTransactionsTransactionGuidSplitDeleteAsync(String transactionGuid, String userGuid, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = usersUserGuidTransactionsTransactionGuidSplitDeleteValidateBeforeCall(transactionGuid, userGuid, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for usersUserGuidTransactionsTransactionGuidSplitPost
     * @param userGuid The unique identifier for the user. Defined by MX. (required)
     * @param transactionGuid The unique identifier for the transaction. Defined by MX. (required)
     * @param splitTransactionRequestBody  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersUserGuidTransactionsTransactionGuidSplitPostCall(String userGuid, String transactionGuid, SplitTransactionRequestBody splitTransactionRequestBody, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = splitTransactionRequestBody;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/transactions/{transaction_guid}/split"
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()))
            .replace("{" + "transaction_guid" + "}", localVarApiClient.escapeString(transactionGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call usersUserGuidTransactionsTransactionGuidSplitPostValidateBeforeCall(String userGuid, String transactionGuid, SplitTransactionRequestBody splitTransactionRequestBody, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling usersUserGuidTransactionsTransactionGuidSplitPost(Async)");
        }

        // verify the required parameter 'transactionGuid' is set
        if (transactionGuid == null) {
            throw new ApiException("Missing the required parameter 'transactionGuid' when calling usersUserGuidTransactionsTransactionGuidSplitPost(Async)");
        }

        return usersUserGuidTransactionsTransactionGuidSplitPostCall(userGuid, transactionGuid, splitTransactionRequestBody, _callback);

    }

    /**
     * Create split transactions
     * This endpoint creates two or more child transactions that are branched from a previous transaction. This endpoint allows you to link multiple categories, descriptions, and amounts to a parent transaction.  When a split transaction is created, the parent transaction&#39;s &#x60;has_been_split&#x60; field will automatically be updated to true and the child transactions&#39; &#x60;parent_guid&#x60; will have the transaction guid of the parent. The total amount of the child transactions must equal the amount of the parent transaction. Once a transaction has been split it can&#39;t be split again.    In order to re-split a transaction, it must first be un-split. This can be done by calling the Delete Split Transactions endpoint. Calling this endpoint will delete the existing child transactions and update the parent transaction&#39;s &#x60;has_been_split&#x60; field to false. You can then re-split the parent transaction by calling Create Split Transaction again.
     * @param userGuid The unique identifier for the user. Defined by MX. (required)
     * @param transactionGuid The unique identifier for the transaction. Defined by MX. (required)
     * @param splitTransactionRequestBody  (optional)
     * @return SplitTransactionsResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public SplitTransactionsResponseBody usersUserGuidTransactionsTransactionGuidSplitPost(String userGuid, String transactionGuid, SplitTransactionRequestBody splitTransactionRequestBody) throws ApiException {
        ApiResponse<SplitTransactionsResponseBody> localVarResp = usersUserGuidTransactionsTransactionGuidSplitPostWithHttpInfo(userGuid, transactionGuid, splitTransactionRequestBody);
        return localVarResp.getData();
    }

    /**
     * Create split transactions
     * This endpoint creates two or more child transactions that are branched from a previous transaction. This endpoint allows you to link multiple categories, descriptions, and amounts to a parent transaction.  When a split transaction is created, the parent transaction&#39;s &#x60;has_been_split&#x60; field will automatically be updated to true and the child transactions&#39; &#x60;parent_guid&#x60; will have the transaction guid of the parent. The total amount of the child transactions must equal the amount of the parent transaction. Once a transaction has been split it can&#39;t be split again.    In order to re-split a transaction, it must first be un-split. This can be done by calling the Delete Split Transactions endpoint. Calling this endpoint will delete the existing child transactions and update the parent transaction&#39;s &#x60;has_been_split&#x60; field to false. You can then re-split the parent transaction by calling Create Split Transaction again.
     * @param userGuid The unique identifier for the user. Defined by MX. (required)
     * @param transactionGuid The unique identifier for the transaction. Defined by MX. (required)
     * @param splitTransactionRequestBody  (optional)
     * @return ApiResponse&lt;SplitTransactionsResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SplitTransactionsResponseBody> usersUserGuidTransactionsTransactionGuidSplitPostWithHttpInfo(String userGuid, String transactionGuid, SplitTransactionRequestBody splitTransactionRequestBody) throws ApiException {
        okhttp3.Call localVarCall = usersUserGuidTransactionsTransactionGuidSplitPostValidateBeforeCall(userGuid, transactionGuid, splitTransactionRequestBody, null);
        Type localVarReturnType = new TypeToken<SplitTransactionsResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create split transactions (asynchronously)
     * This endpoint creates two or more child transactions that are branched from a previous transaction. This endpoint allows you to link multiple categories, descriptions, and amounts to a parent transaction.  When a split transaction is created, the parent transaction&#39;s &#x60;has_been_split&#x60; field will automatically be updated to true and the child transactions&#39; &#x60;parent_guid&#x60; will have the transaction guid of the parent. The total amount of the child transactions must equal the amount of the parent transaction. Once a transaction has been split it can&#39;t be split again.    In order to re-split a transaction, it must first be un-split. This can be done by calling the Delete Split Transactions endpoint. Calling this endpoint will delete the existing child transactions and update the parent transaction&#39;s &#x60;has_been_split&#x60; field to false. You can then re-split the parent transaction by calling Create Split Transaction again.
     * @param userGuid The unique identifier for the user. Defined by MX. (required)
     * @param transactionGuid The unique identifier for the transaction. Defined by MX. (required)
     * @param splitTransactionRequestBody  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersUserGuidTransactionsTransactionGuidSplitPostAsync(String userGuid, String transactionGuid, SplitTransactionRequestBody splitTransactionRequestBody, final ApiCallback<SplitTransactionsResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = usersUserGuidTransactionsTransactionGuidSplitPostValidateBeforeCall(userGuid, transactionGuid, splitTransactionRequestBody, _callback);
        Type localVarReturnType = new TypeToken<SplitTransactionsResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for verifyMember
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call verifyMemberCall(String memberGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/members/{member_guid}/verify"
            .replace("{" + "member_guid" + "}", localVarApiClient.escapeString(memberGuid.toString()))
            .replace("{" + "user_guid" + "}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call verifyMemberValidateBeforeCall(String memberGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling verifyMember(Async)");
        }

        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling verifyMember(Async)");
        }

        return verifyMemberCall(memberGuid, userGuid, _callback);

    }

    /**
     * Verify member
     * The verify endpoint begins a verification process for a member.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return MemberResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public MemberResponseBody verifyMember(String memberGuid, String userGuid) throws ApiException {
        ApiResponse<MemberResponseBody> localVarResp = verifyMemberWithHttpInfo(memberGuid, userGuid);
        return localVarResp.getData();
    }

    /**
     * Verify member
     * The verify endpoint begins a verification process for a member.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;MemberResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MemberResponseBody> verifyMemberWithHttpInfo(String memberGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = verifyMemberValidateBeforeCall(memberGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Verify member (asynchronously)
     * The verify endpoint begins a verification process for a member.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call verifyMemberAsync(String memberGuid, String userGuid, final ApiCallback<MemberResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = verifyMemberValidateBeforeCall(memberGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
