/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.httpserver.log.syslog;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.nesscomputing.galaxy.GalaxyConfig;
import com.nesscomputing.httpserver.log.LogFields;
import com.nesscomputing.httpserver.log.syslog.SyslogRequestLogConfig;
import com.nesscomputing.logging.Log;
import com.nesscomputing.syslog4j.Syslog;
import com.nesscomputing.syslog4j.SyslogConfigIF;
import com.nesscomputing.syslog4j.SyslogIF;
import com.nesscomputing.syslog4j.SyslogMessageIF;
import com.nesscomputing.syslog4j.SyslogMessageProcessorIF;
import com.nesscomputing.syslog4j.impl.message.processor.structured.StructuredSyslogMessageProcessor;
import com.nesscomputing.syslog4j.impl.message.structured.StructuredSyslogMessage;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.component.AbstractLifeCycle;

@Singleton
public class SyslogRequestLog
extends AbstractLifeCycle
implements RequestLog {
    private static final Log LOG = Log.findLog();
    private final Set<String> blackList;
    private final SyslogIF syslog;
    private final List<String> logFields;
    private final Map<String, LogFields.LogField> knownFields;
    private final int ianaIdentifier;
    private GalaxyConfig galaxyConfig = null;

    @Inject
    public SyslogRequestLog(SyslogRequestLogConfig requestLogConfig, Map<String, LogFields.LogField> knownFields) {
        this.blackList = requestLogConfig.getBlacklist();
        List<String> logFields = requestLogConfig.getLogFields();
        LogFields.validateLogFields(knownFields, logFields);
        this.logFields = logFields;
        this.knownFields = knownFields;
        this.ianaIdentifier = requestLogConfig.getIanaIdentifier();
        SyslogIF syslog = Syslog.getInstance((String)requestLogConfig.getProtocol());
        if (syslog == null) {
            LOG.warn("No syslog instance for protocol '%s' available!", new Object[]{requestLogConfig.getProtocol()});
        } else {
            SyslogConfigIF syslogConfig = syslog.getConfig();
            syslogConfig.setUseStructuredData(true);
            syslogConfig.setTruncateMessage(true);
            syslogConfig.setMaxMessageLength(syslogConfig.getMaxMessageLength());
            syslogConfig.setCharSet(Charset.forName(requestLogConfig.getCharset()));
            syslogConfig.setFacility(requestLogConfig.getFacility());
            syslogConfig.setHost(requestLogConfig.getSyslogHost());
            syslogConfig.setPort(requestLogConfig.getSyslogPort());
            syslogConfig.setIdent("");
            syslogConfig.setLocalName(requestLogConfig.getHostname());
            StructuredSyslogMessageProcessor messageProcessor = new StructuredSyslogMessageProcessor(requestLogConfig.getAppname());
            syslog.setStructuredMessageProcessor((SyslogMessageProcessorIF)messageProcessor);
        }
        this.syslog = syslog;
    }

    @Inject(optional=true)
    void setGalaxyConfig(GalaxyConfig galaxyConfig) {
        this.galaxyConfig = galaxyConfig;
    }

    public void doStop() {
        if (this.syslog != null) {
            this.syslog.flush();
        }
    }

    public void log(Request request, Response response) {
        if (this.syslog == null) {
            return;
        }
        String requestUri = request.getRequestURI();
        for (String blackListEntry : this.blackList) {
            if (!StringUtils.startsWith((CharSequence)requestUri, (CharSequence)blackListEntry)) continue;
            return;
        }
        String messageId = UUID.randomUUID().toString().replace("-", "");
        HashMap builderMap = Maps.newHashMap();
        ImmutableMap.Builder logBuilder = ImmutableMap.builder();
        builderMap.put("l@" + this.ianaIdentifier, logBuilder);
        if (this.galaxyConfig != null) {
            logBuilder.put((Object)"si", (Object)this.galaxyConfig.getEnv().getAgentId());
            logBuilder.put((Object)"sc", (Object)this.galaxyConfig.getDeploy().getConfig());
        }
        Iterator<String> it = this.logFields.iterator();
        while (it.hasNext()) {
            String[] chunks = StringUtils.split((String)it.next(), (String)":");
            LogFields.LogField field = this.knownFields.get(chunks[0]);
            if (chunks.length == 1) {
                logBuilder.put((Object)field.getShortName(), (Object)ObjectUtils.toString((Object)field.log(request, response, null)));
                continue;
            }
            if (chunks.length != 2) continue;
            String fieldName = field.getShortName() + "@" + this.ianaIdentifier;
            ImmutableMap.Builder subBuilder = (ImmutableMap.Builder)builderMap.get(fieldName);
            if (subBuilder == null) {
                subBuilder = new ImmutableMap.Builder();
                builderMap.put(fieldName, subBuilder);
            }
            String fieldKey = chunks[1].toLowerCase(Locale.ENGLISH).replace("=", "_");
            subBuilder.put((Object)fieldKey, (Object)ObjectUtils.toString((Object)field.log(request, response, chunks[1])));
        }
        StructuredSyslogMessage structuredMessage = new StructuredSyslogMessage(messageId, Thread.currentThread().getName(), Maps.transformValues((Map)builderMap, (Function)new Function<ImmutableMap.Builder<String, String>, Map<String, String>>(){

            public Map<String, String> apply(ImmutableMap.Builder<String, String> builder) {
                return builder.build();
            }
        }), null);
        this.syslog.info((SyslogMessageIF)structuredMessage);
    }
}

