/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.httpserver.log.file;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.nesscomputing.config.Config;
import com.nesscomputing.httpserver.HttpServerHandlerBinder;
import com.nesscomputing.httpserver.log.file.FileRequestLog;
import com.nesscomputing.httpserver.log.file.FileRequestLogConfig;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.handler.RequestLogHandler;

public class FileRequestLogModule
extends AbstractModule {
    private final Config config;

    public FileRequestLogModule(Config config) {
        this.config = config;
    }

    public void configure() {
        FileRequestLogConfig fileRequestLogConfig = (FileRequestLogConfig)this.config.getBean("ness.httpserver.request-log.file", FileRequestLogConfig.class);
        if (fileRequestLogConfig.isEnabled()) {
            this.bind(FileRequestLogConfig.class).toInstance((Object)fileRequestLogConfig);
            this.bind(FileRequestLog.class).in(Scopes.SINGLETON);
            HttpServerHandlerBinder.bindHandler(this.binder()).toProvider(HandlerProvider.class);
        }
    }

    public static class HandlerProvider
    implements Provider<RequestLogHandler> {
        private final FileRequestLog fileRequestLog;

        @Inject
        public HandlerProvider(FileRequestLog fileRequestLog) {
            this.fileRequestLog = fileRequestLog;
        }

        public RequestLogHandler get() {
            RequestLogHandler handler = new RequestLogHandler();
            handler.setRequestLog((RequestLog)this.fileRequestLog);
            return handler;
        }
    }
}

