/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.http.AmazonRxNettyHttpClient;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.services.ServiceResult;
import com.amazonaws.services.elastictranscoder.AmazonElasticTranscoderRxNetty;
import com.amazonaws.services.elastictranscoder.model.CancelJobRequest;
import com.amazonaws.services.elastictranscoder.model.CancelJobResult;
import com.amazonaws.services.elastictranscoder.model.CreateJobRequest;
import com.amazonaws.services.elastictranscoder.model.CreateJobResult;
import com.amazonaws.services.elastictranscoder.model.CreatePipelineRequest;
import com.amazonaws.services.elastictranscoder.model.CreatePipelineResult;
import com.amazonaws.services.elastictranscoder.model.CreatePresetRequest;
import com.amazonaws.services.elastictranscoder.model.CreatePresetResult;
import com.amazonaws.services.elastictranscoder.model.DeletePipelineRequest;
import com.amazonaws.services.elastictranscoder.model.DeletePipelineResult;
import com.amazonaws.services.elastictranscoder.model.DeletePresetRequest;
import com.amazonaws.services.elastictranscoder.model.DeletePresetResult;
import com.amazonaws.services.elastictranscoder.model.ListJobsByPipelineRequest;
import com.amazonaws.services.elastictranscoder.model.ListJobsByPipelineResult;
import com.amazonaws.services.elastictranscoder.model.ListJobsByStatusRequest;
import com.amazonaws.services.elastictranscoder.model.ListJobsByStatusResult;
import com.amazonaws.services.elastictranscoder.model.ListPipelinesRequest;
import com.amazonaws.services.elastictranscoder.model.ListPipelinesResult;
import com.amazonaws.services.elastictranscoder.model.ListPresetsRequest;
import com.amazonaws.services.elastictranscoder.model.ListPresetsResult;
import com.amazonaws.services.elastictranscoder.model.ReadJobRequest;
import com.amazonaws.services.elastictranscoder.model.ReadJobResult;
import com.amazonaws.services.elastictranscoder.model.ReadPipelineRequest;
import com.amazonaws.services.elastictranscoder.model.ReadPipelineResult;
import com.amazonaws.services.elastictranscoder.model.ReadPresetRequest;
import com.amazonaws.services.elastictranscoder.model.ReadPresetResult;
import com.amazonaws.services.elastictranscoder.model.TestRoleRequest;
import com.amazonaws.services.elastictranscoder.model.TestRoleResult;
import com.amazonaws.services.elastictranscoder.model.UpdatePipelineNotificationsRequest;
import com.amazonaws.services.elastictranscoder.model.UpdatePipelineNotificationsResult;
import com.amazonaws.services.elastictranscoder.model.UpdatePipelineRequest;
import com.amazonaws.services.elastictranscoder.model.UpdatePipelineResult;
import com.amazonaws.services.elastictranscoder.model.UpdatePipelineStatusRequest;
import com.amazonaws.services.elastictranscoder.model.UpdatePipelineStatusResult;
import com.amazonaws.services.elastictranscoder.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.CancelJobRequestMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.CancelJobResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.CreateJobRequestMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.CreateJobResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.CreatePipelineRequestMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.CreatePipelineResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.CreatePresetRequestMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.CreatePresetResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.DeletePipelineRequestMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.DeletePipelineResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.DeletePresetRequestMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.DeletePresetResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.IncompatibleVersionExceptionUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.InternalServiceExceptionUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ListJobsByPipelineRequestMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ListJobsByPipelineResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ListJobsByStatusRequestMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ListJobsByStatusResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ListPipelinesRequestMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ListPipelinesResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ListPresetsRequestMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ListPresetsResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ReadJobRequestMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ReadJobResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ReadPipelineRequestMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ReadPipelineResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ReadPresetRequestMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ReadPresetResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ResourceInUseExceptionUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.TestRoleRequestMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.TestRoleResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.UpdatePipelineNotificationsRequestMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.UpdatePipelineNotificationsResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.UpdatePipelineRequestMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.UpdatePipelineResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.UpdatePipelineStatusRequestMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.UpdatePipelineStatusResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.RxSchedulers;
import java.util.ArrayList;
import java.util.List;
import rx.Observable;

public class AmazonElasticTranscoderRxNettyClient
extends AmazonRxNettyHttpClient
implements AmazonElasticTranscoderRxNetty {
    protected List<JsonErrorUnmarshaller> exceptionUnmarshallers;

    public AmazonElasticTranscoderRxNettyClient() {
    }

    public AmazonElasticTranscoderRxNettyClient(AWSCredentialsProvider aWSCredentialsProvider) {
        super(aWSCredentialsProvider);
    }

    public AmazonElasticTranscoderRxNettyClient(ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
    }

    public AmazonElasticTranscoderRxNettyClient(AWSCredentialsProvider aWSCredentialsProvider, ClientConfiguration clientConfiguration) {
        super(aWSCredentialsProvider, clientConfiguration);
    }

    protected void init() {
        this.setEndpoint("elastictranscoder.us-east-1.amazonaws.com");
        this.exceptionUnmarshallers = new ArrayList<JsonErrorUnmarshaller>();
        this.exceptionUnmarshallers.add((JsonErrorUnmarshaller)new AccessDeniedExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((JsonErrorUnmarshaller)new IncompatibleVersionExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((JsonErrorUnmarshaller)new InternalServiceExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((JsonErrorUnmarshaller)new LimitExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((JsonErrorUnmarshaller)new ResourceInUseExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((JsonErrorUnmarshaller)new ResourceNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((JsonErrorUnmarshaller)new ValidationExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new JsonErrorUnmarshaller());
    }

    @Override
    public Observable<ServiceResult<CancelJobResult>> cancelJob(CancelJobRequest cancelJobRequest2) {
        return Observable.just((Object)cancelJobRequest2).observeOn(RxSchedulers.computation()).flatMap(cancelJobRequest -> {
            long l = System.currentTimeMillis();
            ExecutionContext executionContext = this.createExecutionContext((AmazonWebServiceRequest)cancelJobRequest);
            AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
            Request request = new CancelJobRequestMarshaller().marshall(cancelJobRequest);
            request.setAWSRequestMetrics(aWSRequestMetrics);
            CancelJobResultJsonUnmarshaller cancelJobResultJsonUnmarshaller = CancelJobResultJsonUnmarshaller.getInstance();
            return this.invokeJson(request, (Unmarshaller)cancelJobResultJsonUnmarshaller, this.exceptionUnmarshallers, executionContext).map(cancelJobResult -> new ServiceResult(l, cancelJobResult));
        });
    }

    @Override
    public Observable<ServiceResult<CreateJobResult>> createJob(CreateJobRequest createJobRequest2) {
        return Observable.just((Object)createJobRequest2).observeOn(RxSchedulers.computation()).flatMap(createJobRequest -> {
            long l = System.currentTimeMillis();
            ExecutionContext executionContext = this.createExecutionContext((AmazonWebServiceRequest)createJobRequest);
            AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
            Request request = new CreateJobRequestMarshaller().marshall(createJobRequest);
            request.setAWSRequestMetrics(aWSRequestMetrics);
            CreateJobResultJsonUnmarshaller createJobResultJsonUnmarshaller = CreateJobResultJsonUnmarshaller.getInstance();
            return this.invokeJson(request, (Unmarshaller)createJobResultJsonUnmarshaller, this.exceptionUnmarshallers, executionContext).map(createJobResult -> new ServiceResult(l, createJobResult));
        });
    }

    @Override
    public Observable<ServiceResult<CreatePipelineResult>> createPipeline(CreatePipelineRequest createPipelineRequest2) {
        return Observable.just((Object)createPipelineRequest2).observeOn(RxSchedulers.computation()).flatMap(createPipelineRequest -> {
            long l = System.currentTimeMillis();
            ExecutionContext executionContext = this.createExecutionContext((AmazonWebServiceRequest)createPipelineRequest);
            AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
            Request request = new CreatePipelineRequestMarshaller().marshall(createPipelineRequest);
            request.setAWSRequestMetrics(aWSRequestMetrics);
            CreatePipelineResultJsonUnmarshaller createPipelineResultJsonUnmarshaller = CreatePipelineResultJsonUnmarshaller.getInstance();
            return this.invokeJson(request, (Unmarshaller)createPipelineResultJsonUnmarshaller, this.exceptionUnmarshallers, executionContext).map(createPipelineResult -> new ServiceResult(l, createPipelineResult));
        });
    }

    @Override
    public Observable<ServiceResult<CreatePresetResult>> createPreset(CreatePresetRequest createPresetRequest2) {
        return Observable.just((Object)createPresetRequest2).observeOn(RxSchedulers.computation()).flatMap(createPresetRequest -> {
            long l = System.currentTimeMillis();
            ExecutionContext executionContext = this.createExecutionContext((AmazonWebServiceRequest)createPresetRequest);
            AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
            Request request = new CreatePresetRequestMarshaller().marshall(createPresetRequest);
            request.setAWSRequestMetrics(aWSRequestMetrics);
            CreatePresetResultJsonUnmarshaller createPresetResultJsonUnmarshaller = CreatePresetResultJsonUnmarshaller.getInstance();
            return this.invokeJson(request, (Unmarshaller)createPresetResultJsonUnmarshaller, this.exceptionUnmarshallers, executionContext).map(createPresetResult -> new ServiceResult(l, createPresetResult));
        });
    }

    @Override
    public Observable<ServiceResult<DeletePipelineResult>> deletePipeline(DeletePipelineRequest deletePipelineRequest2) {
        return Observable.just((Object)deletePipelineRequest2).observeOn(RxSchedulers.computation()).flatMap(deletePipelineRequest -> {
            long l = System.currentTimeMillis();
            ExecutionContext executionContext = this.createExecutionContext((AmazonWebServiceRequest)deletePipelineRequest);
            AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
            Request request = new DeletePipelineRequestMarshaller().marshall(deletePipelineRequest);
            request.setAWSRequestMetrics(aWSRequestMetrics);
            DeletePipelineResultJsonUnmarshaller deletePipelineResultJsonUnmarshaller = DeletePipelineResultJsonUnmarshaller.getInstance();
            return this.invokeJson(request, (Unmarshaller)deletePipelineResultJsonUnmarshaller, this.exceptionUnmarshallers, executionContext).map(deletePipelineResult -> new ServiceResult(l, deletePipelineResult));
        });
    }

    @Override
    public Observable<ServiceResult<DeletePresetResult>> deletePreset(DeletePresetRequest deletePresetRequest2) {
        return Observable.just((Object)deletePresetRequest2).observeOn(RxSchedulers.computation()).flatMap(deletePresetRequest -> {
            long l = System.currentTimeMillis();
            ExecutionContext executionContext = this.createExecutionContext((AmazonWebServiceRequest)deletePresetRequest);
            AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
            Request request = new DeletePresetRequestMarshaller().marshall(deletePresetRequest);
            request.setAWSRequestMetrics(aWSRequestMetrics);
            DeletePresetResultJsonUnmarshaller deletePresetResultJsonUnmarshaller = DeletePresetResultJsonUnmarshaller.getInstance();
            return this.invokeJson(request, (Unmarshaller)deletePresetResultJsonUnmarshaller, this.exceptionUnmarshallers, executionContext).map(deletePresetResult -> new ServiceResult(l, deletePresetResult));
        });
    }

    @Override
    public Observable<ServiceResult<ListJobsByPipelineResult>> listJobsByPipeline(ListJobsByPipelineRequest listJobsByPipelineRequest2) {
        return Observable.just((Object)listJobsByPipelineRequest2).observeOn(RxSchedulers.computation()).flatMap(listJobsByPipelineRequest -> {
            long l = System.currentTimeMillis();
            ExecutionContext executionContext = this.createExecutionContext((AmazonWebServiceRequest)listJobsByPipelineRequest);
            AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
            Request request = new ListJobsByPipelineRequestMarshaller().marshall(listJobsByPipelineRequest);
            request.setAWSRequestMetrics(aWSRequestMetrics);
            ListJobsByPipelineResultJsonUnmarshaller listJobsByPipelineResultJsonUnmarshaller = ListJobsByPipelineResultJsonUnmarshaller.getInstance();
            return this.invokeJson(request, (Unmarshaller)listJobsByPipelineResultJsonUnmarshaller, this.exceptionUnmarshallers, executionContext).map(listJobsByPipelineResult -> new ServiceResult(l, listJobsByPipelineResult));
        });
    }

    @Override
    public Observable<ServiceResult<ListJobsByStatusResult>> listJobsByStatus(ListJobsByStatusRequest listJobsByStatusRequest2) {
        return Observable.just((Object)listJobsByStatusRequest2).observeOn(RxSchedulers.computation()).flatMap(listJobsByStatusRequest -> {
            long l = System.currentTimeMillis();
            ExecutionContext executionContext = this.createExecutionContext((AmazonWebServiceRequest)listJobsByStatusRequest);
            AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
            Request request = new ListJobsByStatusRequestMarshaller().marshall(listJobsByStatusRequest);
            request.setAWSRequestMetrics(aWSRequestMetrics);
            ListJobsByStatusResultJsonUnmarshaller listJobsByStatusResultJsonUnmarshaller = ListJobsByStatusResultJsonUnmarshaller.getInstance();
            return this.invokeJson(request, (Unmarshaller)listJobsByStatusResultJsonUnmarshaller, this.exceptionUnmarshallers, executionContext).map(listJobsByStatusResult -> new ServiceResult(l, listJobsByStatusResult));
        });
    }

    @Override
    public Observable<ServiceResult<ListPipelinesResult>> listPipelines() {
        return this.listPipelines(new ListPipelinesRequest());
    }

    @Override
    public Observable<ServiceResult<ListPipelinesResult>> listPipelines(ListPipelinesRequest listPipelinesRequest2) {
        return Observable.just((Object)listPipelinesRequest2).observeOn(RxSchedulers.computation()).flatMap(listPipelinesRequest -> {
            long l = System.currentTimeMillis();
            ExecutionContext executionContext = this.createExecutionContext((AmazonWebServiceRequest)listPipelinesRequest);
            AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
            Request request = new ListPipelinesRequestMarshaller().marshall(listPipelinesRequest);
            request.setAWSRequestMetrics(aWSRequestMetrics);
            ListPipelinesResultJsonUnmarshaller listPipelinesResultJsonUnmarshaller = ListPipelinesResultJsonUnmarshaller.getInstance();
            return this.invokeJson(request, (Unmarshaller)listPipelinesResultJsonUnmarshaller, this.exceptionUnmarshallers, executionContext).map(listPipelinesResult -> new ServiceResult(l, listPipelinesResult));
        });
    }

    @Override
    public Observable<ServiceResult<ListPresetsResult>> listPresets() {
        return this.listPresets(new ListPresetsRequest());
    }

    @Override
    public Observable<ServiceResult<ListPresetsResult>> listPresets(ListPresetsRequest listPresetsRequest2) {
        return Observable.just((Object)listPresetsRequest2).observeOn(RxSchedulers.computation()).flatMap(listPresetsRequest -> {
            long l = System.currentTimeMillis();
            ExecutionContext executionContext = this.createExecutionContext((AmazonWebServiceRequest)listPresetsRequest);
            AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
            Request request = new ListPresetsRequestMarshaller().marshall(listPresetsRequest);
            request.setAWSRequestMetrics(aWSRequestMetrics);
            ListPresetsResultJsonUnmarshaller listPresetsResultJsonUnmarshaller = ListPresetsResultJsonUnmarshaller.getInstance();
            return this.invokeJson(request, (Unmarshaller)listPresetsResultJsonUnmarshaller, this.exceptionUnmarshallers, executionContext).map(listPresetsResult -> new ServiceResult(l, listPresetsResult));
        });
    }

    @Override
    public Observable<ServiceResult<ReadJobResult>> readJob(ReadJobRequest readJobRequest2) {
        return Observable.just((Object)readJobRequest2).observeOn(RxSchedulers.computation()).flatMap(readJobRequest -> {
            long l = System.currentTimeMillis();
            ExecutionContext executionContext = this.createExecutionContext((AmazonWebServiceRequest)readJobRequest);
            AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
            Request request = new ReadJobRequestMarshaller().marshall(readJobRequest);
            request.setAWSRequestMetrics(aWSRequestMetrics);
            ReadJobResultJsonUnmarshaller readJobResultJsonUnmarshaller = ReadJobResultJsonUnmarshaller.getInstance();
            return this.invokeJson(request, (Unmarshaller)readJobResultJsonUnmarshaller, this.exceptionUnmarshallers, executionContext).map(readJobResult -> new ServiceResult(l, readJobResult));
        });
    }

    @Override
    public Observable<ServiceResult<ReadPipelineResult>> readPipeline(ReadPipelineRequest readPipelineRequest2) {
        return Observable.just((Object)readPipelineRequest2).observeOn(RxSchedulers.computation()).flatMap(readPipelineRequest -> {
            long l = System.currentTimeMillis();
            ExecutionContext executionContext = this.createExecutionContext((AmazonWebServiceRequest)readPipelineRequest);
            AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
            Request request = new ReadPipelineRequestMarshaller().marshall(readPipelineRequest);
            request.setAWSRequestMetrics(aWSRequestMetrics);
            ReadPipelineResultJsonUnmarshaller readPipelineResultJsonUnmarshaller = ReadPipelineResultJsonUnmarshaller.getInstance();
            return this.invokeJson(request, (Unmarshaller)readPipelineResultJsonUnmarshaller, this.exceptionUnmarshallers, executionContext).map(readPipelineResult -> new ServiceResult(l, readPipelineResult));
        });
    }

    @Override
    public Observable<ServiceResult<ReadPresetResult>> readPreset(ReadPresetRequest readPresetRequest2) {
        return Observable.just((Object)readPresetRequest2).observeOn(RxSchedulers.computation()).flatMap(readPresetRequest -> {
            long l = System.currentTimeMillis();
            ExecutionContext executionContext = this.createExecutionContext((AmazonWebServiceRequest)readPresetRequest);
            AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
            Request request = new ReadPresetRequestMarshaller().marshall(readPresetRequest);
            request.setAWSRequestMetrics(aWSRequestMetrics);
            ReadPresetResultJsonUnmarshaller readPresetResultJsonUnmarshaller = ReadPresetResultJsonUnmarshaller.getInstance();
            return this.invokeJson(request, (Unmarshaller)readPresetResultJsonUnmarshaller, this.exceptionUnmarshallers, executionContext).map(readPresetResult -> new ServiceResult(l, readPresetResult));
        });
    }

    @Override
    public Observable<ServiceResult<TestRoleResult>> testRole(TestRoleRequest testRoleRequest2) {
        return Observable.just((Object)testRoleRequest2).observeOn(RxSchedulers.computation()).flatMap(testRoleRequest -> {
            long l = System.currentTimeMillis();
            ExecutionContext executionContext = this.createExecutionContext((AmazonWebServiceRequest)testRoleRequest);
            AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
            Request request = new TestRoleRequestMarshaller().marshall(testRoleRequest);
            request.setAWSRequestMetrics(aWSRequestMetrics);
            TestRoleResultJsonUnmarshaller testRoleResultJsonUnmarshaller = TestRoleResultJsonUnmarshaller.getInstance();
            return this.invokeJson(request, (Unmarshaller)testRoleResultJsonUnmarshaller, this.exceptionUnmarshallers, executionContext).map(testRoleResult -> new ServiceResult(l, testRoleResult));
        });
    }

    @Override
    public Observable<ServiceResult<UpdatePipelineResult>> updatePipeline(UpdatePipelineRequest updatePipelineRequest2) {
        return Observable.just((Object)updatePipelineRequest2).observeOn(RxSchedulers.computation()).flatMap(updatePipelineRequest -> {
            long l = System.currentTimeMillis();
            ExecutionContext executionContext = this.createExecutionContext((AmazonWebServiceRequest)updatePipelineRequest);
            AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
            Request request = new UpdatePipelineRequestMarshaller().marshall(updatePipelineRequest);
            request.setAWSRequestMetrics(aWSRequestMetrics);
            UpdatePipelineResultJsonUnmarshaller updatePipelineResultJsonUnmarshaller = UpdatePipelineResultJsonUnmarshaller.getInstance();
            return this.invokeJson(request, (Unmarshaller)updatePipelineResultJsonUnmarshaller, this.exceptionUnmarshallers, executionContext).map(updatePipelineResult -> new ServiceResult(l, updatePipelineResult));
        });
    }

    @Override
    public Observable<ServiceResult<UpdatePipelineNotificationsResult>> updatePipelineNotifications(UpdatePipelineNotificationsRequest updatePipelineNotificationsRequest2) {
        return Observable.just((Object)updatePipelineNotificationsRequest2).observeOn(RxSchedulers.computation()).flatMap(updatePipelineNotificationsRequest -> {
            long l = System.currentTimeMillis();
            ExecutionContext executionContext = this.createExecutionContext((AmazonWebServiceRequest)updatePipelineNotificationsRequest);
            AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
            Request request = new UpdatePipelineNotificationsRequestMarshaller().marshall(updatePipelineNotificationsRequest);
            request.setAWSRequestMetrics(aWSRequestMetrics);
            UpdatePipelineNotificationsResultJsonUnmarshaller updatePipelineNotificationsResultJsonUnmarshaller = UpdatePipelineNotificationsResultJsonUnmarshaller.getInstance();
            return this.invokeJson(request, (Unmarshaller)updatePipelineNotificationsResultJsonUnmarshaller, this.exceptionUnmarshallers, executionContext).map(updatePipelineNotificationsResult -> new ServiceResult(l, updatePipelineNotificationsResult));
        });
    }

    @Override
    public Observable<ServiceResult<UpdatePipelineStatusResult>> updatePipelineStatus(UpdatePipelineStatusRequest updatePipelineStatusRequest2) {
        return Observable.just((Object)updatePipelineStatusRequest2).observeOn(RxSchedulers.computation()).flatMap(updatePipelineStatusRequest -> {
            long l = System.currentTimeMillis();
            ExecutionContext executionContext = this.createExecutionContext((AmazonWebServiceRequest)updatePipelineStatusRequest);
            AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
            Request request = new UpdatePipelineStatusRequestMarshaller().marshall(updatePipelineStatusRequest);
            request.setAWSRequestMetrics(aWSRequestMetrics);
            UpdatePipelineStatusResultJsonUnmarshaller updatePipelineStatusResultJsonUnmarshaller = UpdatePipelineStatusResultJsonUnmarshaller.getInstance();
            return this.invokeJson(request, (Unmarshaller)updatePipelineStatusResultJsonUnmarshaller, this.exceptionUnmarshallers, executionContext).map(updatePipelineStatusResult -> new ServiceResult(l, updatePipelineStatusResult));
        });
    }
}

