/*
 * Decompiled with CFR 0.152.
 */
package rx.android.schedulers;

import android.os.Handler;
import java.util.concurrent.TimeUnit;
import rx.Scheduler;
import rx.Subscription;
import rx.functions.Action1;
import rx.subscriptions.BooleanSubscription;

public class HandlerThreadScheduler
extends Scheduler {
    private final Handler handler;

    public HandlerThreadScheduler(Handler handler) {
        this.handler = handler;
    }

    public Subscription schedule(Action1<Scheduler.Inner> action) {
        InnerHandlerThreadScheduler inner = new InnerHandlerThreadScheduler(this.handler);
        inner.schedule(action);
        return inner;
    }

    public Subscription schedule(Action1<Scheduler.Inner> action, long delayTime, TimeUnit unit) {
        InnerHandlerThreadScheduler inner = new InnerHandlerThreadScheduler(this.handler);
        inner.schedule(action, delayTime, unit);
        return inner;
    }

    private static class InnerHandlerThreadScheduler
    extends Scheduler.Inner {
        private final Handler handler;
        private BooleanSubscription innerSubscription = new BooleanSubscription();
        private Scheduler.Inner _inner = this;

        public InnerHandlerThreadScheduler(Handler handler) {
            this.handler = handler;
        }

        public void unsubscribe() {
            this.innerSubscription.unsubscribe();
        }

        public boolean isUnsubscribed() {
            return this.innerSubscription.isUnsubscribed();
        }

        public void schedule(final Action1<Scheduler.Inner> action, long delayTime, TimeUnit unit) {
            this.handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (InnerHandlerThreadScheduler.this._inner.isUnsubscribed()) {
                        return;
                    }
                    action.call((Object)InnerHandlerThreadScheduler.this._inner);
                }
            }, unit.toMillis(delayTime));
        }

        public void schedule(final Action1<Scheduler.Inner> action) {
            this.handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (InnerHandlerThreadScheduler.this._inner.isUnsubscribed()) {
                        return;
                    }
                    action.call((Object)InnerHandlerThreadScheduler.this._inner);
                }
            }, 0L);
        }
    }
}

