/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import rx.Subscription;
import rx.functions.Action1;
import rx.functions.Action2;
import rx.functions.Func1;
import rx.operators.DebugSubscriber;
import rx.plugins.DebugNotification;

final class DebugSubscription<T, C>
implements Subscription {
    private final DebugSubscriber<T, C> debugObserver;
    private final Func1<DebugNotification, C> start;
    private final Action1<C> complete;
    private final Action2<C, Throwable> error;

    DebugSubscription(DebugSubscriber<T, C> debugObserver, Func1<DebugNotification, C> start, Action1<C> complete, Action2<C, Throwable> error) {
        this.debugObserver = debugObserver;
        this.start = start;
        this.complete = complete;
        this.error = error;
    }

    public void unsubscribe() {
        DebugNotification n = DebugNotification.createUnsubscribe(this.debugObserver.getActual(), this.debugObserver.getFrom(), this.debugObserver.getTo());
        Object context = this.start.call(n);
        try {
            this.debugObserver.unsubscribe();
            this.complete.call(context);
        }
        catch (Throwable e) {
            this.error.call(context, (Object)e);
        }
    }

    public boolean isUnsubscribed() {
        return this.debugObserver.isUnsubscribed();
    }
}

