/*
 * Decompiled with CFR 0.152.
 */
package rx.plugins;

import rx.Observable;
import rx.Observer;
import rx.observers.SafeSubscriber;
import rx.operators.DebugSubscriber;
import rx.plugins.DebugHook;

public class DebugNotification<T, C> {
    private final Observable<? extends T> source;
    private final Observable.OnSubscribe<T> sourceFunc;
    private final Observable.Operator<? extends T, ?> from;
    private final Kind kind;
    private final Observable.Operator<?, ? super T> to;
    private final Throwable throwable;
    private final T value;
    private final Observer observer;

    public static <T, C> DebugNotification<T, C> createSubscribe(Observer<? super T> o, Observable<? extends T> source, Observable.OnSubscribe<T> sourceFunc) {
        Observable.Operator to = null;
        Observable.Operator from = null;
        if (o instanceof SafeSubscriber) {
            o = ((SafeSubscriber)o).getActual();
        }
        if (o instanceof DebugSubscriber) {
            to = ((DebugSubscriber)o).getTo();
            from = ((DebugSubscriber)o).getFrom();
            o = ((DebugSubscriber)o).getActual();
        }
        if (sourceFunc instanceof DebugHook.OnCreateWrapper) {
            sourceFunc = ((DebugHook.OnCreateWrapper)sourceFunc).getActual();
        }
        return new DebugNotification<T, C>(o, from, Kind.Subscribe, null, null, to, source, sourceFunc);
    }

    public static <T, C> DebugNotification<T, C> createOnNext(Observer<? super T> o, Observable.Operator<? extends T, ?> from, T t, Observable.Operator<?, ? super T> to) {
        return new DebugNotification<T, C>((Observer)o, from, Kind.OnNext, t, null, to, null, null);
    }

    public static <T, C> DebugNotification<T, C> createOnError(Observer<? super T> o, Observable.Operator<? extends T, ?> from, Throwable e, Observable.Operator<?, ? super T> to) {
        return new DebugNotification<T, C>(o, from, Kind.OnError, null, e, to, null, null);
    }

    public static <T, C> DebugNotification<T, C> createOnCompleted(Observer<? super T> o, Observable.Operator<? extends T, ?> from, Observable.Operator<?, ? super T> to) {
        return new DebugNotification<T, C>(o, from, Kind.OnCompleted, null, null, to, null, null);
    }

    public static <T, C> DebugNotification<T, C> createUnsubscribe(Observer<? super T> o, Observable.Operator<? extends T, ?> from, Observable.Operator<?, ? super T> to) {
        return new DebugNotification<T, C>(o, from, Kind.Unsubscribe, null, null, to, null, null);
    }

    private DebugNotification(Observer o, Observable.Operator<? extends T, ?> from, Kind kind, T value, Throwable throwable, Observable.Operator<?, ? super T> to, Observable<? extends T> source, Observable.OnSubscribe<T> sourceFunc) {
        this.observer = o instanceof SafeSubscriber ? ((SafeSubscriber)o).getActual() : o;
        this.from = from;
        this.kind = kind;
        this.value = value;
        this.throwable = throwable;
        this.to = to;
        this.source = source;
        this.sourceFunc = sourceFunc;
    }

    public Observer getObserver() {
        return this.observer;
    }

    public Observable.Operator<? extends T, ?> getFrom() {
        return this.from;
    }

    public T getValue() {
        return this.value;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public Observable.Operator<?, ? super T> getTo() {
        return this.to;
    }

    public Kind getKind() {
        return this.kind;
    }

    public Observable<? extends T> getSource() {
        return this.source;
    }

    public Observable.OnSubscribe<T> getSourceFunc() {
        return this.sourceFunc;
    }

    public String toString() {
        StringBuilder s = new StringBuilder("{");
        s.append("\"observer\": \"").append(this.observer.getClass().getName()).append("@").append(Integer.toHexString(this.observer.hashCode())).append("\"");
        s.append(", \"type\": \"").append((Object)this.kind).append("\"");
        if (this.kind == Kind.OnNext) {
            s.append(", \"value\": \"").append(this.value).append("\"");
        }
        if (this.kind == Kind.OnError) {
            s.append(", \"exception\": \"").append(this.throwable.getMessage().replace("\\", "\\\\").replace("\"", "\\\"")).append("\"");
        }
        if (this.source != null) {
            s.append(", \"source\": \"").append(this.source.getClass().getName()).append("@").append(Integer.toHexString(this.source.hashCode())).append("\"");
        }
        if (this.sourceFunc != null) {
            s.append(", \"sourceFunc\": \"").append(this.sourceFunc.getClass().getName()).append("@").append(Integer.toHexString(this.sourceFunc.hashCode())).append("\"");
        }
        if (this.from != null) {
            s.append(", \"from\": \"").append(this.from.getClass().getName()).append("@").append(Integer.toHexString(this.from.hashCode())).append("\"");
        }
        if (this.to != null) {
            s.append(", \"to\": \"").append(this.to.getClass().getName()).append("@").append(Integer.toHexString(this.to.hashCode())).append("\"");
        }
        s.append("}");
        return s.toString();
    }

    public static enum Kind {
        OnNext,
        OnError,
        OnCompleted,
        Subscribe,
        Unsubscribe;

    }
}

