/*
 * Decompiled with CFR 0.152.
 */
package rx.lang.jruby;

import org.jruby.Ruby;
import org.jruby.RubyProc;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import rx.functions.Action;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Action2;
import rx.functions.Action3;

public class JRubyActionWrapper<T1, T2, T3, T4>
implements Action,
Action0,
Action1<T1>,
Action2<T1, T2>,
Action3<T1, T2, T3> {
    private final RubyProc proc;
    private final ThreadContext context;
    private final Ruby runtime;

    public JRubyActionWrapper(ThreadContext context, RubyProc proc) {
        this.proc = proc;
        this.context = context;
        this.runtime = context.getRuntime();
    }

    public void call() {
        IRubyObject[] array = new IRubyObject[]{};
        this.proc.call(this.context, array);
    }

    public void call(T1 t1) {
        IRubyObject[] array = new IRubyObject[]{JavaUtil.convertJavaToRuby((Ruby)this.runtime, t1)};
        this.proc.call(this.context, array);
    }

    public void call(T1 t1, T2 t2) {
        IRubyObject[] array = new IRubyObject[]{JavaUtil.convertJavaToRuby((Ruby)this.runtime, t1), JavaUtil.convertJavaToRuby((Ruby)this.runtime, t2)};
        this.proc.call(this.context, array);
    }

    public void call(T1 t1, T2 t2, T3 t3) {
        IRubyObject[] array = new IRubyObject[]{JavaUtil.convertJavaToRuby((Ruby)this.runtime, t1), JavaUtil.convertJavaToRuby((Ruby)this.runtime, t2), JavaUtil.convertJavaToRuby((Ruby)this.runtime, t3)};
        this.proc.call(this.context, array);
    }
}

