/*
 * Decompiled with CFR 0.152.
 */
package rx.observables;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.functions.Func2;

public class StringObservable {
    public static Observable<byte[]> from(InputStream i) {
        return StringObservable.from(i, 8192);
    }

    public static <R, S extends Closeable> Observable<R> using(final UnsafeFunc0<S> resourceFactory, final Func1<S, Observable<R>> observableFactory) {
        return Observable.using((Func0)new Func0<CloseableResource<S>>(){

            public CloseableResource<S> call() {
                try {
                    return new CloseableResource<Closeable>((Closeable)resourceFactory.call());
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
        }, (Func1)new Func1<CloseableResource<S>, Observable<R>>(){

            public Observable<R> call(CloseableResource<S> t1) {
                return (Observable)observableFactory.call((Object)t1.closable);
            }
        });
    }

    public static Observable<byte[]> from(final InputStream i, final int size) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<byte[]>(){

            public void call(Subscriber<? super byte[]> o) {
                byte[] buffer = new byte[size];
                try {
                    if (o.isUnsubscribed()) {
                        return;
                    }
                    int n = i.read(buffer);
                    while (n != -1 && !o.isUnsubscribed()) {
                        o.onNext((Object)Arrays.copyOf(buffer, n));
                        if (o.isUnsubscribed()) continue;
                        n = i.read(buffer);
                    }
                }
                catch (IOException e) {
                    o.onError((Throwable)e);
                }
                if (o.isUnsubscribed()) {
                    return;
                }
                o.onCompleted();
            }
        });
    }

    public static Observable<String> from(Reader i) {
        return StringObservable.from(i, 8192);
    }

    public static Observable<String> from(final Reader i, final int size) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<String>(){

            public void call(Subscriber<? super String> o) {
                char[] buffer = new char[size];
                try {
                    if (o.isUnsubscribed()) {
                        return;
                    }
                    int n = 0;
                    n = i.read(buffer);
                    while (n != -1 && !o.isUnsubscribed()) {
                        o.onNext((Object)new String(buffer, 0, n));
                        n = i.read(buffer);
                    }
                }
                catch (IOException e) {
                    o.onError((Throwable)e);
                }
                if (o.isUnsubscribed()) {
                    return;
                }
                o.onCompleted();
            }
        });
    }

    public static Observable<String> decode(Observable<byte[]> src, String charsetName) {
        return StringObservable.decode(src, Charset.forName(charsetName));
    }

    public static Observable<String> decode(Observable<byte[]> src, Charset charset) {
        return StringObservable.decode(src, charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE));
    }

    public static Observable<String> decode(Observable<byte[]> src, final CharsetDecoder charsetDecoder) {
        return src.lift((Observable.Operator)new Observable.Operator<String, byte[]>(){

            public Subscriber<? super byte[]> call(final Subscriber<? super String> o) {
                return new Subscriber<byte[]>(o){
                    private ByteBuffer leftOver;
                    {
                        super(x0);
                        this.leftOver = null;
                    }

                    public void onCompleted() {
                        if (this.process(null, this.leftOver, true)) {
                            o.onCompleted();
                        }
                    }

                    public void onError(Throwable e) {
                        if (this.process(null, this.leftOver, true)) {
                            o.onError(e);
                        }
                    }

                    public void onNext(byte[] bytes) {
                        this.process(bytes, this.leftOver, false);
                    }

                    public boolean process(byte[] next, ByteBuffer last, boolean endOfInput) {
                        ByteBuffer bb;
                        if (o.isUnsubscribed()) {
                            return false;
                        }
                        if (last != null) {
                            if (next != null) {
                                bb = ByteBuffer.allocate(last.remaining() + next.length);
                                bb.put(last);
                                bb.put(next);
                                bb.flip();
                            } else {
                                bb = last;
                            }
                        } else if (next != null) {
                            bb = ByteBuffer.wrap(next);
                        } else {
                            return true;
                        }
                        CharBuffer cb = CharBuffer.allocate((int)((float)bb.limit() * charsetDecoder.averageCharsPerByte()));
                        CoderResult cr = charsetDecoder.decode(bb, cb, endOfInput);
                        cb.flip();
                        if (cr.isError()) {
                            try {
                                cr.throwException();
                            }
                            catch (CharacterCodingException e) {
                                o.onError((Throwable)e);
                                return false;
                            }
                        }
                        this.leftOver = bb.remaining() > 0 ? bb : null;
                        String string = cb.toString();
                        if (!string.isEmpty()) {
                            o.onNext((Object)string);
                        }
                        return true;
                    }
                };
            }
        });
    }

    public static Observable<byte[]> encode(Observable<String> src, String charsetName) {
        return StringObservable.encode(src, Charset.forName(charsetName));
    }

    public static Observable<byte[]> encode(Observable<String> src, Charset charset) {
        return StringObservable.encode(src, charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE));
    }

    public static Observable<byte[]> encode(Observable<String> src, final CharsetEncoder charsetEncoder) {
        return src.map((Func1)new Func1<String, byte[]>(){

            public byte[] call(String str) {
                ByteBuffer bb;
                CharBuffer cb = CharBuffer.wrap(str);
                try {
                    bb = charsetEncoder.encode(cb);
                }
                catch (CharacterCodingException e) {
                    throw new RuntimeException(e);
                }
                return Arrays.copyOfRange(bb.array(), bb.position(), bb.limit());
            }
        });
    }

    public static Observable<String> stringConcat(Observable<String> src) {
        return StringObservable.toString(src.reduce((Object)new StringBuilder(), (Func2)new Func2<StringBuilder, String, StringBuilder>(){

            public StringBuilder call(StringBuilder a, String b) {
                return a.append(b);
            }
        }));
    }

    public static Observable<String> toString(Observable<?> src) {
        return src.map((Func1)new Func1<Object, String>(){

            public String call(Object obj) {
                return String.valueOf(obj);
            }
        });
    }

    public static Observable<String> split(Observable<String> src, String regex) {
        final Pattern pattern = Pattern.compile(regex);
        return src.lift((Observable.Operator)new Observable.Operator<String, String>(){

            public Subscriber<? super String> call(final Subscriber<? super String> o) {
                return new Subscriber<String>(o){
                    private String leftOver;
                    private int emptyPartCount;
                    {
                        super(x0);
                        this.leftOver = null;
                        this.emptyPartCount = 0;
                    }

                    public void onCompleted() {
                        if (this.leftOver != null) {
                            this.output(this.leftOver);
                        }
                        if (!o.isUnsubscribed()) {
                            o.onCompleted();
                        }
                    }

                    public void onError(Throwable e) {
                        if (this.leftOver != null) {
                            this.output(this.leftOver);
                        }
                        if (!o.isUnsubscribed()) {
                            o.onError(e);
                        }
                    }

                    public void onNext(String segment) {
                        String[] parts = pattern.split(segment, -1);
                        if (this.leftOver != null) {
                            parts[0] = this.leftOver + parts[0];
                        }
                        for (int i = 0; i < parts.length - 1; ++i) {
                            String part = parts[i];
                            this.output(part);
                        }
                        this.leftOver = parts[parts.length - 1];
                    }

                    private void output(String part) {
                        if (part.isEmpty()) {
                            ++this.emptyPartCount;
                        } else {
                            while (this.emptyPartCount > 0) {
                                if (!o.isUnsubscribed()) {
                                    o.onNext((Object)"");
                                }
                                --this.emptyPartCount;
                            }
                            if (!o.isUnsubscribed()) {
                                o.onNext((Object)part);
                            }
                        }
                    }
                };
            }
        });
    }

    public static Observable<String> join(Observable<String> source, final CharSequence separator) {
        return source.lift((Observable.Operator)new Observable.Operator<String, String>(){

            public Subscriber<String> call(final Subscriber<? super String> o) {
                return new Subscriber<String>(o){
                    boolean mayAddSeparator;
                    StringBuilder b;
                    {
                        super(x0);
                        this.b = new StringBuilder();
                    }

                    public void onCompleted() {
                        String str = this.b.toString();
                        this.b = null;
                        if (!o.isUnsubscribed()) {
                            o.onNext((Object)str);
                        }
                        if (!o.isUnsubscribed()) {
                            o.onCompleted();
                        }
                    }

                    public void onError(Throwable e) {
                        this.b = null;
                        if (!o.isUnsubscribed()) {
                            o.onError(e);
                        }
                    }

                    public void onNext(String t) {
                        if (this.mayAddSeparator) {
                            this.b.append(separator);
                        }
                        this.mayAddSeparator = true;
                        this.b.append(t);
                    }
                };
            }
        });
    }

    public static Observable<Line> byLine(Observable<String> source) {
        return StringObservable.split(source, System.getProperty("line.separator")).map((Func1)new Func1<String, Line>(){
            int lineNumber = 0;

            public Line call(String text) {
                return new Line(this.lineNumber++, text);
            }
        });
    }

    public static final class Line {
        private final int number;
        private final String text;

        public Line(int number, String text) {
            this.number = number;
            this.text = text;
        }

        public int getNumber() {
            return this.number;
        }

        public String getText() {
            return this.text;
        }

        public int hashCode() {
            int result = 31 + this.number;
            result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Line)) {
                return false;
            }
            Line other = (Line)obj;
            if (this.number != other.number) {
                return false;
            }
            if (other.text == this.text) {
                return true;
            }
            if (this.text == null) {
                return false;
            }
            return this.text.equals(other.text);
        }

        public String toString() {
            return this.number + ":" + this.text;
        }
    }

    public static interface UnsafeFunc0<R>
    extends Callable<R> {
        @Override
        public R call() throws Exception;
    }

    private static class CloseableResource<S extends Closeable>
    implements Subscription {
        private final AtomicBoolean unsubscribed = new AtomicBoolean();
        private S closable;

        public CloseableResource(S closeable) {
            this.closable = closeable;
        }

        public void unsubscribe() {
            if (this.unsubscribed.compareAndSet(false, true)) {
                try {
                    this.closable.close();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public boolean isUnsubscribed() {
            return this.unsubscribed.get();
        }
    }
}

