/*
 * Decompiled with CFR 0.152.
 */
package rx.concurrency;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import rx.Scheduler;
import rx.Subscription;
import rx.subscriptions.CompositeSubscription;
import rx.subscriptions.Subscriptions;
import rx.util.functions.Action0;
import rx.util.functions.Func2;

public final class SwingScheduler
extends Scheduler {
    private static final SwingScheduler INSTANCE = new SwingScheduler();

    public static SwingScheduler getInstance() {
        return INSTANCE;
    }

    private SwingScheduler() {
    }

    public <T> Subscription schedule(final T state, final Func2<? super Scheduler, ? super T, ? extends Subscription> action) {
        final AtomicReference sub = new AtomicReference();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                sub.set(action.call((Object)SwingScheduler.this, state));
            }
        });
        return Subscriptions.create((Action0)new Action0(){

            public void call() {
                Subscription subscription = (Subscription)sub.get();
                if (subscription != null) {
                    subscription.unsubscribe();
                }
            }
        });
    }

    public <T> Subscription schedule(final T state, final Func2<? super Scheduler, ? super T, ? extends Subscription> action, long dueTime, TimeUnit unit) {
        final AtomicReference sub = new AtomicReference();
        long delay = unit.toMillis(dueTime);
        SwingScheduler.assertThatTheDelayIsValidForTheSwingTimer(delay);
        class ExecuteOnceAction
        implements ActionListener {
            private Timer timer;

            ExecuteOnceAction() {
            }

            private void setTimer(Timer timer) {
                this.timer = timer;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.timer.stop();
                sub.set(action.call((Object)SwingScheduler.this, state));
            }
        }
        ExecuteOnceAction executeOnce = new ExecuteOnceAction();
        final Timer timer = new Timer((int)delay, executeOnce);
        executeOnce.setTimer(timer);
        timer.start();
        return Subscriptions.create((Action0)new Action0(){

            public void call() {
                timer.stop();
                Subscription subscription = (Subscription)sub.get();
                if (subscription != null) {
                    subscription.unsubscribe();
                }
            }
        });
    }

    public <T> Subscription schedulePeriodically(T state, final Func2<? super Scheduler, ? super T, ? extends Subscription> action, long initialDelay, long period, TimeUnit unit) {
        final AtomicReference timer = new AtomicReference();
        final long delay = unit.toMillis(period);
        SwingScheduler.assertThatTheDelayIsValidForTheSwingTimer(delay);
        final CompositeSubscription subscriptions = new CompositeSubscription(new Subscription[0]);
        Func2 initialAction = new Func2<Scheduler, T, Subscription>(){

            public Subscription call(final Scheduler scheduler, final T state0) {
                timer.set(new Timer((int)delay, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        subscriptions.add((Subscription)action.call((Object)scheduler, state0));
                    }
                }));
                ((Timer)timer.get()).start();
                return (Subscription)action.call((Object)scheduler, state0);
            }
        };
        subscriptions.add(this.schedule(state, initialAction, initialDelay, unit));
        subscriptions.add(Subscriptions.create((Action0)new Action0(){

            public void call() {
                Timer maybeTimer = (Timer)timer.get();
                if (maybeTimer != null) {
                    maybeTimer.stop();
                }
            }
        }));
        return subscriptions;
    }

    private static void assertThatTheDelayIsValidForTheSwingTimer(long delay) {
        if (delay < 0L || delay > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(String.format("The swing timer only accepts non-negative delays up to %d milliseconds.", Integer.MAX_VALUE));
        }
    }

    public static class UnitTest {
        @Rule
        public ExpectedException exception = ExpectedException.none();

        @Test
        public void testInvalidDelayValues() {
            SwingScheduler scheduler = new SwingScheduler();
            Action0 action = (Action0)Mockito.mock(Action0.class);
            this.exception.expect(IllegalArgumentException.class);
            scheduler.schedulePeriodically(action, -1L, 100L, TimeUnit.SECONDS);
            this.exception.expect(IllegalArgumentException.class);
            scheduler.schedulePeriodically(action, 100L, -1L, TimeUnit.SECONDS);
            this.exception.expect(IllegalArgumentException.class);
            scheduler.schedulePeriodically(action, 0x80000000L, 100L, TimeUnit.MILLISECONDS);
            this.exception.expect(IllegalArgumentException.class);
            scheduler.schedulePeriodically(action, 100L, 2147484L, TimeUnit.SECONDS);
        }

        @Test
        public void testPeriodicScheduling() throws Exception {
            SwingScheduler scheduler = new SwingScheduler();
            final CountDownLatch latch = new CountDownLatch(4);
            final Action0 innerAction = (Action0)Mockito.mock(Action0.class);
            Action0 action = new Action0(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void call() {
                    try {
                        innerAction.call();
                        Assert.assertTrue((boolean)SwingUtilities.isEventDispatchThread());
                    }
                    finally {
                        latch.countDown();
                    }
                }
            };
            Subscription sub = scheduler.schedulePeriodically(action, 50L, 200L, TimeUnit.MILLISECONDS);
            if (!latch.await(5000L, TimeUnit.MILLISECONDS)) {
                Assert.fail((String)"timed out waiting for tasks to execute");
            }
            sub.unsubscribe();
            UnitTest.waitForEmptyEventQueue();
            ((Action0)Mockito.verify((Object)innerAction, (VerificationMode)Mockito.times((int)4))).call();
        }

        @Test
        public void testNestedActions() throws Exception {
            final SwingScheduler scheduler = new SwingScheduler();
            final Action0 firstStepStart = (Action0)Mockito.mock(Action0.class);
            final Action0 firstStepEnd = (Action0)Mockito.mock(Action0.class);
            final Action0 secondStepStart = (Action0)Mockito.mock(Action0.class);
            final Action0 secondStepEnd = (Action0)Mockito.mock(Action0.class);
            final Action0 thirdStepStart = (Action0)Mockito.mock(Action0.class);
            final Action0 thirdStepEnd = (Action0)Mockito.mock(Action0.class);
            final Action0 firstAction = new Action0(){

                public void call() {
                    Assert.assertTrue((boolean)SwingUtilities.isEventDispatchThread());
                    firstStepStart.call();
                    firstStepEnd.call();
                }
            };
            final Action0 secondAction = new Action0(){

                public void call() {
                    Assert.assertTrue((boolean)SwingUtilities.isEventDispatchThread());
                    secondStepStart.call();
                    scheduler.schedule(firstAction);
                    secondStepEnd.call();
                }
            };
            Action0 thirdAction = new Action0(){

                public void call() {
                    Assert.assertTrue((boolean)SwingUtilities.isEventDispatchThread());
                    thirdStepStart.call();
                    scheduler.schedule(secondAction);
                    thirdStepEnd.call();
                }
            };
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{firstStepStart, firstStepEnd, secondStepStart, secondStepEnd, thirdStepStart, thirdStepEnd});
            scheduler.schedule(thirdAction);
            UnitTest.waitForEmptyEventQueue();
            ((Action0)inOrder.verify((Object)thirdStepStart, Mockito.times((int)1))).call();
            ((Action0)inOrder.verify((Object)thirdStepEnd, Mockito.times((int)1))).call();
            ((Action0)inOrder.verify((Object)secondStepStart, Mockito.times((int)1))).call();
            ((Action0)inOrder.verify((Object)secondStepEnd, Mockito.times((int)1))).call();
            ((Action0)inOrder.verify((Object)firstStepStart, Mockito.times((int)1))).call();
            ((Action0)inOrder.verify((Object)firstStepEnd, Mockito.times((int)1))).call();
        }

        private static void waitForEmptyEventQueue() throws Exception {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                }
            });
        }
    }
}

