/*
 * Decompiled with CFR 0.152.
 */
package rx.swing.sources;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.subscriptions.Subscriptions;
import rx.util.functions.Action0;
import rx.util.functions.Action1;

public enum AbstractButtonSource {


    public static Observable<ActionEvent> fromActionOf(final AbstractButton button) {
        return Observable.create((Observable.OnSubscribeFunc)new Observable.OnSubscribeFunc<ActionEvent>(){

            public Subscription onSubscribe(final Observer<? super ActionEvent> observer) {
                final ActionListener listener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        observer.onNext((Object)e);
                    }
                };
                button.addActionListener(listener);
                return Subscriptions.create((Action0)new Action0(){

                    public void call() {
                        button.removeActionListener(listener);
                    }
                });
            }
        });
    }

    public static class UnitTest {
        @Test
        public void testObservingActionEvents() {
            Action1 action = (Action1)Mockito.mock(Action1.class);
            Action1 error = (Action1)Mockito.mock(Action1.class);
            Action0 complete = (Action0)Mockito.mock(Action0.class);
            final ActionEvent event = new ActionEvent(this, 1, "command");
            class TestButton
            extends AbstractButton {
                TestButton() {
                }

                void testAction() {
                    this.fireActionPerformed(event);
                }
            }
            TestButton button = new TestButton();
            Subscription sub = AbstractButtonSource.fromActionOf(button).subscribe(action, error, complete);
            ((Action1)Mockito.verify((Object)action, (VerificationMode)Mockito.never())).call(Matchers.any());
            ((Action1)Mockito.verify((Object)error, (VerificationMode)Mockito.never())).call(Matchers.any());
            ((Action0)Mockito.verify((Object)complete, (VerificationMode)Mockito.never())).call();
            button.testAction();
            ((Action1)Mockito.verify((Object)action, (VerificationMode)Mockito.times((int)1))).call(Matchers.any());
            button.testAction();
            ((Action1)Mockito.verify((Object)action, (VerificationMode)Mockito.times((int)2))).call(Matchers.any());
            sub.unsubscribe();
            button.testAction();
            ((Action1)Mockito.verify((Object)action, (VerificationMode)Mockito.times((int)2))).call(Matchers.any());
            ((Action1)Mockito.verify((Object)error, (VerificationMode)Mockito.never())).call(Matchers.any());
            ((Action0)Mockito.verify((Object)complete, (VerificationMode)Mockito.never())).call();
        }
    }
}

