/*
 * Decompiled with CFR 0.152.
 */
package rx.swing.sources;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JPanel;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.subscriptions.Subscriptions;
import rx.util.functions.Action0;
import rx.util.functions.Action1;
import rx.util.functions.Func1;
import rx.util.functions.Func2;

public enum KeyEventSource {


    public static Observable<KeyEvent> fromKeyEventsOf(final Component component) {
        return Observable.create((Observable.OnSubscribeFunc)new Observable.OnSubscribeFunc<KeyEvent>(){

            public Subscription onSubscribe(final Observer<? super KeyEvent> observer) {
                final KeyListener listener = new KeyListener(){

                    @Override
                    public void keyPressed(KeyEvent event) {
                        observer.onNext((Object)event);
                    }

                    @Override
                    public void keyReleased(KeyEvent event) {
                        observer.onNext((Object)event);
                    }

                    @Override
                    public void keyTyped(KeyEvent event) {
                        observer.onNext((Object)event);
                    }
                };
                component.addKeyListener(listener);
                return Subscriptions.create((Action0)new Action0(){

                    public void call() {
                        component.removeKeyListener(listener);
                    }
                });
            }
        });
    }

    public static Observable<Set<Integer>> currentlyPressedKeysOf(Component component) {
        Observable filteredKeyEvents = KeyEventSource.fromKeyEventsOf(component).filter((Func1)new Func1<KeyEvent, Boolean>(){

            public Boolean call(KeyEvent event) {
                return event.getID() == 401 || event.getID() == 402;
            }
        });
        class CollectKeys
        implements Func2<Set<Integer>, KeyEvent, Set<Integer>> {
            CollectKeys() {
            }

            public Set<Integer> call(Set<Integer> pressedKeys, KeyEvent event) {
                HashSet<Integer> afterEvent = new HashSet<Integer>(pressedKeys);
                switch (event.getID()) {
                    case 401: {
                        afterEvent.add(event.getKeyCode());
                        break;
                    }
                    case 402: {
                        afterEvent.remove(event.getKeyCode());
                        break;
                    }
                }
                return afterEvent;
            }
        }
        return filteredKeyEvents.scan(Collections.emptySet(), (Func2)new CollectKeys());
    }

    public static class UnitTest {
        private Component comp = new JPanel();

        @Test
        public void testObservingKeyEvents() {
            Action1 action = (Action1)Mockito.mock(Action1.class);
            Action1 error = (Action1)Mockito.mock(Action1.class);
            Action0 complete = (Action0)Mockito.mock(Action0.class);
            KeyEvent event = (KeyEvent)Mockito.mock(KeyEvent.class);
            Subscription sub = KeyEventSource.fromKeyEventsOf(this.comp).subscribe(action, error, complete);
            ((Action1)Mockito.verify((Object)action, (VerificationMode)Mockito.never())).call(Matchers.any());
            ((Action1)Mockito.verify((Object)error, (VerificationMode)Mockito.never())).call(Matchers.any());
            ((Action0)Mockito.verify((Object)complete, (VerificationMode)Mockito.never())).call();
            this.fireKeyEvent(event);
            ((Action1)Mockito.verify((Object)action, (VerificationMode)Mockito.times((int)1))).call(Matchers.any());
            this.fireKeyEvent(event);
            ((Action1)Mockito.verify((Object)action, (VerificationMode)Mockito.times((int)2))).call(Matchers.any());
            sub.unsubscribe();
            this.fireKeyEvent(event);
            ((Action1)Mockito.verify((Object)action, (VerificationMode)Mockito.times((int)2))).call(Matchers.any());
            ((Action1)Mockito.verify((Object)error, (VerificationMode)Mockito.never())).call(Matchers.any());
            ((Action0)Mockito.verify((Object)complete, (VerificationMode)Mockito.never())).call();
        }

        @Test
        public void testObservingPressedKeys() {
            Action1 action = (Action1)Mockito.mock(Action1.class);
            Action1 error = (Action1)Mockito.mock(Action1.class);
            Action0 complete = (Action0)Mockito.mock(Action0.class);
            Subscription sub = KeyEventSource.currentlyPressedKeysOf(this.comp).subscribe(action, error, complete);
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{action});
            ((Action1)inOrder.verify((Object)action, Mockito.times((int)1))).call(Collections.emptySet());
            ((Action1)Mockito.verify((Object)error, (VerificationMode)Mockito.never())).call(Matchers.any());
            ((Action0)Mockito.verify((Object)complete, (VerificationMode)Mockito.never())).call();
            this.fireKeyEvent(this.keyEvent(1, 401));
            ((Action1)inOrder.verify((Object)action, Mockito.times((int)1))).call(new HashSet<Integer>(Arrays.asList(1)));
            ((Action1)Mockito.verify((Object)error, (VerificationMode)Mockito.never())).call(Matchers.any());
            ((Action0)Mockito.verify((Object)complete, (VerificationMode)Mockito.never())).call();
            this.fireKeyEvent(this.keyEvent(2, 401));
            this.fireKeyEvent(this.keyEvent(0, 400));
            ((Action1)inOrder.verify((Object)action, Mockito.times((int)1))).call(new HashSet<Integer>(Arrays.asList(1, 2)));
            this.fireKeyEvent(this.keyEvent(2, 402));
            ((Action1)inOrder.verify((Object)action, Mockito.times((int)1))).call(new HashSet<Integer>(Arrays.asList(1)));
            this.fireKeyEvent(this.keyEvent(3, 402));
            ((Action1)inOrder.verify((Object)action, Mockito.times((int)1))).call(new HashSet<Integer>(Arrays.asList(1)));
            this.fireKeyEvent(this.keyEvent(1, 402));
            ((Action1)inOrder.verify((Object)action, Mockito.times((int)1))).call(Collections.emptySet());
            sub.unsubscribe();
            this.fireKeyEvent(this.keyEvent(1, 401));
            ((Action1)inOrder.verify((Object)action, Mockito.never())).call(Matchers.any());
            ((Action1)Mockito.verify((Object)error, (VerificationMode)Mockito.never())).call(Matchers.any());
            ((Action0)Mockito.verify((Object)complete, (VerificationMode)Mockito.never())).call();
        }

        private KeyEvent keyEvent(int keyCode, int id) {
            return new KeyEvent(this.comp, id, -1L, 0, keyCode, ' ');
        }

        private void fireKeyEvent(KeyEvent event) {
            for (KeyListener listener : this.comp.getKeyListeners()) {
                listener.keyTyped(event);
            }
        }
    }
}

