/*
 * Decompiled with CFR 0.152.
 */
package rx.swing.sources;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.subscriptions.Subscriptions;
import rx.util.functions.Action0;
import rx.util.functions.Action1;
import rx.util.functions.Func1;
import rx.util.functions.Func2;

public enum MouseEventSource {


    public static Observable<MouseEvent> fromMouseEventsOf(final Component component) {
        return Observable.create((Observable.OnSubscribeFunc)new Observable.OnSubscribeFunc<MouseEvent>(){

            public Subscription onSubscribe(final Observer<? super MouseEvent> observer) {
                final MouseListener listener = new MouseListener(){

                    @Override
                    public void mouseClicked(MouseEvent event) {
                        observer.onNext((Object)event);
                    }

                    @Override
                    public void mousePressed(MouseEvent event) {
                        observer.onNext((Object)event);
                    }

                    @Override
                    public void mouseReleased(MouseEvent event) {
                        observer.onNext((Object)event);
                    }

                    @Override
                    public void mouseEntered(MouseEvent event) {
                        observer.onNext((Object)event);
                    }

                    @Override
                    public void mouseExited(MouseEvent event) {
                        observer.onNext((Object)event);
                    }
                };
                component.addMouseListener(listener);
                return Subscriptions.create((Action0)new Action0(){

                    public void call() {
                        component.removeMouseListener(listener);
                    }
                });
            }
        });
    }

    public static Observable<MouseEvent> fromMouseMotionEventsOf(final Component component) {
        return Observable.create((Observable.OnSubscribeFunc)new Observable.OnSubscribeFunc<MouseEvent>(){

            public Subscription onSubscribe(final Observer<? super MouseEvent> observer) {
                final MouseMotionListener listener = new MouseMotionListener(){

                    @Override
                    public void mouseDragged(MouseEvent event) {
                        observer.onNext((Object)event);
                    }

                    @Override
                    public void mouseMoved(MouseEvent event) {
                        observer.onNext((Object)event);
                    }
                };
                component.addMouseMotionListener(listener);
                return Subscriptions.create((Action0)new Action0(){

                    public void call() {
                        component.removeMouseMotionListener(listener);
                    }
                });
            }
        });
    }

    public static Observable<Point> fromRelativeMouseMotion(Component component) {
        class OldAndRelative {
            public final Point old;
            public final Point relative;

            OldAndRelative(Point old, Point relative) {
                this.old = old;
                this.relative = relative;
            }
        }
        class Relativize
        implements Func2<OldAndRelative, MouseEvent, OldAndRelative> {
            Relativize() {
            }

            public OldAndRelative call(OldAndRelative last, MouseEvent event) {
                Point current = new Point(event.getX(), event.getY());
                Point relative = new Point(current.x - last.old.x, current.y - last.old.y);
                return new OldAndRelative(current, relative);
            }
        }
        class OnlyRelative
        implements Func1<OldAndRelative, Point> {
            OnlyRelative() {
            }

            public Point call(OldAndRelative oar) {
                return oar.relative;
            }
        }
        return MouseEventSource.fromMouseMotionEventsOf(component).scan((Object)new OldAndRelative(new Point(0, 0), new Point(0, 0)), (Func2)new Relativize()).map((Func1)new OnlyRelative()).skip(2);
    }

    public static class UnitTest {
        private Component comp = new JPanel();

        @Test
        public void testRelativeMouseMotion() {
            Action1 action = (Action1)Mockito.mock(Action1.class);
            Action1 error = (Action1)Mockito.mock(Action1.class);
            Action0 complete = (Action0)Mockito.mock(Action0.class);
            Subscription sub = MouseEventSource.fromRelativeMouseMotion(this.comp).subscribe(action, error, complete);
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{action});
            ((Action1)Mockito.verify((Object)action, (VerificationMode)Mockito.never())).call(Matchers.any());
            ((Action1)Mockito.verify((Object)error, (VerificationMode)Mockito.never())).call(Matchers.any());
            ((Action0)Mockito.verify((Object)complete, (VerificationMode)Mockito.never())).call();
            this.fireMouseEvent(this.mouseEvent(0, 0));
            ((Action1)Mockito.verify((Object)action, (VerificationMode)Mockito.never())).call(Matchers.any());
            this.fireMouseEvent(this.mouseEvent(10, -5));
            ((Action1)inOrder.verify((Object)action, Mockito.times((int)1))).call((Object)new Point(10, -5));
            this.fireMouseEvent(this.mouseEvent(6, 10));
            ((Action1)inOrder.verify((Object)action, Mockito.times((int)1))).call((Object)new Point(-4, 15));
            sub.unsubscribe();
            this.fireMouseEvent(this.mouseEvent(0, 0));
            ((Action1)inOrder.verify((Object)action, Mockito.never())).call(Matchers.any());
            ((Action1)Mockito.verify((Object)error, (VerificationMode)Mockito.never())).call(Matchers.any());
            ((Action0)Mockito.verify((Object)complete, (VerificationMode)Mockito.never())).call();
        }

        private MouseEvent mouseEvent(int x, int y) {
            return new MouseEvent(this.comp, 503, 1L, 0, x, y, 0, false);
        }

        private void fireMouseEvent(MouseEvent event) {
            for (MouseMotionListener listener : this.comp.getMouseMotionListeners()) {
                listener.mouseMoved(event);
            }
        }
    }
}

