/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.codegen;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fizzed.rocker.runtime.ArrayOfByteArraysOutput;
import com.fizzed.rocker.runtime.DefaultRockerModel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public interface Generator {
    public static final ObjectMapper yamlMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    public static final ObjectMapper jsonMapper = new ObjectMapper();
    public static final Map<String, byte[]> schemaMap = new HashMap<String, byte[]>();

    public void generate(String var1, Object var2, JsonNode var3) throws IOException;

    public String getFramework();

    default public ByteBuffer getConfigSchema() throws IOException {
        byte[] schemaBuf = schemaMap.get(this.getFramework());
        if (schemaBuf == null) {
            try (InputStream is = this.getClass().getClassLoader().getResourceAsStream(this.getFramework() + ".json");){
                schemaBuf = IOUtils.toByteArray((InputStream)is);
                schemaMap.put(this.getFramework(), schemaBuf);
            }
        }
        return ByteBuffer.wrap(schemaBuf);
    }

    default public void transfer(String folder, String path, String filename, DefaultRockerModel rockerModel) throws IOException {
        String absPath = folder + (String)(path.isEmpty() ? "" : File.separator + path);
        if (Files.notExists(Paths.get(absPath, new String[0]), new LinkOption[0])) {
            Files.createDirectories(Paths.get(absPath, new String[0]), new FileAttribute[0]);
        }
        try (FileOutputStream fos = new FileOutputStream(absPath + File.separator + filename);
             ReadableByteChannel rbc = ((ArrayOfByteArraysOutput)rockerModel.render(ArrayOfByteArraysOutput.FACTORY)).asReadableByteChannel();){
            fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
        }
    }

    default public void transfer(String srcPath, String destFolder, String destPath, String destName) throws IOException {
        String absPath = destFolder + (String)(destPath.isEmpty() ? "" : File.separator + destPath);
        if (Files.notExists(Paths.get(absPath, new String[0]), new LinkOption[0])) {
            Files.createDirectories(Paths.get(absPath, new String[0]), new FileAttribute[0]);
        }
        try (InputStream ins = Generator.class.getResourceAsStream(srcPath);
             FileOutputStream fos = new FileOutputStream(absPath + File.separator + destName);){
            IOUtils.copy((InputStream)ins, (OutputStream)fos);
        }
    }

    default public void setExecutable(String path) throws IOException {
        File file = new File(path);
        if (file.exists()) {
            file.setExecutable(true, false);
        }
    }

    default public void transferMaven(String targetPath) throws IOException {
        this.transfer("/maven/mvnw", targetPath, "", "mvnw");
        this.setExecutable(Paths.get(targetPath, "mvnw").toString());
        this.transfer("/maven/mvnw.cmd", targetPath, "", "mvnw.cmd");
        this.transfer("/maven/mvn/wrapper/maven-wrapper.jar", targetPath, ".mvn/wrapper", "maven-wrapper.jar");
        this.transfer("/maven/mvn/wrapper/maven-wrapper.properties", targetPath, ".mvn/wrapper", "maven-wrapper.properties");
        this.transfer("/maven/mvn/wrapper/MavenWrapperDownloader.java", targetPath, ".mvn/wrapper", "MavenWrapperDownloader.java");
    }

    default public void transferGradle(String targetPath) throws IOException {
        this.transfer("/gradle/gradlew", targetPath, "", "gradlew");
        this.setExecutable(Paths.get(targetPath, "gradlew").toString());
        this.transfer("/gradle/gradlew.bat", targetPath, "", "gradlew.bat");
        this.transfer("/gradle/gradle/wrapper/gradle-wrapper.jar", targetPath, "gradle/wrapper", "gradle-wrapper.jar");
        this.transfer("/gradle/gradle/wrapper/gradle-wrapper.properties", targetPath, "gradle/wrapper", "gradle-wrapper.properties");
    }

    default public boolean checkExist(String folder, String path, String filename) throws IOException {
        String absPath = folder + (String)(path.isEmpty() ? "" : File.separator + path) + File.separator + filename;
        return Files.exists(Paths.get(absPath, new String[0]), new LinkOption[0]);
    }

    public static void copyFile(InputStream is, Path folder) throws IOException {
        Path parent = folder.getParent();
        if (!Files.isDirectory(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        Files.copy(is, folder, StandardCopyOption.REPLACE_EXISTING);
    }

    default public String getRootPackage(JsonNode config, String defaultValue) {
        String rootPackage = defaultValue == null ? "com.networknt.app" : defaultValue;
        JsonNode jsonNode = config.get("rootPackage");
        if (jsonNode == null) {
            ((ObjectNode)config).put("rootPackage", rootPackage);
        } else {
            rootPackage = jsonNode.textValue();
        }
        return rootPackage;
    }

    default public String getModelPackage(JsonNode config, String defaultValue) {
        String rootPackage = this.getRootPackage(config, null);
        Object modelPackage = defaultValue == null ? rootPackage + ".model" : defaultValue;
        JsonNode jsonNode = config.get("modelPackage");
        if (jsonNode == null) {
            ((ObjectNode)config).put("modelPackage", (String)modelPackage);
        } else {
            modelPackage = jsonNode.textValue();
        }
        return modelPackage;
    }

    default public String getHandlerPackage(JsonNode config, String defaultValue) {
        String rootPackage = this.getRootPackage(config, null);
        Object handlerPackage = defaultValue == null ? rootPackage + ".handler" : defaultValue;
        JsonNode jsonNode = config.get("handlerPackage");
        if (jsonNode == null) {
            ((ObjectNode)config).put("handlerPackage", (String)handlerPackage);
        } else {
            handlerPackage = jsonNode.textValue();
        }
        return handlerPackage;
    }

    default public String getServicePackage(JsonNode config, String defaultValue) {
        String rootPackage = this.getRootPackage(config, null);
        Object servicePackage = defaultValue == null ? rootPackage + ".service" : defaultValue;
        JsonNode jsonNode = config.get("servicePackage");
        if (jsonNode == null) {
            ((ObjectNode)config).put("servicePackage", (String)servicePackage);
        } else {
            servicePackage = jsonNode.textValue();
        }
        return servicePackage;
    }

    default public boolean isOverwriteHandler(JsonNode config, Boolean defaultValue) {
        boolean overwriteHandler = defaultValue == null ? true : defaultValue;
        JsonNode jsonNode = config.get("overwriteHandler");
        if (jsonNode == null) {
            ((ObjectNode)config).put("overwriteHandler", overwriteHandler);
        } else {
            overwriteHandler = jsonNode.booleanValue();
        }
        return overwriteHandler;
    }

    default public boolean isOverwriteHandlerTest(JsonNode config, Boolean defaultValue) {
        boolean overwriteHandlerTest = defaultValue == null ? true : defaultValue;
        JsonNode jsonNode = config.get("overwriteHandlerTest");
        if (jsonNode == null) {
            ((ObjectNode)config).put("overwriteHandlerTest", overwriteHandlerTest);
        } else {
            overwriteHandlerTest = jsonNode.booleanValue();
        }
        return overwriteHandlerTest;
    }

    default public boolean isOverwriteModel(JsonNode config, Boolean defaultValue) {
        boolean overwriteModel = defaultValue == null ? true : defaultValue;
        JsonNode jsonNode = config.get("overwriteModel");
        if (jsonNode == null) {
            ((ObjectNode)config).put("overwriteModel", overwriteModel);
        } else {
            overwriteModel = jsonNode.booleanValue();
        }
        return overwriteModel;
    }

    default public boolean isUseLightProxy(JsonNode config, Boolean defaultValue) {
        boolean useLightProxy = defaultValue == null ? false : defaultValue;
        JsonNode jsonNode = config.get("useLightProxy");
        if (jsonNode == null) {
            ((ObjectNode)config).put("useLightProxy", useLightProxy);
        } else {
            useLightProxy = jsonNode.booleanValue();
        }
        return useLightProxy;
    }

    default public boolean isGenerateModelOnly(JsonNode config, Boolean defaultValue) {
        boolean generateModelOnly = defaultValue == null ? false : defaultValue;
        JsonNode jsonNode = config.get("generateModelOnly");
        if (jsonNode == null) {
            ((ObjectNode)config).put("generateModelOnly", generateModelOnly);
        } else {
            generateModelOnly = jsonNode.booleanValue();
        }
        return generateModelOnly;
    }

    default public boolean isEnableHttp(JsonNode config, Boolean defaultValue) {
        boolean enableHttp = defaultValue == null ? false : defaultValue;
        JsonNode jsonNode = config.get("enableHttp");
        if (jsonNode == null) {
            ((ObjectNode)config).put("enableHttp", enableHttp);
        } else {
            enableHttp = jsonNode.booleanValue();
        }
        return enableHttp;
    }

    default public String getHttpPort(JsonNode config, String defaultValue) {
        String httpPort = defaultValue == null ? "8080" : defaultValue;
        JsonNode jsonNode = config.get("httpPort");
        if (jsonNode == null) {
            ((ObjectNode)config).put("httpPort", httpPort);
        } else {
            httpPort = jsonNode.asText();
        }
        return httpPort;
    }

    default public boolean isEnableHttps(JsonNode config, Boolean defaultValue) {
        boolean enableHttps = defaultValue == null ? true : defaultValue;
        JsonNode jsonNode = config.get("enableHttps");
        if (jsonNode == null) {
            ((ObjectNode)config).put("enableHttps", enableHttps);
        } else {
            enableHttps = jsonNode.booleanValue();
        }
        return enableHttps;
    }

    default public boolean isEnableHttp2(JsonNode config, Boolean defaultValue) {
        boolean enableHttp2 = defaultValue == null ? true : defaultValue;
        JsonNode jsonNode = config.get("enableHttp2");
        if (jsonNode == null) {
            ((ObjectNode)config).put("enableHttp2", enableHttp2);
        } else {
            enableHttp2 = jsonNode.booleanValue();
        }
        return enableHttp2;
    }

    default public String getHttpsPort(JsonNode config, String defaultValue) {
        String httpsPort = defaultValue == null ? "8443" : defaultValue;
        JsonNode jsonNode = config.get("httpsPort");
        if (jsonNode == null) {
            ((ObjectNode)config).put("httpsPort", httpsPort);
        } else {
            httpsPort = jsonNode.asText();
        }
        return httpsPort;
    }

    default public boolean isEnableRegistry(JsonNode config, Boolean defaultValue) {
        boolean enableRegistry = defaultValue == null ? false : defaultValue;
        JsonNode jsonNode = config.get("enableRegistry");
        if (jsonNode == null) {
            ((ObjectNode)config).put("enableRegistry", enableRegistry);
        } else {
            enableRegistry = jsonNode.booleanValue();
        }
        return enableRegistry;
    }

    default public boolean isEclipseIDE(JsonNode config, Boolean defaultValue) {
        boolean eclipseIDE = defaultValue == null ? false : defaultValue;
        JsonNode jsonNode = config.get("eclipseIDE");
        if (jsonNode == null) {
            ((ObjectNode)config).put("eclipseIDE", eclipseIDE);
        } else {
            eclipseIDE = jsonNode.booleanValue();
        }
        return eclipseIDE;
    }

    default public boolean isSupportClient(JsonNode config, Boolean defaultValue) {
        boolean supportClient = defaultValue == null ? false : defaultValue;
        JsonNode jsonNode = config.get("supportClient");
        if (jsonNode == null) {
            ((ObjectNode)config).put("supportClient", supportClient);
        } else {
            supportClient = jsonNode.booleanValue();
        }
        return supportClient;
    }

    default public boolean isPrometheusMetrics(JsonNode config, Boolean defaultValue) {
        boolean prometheusMetrics = defaultValue == null ? false : defaultValue;
        JsonNode jsonNode = config.get("prometheusMetrics");
        if (jsonNode == null) {
            ((ObjectNode)config).put("prometheusMetrics", prometheusMetrics);
        } else {
            prometheusMetrics = jsonNode.booleanValue();
        }
        return prometheusMetrics;
    }

    default public String getDockerOrganization(JsonNode config, String defaultValue) {
        String dockerOrganization = defaultValue == null ? "networknt" : defaultValue;
        JsonNode jsonNode = config.get("dockerOrganization");
        if (jsonNode == null) {
            ((ObjectNode)config).put("dockerOrganization", dockerOrganization);
        } else {
            dockerOrganization = jsonNode.textValue();
        }
        return dockerOrganization;
    }

    default public String getVersion(JsonNode config, String defaultValue) {
        String version = defaultValue == null ? "1.0.0" : defaultValue;
        JsonNode jsonNode = config.get("version");
        if (jsonNode == null) {
            ((ObjectNode)config).put("version", version);
        } else {
            version = jsonNode.textValue();
        }
        return version;
    }

    default public String getGroupId(JsonNode config, String defaultValue) {
        String groupId = defaultValue == null ? "com.networknt" : defaultValue;
        JsonNode jsonNode = config.get("groupId");
        if (jsonNode == null) {
            ((ObjectNode)config).put("groupId", groupId);
        } else {
            groupId = jsonNode.textValue();
        }
        return groupId;
    }

    default public String getArtifactId(JsonNode config, String defaultValue) {
        String artifactId = defaultValue == null ? "app" : defaultValue;
        JsonNode jsonNode = config.get("artifactId");
        if (jsonNode == null) {
            ((ObjectNode)config).put("artifactId", artifactId);
        } else {
            artifactId = jsonNode.textValue();
        }
        return artifactId;
    }

    default public boolean isSpecChangeCodeReGenOnly(JsonNode config, Boolean defaultValue) {
        boolean specChangeCodeReGenOnly = defaultValue == null ? false : defaultValue;
        JsonNode jsonNode = config.get("specChangeCodeReGenOnly");
        if (jsonNode == null) {
            ((ObjectNode)config).put("specChangeCodeReGenOnly", specChangeCodeReGenOnly);
        } else {
            specChangeCodeReGenOnly = jsonNode.booleanValue();
        }
        return specChangeCodeReGenOnly;
    }

    default public boolean isEnableParamDescription(JsonNode config, Boolean defaultValue) {
        boolean enableParamDescription = defaultValue == null ? false : defaultValue;
        JsonNode jsonNode = config.get("enableParamDescription");
        if (jsonNode == null) {
            ((ObjectNode)config).put("enableParamDescription", enableParamDescription);
        } else {
            enableParamDescription = jsonNode.booleanValue();
        }
        return enableParamDescription;
    }

    default public boolean isSkipPomFile(JsonNode config, Boolean defaultValue) {
        boolean skipPomFile = defaultValue == null ? false : defaultValue;
        JsonNode jsonNode = config.get("skipPomFile");
        if (jsonNode == null) {
            ((ObjectNode)config).put("skipPomFile", skipPomFile);
        } else {
            skipPomFile = jsonNode.booleanValue();
        }
        return skipPomFile;
    }

    default public boolean isKafkaProducer(JsonNode config, Boolean defaultValue) {
        boolean kafkaProducer = defaultValue == null ? false : defaultValue;
        JsonNode jsonNode = config.get("kafkaProducer");
        if (jsonNode == null) {
            ((ObjectNode)config).put("kafkaProducer", kafkaProducer);
        } else {
            kafkaProducer = jsonNode.booleanValue();
        }
        return kafkaProducer;
    }

    default public boolean isKafkaConsumer(JsonNode config, Boolean defaultValue) {
        boolean kafkaConsumer = defaultValue == null ? false : defaultValue;
        JsonNode jsonNode = config.get("kafkaConsumer");
        if (jsonNode == null) {
            ((ObjectNode)config).put("kafkaConsumer", kafkaConsumer);
        } else {
            kafkaConsumer = jsonNode.booleanValue();
        }
        return kafkaConsumer;
    }

    default public boolean isKafkaStreams(JsonNode config, Boolean defaultValue) {
        boolean kafkaStreams = defaultValue == null ? false : defaultValue;
        JsonNode jsonNode = config.get("kafkaStreams");
        if (jsonNode == null) {
            ((ObjectNode)config).put("kafkaStreams", kafkaStreams);
        } else {
            kafkaStreams = jsonNode.booleanValue();
        }
        return kafkaStreams;
    }

    default public boolean isSupportAvro(JsonNode config, Boolean defaultValue) {
        boolean supportAvro = defaultValue == null ? false : defaultValue;
        JsonNode jsonNode = config.get("supportAvro");
        if (jsonNode == null) {
            ((ObjectNode)config).put("supportAvro", supportAvro);
        } else {
            supportAvro = jsonNode.booleanValue();
        }
        return supportAvro;
    }

    default public String getKafkaTopic(JsonNode config, String defaultValue) {
        String kafkaTopic = defaultValue == null ? "event" : defaultValue;
        JsonNode jsonNode = config.get("kafkaTopic");
        if (jsonNode == null) {
            ((ObjectNode)config).put("kafkaTopic", kafkaTopic);
        } else {
            kafkaTopic = jsonNode.textValue();
        }
        return kafkaTopic;
    }

    default public String getDecryptOption(JsonNode config, String defaultValue) {
        String decryptOption = defaultValue == null ? "default" : defaultValue;
        JsonNode jsonNode = config.get("decryptOption");
        if (jsonNode == null) {
            ((ObjectNode)config).put("decryptOption", decryptOption);
        } else {
            decryptOption = jsonNode.textValue();
        }
        return decryptOption;
    }

    default public boolean isBuildMaven(JsonNode config, Boolean defaultValue) {
        boolean buildMaven = defaultValue == null ? false : defaultValue;
        JsonNode jsonNode = config.get("buildMaven");
        if (jsonNode == null) {
            ((ObjectNode)config).put("buildMaven", buildMaven);
        } else {
            buildMaven = jsonNode.booleanValue();
        }
        return buildMaven;
    }

    default public boolean isMultipleModule(JsonNode config, Boolean defaultValue) {
        boolean multipleModule = defaultValue == null ? false : defaultValue;
        JsonNode jsonNode = config.get("multipleModule");
        if (jsonNode == null) {
            ((ObjectNode)config).put("multipleModule", multipleModule);
        } else {
            multipleModule = jsonNode.booleanValue();
        }
        return multipleModule;
    }

    default public boolean isSupportDb(JsonNode config, Boolean defaultValue) {
        boolean supportDb = defaultValue == null ? false : defaultValue;
        JsonNode jsonNode = config.get("supportDb");
        if (jsonNode == null) {
            ((ObjectNode)config).put("supportDb", supportDb);
        } else {
            supportDb = jsonNode.booleanValue();
        }
        return supportDb;
    }

    default public boolean isSupportH2ForTest(JsonNode config, Boolean defaultValue) {
        boolean supportH2ForTest = defaultValue == null ? false : defaultValue;
        JsonNode jsonNode = config.get("supportH2ForTest");
        if (jsonNode == null) {
            ((ObjectNode)config).put("supportH2ForTest", supportH2ForTest);
        } else {
            supportH2ForTest = jsonNode.booleanValue();
        }
        return supportH2ForTest;
    }
}

