/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.codegen;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Utils {
    private static InputStream urlToStream(String urlStr) throws IOException {
        URL url = new URL(urlStr);
        return new BufferedInputStream(url.openStream());
    }

    private static void downloadUsingNIO(String urlStr, String file) throws IOException {
        URL url = new URL(urlStr);
        ReadableByteChannel rbc = Channels.newChannel(url.openStream());
        FileOutputStream fos = new FileOutputStream(file);
        fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
        fos.close();
        rbc.close();
    }

    public static String camelize(String word) {
        return Utils.camelize(word, false);
    }

    public static String camelize(String word, boolean lowercaseFirstLetter) {
        Pattern p = Pattern.compile("\\/(.?)");
        Matcher m = p.matcher((CharSequence)word);
        while (m.find()) {
            word = m.replaceFirst("." + m.group(1));
            m = p.matcher((CharSequence)word);
        }
        word = ((String)word).replaceAll("-", ".");
        String[] parts = ((String)word).split("\\.");
        StringBuilder f = new StringBuilder();
        for (String z : parts) {
            if (z.length() <= 0) continue;
            f.append(Character.toUpperCase(z.charAt(0))).append(z.substring(1));
        }
        word = f.toString();
        m = p.matcher((CharSequence)word);
        while (m.find()) {
            word = m.replaceFirst(Character.toUpperCase(m.group(1).charAt(0)) + m.group(1).substring(1));
            m = p.matcher((CharSequence)word);
        }
        p = Pattern.compile("(\\.?)(\\w)([^\\.]*)$");
        m = p.matcher((CharSequence)word);
        if (m.find()) {
            Object rep = m.group(1) + m.group(2).toUpperCase() + m.group(3);
            rep = ((String)rep).replaceAll("\\$", "\\\\\\$");
            word = m.replaceAll((String)rep);
        }
        p = Pattern.compile("(_)(.)");
        m = p.matcher((CharSequence)word);
        while (m.find()) {
            word = m.replaceFirst(m.group(2).toUpperCase());
            m = p.matcher((CharSequence)word);
        }
        if (lowercaseFirstLetter) {
            word = ((String)word).substring(0, 1).toLowerCase() + ((String)word).substring(1);
        }
        return word;
    }

    public static boolean isUrl(String location) {
        return location.startsWith("http://") || location.startsWith("https://");
    }

    public static byte[] urlToByteArray(URL url) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(url.openStream());){
            byte[] byArray;
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                int count;
                byte[] data = new byte[1024];
                while ((count = in.read(data, 0, 1024)) != -1) {
                    out.write(data, 0, count);
                }
                byArray = out.toByteArray();
            }
            return byArray;
        }
    }
}

