/*
 * Decompiled with CFR 0.152.
 */
package com.ning.api.client;

public class NingClientConfig {
    protected static final int DEFAULT_READ_TIMEOUT_MSECS = 8000;
    protected static final int DEFAULT_WRITE_TIMEOUT_MSECS = 5000;
    protected static final boolean DEFAULT_USE_HTTPS = Boolean.FALSE;
    private static final NingClientConfig DEFAULT_SETTINGS = new NingClientConfig(8000, 5000, DEFAULT_USE_HTTPS);
    protected Integer readTimeoutMsecs;
    protected Integer writeTimeoutMsecs;
    protected Boolean useSecureConnection;

    public NingClientConfig() {
        this(null, null, null);
    }

    public NingClientConfig(Integer readTimeoutMsecs, Integer writeTimeoutMsecs, Boolean useHttps) {
        this.readTimeoutMsecs = readTimeoutMsecs;
        this.writeTimeoutMsecs = writeTimeoutMsecs;
        this.useSecureConnection = useHttps;
    }

    public NingClientConfig withReadTimeoutMsecs(Integer value) {
        return new NingClientConfig(value, this.writeTimeoutMsecs, this.useSecureConnection);
    }

    public NingClientConfig withWriteTimeoutMsecs(Integer value) {
        return new NingClientConfig(this.readTimeoutMsecs, value, this.useSecureConnection);
    }

    public NingClientConfig withSecureConnection() {
        return new NingClientConfig(this.readTimeoutMsecs, this.writeTimeoutMsecs, Boolean.TRUE);
    }

    public NingClientConfig withNonSecureConnection() {
        return new NingClientConfig(this.readTimeoutMsecs, this.writeTimeoutMsecs, Boolean.TRUE);
    }

    public NingClientConfig withAnyConnection() {
        return new NingClientConfig(this.readTimeoutMsecs, this.writeTimeoutMsecs, null);
    }

    public static NingClientConfig defaults() {
        return DEFAULT_SETTINGS;
    }

    public NingClientConfig overrideWith(NingClientConfig overrides) {
        if (overrides == null) {
            return this;
        }
        Integer readTimeout = this.choose(this.getReadTimeoutMsecs(), overrides.getReadTimeoutMsecs());
        Integer writeTimeout = this.choose(this.getWriteTimeoutMsecs(), overrides.getWriteTimeoutMsecs());
        Boolean useSecure = this.choose(this.getUseSecureConnection(), overrides.getUseSecureConnection());
        return new NingClientConfig(readTimeout, writeTimeout, useSecure);
    }

    public Integer getReadTimeoutMsecs() {
        return this.readTimeoutMsecs;
    }

    public Integer getWriteTimeoutMsecs() {
        return this.writeTimeoutMsecs;
    }

    public Boolean getUseSecureConnection() {
        return this.useSecureConnection;
    }

    protected <T> T choose(T baseline, T override) {
        if (override != null) {
            return override;
        }
        return baseline;
    }
}

