/*
 * Decompiled with CFR 0.152.
 */
package com.ning.api.client.access;

import com.ning.api.client.NingClientConfig;
import com.ning.api.client.access.Items;
import com.ning.api.client.access.NingConnection;
import com.ning.api.client.access.impl.DefaultCounter;
import com.ning.api.client.access.impl.DefaultFinder;
import com.ning.api.client.access.impl.DefaultLister;
import com.ning.api.client.access.impl.DefaultUpdater;
import com.ning.api.client.access.impl.PagedListImpl;
import com.ning.api.client.action.PagedList;
import com.ning.api.client.action.Updater;
import com.ning.api.client.http.NingHttpGet;
import com.ning.api.client.http.NingHttpPut;
import com.ning.api.client.http.NingHttpRequest;
import com.ning.api.client.item.Fields;
import com.ning.api.client.item.User;
import com.ning.api.client.item.UserField;
import java.util.List;
import org.joda.time.ReadableDateTime;

public class Users
extends Items<User, UserField> {
    public Users(NingConnection connection, NingClientConfig config) {
        super(connection, config, "User", User.class, UserField.class);
    }

    public Counter counter(ReadableDateTime createdAfter) {
        return new Counter(this.connection, this.config, this.endpointForCount(), createdAfter, null, null);
    }

    public UserFinder finder(UserField firstField, UserField ... otherFields) {
        return this.finder(new Fields(UserField.class, (Enum)firstField, (Enum[])otherFields));
    }

    public UserFinder finder(Fields<UserField> fields) {
        return new UserFinder(this.connection, this.config, this.endpointForSingle(), fields);
    }

    public UserLister listerForAlpha(UserField firstField, UserField ... otherFields) {
        return this.listerForAlpha(new Fields(UserField.class, (Enum)firstField, (Enum[])otherFields));
    }

    public UserLister listerForAlpha(Fields<UserField> fields) {
        return new UserLister(this.connection, this.config, this.endpointForAlpha(), fields, null, null, null);
    }

    public UserLister listerForRecent(UserField firstField, UserField ... otherFields) {
        return this.listerForRecent(new Fields(UserField.class, (Enum)firstField, (Enum[])otherFields));
    }

    public UserLister listerForRecent(Fields<UserField> fields) {
        return new UserLister(this.connection, this.config, this.endpointForRecent(), fields, null, null, null);
    }

    public Updater<User> updater(User user) {
        return new UserUpdater(this.connection, this.config, this.endpointForPUT(), user);
    }

    public Updater<User> updater() {
        return new UserUpdater(this.connection, this.config, this.endpointForPUT(), new User());
    }

    public static class UserUpdater
    extends DefaultUpdater<User> {
        protected User user;

        protected UserUpdater(NingConnection connection, NingClientConfig config, String endpoint, User user) {
            super(connection, config, endpoint);
            this.user = user;
        }

        @Override
        protected NingHttpPut addUpdateParameters(NingHttpPut put) {
            if (this.user.getStatusMessage() != null) {
                put = (NingHttpPut)put.addFormParameter("statusMessage", this.user.getStatusMessage());
            }
            if (this.user.isApproved() != null) {
                put = (NingHttpPut)put.addFormParameter("approved", this.user.isApproved().toString());
            }
            return put;
        }

        public UserUpdater approved(Boolean approvedOrNot) {
            this.user = this.user.clone();
            this.user.setApproved(approvedOrNot);
            return this;
        }
    }

    public static class UserLister
    extends DefaultLister<User, UserField> {
        protected final Boolean isMember;

        protected UserLister(NingConnection connection, NingClientConfig config, String endpoint, Fields<UserField> fields, String author, Boolean isApproved, Boolean isMember) {
            super(connection, config, endpoint, fields, author, null, isApproved);
            this.isMember = isMember;
        }

        public UserLister author(String author) {
            return new UserLister(this.connection, this.config, this.endpoint, this.fields, author, this.isApproved, this.isMember);
        }

        public UserLister unapproved() {
            return new UserLister(this.connection, this.config, this.endpoint, this.fields, this.author, Boolean.FALSE, this.isMember);
        }

        public UserLister onlyMembers() {
            return new UserLister(this.connection, this.config, this.endpoint, this.fields, this.author, this.isApproved, Boolean.TRUE);
        }

        @Override
        public PagedList<User> list() {
            NingHttpRequest.Param memberParam = this.isMember == null ? null : new NingHttpRequest.Param("isMember", this.isMember.toString());
            return new PagedListImpl(this.connection, this.config, this.endpoint, User.class, this.fields, this.author, null, null, memberParam);
        }
    }

    public static class UserFinder
    extends DefaultFinder<User, UserField> {
        public UserFinder(NingConnection connection, NingClientConfig config, String endpoint, Fields<UserField> fields) {
            super(connection, config, endpoint, User.class, fields);
        }

        public User findByAuthor(String author) {
            NingHttpGet getter = this.prepareQuery();
            getter = (NingHttpGet)getter.addQueryParameter("author", author);
            return (User)getter.execute(this.config.getReadTimeoutMsecs().intValue()).asSingleItem(this.itemType);
        }

        public List<User> findByAuthors(String ... authors) {
            throw new UnsupportedOperationException("Not yet implemented");
        }
    }

    public static class Counter
    extends DefaultCounter {
        protected final Boolean isMember;

        protected Counter(NingConnection connection, NingClientConfig config, String endpoint, ReadableDateTime createdAfter, Boolean isApproved, Boolean isMember) {
            super(connection, config, endpoint, createdAfter, null, null, isApproved);
            this.isMember = isMember;
        }

        public Counter unapproved() {
            return new Counter(this.connection, this.config, this.endpoint, this.createdAfter, Boolean.FALSE, this.isMember);
        }

        public Counter onlyMembers() {
            return new Counter(this.connection, this.config, this.endpoint, this.createdAfter, this.isApproved, Boolean.TRUE);
        }

        @Override
        protected NingHttpGet buildQuery() {
            NingHttpGet query = super.buildQuery();
            if (this.isMember != null) {
                query = (NingHttpGet)query.addQueryParameter("isMember", this.isMember.toString());
            }
            return query;
        }
    }
}

