/*
 * Decompiled with CFR 0.152.
 */
package com.ning.api.client.sample;

import com.ning.api.client.access.Activities;
import com.ning.api.client.access.NingConnection;
import com.ning.api.client.action.PagedList;
import com.ning.api.client.item.Activity;
import com.ning.api.client.item.ActivityField;
import com.ning.api.client.item.Author;
import com.ning.api.client.item.Image;
import com.ning.api.client.sample.SampleIntermediate;
import java.util.List;

public class ManualIterateActivities
extends SampleIntermediate {
    @Override
    public void doAction(NingConnection conn) throws Exception {
        Activities a = conn.activities();
        int entry = 0;
        List<Activity> acts = null;
        Activities.Lister lister = a.listerForRecent(ActivityField.title, ActivityField.type, ActivityField.author, ActivityField.attachedTo, ActivityField.attachedToAuthor, ActivityField.attachedToAuthor_fullName, ActivityField.image_url);
        PagedList<Activity> list = lister.list();
        System.out.println("First, iterate over list in chunks of 3");
        do {
            System.out.println("Request #" + entry / 3 + " (anchor=" + list.position() + "):");
            acts = list.next(3);
            for (Activity act : acts) {
                System.out.println(" activity #" + ++entry + " -> " + ManualIterateActivities.toString(act));
            }
        } while (!acts.isEmpty());
        System.out.println("Done!");
    }

    static String toString(Activity act) {
        String base = "activity of type " + act.getType() + ", title '" + act.getTitle() + "', author: " + act.getAuthor();
        Author auth = act.getAttachedToAuthorResource();
        base = auth == null ? base + ", author info UNKNOWN" : base + ", author name: " + auth.getFullName();
        Image image = act.getImageResource();
        base = image == null ? base + ", NO image" : base + ", image url: " + image.getUrl();
        return base;
    }

    public static void main(String[] args) throws Exception {
        new ManualIterateActivities().action();
    }
}

