/*
 * Decompiled with CFR 0.152.
 */
package com.ning.api.client.sample;

import com.ning.api.client.access.BlogPosts;
import com.ning.api.client.access.NingConnection;
import com.ning.api.client.item.BlogPost;
import com.ning.api.client.sample.SampleIntermediate;
import org.joda.time.DateTime;
import org.joda.time.ReadableDateTime;

public class ManualAddBlogPost
extends SampleIntermediate {
    @Override
    public void doAction(NingConnection conn) throws Exception {
        BlogPosts posts = conn.blogPosts();
        DateTime now = new DateTime();
        String nowStr = now.toString();
        long startTime = System.currentTimeMillis();
        int count = posts.counter((ReadableDateTime)now.minusDays(5)).count();
        long took = System.currentTimeMillis() - startTime;
        System.out.println("Existing blogs during past 5 days: " + count + " (took " + took + " msecs)");
        System.out.println("Add new post:");
        String title = "Blog post #" + count + ", at " + nowStr;
        String desc = "Test post, sent via Java client";
        BlogPost post = new BlogPost(title, desc);
        post.setPublishTime((ReadableDateTime)now);
        startTime = System.currentTimeMillis();
        posts.creator(post).create();
        took = System.currentTimeMillis() - startTime;
        System.out.println("Created, took " + took + " msecs");
    }

    public static void main(String[] args) throws Exception {
        new ManualAddBlogPost().action();
    }
}

