/*
 * Decompiled with CFR 0.152.
 */
package com.openlayer.api.core;

import com.openlayer.api.core.PhantomReachable;
import com.openlayer.api.core.Sleeper;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/openlayer/api/core/PhantomReachableSleeper;", "Lcom/openlayer/api/core/Sleeper;", "sleeper", "(Lcom/openlayer/api/core/Sleeper;)V", "close", "", "sleep", "duration", "Ljava/time/Duration;", "sleepAsync", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "openlayer-java-core"})
public final class PhantomReachableSleeper
implements Sleeper {
    @NotNull
    private final Sleeper sleeper;

    public PhantomReachableSleeper(@NotNull Sleeper sleeper) {
        Intrinsics.checkNotNullParameter((Object)sleeper, (String)"sleeper");
        this.sleeper = sleeper;
        PhantomReachable.closeWhenPhantomReachable((Object)this, this.sleeper);
    }

    @Override
    public void sleep(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        this.sleeper.sleep(duration);
    }

    @Override
    @NotNull
    public CompletableFuture<Void> sleepAsync(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        return this.sleeper.sleepAsync(duration);
    }

    @Override
    public void close() {
        this.sleeper.close();
    }
}

