/*
 * Decompiled with CFR 0.152.
 */
package com.openlayer.api.core.http;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.openlayer.api.core.MultipartField;
import com.openlayer.api.core.http.HttpRequestBodies;
import com.openlayer.api.core.http.HttpRequestBody;
import com.openlayer.api.core.http.MultipartBody;
import com.openlayer.api.errors.OpenlayerInvalidDataException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0000\u001a\u00020\u0001\"\u0006\b\u0000\u0010\u0002\u0018\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u0002H\u0002H\u0080\b\u00a2\u0006\u0002\u0010\u0006\u001a(\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\tH\u0000\u001a*\u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000f0\u000e0\r2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0013"}, d2={"json", "Lcom/openlayer/api/core/http/HttpRequestBody;", "T", "jsonMapper", "Lcom/fasterxml/jackson/databind/json/JsonMapper;", "value", "(Lcom/fasterxml/jackson/databind/json/JsonMapper;Ljava/lang/Object;)Lcom/openlayer/api/core/http/HttpRequestBody;", "multipartFormData", "fields", "", "", "Lcom/openlayer/api/core/MultipartField;", "serializePart", "Lkotlin/sequences/Sequence;", "Lkotlin/Pair;", "Ljava/io/InputStream;", "name", "node", "Lcom/fasterxml/jackson/databind/JsonNode;", "openlayer-java-core"})
@JvmName(name="HttpRequestBodies")
@SourceDebugExtension(value={"SMAP\nHttpRequestBodies.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpRequestBodies.kt\ncom/openlayer/api/core/http/HttpRequestBodies\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,268:1\n215#2:269\n216#2:272\n1295#3,2:270\n*S KotlinDebug\n*F\n+ 1 HttpRequestBodies.kt\ncom/openlayer/api/core/http/HttpRequestBodies\n*L\n42#1:269\n42#1:272\n54#1:270,2\n*E\n"})
public final class HttpRequestBodies {
    public static final /* synthetic */ <T> HttpRequestBody json(JsonMapper jsonMapper, T value2) {
        Intrinsics.checkNotNullParameter((Object)jsonMapper, (String)"jsonMapper");
        boolean $i$f$json = false;
        return new HttpRequestBody(jsonMapper, value2){
            @NotNull
            private final Lazy bytes$delegate;
            {
                this.bytes$delegate = LazyKt.lazy((Function0)((Function0)new Function0<byte[]>($jsonMapper, $value){
                    final /* synthetic */ JsonMapper $jsonMapper;
                    final /* synthetic */ T $value;
                    {
                        this.$jsonMapper = $jsonMapper;
                        this.$value = $value;
                        super(0);
                    }

                    public final byte[] invoke() {
                        return this.$jsonMapper.writeValueAsBytes(this.$value);
                    }
                }));
            }

            private final byte[] getBytes() {
                Lazy lazy = this.bytes$delegate;
                Object object = lazy.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-bytes>(...)");
                return (byte[])object;
            }

            public void writeTo(@NotNull OutputStream outputStream) {
                Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                outputStream.write(this.getBytes());
            }

            @NotNull
            public String contentType() {
                return "application/json";
            }

            public long contentLength() {
                return this.getBytes().length;
            }

            public boolean repeatable() {
                return true;
            }

            public void close() {
            }
        };
    }

    public static final /* synthetic */ HttpRequestBody multipartFormData(JsonMapper jsonMapper, Map fields) {
        MultipartBody.Builder builder;
        Intrinsics.checkNotNullParameter((Object)jsonMapper, (String)"jsonMapper");
        Intrinsics.checkNotNullParameter((Object)fields, (String)"fields");
        MultipartBody.Builder $this$multipartFormData_u24lambda_u242 = builder = new MultipartBody.Builder();
        boolean bl = false;
        Map $this$forEach$iv = fields;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Sequence<Pair<String, InputStream>> parts;
            Sequence<Pair<String, InputStream>> sequence;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl2 = false;
            String name = (String)entry.getKey();
            MultipartField field = (MultipartField)entry.getValue();
            Object knownValue = OptionalsKt.getOrNull(field.value().asKnown());
            if (knownValue instanceof InputStream) {
                Object[] objectArray = new Pair[]{TuplesKt.to((Object)name, (Object)knownValue)};
                sequence = SequencesKt.sequenceOf((Object[])objectArray);
            } else {
                JsonNode node = jsonMapper.valueToTree(field.value());
                Intrinsics.checkNotNullExpressionValue((Object)node, (String)"node");
                sequence = HttpRequestBodies.serializePart(name, node);
            }
            Sequence<Pair<String, InputStream>> $this$forEach$iv2 = parts = sequence;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                HttpRequestBody httpRequestBody;
                Pair pair = (Pair)element$iv2;
                boolean bl3 = false;
                String name2 = (String)pair.component1();
                InputStream bytes2 = (InputStream)pair.component2();
                if (bytes2 instanceof ByteArrayInputStream) {
                    byte[] byteArray = ByteStreamsKt.readBytes((InputStream)bytes2);
                    httpRequestBody = new HttpRequestBody(byteArray, field){
                        final /* synthetic */ byte[] $byteArray;
                        final /* synthetic */ MultipartField<?> $field;
                        {
                            this.$byteArray = $byteArray;
                            this.$field = $field;
                        }

                        public void writeTo(@NotNull OutputStream outputStream) {
                            Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                            outputStream.write(this.$byteArray);
                        }

                        @NotNull
                        public String contentType() {
                            return this.$field.contentType();
                        }

                        public long contentLength() {
                            return this.$byteArray.length;
                        }

                        public boolean repeatable() {
                            return true;
                        }

                        public void close() {
                        }
                    };
                } else {
                    httpRequestBody = new HttpRequestBody(bytes2, field){
                        final /* synthetic */ InputStream $bytes;
                        final /* synthetic */ MultipartField<?> $field;
                        {
                            this.$bytes = $bytes;
                            this.$field = $field;
                        }

                        public void writeTo(@NotNull OutputStream outputStream) {
                            Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                            ByteStreamsKt.copyTo$default((InputStream)this.$bytes, (OutputStream)outputStream, (int)0, (int)2, null);
                        }

                        @NotNull
                        public String contentType() {
                            return this.$field.contentType();
                        }

                        public long contentLength() {
                            return -1L;
                        }

                        public boolean repeatable() {
                            return false;
                        }

                        public void close() {
                            this.$bytes.close();
                        }
                    };
                }
                HttpRequestBody partBody2 = httpRequestBody;
                $this$multipartFormData_u24lambda_u242.addPart(MultipartBody.Part.Companion.create(name2, (String)OptionalsKt.getOrNull(field.filename()), field.contentType(), partBody2));
            }
        }
        return builder.build();
    }

    private static final Sequence<Pair<String, InputStream>> serializePart(String name, JsonNode node) {
        Sequence sequence;
        JsonNodeType jsonNodeType = node.getNodeType();
        switch (jsonNodeType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[jsonNodeType.ordinal()]) {
            case 1: 
            case 2: {
                sequence = SequencesKt.emptySequence();
                break;
            }
            case 3: {
                Object[] objectArray = new Pair[1];
                byte[] byArray = node.binaryValue();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"node.binaryValue()");
                byte[] byArray2 = byArray;
                objectArray[0] = TuplesKt.to((Object)name, (Object)new ByteArrayInputStream(byArray2));
                sequence = SequencesKt.sequenceOf((Object[])objectArray);
                break;
            }
            case 4: {
                Object[] objectArray = new Pair[1];
                String string = node.textValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.textValue()");
                String string2 = string;
                Charset charset = Charsets.UTF_8;
                byte[] byArray = string2.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                objectArray[0] = TuplesKt.to((Object)name, (Object)new ByteArrayInputStream(byArray));
                sequence = SequencesKt.sequenceOf((Object[])objectArray);
                break;
            }
            case 5: {
                Object[] objectArray = new Pair[1];
                String string = String.valueOf(node.booleanValue());
                Charset charset = Charsets.UTF_8;
                byte[] byArray = string.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                objectArray[0] = TuplesKt.to((Object)name, (Object)new ByteArrayInputStream(byArray));
                sequence = SequencesKt.sequenceOf((Object[])objectArray);
                break;
            }
            case 6: {
                Object[] objectArray = new Pair[1];
                String string = node.numberValue().toString();
                Charset charset = Charsets.UTF_8;
                byte[] byArray = string.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                objectArray[0] = TuplesKt.to((Object)name, (Object)new ByteArrayInputStream(byArray));
                sequence = SequencesKt.sequenceOf((Object[])objectArray);
                break;
            }
            case 7: {
                Object[] objectArray = new Pair[1];
                Iterator iterator = node.elements();
                Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"node\n                        .elements()");
                String string = SequencesKt.joinToString$default((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.asSequence((Iterator)iterator), (Function1)serializePart.1.INSTANCE), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
                Charset charset = Charsets.UTF_8;
                byte[] byArray = string.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                objectArray[0] = TuplesKt.to((Object)name, (Object)new ByteArrayInputStream(byArray));
                sequence = SequencesKt.sequenceOf((Object[])objectArray);
                break;
            }
            case 8: {
                Iterator iterator = node.fields();
                Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"node.fields()");
                sequence = SequencesKt.flatMap((Sequence)SequencesKt.asSequence((Iterator)iterator), (Function1)((Function1)new Function1<Map.Entry<String, JsonNode>, Sequence<? extends Pair<? extends String, ? extends InputStream>>>(name){
                    final /* synthetic */ String $name;
                    {
                        this.$name = $name;
                        super(1);
                    }

                    @NotNull
                    public final Sequence<Pair<String, InputStream>> invoke(Map.Entry<String, JsonNode> entry) {
                        Intrinsics.checkNotNullExpressionValue(entry, (String)"(key, value)");
                        String key = entry.getKey();
                        JsonNode value2 = entry.getValue();
                        String string = this.$name + '[' + key + ']';
                        Intrinsics.checkNotNullExpressionValue((Object)value2, (String)"value");
                        return HttpRequestBodies.access$serializePart(string, value2);
                    }
                }));
                break;
            }
            case -1: 
            case 9: {
                throw new OpenlayerInvalidDataException("Unexpected JsonNode type: " + node.getNodeType(), null, 2, null);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return sequence;
    }

    public static final /* synthetic */ Sequence access$serializePart(String name, JsonNode node) {
        return HttpRequestBodies.serializePart(name, node);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JsonNodeType.values().length];
            try {
                nArray[JsonNodeType.MISSING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonNodeType.NULL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonNodeType.BINARY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonNodeType.STRING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonNodeType.BOOLEAN.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonNodeType.NUMBER.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonNodeType.ARRAY.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonNodeType.OBJECT.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonNodeType.POJO.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

