/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.okhttp;

import com.openshift.internal.restclient.DefaultClient;
import com.openshift.internal.restclient.URLBuilder;
import com.openshift.internal.restclient.model.KubernetesResource;
import com.openshift.internal.restclient.okhttp.ResponseCodeInterceptor;
import com.openshift.restclient.IApiTypeMapper;
import com.openshift.restclient.IClient;
import com.openshift.restclient.IOpenShiftWatchListener;
import com.openshift.restclient.IWatcher;
import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.http.IHttpConstants;
import com.openshift.restclient.model.IList;
import com.openshift.restclient.model.IResource;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.ws.WebSocket;
import okhttp3.ws.WebSocketCall;
import okhttp3.ws.WebSocketListener;
import okio.Buffer;
import org.apache.commons.lang.StringUtils;
import org.jboss.dmr.ModelNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchClient
implements IWatcher,
IHttpConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(WatchClient.class);
    private DefaultClient client;
    private OkHttpClient okClient;
    private AtomicReference<Status> status = new AtomicReference<Status>(Status.Stopped);
    private IApiTypeMapper typeMappings;
    private Map<String, WatchEndpoint> endpointMap = Collections.synchronizedMap(new HashMap());

    public WatchClient(DefaultClient client, IApiTypeMapper typeMapper, OkHttpClient okClient) {
        this.client = client;
        this.typeMappings = typeMapper;
        this.okClient = okClient;
    }

    @Override
    public void stop() {
        if (this.status.compareAndSet(Status.Started, Status.Stopping)) {
            HashMap<String, WatchEndpoint> endpoints = new HashMap<String, WatchEndpoint>(this.endpointMap);
            this.endpointMap.clear();
            endpoints.values().forEach(w -> w.close());
            this.status.set(Status.Stopped);
        }
    }

    public IWatcher watch(Collection<String> kinds, String namespace, IOpenShiftWatchListener listener) {
        if (this.status.compareAndSet(Status.Stopped, Status.Starting)) {
            try {
                for (String kind : kinds) {
                    WatchEndpoint socket = new WatchEndpoint(this.client, listener, kind);
                    String resourceVersion = this.getResourceVersion(kind, namespace, socket);
                    String endpoint = new URLBuilder(this.client.getBaseURL(), this.typeMappings).kind(kind).namespace(namespace).watch().addParmeter("resourceVersion", resourceVersion).websocket();
                    Request request = this.client.newRequestBuilderTo(endpoint).header("Origin", this.client.getBaseURL().toString()).header("User-Agent", "openshift-restclient-java").build();
                    WebSocketCall call = WebSocketCall.create((OkHttpClient)this.okClient.newBuilder().build(), (Request)request);
                    socket.setCall(call);
                    this.endpointMap.put(kind, socket);
                    call.enqueue((WebSocketListener)socket);
                }
                this.status.set(Status.Started);
            }
            catch (Exception e) {
                this.endpointMap.clear();
                this.status.set(Status.Stopped);
                try {
                    throw ResponseCodeInterceptor.createOpenShiftException(this.client, 0, String.format("Could not watch resources in namespace %s: %s", namespace, e.getMessage()), null, e);
                }
                catch (IOException e1) {
                    throw new OpenShiftException((Throwable)e1, "IOException trying to create an OpenShift specific exception", new Object[0]);
                }
            }
        }
        return this;
    }

    private String getResourceVersion(String kind, String namespace, WatchEndpoint endpoint) throws Exception {
        IList list = this.client.get(kind, namespace);
        Collection<IResource> items = list.getItems();
        ArrayList<IResource> resources = new ArrayList<IResource>(items.size());
        resources.addAll(items);
        endpoint.setResources(resources);
        return list.getResourceVersion();
    }

    static class WatchEndpoint
    implements WebSocketListener {
        private IOpenShiftWatchListener listener;
        private List<IResource> resources;
        private final String kind;
        private final IClient client;
        private WebSocket wsClient;
        private WebSocketCall call;

        public WatchEndpoint(IClient client, IOpenShiftWatchListener listener, String kind) {
            this.listener = listener;
            this.kind = kind;
            this.client = client;
        }

        public void setCall(WebSocketCall call) {
            this.call = call;
        }

        void close() {
            try {
                if (this.wsClient != null) {
                    this.wsClient.close(1000, "Client was asked to stop.");
                    this.wsClient = null;
                }
                if (this.call != null) {
                    this.call.cancel();
                }
                this.listener.disconnected();
            }
            catch (Exception e) {
                LOGGER.debug("Unable to stop the watch client", (Throwable)e);
            }
            finally {
                this.wsClient = null;
            }
        }

        public void setResources(List<IResource> resources) {
            this.resources = resources;
        }

        public void onClose(int statusCode, String reason) {
            LOGGER.debug("WatchSocket closed for kind: {}, code: {}, reason: {}", new Object[]{this.kind, statusCode, reason});
            this.listener.disconnected();
        }

        public void onFailure(IOException err, Response response) {
            LOGGER.debug("WatchSocket Error for kind {}: {}", (Object)this.kind, (Object)err);
            try {
                if (response == null) {
                    this.listener.error(ResponseCodeInterceptor.createOpenShiftException(this.client, 0, "", "", err));
                } else if (response.code() == 200 && err instanceof ProtocolException) {
                    LOGGER.debug("The feature isn't supported", (Throwable)err);
                } else {
                    this.listener.error(ResponseCodeInterceptor.createOpenShiftException(this.client, response.code(), response.body().string(), response.request().url().toString(), err));
                }
            }
            catch (IOException e) {
                LOGGER.error("IOException trying to notify listener of specific OpenShiftException", (Throwable)err);
                this.listener.error(err);
            }
        }

        public void onMessage(ResponseBody body) throws IOException {
            String message = body.string();
            LOGGER.debug(message);
            KubernetesResource payload = (KubernetesResource)this.client.getResourceFactory().create(message);
            ModelNode node = payload.getNode();
            IOpenShiftWatchListener.ChangeType event = new IOpenShiftWatchListener.ChangeType(node.get("type").asString());
            Object resource = this.client.getResourceFactory().create(node.get("object").toJSONString(true));
            if (StringUtils.isEmpty((String)resource.getKind())) {
                LOGGER.error("Unable to determine resource kind from: " + node.get("object").toJSONString(false));
            }
            this.listener.received((IResource)resource, event);
        }

        public void onOpen(WebSocket socket, Response response) {
            LOGGER.debug("WatchSocket connected for {}", (Object)this.kind);
            this.wsClient = socket;
            this.listener.connected(this.resources);
        }

        public void onPong(Buffer buffer) {
        }
    }

    private static enum Status {
        Started,
        Starting,
        Stopped,
        Stopping;

    }
}

