package com.paymentplugins;

public class PaymentPlugins {

	private Environment environment;
	
	private String securenetId;
	
	private String secureKey;
	
	private Configuration configuration;

	private Http http;

	private ClientTokenRequest clienTokenRequest;
	
	/**
	 * Creates a PaymentPlugins object that accepts key configuration items necessary for server integration. 
	 * @param environment - The environment you are configuring. Valid values are Environment.SANDBOX and Environment.PRODUCTION.
	 * @param securenetId - The securenet Id that represents your identity when making requests to the Payment Plugins API. This is the Id given to you by SecureNet and can be found by loggin into the SecureNet terminal. 
	 * @param secureKey - The seureKey is used to authenticate all requests to the Payment Plugins API. You can obtain a secureKey by logging into the SecureNet terminal. 
	 */
	public PaymentPlugins(Environment environment, String securenetId, String secureKey){
		this.environment = environment;
		this.securenetId = securenetId;
		this.secureKey = secureKey;
		this.configuration = new Configuration(this.environment, securenetId, secureKey);
		this.http = new Http(this.configuration);
	}
	
	public String getClienToken(ClientTokenRequest clienTokenRequest){
		if(clienTokenRequest == null){
			clienTokenRequest = new ClientTokenRequest();
		}
		XMLNode node = this.http.processRequest("/client_token", Http.Method.POST, clienTokenRequest.buildJsonObject(null));
		ClientToken clientToken = new ClientToken(node.findNode("clientToken"));
		return clientToken.getToken();
	}
}
