/*
 * Decompiled with CFR 0.152.
 */
package com.paymentplugins;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class XMLNode {
    public String name;
    private String value;
    private List<XMLNode> content = new LinkedList<XMLNode>();

    public XMLNode(String name) {
        this.name = name;
    }

    public XMLNode findNode(String name) {
        XMLNode returnNode = null;
        for (XMLNode node : this.content) {
            if (node.name.equals(name)) {
                return node;
            }
            returnNode = node.findNode(name);
            if (returnNode == null) continue;
            break;
        }
        return returnNode;
    }

    public void addNode(XMLNode node) {
        this.content.add(node);
    }

    public void addValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String getString(String name) {
        String value = null;
        if (this.name.equals(name)) {
            value = this.value;
        } else {
            XMLNode node;
            Iterator<XMLNode> iterator = this.content.iterator();
            while (iterator.hasNext() && (value = (node = iterator.next()).getString(name)) == null) {
            }
        }
        return value;
    }

    public List<XMLNode> findAll(String name) {
        String[] parentChild = name.split("/");
        ArrayList<XMLNode> list = new ArrayList<XMLNode>();
        XMLNode rootNode = this.findNode(parentChild[0]);
        for (XMLNode node : rootNode.content) {
            if (!node.name.equals(parentChild[1])) continue;
            list.add(node);
        }
        return list;
    }
}

