/*
 * Decompiled with CFR 0.152.
 */
package com.paymentwall.java;

import com.paymentwall.java.ApiObject;
import com.paymentwall.java.Instance;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpAction
extends Instance {
    protected ApiObject apiObject;
    protected HashMap<String, String> apiParams;
    protected ArrayList<String> apiHeaders;
    private static final int httpTimeoutMs = 60000;

    HttpAction(ApiObject object, HashMap<String, String> params, ArrayList<String> headers) {
        this.setApiObject(object);
        this.setApiParams(params);
        this.setApiHeaders(headers);
    }

    public ApiObject getApiObject() {
        return this.apiObject;
    }

    public void setApiObject(ApiObject apiObject) {
        this.apiObject = apiObject;
    }

    public HashMap<String, String> getApiParams() {
        return this.apiParams;
    }

    public void setApiParams(HashMap<String, String> params) {
        this.apiParams = params;
    }

    public ArrayList<String> getApiHeaders() {
        return this.apiHeaders;
    }

    public void setApiHeaders(ArrayList<String> headers) {
        this.apiHeaders = headers;
    }

    public String run() throws Exception {
        String result = "";
        if (this.getApiObject() != null) {
            result = this.apiObjectPostRequest(this.getApiObject());
        }
        return result;
    }

    private String apiObjectPostRequest(ApiObject object) throws Exception {
        return this.request(Instance.httpMethod.POST, object.getApiUrl(), this.getApiParams(), this.getApiHeaders());
    }

    public String post(String url) throws Exception {
        return this.request(Instance.httpMethod.POST, url, this.getApiParams(), this.getApiHeaders());
    }

    public String get(String url) throws Exception {
        return this.request(Instance.httpMethod.GET, url, this.getApiParams(), this.getApiHeaders());
    }

    protected String request(Instance.httpMethod method, String url, HashMap<String, String> params, ArrayList<String> customHeaders) throws Exception {
        String inputLine;
        int responseCode;
        ArrayList<String> headers = this.sList(this.getLibraryDefaultRequestHeader());
        ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            list.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }
        String encodedParams = URLEncodedUtils.format(list, (String)"UTF-8");
        URL obj = new URL(url);
        HttpURLConnection con = (HttpURLConnection)obj.openConnection();
        if (!customHeaders.isEmpty()) {
            headers.addAll(customHeaders);
        }
        for (String header : headers) {
            String[] pair = header.split(":", 2);
            if (pair.length == 2) {
                String key = pair[0];
                String value = pair[1];
                con.setRequestProperty(key, value);
                continue;
            }
            throw new Exception("Header does not comply format 'key:value'");
        }
        con.setRequestMethod(method.name());
        con.setConnectTimeout(60000);
        con.setDoOutput(true);
        if (method.equals((Object)Instance.httpMethod.POST)) {
            DataOutputStream wr = new DataOutputStream(con.getOutputStream());
            wr.writeBytes(encodedParams);
            wr.flush();
            wr.close();
        }
        BufferedReader in = new BufferedReader(new InputStreamReader((responseCode = con.getResponseCode()) >= 200 && responseCode <= 299 ? con.getInputStream() : con.getErrorStream()));
        StringBuilder response = new StringBuilder();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
        }
        in.close();
        return this.prepareResponse(response.toString());
    }

    protected String getLibraryDefaultRequestHeader() {
        return "User-Agent:Paymentwall Java Library v. " + this.getConfig().getVersion();
    }

    protected String prepareResponse(String string) {
        return string.replaceAll("\\uFEFF", "");
    }
}

