/*
 * Decompiled with CFR 0.152.
 */
package com.paymentwall.java.Signature;

import com.paymentwall.java.Signature.Abstract;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Widget
extends Abstract {
    @Override
    public String process(LinkedHashMap<String, ArrayList<String>> params, int version) {
        MessageDigest md;
        MessageDigest sha;
        String baseString = "";
        if (version == 1) {
            MessageDigest md2;
            baseString = baseString + (params.containsKey("uid") ? params.get("uid").get(0) : "");
            baseString = baseString + this.getConfig().getPrivateKey();
            try {
                md2 = MessageDigest.getInstance("MD5");
                md2.update(baseString.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                return "";
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
                return "";
            }
            return String.format("%032X", new BigInteger(1, md2.digest())).toLowerCase();
        }
        params = this.sortMultiDimensional(params);
        baseString = this.prepareParams(params, baseString);
        baseString = baseString + this.getConfig().getPrivateKey();
        try {
            sha = MessageDigest.getInstance("SHA-256");
            sha.update(baseString.getBytes("UTF-8"));
            md = MessageDigest.getInstance("MD5");
            md.update(baseString.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "";
        }
        if (version == 3) {
            return String.format("%064X", new BigInteger(1, sha.digest())).toLowerCase();
        }
        return String.format("%032X", new BigInteger(1, md.digest())).toLowerCase();
    }

    @Override
    public String prepareParams(HashMap<String, ArrayList<String>> params, String baseString) {
        for (Map.Entry<String, ArrayList<String>> pair : params.entrySet()) {
            if (pair.getValue().size() > 1) {
                int i = 0;
                for (String each : pair.getValue()) {
                    baseString = baseString + pair.getKey() + "[" + i + "]" + "=" + (each.equals("false") ? "0" : each);
                    ++i;
                }
                continue;
            }
            baseString = baseString + pair.getKey() + "=" + (pair.getValue().get(0).equals("false") ? "0" : pair.getValue().get(0));
        }
        return baseString;
    }
}

