/*
 * Decompiled with CFR 0.152.
 */
package com.phaxio.services;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.phaxio.entities.Paging;
import com.phaxio.exceptions.ApiConnectionException;
import com.phaxio.exceptions.AuthenticationException;
import com.phaxio.exceptions.InvalidRequestException;
import com.phaxio.exceptions.NotFoundException;
import com.phaxio.exceptions.RateLimitException;
import com.phaxio.exceptions.ServerException;
import com.phaxio.restclient.RestClient;
import com.phaxio.restclient.entities.Method;
import com.phaxio.restclient.entities.RestRequest;
import com.phaxio.restclient.entities.RestResponse;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class Requests {
    private static final String KEY_PARAMETER = "api_key";
    private static final String SECRET_PARAMETER = "api_secret";
    private final String key;
    private final String secret;
    private final RestClient client;

    public Requests(String key, String secret, String endpoint, int port) {
        this(key, secret, endpoint, port, null);
    }

    public Requests(String key, String secret, String endpoint, int port, Proxy proxy) {
        this.secret = secret;
        this.key = key;
        String endpointWithPort = String.format(endpoint, port);
        this.client = new RestClient(endpointWithPort, proxy);
    }

    public <T> T get(RestRequest request, Class clazz) {
        request.setMethod(Method.GET);
        RestResponse response = this.execute(request);
        return this.getData(response, clazz);
    }

    public <T> Iterable<T> list(final RestRequest request, final Class clazz) {
        request.setMethod(Method.GET);
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    private Paging paging;
                    private List<T> list;
                    private Iterator<T> iterator;
                    {
                        this.load();
                    }

                    private void load() {
                        try {
                            RestResponse response = Requests.this.execute(request);
                            JsonNode json = response.toJson();
                            ArrayNode arrayNode = (ArrayNode)json.get("data");
                            this.paging = (Paging)response.getMapper().readValue(json.get("paging").toString(), Paging.class);
                            this.list = Requests.this.getList(arrayNode, response.getMapper(), clazz);
                            this.iterator = null;
                        }
                        catch (IOException e) {
                            throw new ApiConnectionException("Could not connect to the Phaxio API", e);
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        return this.getIter().hasNext() || this.hasNextPage();
                    }

                    @Override
                    public T next() {
                        if (this.getIter().hasNext()) {
                            return this.getIter().next();
                        }
                        if (this.hasNextPage()) {
                            request.addOrReplaceParameter("page", this.paging.page + 1);
                            this.load();
                            return this.getIter().next();
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new NotImplementedException();
                    }

                    private Iterator<T> getIter() {
                        if (this.iterator == null) {
                            this.iterator = this.list.iterator();
                        }
                        return this.iterator;
                    }

                    private boolean hasNextPage() {
                        return this.totalPages() > this.paging.page;
                    }

                    private int totalPages() {
                        BigDecimal total = new BigDecimal(this.paging.total);
                        BigDecimal perPage = new BigDecimal(this.paging.perPage);
                        return (int)total.divide(perPage, RoundingMode.UP).longValue();
                    }
                };
            }
        };
    }

    public <T> T post(RestRequest request, Class clazz) {
        request.setMethod(Method.POST);
        RestResponse response = this.execute(request);
        return this.getData(response, clazz);
    }

    public void post(RestRequest request) {
        request.setMethod(Method.POST);
        this.execute(request);
    }

    public byte[] download(RestRequest request) {
        request.setMethod(Method.GET);
        RestResponse response = this.execute(request);
        try {
            return response.getRawBytes();
        }
        catch (IOException e) {
            throw new ApiConnectionException("Could not connect to the Phaxio API", e);
        }
    }

    public void delete(RestRequest request) {
        request.setMethod(Method.DELETE);
        this.execute(request);
    }

    private RestResponse execute(RestRequest request) {
        request.addOrReplaceParameter(SECRET_PARAMETER, this.secret);
        request.addOrReplaceParameter(KEY_PARAMETER, this.key);
        RestResponse response = this.client.execute(request);
        if (response.getException() != null) {
            throw new ApiConnectionException("Could not connection the Phaxio API", response.getException());
        }
        try {
            switch (response.getStatusCode()) {
                case 200: 
                case 201: {
                    return response;
                }
                case 401: {
                    throw new AuthenticationException(this.getMessage(response));
                }
                case 404: {
                    throw new NotFoundException(this.getMessage(response));
                }
                case 429: {
                    throw new RateLimitException(this.getMessage(response));
                }
                case 422: {
                    throw new InvalidRequestException(this.getMessage(response));
                }
            }
            throw new ServerException(this.getMessage(response));
        }
        catch (IOException e) {
            throw new ApiConnectionException("Could not connect to the Phaxio API", e);
        }
    }

    private String getMessage(RestResponse response) throws IOException {
        if (response.getContentType().startsWith("application/json")) {
            return response.toJson().get("message").asText();
        }
        return "";
    }

    private <T> T getData(RestResponse response, Class clazz) {
        try {
            Object object = response.getMapper().readValue(response.toJson().get("data").toString(), clazz);
            this.addClient(object, clazz);
            return (T)object;
        }
        catch (IOException e) {
            throw new ApiConnectionException("Could not connect to the Phaxio API", e);
        }
    }

    private <T> List<T> getList(ArrayNode arrayNode, ObjectMapper mapper, Class clazz) throws IOException {
        ArrayList<Object> list = new ArrayList<Object>();
        for (JsonNode node : arrayNode) {
            Object object = mapper.readValue(node.toString(), clazz);
            this.addClient(object, clazz);
            list.add(object);
        }
        return list;
    }

    private void addClient(Object object, Class clazz) {
        try {
            java.lang.reflect.Method[] methods = clazz.getMethods();
            java.lang.reflect.Method method = null;
            Object[] parameterTypes = new Class[]{Requests.class};
            for (java.lang.reflect.Method m : methods) {
                if (!m.getName().equals("setClient") || !Arrays.equals(m.getParameterTypes(), parameterTypes)) continue;
                method = m;
            }
            if (method != null) {
                method.invoke(object, this);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

