/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.plaid.client.PlaidUserClient;
import com.plaid.client.exception.PlaidClientsideException;
import com.plaid.client.exception.PlaidMfaException;
import com.plaid.client.http.HttpDelegate;
import com.plaid.client.http.HttpResponseWrapper;
import com.plaid.client.http.PlaidHttpRequest;
import com.plaid.client.request.ConnectOptions;
import com.plaid.client.request.Credentials;
import com.plaid.client.request.GetOptions;
import com.plaid.client.response.AccountsResponse;
import com.plaid.client.response.MessageResponse;
import com.plaid.client.response.PlaidUserResponse;
import com.plaid.client.response.TransactionsResponse;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class DefaultPlaidUserClient
implements PlaidUserClient {
    private String accessToken;
    private String clientId;
    private String secret;
    private ObjectMapper jsonMapper;
    private HttpDelegate httpDelegate;

    public DefaultPlaidUserClient(HttpDelegate httpDelegate, String clientId, String secret) {
        this.httpDelegate = httpDelegate;
        this.clientId = clientId;
        this.secret = secret;
        ObjectMapper jsonMapper = new ObjectMapper();
        jsonMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.jsonMapper = jsonMapper;
    }

    @Override
    public void setAccessToken(String accesstoken) {
        this.accessToken = accesstoken;
    }

    @Override
    public String getAccessToken() {
        return this.accessToken;
    }

    @Override
    public TransactionsResponse addUser(Credentials credentials, String type, String email, ConnectOptions connectOptions) throws PlaidMfaException {
        HashMap<String, Object> requestParams = new HashMap<String, Object>();
        requestParams.put("credentials", credentials);
        requestParams.put("type", type);
        requestParams.put("email", email);
        requestParams.put("options", connectOptions);
        return this.handlePost("/connect", requestParams, TransactionsResponse.class);
    }

    @Override
    public AccountsResponse achAuth(Credentials credentials, String type, ConnectOptions connectOptions) throws PlaidMfaException {
        HashMap<String, Object> requestParams = new HashMap<String, Object>();
        requestParams.put("credentials", credentials);
        requestParams.put("type", type);
        requestParams.put("options", connectOptions);
        return this.handlePost("/auth", requestParams, AccountsResponse.class);
    }

    @Override
    public TransactionsResponse mfaConnectStep(String mfa, String type) throws PlaidMfaException {
        return this.handleMfa("/connect/step", mfa, type, TransactionsResponse.class);
    }

    @Override
    public TransactionsResponse mfaAuthStep(String mfa, String type) throws PlaidMfaException {
        return this.handleMfa("/auth/step", mfa, type, TransactionsResponse.class);
    }

    @Override
    public TransactionsResponse updateTransactions() {
        if (StringUtils.isEmpty((String)this.accessToken)) {
            throw new PlaidClientsideException("No accessToken set");
        }
        PlaidHttpRequest request = new PlaidHttpRequest("/connect", this.authenticationParams());
        HttpResponseWrapper<TransactionsResponse> response = this.httpDelegate.doGet(request, TransactionsResponse.class);
        TransactionsResponse body = response.getResponseBody();
        this.setAccessToken(body.getAccessToken());
        return body;
    }

    @Override
    public TransactionsResponse updateTransactions(GetOptions options) {
        if (StringUtils.isEmpty((String)this.accessToken)) {
            throw new PlaidClientsideException("No accessToken set");
        }
        HashMap<String, Object> requestParams = new HashMap<String, Object>();
        requestParams.put("options", options);
        return this.handlePost("/connect/get", requestParams, TransactionsResponse.class);
    }

    @Override
    public TransactionsResponse updateCredentials(Credentials credentials, String type) {
        if (StringUtils.isEmpty((String)this.accessToken)) {
            throw new PlaidClientsideException("No accessToken set");
        }
        PlaidHttpRequest request = new PlaidHttpRequest("/connect", this.authenticationParams());
        try {
            String credentialsString = this.jsonMapper.writeValueAsString((Object)credentials);
            request.addParameter("credentials", credentialsString);
            request.addParameter("type", type);
            HttpResponseWrapper<TransactionsResponse> response = this.httpDelegate.doPatch(request, TransactionsResponse.class);
            TransactionsResponse body = response.getResponseBody();
            this.setAccessToken(body.getAccessToken());
            return body;
        }
        catch (JsonProcessingException e) {
            throw new PlaidClientsideException(e);
        }
    }

    @Override
    public MessageResponse deleteUser() {
        if (StringUtils.isEmpty((String)this.accessToken)) {
            throw new PlaidClientsideException("No accessToken set");
        }
        PlaidHttpRequest request = new PlaidHttpRequest("/connect", this.authenticationParams());
        HttpResponseWrapper<MessageResponse> response = this.httpDelegate.doDelete(request, MessageResponse.class);
        return response.getResponseBody();
    }

    @Override
    public AccountsResponse checkBalance() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    private <T extends PlaidUserResponse> T handleMfa(String path, String mfa, String type, Class<T> returnTypeClass) throws PlaidMfaException {
        if (StringUtils.isEmpty((String)this.accessToken)) {
            throw new PlaidClientsideException("No accessToken set");
        }
        HashMap<String, Object> requestParams = new HashMap<String, Object>();
        requestParams.put("mfa", mfa);
        if (type != null) {
            requestParams.put("type", type);
        }
        return this.handlePost(path, requestParams, returnTypeClass);
    }

    private <T extends PlaidUserResponse> T handlePost(String path, Map<String, Object> requestParams, Class<T> returnTypeClass) throws PlaidMfaException {
        PlaidHttpRequest request = new PlaidHttpRequest(path, this.authenticationParams());
        try {
            for (String param : requestParams.keySet()) {
                Object value = requestParams.get(param);
                if (value == null) continue;
                String stringValue = value instanceof String ? (String)value : this.jsonMapper.writeValueAsString(value);
                request.addParameter(param, stringValue);
            }
        }
        catch (JsonProcessingException e) {
            throw new PlaidClientsideException(e);
        }
        try {
            HttpResponseWrapper<T> response = this.httpDelegate.doPost(request, returnTypeClass);
            PlaidUserResponse body = (PlaidUserResponse)response.getResponseBody();
            this.setAccessToken(body.getAccessToken());
            return (T)body;
        }
        catch (PlaidMfaException e) {
            this.setAccessToken(e.getMfaResponse().getAccessToken());
            throw e;
        }
    }

    private Map<String, String> authenticationParams() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("client_id", this.clientId);
        parameters.put("secret", this.secret);
        if (!StringUtils.isEmpty((String)this.accessToken)) {
            parameters.put("access_token", this.accessToken);
        }
        return parameters;
    }

    @Override
    public HttpDelegate getHttpDelegate() {
        return this.httpDelegate;
    }
}

