/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client;

import com.plaid.client.DefaultPlaidPublicClient;
import com.plaid.client.DefaultPlaidUserClient;
import com.plaid.client.PlaidPublicClient;
import com.plaid.client.PlaidUserClient;
import com.plaid.client.http.ApacheHttpClientHttpDelegate;
import com.plaid.client.http.WireLogger;

public class PlaidClients {
    public static final String BASE_URI_PRODUCTION = "https://api.plaid.com";
    public static final String BASE_URI_TEST = "https://tartan.plaid.com";

    public static PlaidUserClient productionUserClient(String clientId, String secret, WireLogger wireLogger) {
        return new DefaultPlaidUserClient(PlaidClients.createHttpDelegate(BASE_URI_PRODUCTION, wireLogger), clientId, secret);
    }

    public static PlaidUserClient testUserClient(String clientId, String secret, WireLogger wireLogger) {
        return new DefaultPlaidUserClient(PlaidClients.createHttpDelegate(BASE_URI_TEST, wireLogger), clientId, secret);
    }

    public static PlaidPublicClient productionPublicClient(WireLogger wireLogger) {
        return new DefaultPlaidPublicClient(PlaidClients.createHttpDelegate(BASE_URI_PRODUCTION, wireLogger));
    }

    public static PlaidPublicClient testPublicClient(WireLogger wireLogger) {
        return new DefaultPlaidPublicClient(PlaidClients.createHttpDelegate(BASE_URI_TEST, wireLogger));
    }

    public static PlaidUserClient productionUserClient(String clientId, String secret) {
        return PlaidClients.productionUserClient(clientId, secret, null);
    }

    public static PlaidUserClient testUserClient(String clientId, String secret) {
        return PlaidClients.testUserClient(clientId, secret, null);
    }

    public static PlaidPublicClient productionPublicClient() {
        return PlaidClients.productionPublicClient(null);
    }

    public static PlaidPublicClient testPublicClient() {
        return PlaidClients.testPublicClient(null);
    }

    private static ApacheHttpClientHttpDelegate createHttpDelegate(String uri, WireLogger wireLogger) {
        ApacheHttpClientHttpDelegate httpDelegate = ApacheHttpClientHttpDelegate.createDefault(BASE_URI_PRODUCTION);
        if (wireLogger != null) {
            httpDelegate.setWireLogger(wireLogger);
        }
        return httpDelegate;
    }
}

