/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.http;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.plaid.client.exception.PlaidClientsideException;
import com.plaid.client.exception.PlaidCommunicationsException;
import com.plaid.client.exception.PlaidMfaException;
import com.plaid.client.exception.PlaidServersideException;
import com.plaid.client.http.HttpDelegate;
import com.plaid.client.http.HttpResponseWrapper;
import com.plaid.client.http.PlaidHttpRequest;
import com.plaid.client.http.WireLogger;
import com.plaid.client.response.ErrorResponse;
import com.plaid.client.response.MfaResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpMessage;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class ApacheHttpClientHttpDelegate
implements HttpDelegate {
    private String baseUri;
    private CloseableHttpClient httpClient;
    private ObjectMapper jsonMapper;
    private WireLogger wireLogger;

    public ApacheHttpClientHttpDelegate(String baseUri, CloseableHttpClient httpClient) {
        this.baseUri = baseUri;
        this.httpClient = httpClient;
        this.jsonMapper = new ObjectMapper();
    }

    public static ApacheHttpClientHttpDelegate createDefault(String baseUri) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        return new ApacheHttpClientHttpDelegate(baseUri, httpClient);
    }

    public void setWireLogger(WireLogger wireLogger) {
        this.wireLogger = wireLogger;
    }

    public WireLogger getWireLogger() {
        return this.wireLogger;
    }

    @Override
    public <T> HttpResponseWrapper<T> doPost(PlaidHttpRequest request, Class<T> clazz) {
        List<NameValuePair> parameters = ApacheHttpClientHttpDelegate.mapToNvps(request.getParameters());
        try {
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(parameters, "UTF-8");
            HttpPost post = new HttpPost(this.baseUri + request.getPath());
            post.setEntity((HttpEntity)entity);
            ApacheHttpClientHttpDelegate.addUserAgent((HttpMessage)post);
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)post);
            return this.handleResponse((HttpRequestBase)post, response, clazz);
        }
        catch (UnsupportedEncodingException e) {
            throw new PlaidClientsideException(e);
        }
        catch (IOException e) {
            throw new PlaidCommunicationsException(e);
        }
    }

    @Override
    public <T> HttpResponseWrapper<T> doGet(PlaidHttpRequest request, Class<T> clazz) {
        try {
            List<NameValuePair> parameters = ApacheHttpClientHttpDelegate.mapToNvps(request.getParameters());
            URI uri = new URIBuilder(this.baseUri).setPath(request.getPath()).addParameters(parameters).build();
            HttpGet get = new HttpGet(uri);
            ApacheHttpClientHttpDelegate.addUserAgent((HttpMessage)get);
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)get);
            return this.handleResponse((HttpRequestBase)get, response, clazz);
        }
        catch (UnsupportedEncodingException e) {
            throw new PlaidClientsideException(e);
        }
        catch (IOException e) {
            throw new PlaidCommunicationsException(e);
        }
        catch (URISyntaxException e) {
            throw new PlaidClientsideException(e);
        }
    }

    @Override
    public <T> HttpResponseWrapper<T> doDelete(PlaidHttpRequest request, Class<T> clazz) {
        try {
            List<NameValuePair> parameters = ApacheHttpClientHttpDelegate.mapToNvps(request.getParameters());
            URI uri = new URIBuilder(this.baseUri).setPath(request.getPath()).addParameters(parameters).build();
            HttpDelete delete = new HttpDelete(uri);
            ApacheHttpClientHttpDelegate.addUserAgent((HttpMessage)delete);
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)delete);
            return this.handleResponse((HttpRequestBase)delete, response, clazz);
        }
        catch (UnsupportedEncodingException e) {
            throw new PlaidClientsideException(e);
        }
        catch (IOException e) {
            throw new PlaidCommunicationsException(e);
        }
        catch (URISyntaxException e) {
            throw new PlaidClientsideException(e);
        }
    }

    @Override
    public <T> HttpResponseWrapper<T> doPatch(PlaidHttpRequest request, Class<T> clazz) {
        List<NameValuePair> parameters = ApacheHttpClientHttpDelegate.mapToNvps(request.getParameters());
        try {
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(parameters, "UTF-8");
            HttpPatch patch = new HttpPatch(this.baseUri + request.getPath());
            patch.setEntity((HttpEntity)entity);
            ApacheHttpClientHttpDelegate.addUserAgent((HttpMessage)patch);
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)patch);
            return this.handleResponse((HttpRequestBase)patch, response, clazz);
        }
        catch (UnsupportedEncodingException e) {
            throw new PlaidClientsideException(e);
        }
        catch (IOException e) {
            throw new PlaidCommunicationsException(e);
        }
    }

    private void wireLog(HttpRequestBase request, CloseableHttpResponse response, JsonNode responseBody) {
        if (this.wireLogger != null) {
            this.wireLogger.logRequestResponsePair(request, response, responseBody);
        }
    }

    private <T> HttpResponseWrapper<T> handleResponse(HttpRequestBase request, CloseableHttpResponse response, Class<T> clazz) {
        HttpEntity responseEntity = response.getEntity();
        try {
            int statusCode = response.getStatusLine().getStatusCode();
            JsonNode jsonBody = this.jsonMapper.readTree(responseEntity.getContent());
            EntityUtils.consume((HttpEntity)responseEntity);
            this.wireLog(request, response, jsonBody);
            if (200 == statusCode) {
                Object responseBody = this.jsonMapper.convertValue((Object)jsonBody, clazz);
                HttpResponseWrapper<Object> httpResponseWrapper = HttpResponseWrapper.create(statusCode, responseBody);
                return httpResponseWrapper;
            }
            try {
                if (201 == statusCode) {
                    MfaResponse mfaResponse = (MfaResponse)this.jsonMapper.convertValue((Object)jsonBody, MfaResponse.class);
                    throw new PlaidMfaException(mfaResponse, statusCode);
                }
                if (statusCode >= 400) {
                    ErrorResponse errorResponse = (ErrorResponse)this.jsonMapper.convertValue((Object)jsonBody, ErrorResponse.class);
                    throw new PlaidServersideException(errorResponse, statusCode);
                }
                throw new PlaidCommunicationsException("Unable to interpret Plaid response");
            }
            catch (IOException | IllegalStateException e) {
                throw new PlaidCommunicationsException("Unable to interpret Plaid response");
            }
        }
        finally {
            try {
                response.close();
            }
            catch (IOException e) {}
        }
    }

    private static List<NameValuePair> mapToNvps(Map<String, String> params) {
        ArrayList<NameValuePair> nvps = new ArrayList<NameValuePair>();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            nvps.add((NameValuePair)new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }
        return nvps;
    }

    private static void addUserAgent(HttpMessage httpMessage) {
        httpMessage.addHeader("User-Agent", "plaid-java 0.2");
    }
}

