/*
 * Decompiled with CFR 0.152.
 */
package com.platformlib.ktscript.api.factory;

import com.platformlib.ktscript.api.KtScriptRunner;
import com.platformlib.ktscript.api.configuration.KtScriptRunnerConfiguration;
import com.platformlib.ktscript.api.enums.RunnerType;
import com.platformlib.ktscript.api.provider.KtScriptProvider;
import java.util.ArrayList;
import java.util.ServiceLoader;

public final class KtScriptRunners {
    private KtScriptRunners() {
    }

    public static KtScriptRunner embeddedRunner() {
        return KtScriptRunners.newRunner(RunnerType.EMBEDDED, null);
    }

    public static KtScriptRunner forkRunner(KtScriptRunnerConfiguration ktScriptRunnerConfiguration) {
        return KtScriptRunners.newRunner(RunnerType.FORK, ktScriptRunnerConfiguration);
    }

    public static KtScriptRunner newRunner(RunnerType type, KtScriptRunnerConfiguration ktScriptRunnerConfiguration) {
        ServiceLoader<KtScriptProvider> providers = ServiceLoader.load(KtScriptProvider.class);
        ArrayList ktScriptProviders = new ArrayList();
        providers.forEach(provider -> {
            if (provider.getType() == type) {
                ktScriptProviders.add(provider);
            }
        });
        if (ktScriptProviders.isEmpty()) {
            throw new IllegalStateException("No ktScript provider has been found for " + (Object)((Object)type));
        }
        if (ktScriptProviders.size() > 1) {
            throw new IllegalStateException("More than one providers have been found for " + (Object)((Object)type) + ": " + ktScriptProviders);
        }
        return ((KtScriptProvider)ktScriptProviders.get(0)).newScriptRunner(ktScriptRunnerConfiguration);
    }
}

