/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.lexer.elements;

import com.scriptbasic.exceptions.LexicalException;
import com.scriptbasic.exceptions.UnterminatedStringException;
import com.scriptbasic.interfaces.LexicalElement;
import com.scriptbasic.lexer.BasicLexialElementFactory;
import com.scriptbasic.lexer.BasicLexicalElement;
import com.scriptbasic.lexer.elements.AbstractElementAnalyzer;

public class BasicString
extends AbstractElementAnalyzer {
    private static final int SINGLE_LINE_STRINGBUILDER_INITIAL_CAPACITY = 100;
    private static final int MULTI_LINE_STRINGBUILDER_INITIAL_CAPACITY = 1000;

    @Override
    public LexicalElement read() throws LexicalException {
        BasicLexicalElement lexicalElement = null;
        Integer character = this.getReader().get();
        if (character != null && character.equals(34)) {
            lexicalElement = this.isTripleQuote() ? this.readMultiLineString() : this.readSingleLineString();
        } else {
            this.getReader().pushBack(character);
        }
        return lexicalElement;
    }

    private boolean isTripleQuote() {
        boolean itIs;
        Integer second = this.getReader().get();
        Integer third = this.getReader().get();
        boolean bl = itIs = Integer.valueOf(34).equals(second) && Integer.valueOf(34).equals(third);
        if (!itIs) {
            this.getReader().pushBack(third);
            this.getReader().pushBack(second);
        }
        return itIs;
    }

    private boolean isStringTerminated(Integer character, boolean multiLine) throws UnterminatedStringException {
        boolean terminated = false;
        if (character == null) {
            throw new UnterminatedStringException(this.getReader());
        }
        if (character.equals(34)) {
            terminated = multiLine ? this.isTripleQuote() : true;
        }
        return terminated;
    }

    private static Integer convertEscapedChar(Integer inputCharacter) {
        Integer outputCharacter = inputCharacter;
        if (inputCharacter != null) {
            switch (inputCharacter) {
                case 110: {
                    outputCharacter = 10;
                    break;
                }
                case 116: {
                    outputCharacter = 9;
                    break;
                }
                case 114: {
                    outputCharacter = 13;
                    break;
                }
            }
        }
        return outputCharacter;
    }

    private static void appendSeparator(StringBuilder stringBuilder, boolean multiLine) {
        stringBuilder.append(multiLine ? "\"\"\"" : "\"");
    }

    private BasicLexicalElement readString(int stringBufferInitialSize, boolean multiLine) throws UnterminatedStringException {
        StringBuilder string = new StringBuilder(stringBufferInitialSize);
        StringBuilder lexeme = new StringBuilder(stringBufferInitialSize);
        BasicString.appendSeparator(lexeme, multiLine);
        BasicLexicalElement lexicalElement = BasicLexialElementFactory.create(this.getReader(), 0);
        Integer character = this.getReader().get();
        while (!this.isStringTerminated(character, multiLine)) {
            lexeme.appendCodePoint(character);
            if (character.equals(92)) {
                character = this.getReader().get();
                lexeme.appendCodePoint(character);
                character = BasicString.convertEscapedChar(character);
            }
            string.appendCodePoint(character);
            character = this.getReader().get();
        }
        BasicString.appendSeparator(lexeme, multiLine);
        lexicalElement.setLexeme(lexeme.toString());
        lexicalElement.setStringValue(string.toString());
        lexicalElement.setType(0);
        return lexicalElement;
    }

    private BasicLexicalElement readSingleLineString() throws UnterminatedStringException {
        return this.readString(100, false);
    }

    private BasicLexicalElement readMultiLineString() throws UnterminatedStringException {
        return this.readString(1000, true);
    }
}

