/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.readers;

import com.scriptbasic.interfaces.Factory;
import com.scriptbasic.interfaces.SourceProvider;
import com.scriptbasic.utility.CharUtils;
import java.io.IOException;
import java.io.Reader;
import java.util.Deque;
import java.util.LinkedList;

public class GenericReader
implements com.scriptbasic.interfaces.Reader {
    private Reader sourceReader;
    private String sourceFileName = null;
    private int lineNumber = 0;
    private int position = 0;
    private SourceProvider sourceProvider = null;
    private Integer lastChar = null;
    private Deque<Integer> charsAhead = new LinkedList<Integer>();

    @Override
    public void setFactory(Factory factory) {
    }

    public void set(Reader sourceReader) {
        this.sourceReader = sourceReader;
    }

    @Override
    public void set(String sourceFileName) {
        this.sourceFileName = sourceFileName;
    }

    @Override
    public String getFileName() {
        return this.sourceFileName;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public void pushBack(Integer ch) {
        if (ch != null) {
            this.charsAhead.addFirst(ch);
            --this.position;
        }
    }

    @Override
    public Integer get() {
        Integer nextChar;
        if (!this.charsAhead.isEmpty()) {
            ++this.position;
            return this.charsAhead.removeFirst();
        }
        try {
            nextChar = this.sourceReader.read();
            if (nextChar == -1) {
                nextChar = null;
            }
        }
        catch (IOException e) {
            return null;
        }
        if (this.lastChar != null && CharUtils.isNewLine(this.lastChar)) {
            this.position = 0;
            ++this.lineNumber;
        }
        ++this.position;
        this.lastChar = nextChar;
        return this.lastChar;
    }

    public void setSourceProvider(SourceProvider sourceProvider) {
        this.sourceProvider = sourceProvider;
    }

    @Override
    public SourceProvider getSourceProvider() {
        return this.sourceProvider;
    }
}

