/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.syntax.commands;

import com.scriptbasic.exceptions.GenericSyntaxException;
import com.scriptbasic.executors.commands.CommandFor;
import com.scriptbasic.executors.commands.CommandNext;
import com.scriptbasic.interfaces.AnalysisException;
import com.scriptbasic.interfaces.Command;
import com.scriptbasic.interfaces.LeftValue;
import com.scriptbasic.interfaces.LexicalAnalyzer;
import com.scriptbasic.interfaces.LexicalElement;
import com.scriptbasic.interfaces.NestedStructureHouseKeeper;
import com.scriptbasic.syntax.commands.AbstractCommandAnalyzer;
import com.scriptbasic.utility.FactoryUtility;

public class CommandAnalyzerNext
extends AbstractCommandAnalyzer {
    @Override
    protected String getName() {
        return "NEXT";
    }

    @Override
    public Command analyze() throws AnalysisException {
        CommandNext node = new CommandNext();
        LexicalAnalyzer lexicalAnalyzer = FactoryUtility.getLexicalAnalyzer(this.getFactory());
        LexicalElement lexicalElement = lexicalAnalyzer.peek();
        NestedStructureHouseKeeper nshk = FactoryUtility.getNestedStructureHouseKeeper(this.getFactory());
        CommandFor commandFor = nshk.pop(CommandFor.class);
        commandFor.setLoopEndNode(node);
        node.setLoopStartNode(commandFor);
        if (lexicalElement != null && !lexicalElement.isLineTerminator().booleanValue()) {
            LeftValue loopVariableB = this.analyzeSimpleLeftValue();
            LeftValue loopVariableA = commandFor.getLoopVariable();
            if (!CommandAnalyzerNext.equal(loopVariableA, loopVariableB)) {
                throw new GenericSyntaxException("The variable following the command " + this.getName() + " does not match the loop variable of the corresponging command FOR", lexicalElement);
            }
        }
        this.consumeEndOfLine();
        return node;
    }
}

