/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.utility;

import com.scriptbasic.utility.UtilityUtility;

public final class CastUtility {
    private CastUtility() {
        UtilityUtility.throwExceptionToEnsureNobodyCallsIt();
    }

    public static Object cast(Object object, Class<?> castTo) {
        Object result = object;
        try {
            switch (castTo.getName()) {
                case "byte": 
                case "java.lang.Byte": {
                    result = Byte.cast(object);
                    break;
                }
                case "short": 
                case "java.lang.Short": {
                    result = Short.cast(object);
                    break;
                }
                case "int": 
                case "java.lang.Integer": {
                    result = Integer.cast(object);
                    break;
                }
                case "long": 
                case "java.lang.Long": {
                    result = Long.cast(object);
                    break;
                }
                case "float": 
                case "java.lang.Float": {
                    result = Float.cast(object);
                    break;
                }
                case "double": 
                case "java.lang.Double": {
                    result = Double.cast(object);
                    break;
                }
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return result;
    }

    private static class Double {
        private Double() {
        }

        static java.lang.Double cast(Object object) {
            return ((Number)object).doubleValue();
        }
    }

    private static class Float {
        private Float() {
        }

        static java.lang.Float cast(Object object) {
            return java.lang.Float.valueOf(((Number)object).floatValue());
        }
    }

    private static class Long {
        private Long() {
        }

        static java.lang.Long cast(Object object) {
            return ((Number)object).longValue();
        }
    }

    private static class Integer {
        private Integer() {
        }

        static java.lang.Integer cast(Object object) {
            return ((Number)object).intValue();
        }
    }

    private static class Short {
        private Short() {
        }

        static java.lang.Short cast(Object object) {
            return ((Number)object).shortValue();
        }
    }

    private static class Byte {
        private Byte() {
        }

        static java.lang.Byte cast(Object object) {
            return ((Number)object).byteValue();
        }
    }
}

