/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.configuration;

import com.scriptbasic.interfaces.Configuration;
import com.scriptbasic.interfaces.Factory;
import com.scriptbasic.log.Logger;
import com.scriptbasic.log.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class BasicConfiguration
implements Configuration {
    private static final Logger LOG = LoggerFactory.getLogger(BasicConfiguration.class);
    Factory factory;
    Properties configProperties;
    private final HashMap<String, List<String>> lists = new HashMap();

    public BasicConfiguration() {
        try {
            this.loadDefaultConfiguration();
        }
        catch (Exception e) {
            LOG.error("Configuration was not loaded", e);
        }
    }

    @Override
    public void setFactory(Factory factory) {
        this.factory = factory;
    }

    @Override
    public void setConfigProperties(Properties configProperties) {
        this.configProperties = configProperties;
        this.lists.clear();
    }

    @Override
    public String getConfigValue(String key) {
        String configValue = null;
        String envKey = "sb4j." + key;
        if (this.configProperties != null && this.configProperties.containsKey(key)) {
            configValue = this.configProperties.getProperty(key);
        }
        String sysValue = null;
        sysValue = System.getenv(envKey);
        if (sysValue != null) {
            configValue = sysValue;
        }
        if ((sysValue = System.getProperty(envKey)) != null) {
            configValue = sysValue;
        }
        return configValue;
    }

    @Override
    public String getConfigValue(String key, String defaultValue) {
        String configValue = this.getConfigValue(key);
        return configValue == null ? defaultValue : configValue;
    }

    @Override
    public List<String> getConfigValueList(String key) {
        String value;
        String keyi;
        if (this.lists.containsKey(key)) {
            return this.lists.get(key);
        }
        LinkedList<String> list = new LinkedList<String>();
        int i = 0;
        while ((keyi = key + "." + i) != null && (value = this.getConfigValue(keyi)) != null) {
            list.add(value);
            ++i;
        }
        this.lists.put(keyi, list);
        return list;
    }

    @Override
    public void loadDefaultConfiguration() {
        String systemPropertyDefinedConfiguration = System.getProperty("sb4j.configuration");
        String configurationFileName = systemPropertyDefinedConfiguration == null ? "sb4j.properties" : systemPropertyDefinedConfiguration;
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(configurationFileName);
        if (null != is) {
            this.loadConfiguration(is);
        }
    }

    @Override
    public void loadConfiguration(InputStream is) {
        Properties configProperties = new Properties();
        try {
            configProperties.load(is);
            this.setConfigProperties(configProperties);
        }
        catch (IOException e) {
            LOG.error("Can not load the configuration.", e);
            this.setConfigProperties(null);
        }
    }
}

