/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic;

import com.scriptbasic.api.ScriptBasic;
import com.scriptbasic.api.ScriptBasicException;
import com.scriptbasic.api.Subroutine;
import com.scriptbasic.errors.BasicInterpreterInternalError;
import com.scriptbasic.executors.commands.CommandSub;
import com.scriptbasic.factories.Context;
import com.scriptbasic.factories.ContextBuilder;
import com.scriptbasic.interfaces.AnalysisException;
import com.scriptbasic.interfaces.ExecutionException;
import com.scriptbasic.interfaces.SourcePath;
import com.scriptbasic.interfaces.SourceProvider;
import com.scriptbasic.interfaces.SourceReader;
import com.scriptbasic.sourceproviders.BasicSourcePath;
import com.scriptbasic.sourceproviders.FileSourceProvider;
import com.scriptbasic.utility.RightValueUtility;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class Engine
implements ScriptBasic {
    private final Map<String, Subroutine> subroutines = new HashMap<String, Subroutine>();
    private Reader input;
    private Writer output;
    private Writer error;
    private boolean theMapHasToBeFilled = true;
    private Context ctx;

    @Override
    public void registerFunctions(Class<?> klass) throws ScriptBasicException {
        this.ctx.interpreter.registerFunctions(klass);
    }

    @Override
    public Reader getInput() {
        return this.input;
    }

    @Override
    public void setInput(Reader input) {
        this.input = input;
    }

    @Override
    public Writer getOutput() {
        return this.output;
    }

    @Override
    public void setOutput(Writer output) {
        this.output = output;
    }

    @Override
    public Writer getError() {
        return this.error;
    }

    @Override
    public void setError(Writer error) {
        this.error = error;
    }

    private void loadHelper(Reader reader) throws ScriptBasicException {
        this.loadHelper(reader, null);
    }

    private void loadHelper(String fileName, SourceProvider sourceProvider) throws ScriptBasicException {
        try {
            SourceReader sourceReader = sourceProvider.get(fileName);
            this.loadHelper(sourceReader);
        }
        catch (IOException e) {
            throw new ScriptBasicException(e);
        }
    }

    private void loadHelper(Reader reader, String fileName) throws ScriptBasicException {
        try {
            this.ctx = ContextBuilder.from(this.ctx, reader, this.input, this.output, this.error);
            this.ctx.interpreter.setProgram(this.ctx.syntaxAnalyzer.analyze());
        }
        catch (AnalysisException e) {
            throw new ScriptBasicException(e);
        }
    }

    private void loadHelper(SourceReader sourceReader) throws ScriptBasicException {
        try {
            this.ctx = ContextBuilder.from(this.ctx, sourceReader, this.input, this.output, this.error);
            this.ctx.interpreter.setProgram(this.ctx.syntaxAnalyzer.analyze());
        }
        catch (AnalysisException e) {
            throw new ScriptBasicException(e);
        }
    }

    @Override
    public void execute() throws ScriptBasicException {
        try {
            if (this.ctx == null) {
                throw new ScriptBasicException("Interpreter was not properly initialized.");
            }
            this.ctx.interpreter.execute();
        }
        catch (ExecutionException e) {
            throw new ScriptBasicException(e);
        }
    }

    @Override
    public void load(String sourceCode) throws ScriptBasicException {
        this.loadHelper(new StringReader(sourceCode));
    }

    @Override
    public void eval(String sourceCode) throws ScriptBasicException {
        this.load(sourceCode);
        this.execute();
    }

    @Override
    public void load(Reader reader) throws ScriptBasicException {
        this.loadHelper(reader);
    }

    @Override
    public void eval(Reader reader) throws ScriptBasicException {
        this.load(reader);
        this.execute();
    }

    @Override
    public void load(File sourceFile) throws ScriptBasicException {
        try {
            this.loadHelper(new FileReader(sourceFile), sourceFile.getAbsolutePath());
        }
        catch (FileNotFoundException e) {
            throw new ScriptBasicException(e);
        }
    }

    @Override
    public void eval(File sourceFile) throws ScriptBasicException {
        this.load(sourceFile);
        this.execute();
    }

    @Override
    public void load(String sourceFileName, String ... path) throws ScriptBasicException {
        FileSourceProvider sourceProvider = new FileSourceProvider();
        BasicSourcePath sourcePath = new BasicSourcePath();
        for (String p : path) {
            sourcePath.add(p);
        }
        sourceProvider.setSourcePath(sourcePath);
        this.loadHelper(sourceFileName, sourceProvider);
    }

    @Override
    public void eval(String sourceFileName, String ... path) throws ScriptBasicException {
        this.load(sourceFileName, path);
        this.execute();
    }

    @Override
    public void load(String sourceFileName, SourcePath path) throws ScriptBasicException {
        FileSourceProvider sourceProvider = new FileSourceProvider();
        sourceProvider.setSourcePath(path);
        this.loadHelper(sourceFileName, sourceProvider);
    }

    @Override
    public void eval(String sourceFileName, SourcePath path) throws ScriptBasicException {
        this.load(sourceFileName, path);
        this.execute();
    }

    @Override
    public void load(String sourceName, SourceProvider provider) throws ScriptBasicException {
        this.loadHelper(sourceName, provider);
    }

    @Override
    public void eval(String sourceName, SourceProvider provider) throws ScriptBasicException {
        this.load(sourceName, provider);
        this.execute();
    }

    @Override
    public void setVariable(String name, Object value) throws ScriptBasicException {
        try {
            this.ctx = ContextBuilder.from(this.ctx);
            this.ctx.interpreter.getVariables().setVariable(name, RightValueUtility.createRightValue(value));
        }
        catch (ExecutionException e) {
            throw new ScriptBasicException(e);
        }
    }

    @Override
    public Object getVariable(String name) throws ScriptBasicException {
        try {
            return this.ctx.interpreter.getVariable(name);
        }
        catch (ExecutionException e) {
            throw new ScriptBasicException(e);
        }
    }

    @Override
    public Iterable<String> getVariablesIterator() {
        return this.ctx.interpreter.getVariables().getGlobalMap().getVariableNameSet();
    }

    private void SNAFU_SubroutineDoesNotExist(Exception e) {
        throw new BasicInterpreterInternalError("An already located subroutine does not exist", e);
    }

    @Override
    public Iterable<Subroutine> getSubroutines() {
        if (this.theMapHasToBeFilled) {
            for (String s : this.ctx.interpreter.getProgram().getNamedCommandNames()) {
                try {
                    this.getSubroutine(s);
                }
                catch (ScriptBasicException e) {
                    this.SNAFU_SubroutineDoesNotExist(e);
                }
            }
            this.theMapHasToBeFilled = false;
        }
        return this.subroutines.values();
    }

    private CommandSub getCommandSub(String subroutineName) throws ScriptBasicException {
        CommandSub commandSub = this.ctx.interpreter.getSubroutine(subroutineName);
        if (commandSub == null) {
            throw new ScriptBasicException("Sobroutine '" + subroutineName + "' is not defined in the program");
        }
        return commandSub;
    }

    private int getNumberOfArguments(String subroutineName) throws ScriptBasicException {
        CommandSub commandSub = this.getCommandSub(subroutineName);
        int size = commandSub.getArguments() != null ? commandSub.getArguments().size() : 0;
        return size;
    }

    @Override
    public Subroutine getSubroutine(String subroutineName) throws ScriptBasicException {
        if (this.subroutines.containsKey(subroutineName)) {
            return this.subroutines.get(subroutineName);
        }
        CommandSub commandSub = this.getCommandSub(subroutineName);
        Sub sub = new Sub(commandSub.getSubName());
        this.subroutines.put(subroutineName, sub);
        return sub;
    }

    @Override
    public void registerExtension(Class<?> klass) throws ScriptBasicException {
        this.ctx.interpreter.registerFunctions(klass);
    }

    public class Sub
    implements Subroutine {
        private final String name;

        Sub(String n) {
            this.name = n;
        }

        @Override
        public int getNumberOfArguments() {
            try {
                return Engine.this.getNumberOfArguments(this.name);
            }
            catch (ScriptBasicException e) {
                Engine.this.SNAFU_SubroutineDoesNotExist(e);
                return 0;
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Object call(Object ... args) throws ScriptBasicException {
            try {
                return ((Engine)Engine.this).ctx.interpreter.call(this.name, args);
            }
            catch (ExecutionException e) {
                throw new ScriptBasicException(e);
            }
        }

        @Override
        public Object call() throws ScriptBasicException {
            return this.call(null);
        }
    }
}

