/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.executors.rightvalues;

import com.scriptbasic.executors.rightvalues.AbstractRightValue;
import com.scriptbasic.interfaces.BasicRuntimeException;
import com.scriptbasic.interfaces.ExecutionException;
import com.scriptbasic.interfaces.ExtendedInterpreter;
import java.util.Arrays;

public class BasicArrayValue
extends AbstractRightValue {
    private static final Integer INCREMENT_GAP = 100;
    private Object[] array = new Object[INCREMENT_GAP.intValue()];
    private int maxIndex = -1;
    private ExtendedInterpreter interpreter;

    public BasicArrayValue() {
        this.interpreter = null;
    }

    public BasicArrayValue(ExtendedInterpreter interpreter) {
        this.interpreter = interpreter;
    }

    public void setArray(Object[] array) {
        if (array == null) {
            throw new NullPointerException("BasicArrayValue embedded array cann ot be null");
        }
        this.array = array;
    }

    public void setInterpreter(ExtendedInterpreter interpreter) {
        this.interpreter = interpreter;
    }

    private void assertArraySize(Integer index) throws ExecutionException {
        if (index < 0) {
            throw new BasicRuntimeException("Array index can not be negative");
        }
        if (this.array.length <= index) {
            this.array = Arrays.copyOf(this.array, index + INCREMENT_GAP);
        }
    }

    public Long getLength() {
        return (long)this.maxIndex + 1L;
    }

    public void set(Integer index, Object object) throws ExecutionException {
        this.assertArraySize(index);
        this.array[index.intValue()] = object;
        if (this.maxIndex < index) {
            this.maxIndex = index;
        }
    }

    public Object get(Integer index) throws ExecutionException {
        this.assertArraySize(index);
        return this.array[index];
    }
}

